/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.dto.req;

import cn.kinyun.pay.business.enums.PayChannelType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OrderPayReq {
    private String orderNo;
    private Integer payChannelType;
    private Long totalAmount;
    private Long payAmount;

    public void validateAll() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.orderNo), (Object)"orderNo is null or empty");
        Preconditions.checkArgument((boolean)Objects.nonNull(PayChannelType.get((Integer)this.payChannelType)), (Object)"payChannelType is not valid");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.totalAmount), (Object)"totalAmount is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.payAmount), (Object)"payAmount is null");
        Preconditions.checkArgument((this.totalAmount >= this.payAmount ? 1 : 0) != 0, (Object)"totalAmount must bigger then payAmount");
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.orderNo), (Object)"orderNo is null or empty");
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public Integer getPayChannelType() {
        return this.payChannelType;
    }

    public Long getTotalAmount() {
        return this.totalAmount;
    }

    public Long getPayAmount() {
        return this.payAmount;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setPayChannelType(Integer payChannelType) {
        this.payChannelType = payChannelType;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setPayAmount(Long payAmount) {
        this.payAmount = payAmount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderPayReq)) {
            return false;
        }
        OrderPayReq other = (OrderPayReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$payChannelType = this.getPayChannelType();
        Integer other$payChannelType = other.getPayChannelType();
        if (this$payChannelType == null ? other$payChannelType != null : !((Object)this$payChannelType).equals(other$payChannelType)) {
            return false;
        }
        Long this$totalAmount = this.getTotalAmount();
        Long other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        Long this$payAmount = this.getPayAmount();
        Long other$payAmount = other.getPayAmount();
        if (this$payAmount == null ? other$payAmount != null : !((Object)this$payAmount).equals(other$payAmount)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        return !(this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderPayReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $payChannelType = this.getPayChannelType();
        result = result * 59 + ($payChannelType == null ? 43 : ((Object)$payChannelType).hashCode());
        Long $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        Long $payAmount = this.getPayAmount();
        result = result * 59 + ($payAmount == null ? 43 : ((Object)$payAmount).hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        return result;
    }

    public String toString() {
        return "OrderPayReq(orderNo=" + this.getOrderNo() + ", payChannelType=" + this.getPayChannelType() + ", totalAmount=" + this.getTotalAmount() + ", payAmount=" + this.getPayAmount() + ")";
    }
}

