/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.AccessInfo;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.scrm.page.auth.dto.ReportDataDto;
import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.service.PageReportService;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import com.kuaike.scrm.common.utils.IdGen;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PageReportServiceImpl
implements PageReportService {
    private static final Logger log = LoggerFactory.getLogger(PageReportServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private WoauthParseUtil woauthParseUtil;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private static final String SOURCE = "scrm";

    @Override
    public String getAccessNum() {
        return this.idGen.getNum();
    }

    @Override
    public void report(ReportDataDto params, HttpServletRequest request) {
        params.validate();
        WoauthUserDto authInfo = this.woauthParseUtil.getWoauthInfo(request);
        if (authInfo.getBizId() == null) {
            authInfo.setBizId(params.getBizId());
        }
        if (authInfo.getBizId() == null) {
            String msgKey = this.redisKeyPrefix + ":" + params.getId();
            String bizStr = (String)this.redisTemplate.opsForValue().get((Object)msgKey);
            if (bizStr == null) {
                log.warn("redis not find accessNum to bizId, params: {}", (Object)params);
                return;
            }
            Long bizId = Long.parseLong(bizStr);
            authInfo.setBizId(bizId);
            this.redisTemplate.opsForValue().set((Object)msgKey, (Object)bizStr, 60L, TimeUnit.SECONDS);
        }
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.VISIT_PAGE.getCode());
        eventReq.setEventTime(params.getVisitBeginTime());
        eventReq.setBizId(authInfo.getBizId());
        eventReq.setSource(SOURCE);
        EventData eventData = new EventData();
        eventData.setAccessNum(params.getId());
        AccessInfo accessInfo = new AccessInfo();
        accessInfo.setVisitBeginTime(params.getVisitBeginTime());
        accessInfo.setVisitEndTime(params.getVisitEndTime());
        long stayTime = params.getVisitEndTime().getTime() - params.getVisitBeginTime().getTime();
        accessInfo.setStayTime(Long.valueOf(stayTime));
        accessInfo.setFinishPercent(params.getFinishPercent());
        eventData.setAccessInfo(accessInfo);
        eventReq.setEventData(eventData);
        log.info("report update accessInfo: {}", (Object)accessInfo);
        this.ccCustomerEventService.updateVisitPage(eventReq);
    }
}

