/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.service.impl;

import cn.kinyun.scrm.page.auth.dto.OAuthPageDto;
import cn.kinyun.scrm.page.auth.service.VipUserOauthService;
import cn.kinyun.wework.sdk.api.WwOauth2Client;
import cn.kinyun.wework.sdk.entity.oauth2.UserDetail;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.WxOAuthScope;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VipUserOauthServiceImpl
implements VipUserOauthService {
    private static final Logger log = LoggerFactory.getLogger(VipUserOauthServiceImpl.class);
    @Value(value="${scrm.domain.root}")
    private String domain;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}/vip/oauth/jump.json")
    private String callbackUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.defaultUrl}")
    private String defaultUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.successUrl:}")
    private String successUrl;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private WwOauth2Client wwOauth2Client;

    @Override
    public String getOAuthUrl() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        String corpId = user.getCorpId();
        Long bizId = user.getBizId();
        Integer agentId = this.customizedTokenService.getAgentId(corpId);
        OAuthPageDto params = new OAuthPageDto();
        params.setUrl(this.defaultUrl);
        params.setBizId(bizId);
        return this.getOAuthUrl(corpId, agentId, params);
    }

    @Override
    public String callback(String code, String state, String value, HttpServletRequest request, HttpServletResponse response) {
        log.info("callback with code={}, state={}, value={}", new Object[]{code, state, value});
        OAuthPageDto dto = OAuthPageDto.decrypt(value);
        if (dto == null) {
            log.warn("Invalid param. value={}", (Object)value);
            return this.defaultUrl;
        }
        String url = dto.getUrl();
        log.info("redirectUrl={}", (Object)url);
        if (StringUtils.isBlank((CharSequence)code)) {
            log.warn("Matching failed: code is empty. params={}", (Object)dto);
            return url;
        }
        String corpId = state;
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        if (Objects.isNull(corp)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743, corpId={}", (Object)corpId);
            return url;
        }
        try {
            Userinfo userinfo = this.wwOauth2Client.getUserinfo(corpId, code);
            if (userinfo == null || !StringUtils.isNotBlank((CharSequence)userinfo.getUserId()) || !StringUtils.isNotBlank((CharSequence)userinfo.getUserTicket())) {
                log.info("userinfo error");
                return url;
            }
            UserDetail userdetail = this.wwOauth2Client.getUserdetail(corpId, userinfo.getUserTicket());
            log.info("userdetail: {}", (Object)userdetail);
        }
        catch (Exception e) {
            log.error("bind contactId and openId error: {}", (Object)dto, (Object)e);
            return url;
        }
        return url;
    }

    private String getOAuthUrl(String corpId, Integer agentId, OAuthPageDto params) {
        String redirectUrl = this.callbackUrl + "?v=" + params.encrypt();
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("encode with error", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?response_type=code");
        sb.append("&appid=").append(corpId);
        sb.append("&redirect_uri=").append(redirectUrl);
        sb.append("&scope=").append(WxOAuthScope.SNSAPI_PRIVATEINFO.getValue());
        sb.append("&state=").append(corpId);
        sb.append("&agentid=").append(agentId);
        sb.append("#wechat_redirect");
        return sb.toString();
    }
}

