/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.service.impl;

import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.marketing.mapper.OauthShortUrlMapper;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShortUrlServiceImpl
implements ShortUrlService {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlServiceImpl.class);
    @Resource
    private OauthShortUrlMapper oauthShortUrlMapper;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.defaultUrl}")
    private String defaultUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.shortUrl}")
    private String oauthShortUrl;

    @Override
    public String getOriginUrl(String shortUrl) {
        OauthShortUrl oauthShortUrl = this.oauthShortUrlMapper.getByShortUrl(shortUrl);
        if (oauthShortUrl == null) {
            return this.defaultUrl;
        }
        return oauthShortUrl.getOriginUrl();
    }

    @Override
    public String getOauthPageUrl(String shortUrl) {
        OauthShortUrl oauthShortUrl = this.oauthShortUrlMapper.getByShortUrl(shortUrl);
        if (oauthShortUrl == null) {
            return this.defaultUrl;
        }
        return oauthShortUrl.getOauthUrl();
    }

    @Override
    public String getShortUlr(String num) {
        return MessageFormat.format(this.oauthShortUrl, num);
    }

    @Override
    public String getRedirectUrl(HttpServletRequest request, String shortUrl) {
        OauthShortUrl oauthShortUrl = this.oauthShortUrlMapper.getByShortUrl(shortUrl);
        if (oauthShortUrl == null) {
            return this.defaultUrl;
        }
        String redirectUrl = oauthShortUrl.getOriginUrl();
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent = userAgent.toLowerCase(Locale.getDefault())).contains("micromessenger")) {
            redirectUrl = oauthShortUrl.getOauthUrl();
        }
        return redirectUrl;
    }

    @Override
    public void recordShortUrl(String appId, Integer type, String originUrl, String oauthUrl, String shortUrl) {
        OauthShortUrl oauthShortUrl = new OauthShortUrl();
        oauthShortUrl.setAppId(appId);
        oauthShortUrl.setType(type);
        oauthShortUrl.setOriginUrl(originUrl);
        oauthShortUrl.setOauthUrl(oauthUrl);
        oauthShortUrl.setShortUrl(shortUrl);
        oauthShortUrl.setCreateTime(new Date());
        oauthShortUrl.setUpdateTime(new Date());
        oauthShortUrl.setIsDeleted(Integer.valueOf(0));
        this.oauthShortUrlMapper.insertSelective((Object)oauthShortUrl);
    }

    @Override
    public OauthShortUrl getByOriginUrl(String originUrl) {
        if (StringUtils.isBlank((CharSequence)originUrl)) {
            return null;
        }
        return this.oauthShortUrlMapper.queryShortUrlByOriginUrl(originUrl);
    }
}

