/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.utils;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PageAuthRedisUtil {
    private static final Logger log = LoggerFactory.getLogger(PageAuthRedisUtil.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private static final String LOCK_QR_TOKEN_FORMAT = "%s:lock:qr:token:%s";
    private static final Long LOCK_QR_TOKEN_TIME = 600L;
    private static final String SNS_USER_KEY = "SNS_USER_CACHE:";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public void setSnsUser(String key, String value, Duration timeout) {
        String snsKey = this.redisKeyPrefix + SNS_USER_KEY + key;
        this.redisTemplate.opsForValue().set((Object)snsKey, (Object)value, timeout);
    }

    public String getSnsUser(String key) {
        String snsKey = this.redisKeyPrefix + SNS_USER_KEY + key;
        return (String)this.redisTemplate.opsForValue().get((Object)snsKey);
    }

    public boolean existsQrToken(String token) {
        String content = String.format(LOCK_QR_TOKEN_FORMAT, LOCK_QR_TOKEN_FORMAT, token);
        String lockKey = this.redisKeyPrefix + content;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", LOCK_QR_TOKEN_TIME.longValue(), TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return true;
            }
            return locked == false;
        }
        catch (Exception e) {
            log.error("Failed lock qr token={}", (Object)token, (Object)e);
            return true;
        }
    }
}

