/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizationInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizeMsg;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.FunctionInfo;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.callback.service.OfficialAuthService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountOperatorCriteria;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountOperatorMapper;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.syncdata.service.OfficialFansSyncService;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAuthServiceImpl
implements OfficialAuthService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAuthServiceImpl.class);
    private static final String FUNCTION_ID_SPIT = ",";
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialAccountOperatorMapper officialAccountOperatorMapper;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private OfficialFansSyncService officialFansSyncService;
    @Resource
    private MeetingCacheService meetingCacheService;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);

    @Override
    public void authorize(AuthorizeMsg msg) {
        String appId = msg.getAuthorizerAppid();
        String authCode = msg.getAuthorizationCode();
        Date expiredTime = new Date(msg.getAuthorizationCodeExpiredTime() * 1000L);
        String preAuthCode = msg.getPreAuthCode();
        log.info("authorize official account, appId={}, authCode={}, expiredTime={}, preAuthCode={}", new Object[]{appId, authCode, expiredTime, preAuthCode});
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        try {
            AuthInfoResp authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
            OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
            if (officialAccount != null) {
                this.updateOfficialAccount(officialAccount, authInfo.getAuthorizationInfo(), appInfo.getAuthorizerInfo());
            }
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        this.executorService.submit(() -> {
            try {
                this.officialFansSyncService.sync(appId);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u516c\u4f17\u53f7\u7c89\u4e1d\u6570\u636e\u5931\u8d25, appId={}", (Object)appId, (Object)e);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unauthorize(AuthorizeMsg msg) {
        String appId = msg.getAuthorizerAppid();
        log.info("app deauth callback, appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
        if (officialAccount != null) {
            officialAccount.setAuthStatus(Integer.valueOf(0));
            officialAccount.setDeauthTime(new Date());
            this.officialAccountMapper.updateByPrimaryKeySelective((Object)officialAccount);
            try {
                this.meetingCacheService.setOfficialAppId(officialAccount.getBizId(), "");
            }
            catch (Exception e) {
                log.error("meetingCacheService,getOfficialAppId error", (Throwable)e);
            }
        }
        OfficialAccountOperatorCriteria filter = new OfficialAccountOperatorCriteria();
        filter.createCriteria().andAppIdEqualTo(appId);
        this.officialAccountOperatorMapper.deleteByFilter(filter);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuthorize(AuthorizeMsg msg) {
        String appId = msg.getAuthorizerAppid();
        String authCode = msg.getAuthorizationCode();
        Date expiredTime = new Date(msg.getAuthorizationCodeExpiredTime());
        String preAuthCode = msg.getPreAuthCode();
        log.info("updateAuthorize, appId={},authCode={},expiredTime={},preAuthCode={}", new Object[]{appId, authCode, expiredTime, preAuthCode});
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        try {
            AuthInfoResp authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
            OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
            if (officialAccount != null) {
                this.updateOfficialAccount(officialAccount, authInfo.getAuthorizationInfo(), appInfo.getAuthorizerInfo());
            }
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
    }

    private void updateOfficialAccount(OfficialAccount account, AuthorizationInfo authInfo, AuthorizerInfo appInfo) {
        Date now = new Date();
        account.setAccessToken(authInfo.getAuthorizerAccessToken());
        account.setRefreshToken(authInfo.getAuthorizerRefreshToken());
        account.setTokenExpireTime(DateUtils.addSeconds((Date)now, (int)((int)authInfo.getExpires())));
        StringBuilder sb = new StringBuilder();
        sb.append(FUNCTION_ID_SPIT);
        for (FunctionInfo category : authInfo.getFuncInfo()) {
            sb.append(category.getFuncscopeCategory().getId()).append(FUNCTION_ID_SPIT);
        }
        account.setFunctionInfo(sb.toString());
        account.setNickName(appInfo.getNickName());
        account.setAlias(appInfo.getAlias());
        if (account.getAuthStatus() != 1) {
            account.setAuthTime(now);
        }
        account.setHeadImg(appInfo.getHeadImg());
        account.setPrincipalName(appInfo.getPrincipalName());
        account.setQrcodeUrl(appInfo.getQrcodeUrl());
        account.setUserName(appInfo.getUserName());
        account.setVerifyType(Integer.valueOf(appInfo.getVerifyTypeInfo().getId().intValue()));
        account.setServiceType(Integer.valueOf(appInfo.getServiceTypeInfo().getId().intValue()));
        int function = appInfo.getBusinessInfo().getOpenStore() << 4 + appInfo.getBusinessInfo().getOpenScan() << 3 + appInfo.getBusinessInfo().getOpenPay() << 2 + appInfo.getBusinessInfo().getOpenCard() << 1 + appInfo.getBusinessInfo().getOpenShake();
        account.setBusinessInfo(Integer.valueOf(function));
        account.setAuthStatus(Integer.valueOf(1));
        this.officialAccountMapper.updateByPrimaryKeySelective((Object)account);
    }
}

