/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.AudioAttributes;
import ws.schild.jave.AudioInfo;
import ws.schild.jave.ConversionOutputAnalyzer;
import ws.schild.jave.DefaultFFMPEGLocator;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncoderException;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaInfo;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.RBufferedReader;
import ws.schild.jave.VideoInfo;
import ws.schild.jave.VideoSize;

public final class FfmpegUtils {
    private static final Logger log = LoggerFactory.getLogger(FfmpegUtils.class);

    private FfmpegUtils() {
    }

    public static String getSuffix(String fileName) {
        int index;
        if (StringUtils.isNotBlank((CharSequence)fileName) && (index = fileName.lastIndexOf(46)) > 0) {
            return fileName.substring(index + 1);
        }
        return null;
    }

    public static String getSha1(byte[] data) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(data, 0, data.length);
            String sha1 = new BigInteger(1, digest.digest()).toString(16);
            int length = 40 - sha1.length();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    sb.append(0);
                }
            }
            sb.append(sha1);
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u751f\u6210SHA-1\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static long getDuration(File source) {
        long sec = 0L;
        MultimediaObject mediaObj = new MultimediaObject(source);
        try {
            MultimediaInfo mediaInfo = mediaObj.getInfo();
            sec = Math.round((double)mediaInfo.getDuration() * 0.001);
        }
        catch (InputFormatException e) {
            log.error("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301", (Throwable)e);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u7801\u5931\u8d25", (Throwable)e);
        }
        return sec;
    }

    public static File getVideoImage(File input, Integer maxWidth) {
        return FfmpegUtils.getVideoImage(input, maxWidth, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getVideoImage(File input, Integer maxWidth, File output) {
        if (input == null || !input.isFile() || !input.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + input);
        }
        MultimediaObject mediaObj = new MultimediaObject(input);
        MultimediaInfo mediaInfo = null;
        VideoInfo videoInfo = null;
        try {
            mediaInfo = mediaObj.getInfo();
            videoInfo = mediaInfo.getVideo();
        }
        catch (EncoderException e) {
            log.error("\u83b7\u53d6\u56fe\u50cf\u7f16\u7801\u5668\u5931\u8d25", (Throwable)e);
        }
        if (videoInfo == null) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u4e0d\u662f\u89c6\u9891\u6587\u4ef6:" + input);
        }
        output = FfmpegUtils.mkdir(input, output, "jpg");
        VideoSize size = videoInfo.getSize();
        int width = size.getWidth();
        int height = size.getHeight();
        if (maxWidth != null && maxWidth > 0 && width > maxWidth) {
            double scale = (double)maxWidth.intValue() / (double)width;
            height = (int)((double)height * scale);
            width = (int)((double)width * scale);
        }
        DefaultFFMPEGLocator locator = new DefaultFFMPEGLocator();
        FFMPEGExecutor ffmpeg = locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(input.getAbsolutePath());
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("image2");
        ffmpeg.addArgument("-ss");
        if (mediaInfo.getDuration() > 1000L) {
            ffmpeg.addArgument("00:00:01");
        } else {
            ffmpeg.addArgument("00:00:00");
        }
        ffmpeg.addArgument("-s");
        ffmpeg.addArgument(width + "x" + height);
        ffmpeg.addArgument("-vframes");
        ffmpeg.addArgument("1");
        ffmpeg.addArgument(output.getAbsolutePath());
        ConversionOutputAnalyzer outputAnalyzer = new ConversionOutputAnalyzer(0L, null);
        try {
            ffmpeg.execute();
            try (RBufferedReader reader = new RBufferedReader((Reader)new InputStreamReader(ffmpeg.getErrorStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    outputAnalyzer.analyzeNewLine(line);
                }
            }
            int exitCode = ffmpeg.getProcessExitCode();
            if (exitCode != 0) {
                throw new EncoderException("Exit code of ffmpeg encoding run is " + exitCode);
            }
        }
        catch (IOException | EncoderException e) {
            log.error("\u89e3\u7801\u5931\u8d25:{}", (Object)outputAnalyzer.getUnhandledMessages(), (Object)e);
        }
        finally {
            ffmpeg.destroy();
            ffmpeg = null;
        }
        return output;
    }

    public static File getAudioMp3(File input) {
        return FfmpegUtils.getAudioMp3(input, null);
    }

    public static File getAudioMp3(File input, File output) {
        if (input == null || !input.isFile() || !input.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + input);
        }
        MultimediaObject mediaObj = new MultimediaObject(input);
        MultimediaInfo mediaInfo = null;
        AudioInfo audioInfo = null;
        try {
            mediaInfo = mediaObj.getInfo();
            audioInfo = mediaInfo.getAudio();
        }
        catch (InputFormatException e) {
            log.error("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        if (audioInfo == null) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u4e0d\u662f\u97f3\u9891\u6587\u4ef6:" + input);
        }
        output = FfmpegUtils.mkdir(input, output, "mp3");
        Encoder encoder = new Encoder();
        AudioAttributes audio = new AudioAttributes();
        audio.setChannels(Integer.valueOf(1));
        EncodingAttributes attributes = new EncodingAttributes();
        attributes.setFormat("mp3");
        attributes.setAudioAttributes(audio);
        try {
            encoder.encode(mediaObj, output, attributes);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
        return output;
    }

    public static File getAudioAmr(File input) {
        return FfmpegUtils.getAudioAmr(input, null);
    }

    public static File getAudioAmr(File input, File output) {
        if (input == null || !input.isFile() || !input.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + input);
        }
        MultimediaObject mediaObj = new MultimediaObject(input);
        MultimediaInfo mediaInfo = null;
        AudioInfo audioInfo = null;
        try {
            mediaInfo = mediaObj.getInfo();
            audioInfo = mediaInfo.getAudio();
        }
        catch (InputFormatException e) {
            log.error("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        if (audioInfo == null) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u4e0d\u662f\u97f3\u9891\u6587\u4ef6:" + input);
        }
        output = FfmpegUtils.mkdir(input, output, "amr");
        Encoder encoder = new Encoder();
        AudioAttributes audio = new AudioAttributes();
        audio.setChannels(Integer.valueOf(1));
        audio.setSamplingRate(Integer.valueOf(8000));
        EncodingAttributes attributes = new EncodingAttributes();
        attributes.setFormat("amr");
        attributes.setAudioAttributes(audio);
        try {
            encoder.encode(mediaObj, output, attributes);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u7801\u5931\u8d25:{}", (Object)encoder.getUnhandledMessages(), (Object)e);
            return null;
        }
        return output;
    }

    public static boolean hasVideo(File input) {
        if (input == null || !input.isFile() || !input.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + input);
        }
        MultimediaObject mediaSource = new MultimediaObject(input);
        MultimediaInfo mediaInfo = null;
        VideoInfo videoInfo = null;
        try {
            mediaInfo = mediaSource.getInfo();
            videoInfo = mediaInfo.getVideo();
        }
        catch (InputFormatException e) {
            log.error("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return videoInfo != null;
    }

    public static boolean hasAudio(File input) {
        if (input == null || !input.isFile() || !input.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728:" + input);
        }
        MultimediaObject mediaSource = new MultimediaObject(input);
        MultimediaInfo mediaInfo = null;
        AudioInfo audioInfo = null;
        try {
            mediaInfo = mediaSource.getInfo();
            audioInfo = mediaInfo.getAudio();
        }
        catch (InputFormatException e) {
            log.error("\u8f93\u5165\u7684\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        catch (EncoderException e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return audioInfo != null;
    }

    private static File mkdir(File source, File target, String suffix) {
        File parent;
        if (target == null) {
            String f = source.getAbsolutePath();
            String name = f.substring(0, f.lastIndexOf(46) + 1) + suffix;
            target = new File(name);
        }
        if ((parent = target.getParentFile()).exists()) {
            parent.mkdirs();
        }
        return target;
    }
}

