/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.dto.req.ConfDto;
import cn.kinyun.scrm.weixin.recommend.service.ConfService;
import com.kuaike.scrm.dal.activity.entity.BehaviorConf;
import com.kuaike.scrm.dal.activity.entity.OpConf;
import com.kuaike.scrm.dal.activity.mapper.BehaviorConfMapper;
import com.kuaike.scrm.dal.activity.mapper.OpConfMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfServiceImpl
implements ConfService {
    @Autowired
    BehaviorConfMapper behaviorConfMapper;
    @Autowired
    OpConfMapper opConfMapper;

    @Override
    public int addBehaviorConf(ConfDto params) {
        return this.behaviorConfMapper.insertSelective((Object)this.buildBehavior(params));
    }

    @Override
    public int addOpconf(ConfDto params) {
        return this.opConfMapper.insertSelective((Object)this.buildOp(params));
    }

    @Override
    public BehaviorConf getBehaviorConf(int confId) {
        return (BehaviorConf)this.behaviorConfMapper.selectByPrimaryKey((Object)confId);
    }

    @Override
    public List<BehaviorConf> getBehaviorConfs(List<Integer> confIds) {
        return this.behaviorConfMapper.queryList(confIds);
    }

    @Override
    public Map<Integer, BehaviorConf> getBehaviorMap() {
        return this.behaviorConfMapper.selectAll().stream().collect(Collectors.toMap(BehaviorConf::getId, Function.identity()));
    }

    @Override
    public OpConf getOpConf(int confId) {
        return (OpConf)this.opConfMapper.selectByPrimaryKey((Object)confId);
    }

    @Override
    public List<OpConf> getOpConf(List<Integer> confIds) {
        return this.opConfMapper.queryList(confIds);
    }

    private BehaviorConf buildBehavior(ConfDto params) {
        BehaviorConf conf = new BehaviorConf();
        conf.setId(params.getId());
        conf.setContextFields(String.join((CharSequence)",", params.getContextFields()));
        conf.setSystem(Integer.valueOf(params.getSystem()));
        conf.setRemark(params.getRemark());
        return conf;
    }

    private OpConf buildOp(ConfDto params) {
        OpConf conf = new OpConf();
        conf.setId(params.getId());
        conf.setContextFields(String.join((CharSequence)",", params.getContextFields()));
        conf.setSystem(Integer.valueOf(params.getSystem()));
        conf.setRemark(params.getRemark());
        return conf;
    }
}

