/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.common.component.DistributedLock;
import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityStatus;
import cn.kinyun.scrm.weixin.recommend.common.utils.GraphSvgsUtils;
import cn.kinyun.scrm.weixin.recommend.common.utils.MatchUtils;
import cn.kinyun.scrm.weixin.recommend.dto.GraphInstanceInfo;
import cn.kinyun.scrm.weixin.recommend.service.ActivityService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.activity.entity.Activity;
import com.kuaike.scrm.dal.activity.entity.ActivityBack;
import com.kuaike.scrm.dal.activity.entity.BehaviorConf;
import com.kuaike.scrm.dal.activity.entity.OpConf;
import com.kuaike.scrm.dal.activity.mapper.ActivityBackMapper;
import com.kuaike.scrm.dal.activity.mapper.ActivityMapper;
import com.kuaike.scrm.dal.activity.mapper.BehaviorConfMapper;
import com.kuaike.scrm.dal.activity.mapper.OpConfMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityBackMapper activityBackMapper;
    @Autowired
    private BehaviorConfMapper behaviorConfMapper;
    @Autowired
    private OpConfMapper opConfMapper;
    @Autowired
    DistributedLock distributedLock;

    @Override
    public List<Activity> matchBehavior(Behavior behavior) {
        List activityList = this.activityMapper.queryList(behavior.getBizId(), behavior.getConfId());
        ArrayList result = Lists.newArrayList();
        int priority = -1;
        Date now = new Date();
        for (Activity activity2 : activityList) {
            boolean flag = activity2.getExpireTime() == null || !activity2.getExpireTime().before(now);
            Graph graph = (Graph)JSONObject.parseObject((String)activity2.getActContent(), Graph.class);
            List<Edge> edges = graph.filterEdges(graph.getNearestNodeId());
            ArrayList conditions = Lists.newArrayList();
            edges.forEach(edge -> conditions.addAll(edge.getConditions()));
            if (!MatchUtils.match(graph.getContext(), (List<Condition>)conditions, behavior)) {
                flag = false;
            }
            if (!flag) continue;
            if (activity2.getPriority() > priority) {
                priority = activity2.getPriority();
            }
            result.add(activity2);
        }
        int finalPriority = priority;
        return result.stream().filter(activity -> activity.getPriority() == finalPriority).collect(Collectors.toList());
    }

    @Override
    public List<GraphInstanceInfo> hasInstance(Collection<Long> graphIds, String objectId) {
        if (CollectionUtils.isEmpty(graphIds) || !StringUtils.isNotBlank((CharSequence)objectId)) {
            return Lists.newArrayList();
        }
        Map<Long, List<ActivityBack>> activityBackMap = this.activityBackMapper.queryList(graphIds, objectId).stream().collect(Collectors.groupingBy(ActivityBack::getGraphId));
        Map<Long, List<Activity>> activityMap = this.activityMapper.queryByGraphAndObject(graphIds, objectId).stream().collect(Collectors.groupingBy(Activity::getGraphId));
        ArrayList result = Lists.newArrayList();
        for (Long id : graphIds) {
            GraphInstanceInfo instanceInfo = new GraphInstanceInfo();
            instanceInfo.setGraphId(id);
            if (CollectionUtils.isNotEmpty((Collection)activityBackMap.get(id))) {
                instanceInfo.setHavingInstance(true);
                long activeCount = activityMap.getOrDefault(id, Lists.newArrayList()).stream().filter(a -> a.getActStatus().intValue() == ActivityStatus.PROCESSING.getStatus()).count();
                instanceInfo.setHavingActiveInstance(activeCount > 0L);
            } else {
                instanceInfo.setHavingInstance(false);
                instanceInfo.setHavingActiveInstance(false);
            }
            result.add(instanceInfo);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long addActivity(Activity activity) {
        this.activityMapper.insertSelective((Object)activity);
        ActivityBack activityBack = this.from(activity);
        this.activityBackMapper.insertSelective((Object)activityBack);
        return activity.getId();
    }

    @Override
    public Activity getActivity(Long activityId) {
        return (Activity)this.activityMapper.selectByPrimaryKey((Object)activityId);
    }

    @Override
    public boolean matchActivity(Activity activity, Behavior behavior) {
        if (activity != null) {
            Graph graph = (Graph)JSONObject.parseObject((String)activity.getActContent(), Graph.class);
            List<Edge> edges = graph.filterEdges(graph.getNearestNodeId());
            ArrayList conditions = Lists.newArrayList();
            edges.forEach(edge -> conditions.addAll(edge.getConditions()));
            return MatchUtils.match(graph.getContext(), (List<Condition>)conditions, behavior);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateActivity(Activity activity) {
        this.activityMapper.updateByPrimaryKey((Object)activity);
        Long backId = this.activityBackMapper.queryBackId(activity.getId());
        if (backId != null) {
            ActivityBack activityBack = this.from(activity);
            activityBack.setId(backId);
            this.activityBackMapper.updateByPrimaryKey((Object)activityBack);
        } else {
            log.warn("query activity_back is null, activityId: {}", (Object)activity.getId());
        }
    }

    @Override
    public List<Activity> queryListWithTimeoutbehavior() {
        List activityList = this.activityMapper.queryTimeOutList(new Date());
        ArrayList result = Lists.newArrayList();
        Date now = new Date();
        for (Activity activity : activityList) {
            if (activity.getExpireTime() != null && activity.getExpireTime().before(now)) continue;
            result.add(activity);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backupActivity() {
        log.info("finished activity clean task start");
        List delIds = this.activityMapper.queryFinishedActivities();
        if (CollectionUtils.isNotEmpty((Collection)delIds)) {
            log.info("clean finished activity with ids={}", (Object)delIds);
            List<String> lockKeys = delIds.stream().map(Object::toString).collect(Collectors.toList());
            try {
                this.distributedLock.multiLock(lockKeys);
                this.activityMapper.batchDel((Collection)delIds);
                this.activityBackMapper.batchUpdateStatus((Collection)delIds, Integer.valueOf(ActivityStatus.FINISHED.getStatus()));
            }
            catch (InterruptedException e) {
                log.error("log failed", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.distributedLock.unlockMultiLock(lockKeys);
            }
        }
        log.info("finished activity clean task end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activitiesExpired() {
        log.info("activitiesExpired task start");
        List ids = this.activityMapper.queryExpiredActivities(new Date());
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            log.info("clean expired activity with ids={}", (Object)ids);
            List<String> lockKeys = ids.stream().map(Object::toString).collect(Collectors.toList());
            try {
                this.distributedLock.multiLock(lockKeys);
                this.activityMapper.batchDel((Collection)ids);
                this.activityBackMapper.batchUpdateStatus((Collection)ids, Integer.valueOf(ActivityStatus.EXPIRED.getStatus()));
            }
            catch (InterruptedException e) {
                log.error("lock failed", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.distributedLock.unlockMultiLock(lockKeys);
            }
        }
        log.info("activitiesExpired task end");
    }

    @Override
    public String getGraphSvg(Long id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null!");
        Activity activity = (Activity)this.activityMapper.selectByPrimaryKey((Object)id);
        if (activity == null) {
            return "";
        }
        Graph g = (Graph)JSONObject.parseObject((String)activity.getActContent(), Graph.class);
        Map<Integer, OpConf> opConfMap = this.opConfMapper.selectAll().stream().collect(Collectors.toMap(OpConf::getId, Function.identity()));
        Map<Integer, BehaviorConf> bConfMap = this.behaviorConfMapper.selectAll().stream().collect(Collectors.toMap(BehaviorConf::getId, Function.identity()));
        return GraphSvgsUtils.getGraphSvg(g, opConfMap, bConfMap);
    }

    private ActivityBack from(Activity activity) {
        ActivityBack back = new ActivityBack();
        back.setActivityId(activity.getId());
        back.setActContent(activity.getActContent());
        back.setActStatus(activity.getActStatus());
        back.setBizId(activity.getBizId());
        back.setCorpId(activity.getCorpId());
        back.setObjectId(activity.getObjectId());
        back.setCreateTime(activity.getCreateTime());
        back.setExpireTime(activity.getExpireTime());
        back.setGraphId(activity.getGraphId());
        back.setPriority(activity.getPriority());
        back.setTimeOut(activity.getTimeOut());
        back.setTimeTrigger(activity.getTimeTrigger());
        back.setTriggerBehaviors(activity.getTriggerBehaviors());
        back.setUpdateTime(activity.getUpdateTime());
        return back;
    }
}

