/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.service.impl;

import cn.kinyun.scrm.weixin.recommend.common.enums.ModuleEnum;
import cn.kinyun.scrm.weixin.recommend.common.service.KafkaMessageProducer;
import cn.kinyun.scrm.weixin.recommend.common.service.KafkaSendCallback;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.stereotype.Service;

@Service
public class MessageProducerImpl
implements KafkaMessageProducer {
    private static final Logger log = LoggerFactory.getLogger(MessageProducerImpl.class);
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    private static Map<String, KafkaSendCallback> callbackMaps = Maps.newConcurrentMap();

    @Override
    public void send(final Long id, ModuleEnum module, String topic, String key, String msgJson, KafkaSendCallback callback, String modualClass, boolean ifSaveWhenError) {
        key = StringUtils.isEmpty((CharSequence)key) ? "" : key;
        key = key + UUID.randomUUID().toString();
        if (callback != null) {
            callbackMaps.put(key, callback);
        }
        this.kafkaTemplate.setProducerListener((ProducerListener)new ProducerListener<String, String>(){

            public void onSuccess(String topic, Integer partition, String key, String value, RecordMetadata recordMetadata) {
                log.info("send topic:{} msg success,message={}", (Object)topic, (Object)value);
                KafkaSendCallback callback = (KafkaSendCallback)callbackMaps.get(key);
                if (callback != null) {
                    callback.onSuccess();
                    callbackMaps.remove(key);
                }
                if (id != null && id > 0L) {
                    log.info("\u8865\u507f\u53d1\u9001\u6210\u529f,id={}", (Object)id);
                }
            }

            public void onError(String topic, Integer partition, String key, String value, Exception exception) {
                log.warn("fail to send message: topic:{},key:{},value:{}", new Object[]{topic, key, value});
                log.warn("callbackAddDevice fail", (Throwable)exception);
                KafkaSendCallback callback = (KafkaSendCallback)callbackMaps.get(key);
                if (callback != null) {
                    callback.onFail();
                    callbackMaps.remove(key);
                }
            }

            public boolean isInterestedInSuccess() {
                return true;
            }
        });
        this.kafkaTemplate.send(topic, (Object)key, (Object)msgJson);
    }
}

