/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.TagReqDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountTagService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.dto.TagQueryParam;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountTag;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTagMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountTagServiceImpl
implements OfficialAccountTagService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountTagServiceImpl.class);
    @Resource
    private OfficialAccountTagMapper tagMapper;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Resource
    private WeworkTagMapper weworkTagMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int add(TagReqDto params) {
        log.info("addOrMod tag with params={}", (Object)params);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getTagNames()), (Object)"tagNames must not be null");
        List<String> tagNames = params.getTagNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getTagNames()), (Object)"tagNames are invalid");
        params.commonValidate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        TagQueryParam tagQueryParam = TagQueryParam.instance().bizId(params.getBusinessCustomerId()).tagNames(tagNames);
        List tags = this.tagMapper.queryList(tagQueryParam);
        ArrayList existTagNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            existTagNames.addAll(tags.stream().map(OfficialAccountTag::getDescription).collect(Collectors.toList()));
        }
        ArrayList saveTags = Lists.newArrayList();
        tagNames.forEach(tagName -> {
            String name = tagName.trim();
            if (existTagNames.contains(name)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u6709\u8be5\u6807\u7b7e\uff0c\u8bf7\u9009\u62e9\u5df2\u6709\u6807\u7b7e");
            }
            OfficialAccountTag tag = new OfficialAccountTag();
            tag.setBizId(params.getBusinessCustomerId());
            tag.setCorpId(userInfo.getCorpId());
            tag.setDescription(name);
            tag.setCreatorId(params.getOperatorId());
            saveTags.add(tag);
        });
        if (CollectionUtils.isNotEmpty((Collection)saveTags)) {
            try {
                this.tagMapper.saveAll((List)saveTags);
            }
            catch (DuplicateKeyException e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u6807\u7b7e");
            }
        }
        return saveTags.size();
    }

    @Override
    public List<IdAndNameDto> list(TagReqDto params) {
        log.info("query tag list with params={}", (Object)params);
        params.commonValidate();
        PageDto pageDto = params.getPageDto();
        TagQueryParam tagQueryParam = TagQueryParam.instance().bizId(params.getBusinessCustomerId()).query(params.getQuery()).pageDto(pageDto);
        List tags = this.tagMapper.queryList(tagQueryParam);
        int count = this.tagMapper.count(tagQueryParam);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(tags == null ? 0 : tags.size()));
        }
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return Collections.emptyList();
        }
        return tags.stream().map(a -> new IdAndNameDto(a.getId(), a.getDescription())).collect(Collectors.toList());
    }

    @Override
    public List<WeworkTagDto> appTagList(TagReqDto params) {
        List<String> app2PostTagIds;
        log.info("query app tag list with params={}", (Object)params);
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId must not be null");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List<String> permitAppIds = this.operatorService.getPermitAppIds(params.getOperatorId(), UserIdentity.MANAGER.getValue());
        if (CollectionUtils.isNotEmpty(params.getAppIds())) {
            permitAppIds.retainAll(params.getAppIds());
            if (CollectionUtils.isEmpty(permitAppIds)) {
                return Collections.emptyList();
            }
        }
        if (CollectionUtils.isEmpty(app2PostTagIds = this.fansTagService.queryDistinctAppPostTagIds(permitAppIds))) {
            return Collections.emptyList();
        }
        Map tagMap = this.weworkTagMapper.queryTagIdAndName(userInfo.getCorpId(), app2PostTagIds);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(tagMap.values())) {
            tagMap.forEach((tagId, name) -> {
                WeworkTagDto tagDto = new WeworkTagDto();
                tagDto.setId(tagId);
                tagDto.setName(name);
                result.add(tagDto);
            });
        }
        return result;
    }
}

