/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountAuthService;
import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizationInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.FunctionInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.PreAuthCode;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.WeixinCallbackDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountOperator;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountOperatorMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.service.MeetingCacheService;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountAuthServiceImpl
implements OfficialAccountAuthService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountAuthServiceImpl.class);
    private static final String FUNCTION_ID_SPIT = ",";
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-mp}")
    private String hostName;
    @Value(value="${kafka.topic.weixin_callback}")
    private String topic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialAccountOperatorMapper officialAccountOperatorMapper;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private UserMapper userMapper;
    @Resource
    private MeetingCacheService meetingCacheService;

    @Override
    public String getAuthUrl() {
        String authCode;
        log.info("get auth url by operatorId={}", (Object)LoginUtils.getCurrentUserId());
        String num = this.userMapper.getNumById(LoginUtils.getCurrentUserId());
        try {
            String accessToken = this.componentTokenService.getComponentAccessToken();
            PreAuthCode preAuthCode = this.componentAuthAPI.preAuthCode(accessToken, this.componentAppId);
            authCode = preAuthCode.getPreAuthCode();
            log.info("get component pre auth code={}", (Object)authCode);
        }
        catch (WeixinException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        String redirectUri = this.hostName + "/official/" + num + "/auth.json";
        return this.componentAuthAPI.bindcomponent(this.componentAppId, authCode, redirectUri, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean callback(String num, String authCode, int expire) {
        AuthorizerInfoResp appInfo;
        String appId;
        AuthInfoResp authInfo;
        log.info("weixin component auth callback, num={}, authCode={}, expire={}", new Object[]{num, authCode, expire});
        Preconditions.checkArgument((num != null ? 1 : 0) != 0, (Object)"num is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)authCode), (Object)"authCode is null!");
        Long userId = this.userMapper.getIdByNum(num);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"auth user is not found");
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"auth user is not found");
        try {
            String componentAccessToken = this.componentTokenService.getComponentAccessToken();
            authInfo = this.componentAuthAPI.apiQueryAuth(componentAccessToken, this.componentAppId, authCode);
            appId = authInfo.getAuthorizationInfo().getAuthorizerAppId();
            appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
        }
        catch (WeixinException e) {
            log.error("\u516c\u4f17\u53f7\u6388\u6743\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getErrorMsg());
        }
        AuthorizerInfo authorizerInfo = appInfo.getAuthorizerInfo();
        String nickname = authorizerInfo.getNickName();
        Long serviceType = authorizerInfo.getServiceTypeInfo().getId();
        Long verifyType = authorizerInfo.getVerifyTypeInfo().getId();
        if (serviceType != 2L) {
            log.warn("\u516c\u4f17\u53f7 {} \u4e0d\u662f\u670d\u52a1\u53f7\uff0c\u65e0\u6cd5\u63d0\u4f9b\u670d\u52a1\u3002", (Object)nickname);
            return false;
        }
        if (verifyType != 0L) {
            log.warn("\u516c\u4f17\u53f7 {} \u672a\u901a\u8fc7\u5fae\u4fe1\u8ba4\u8bc1\uff0c\u65e0\u6cd5\u63d0\u4f9b\u670d\u52a1\u3002", (Object)nickname);
            return false;
        }
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
        if (officialAccount == null) {
            this.addOfficialAccount(authInfo.getAuthorizationInfo(), appInfo.getAuthorizerInfo(), user);
        } else {
            this.updateOfficialAccount(officialAccount, authInfo.getAuthorizationInfo(), appInfo.getAuthorizerInfo(), user);
        }
        log.info("\u6dfb\u52a0\u516c\u4f17\u53f7\u8fd0\u8425\u4eba\u5458, appId={}, bizId={}, userId={}", new Object[]{appId, user.getBizId(), user.getId()});
        OfficialAccountOperator officialAccountOperator = this.officialAccountOperatorMapper.queryByUserIdAndAccountIdentity(appId, user.getId(), UserIdentity.MANAGER.getValue());
        if (officialAccountOperator == null) {
            OfficialAccountOperator operator = new OfficialAccountOperator();
            operator.setAppId(appId);
            operator.setUserId(user.getId());
            operator.setUserIdentity(UserIdentity.MANAGER.getValue());
            operator.setBizId(user.getBizId());
            operator.setCorpId(user.getCorpId());
            operator.setCreateTime(new Date());
            operator.setUpdateTime(new Date());
            this.officialAccountOperatorMapper.insertSelective((Object)operator);
        }
        log.info("callback after auth complete, authorizerInfo:{}", (Object)appInfo.getAuthorizerInfo());
        WeixinCallbackDto dto = new WeixinCallbackDto();
        dto.setType("Sync");
        dto.setMsgType("fans");
        dto.setData(appId);
        try {
            this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)dto));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7c89\u4e1d\u4fe1\u606f\u5931\u8d25, appId={}", (Object)appId, (Object)e);
        }
        return true;
    }

    private void updateOfficialAccount(OfficialAccount account, AuthorizationInfo authInfo, AuthorizerInfo appInfo, User user) {
        Date now = new Date();
        account.setBizId(user.getBizId());
        account.setCorpId(user.getCorpId());
        account.setNodeId(user.getNodeId());
        this.setAuthorizerInfo(account, appInfo, authInfo);
        if (account.getAuthStatus() != 1) {
            account.setAuthTime(now);
            account.setAuthStatus(Integer.valueOf(1));
        }
        account.setCreatorId(user.getId());
        account.setUpdateTime(now);
        this.officialAccountMapper.updateByPrimaryKeySelective((Object)account);
        try {
            this.meetingCacheService.setOfficialAppId(user.getBizId(), account.getAppId());
        }
        catch (Exception e) {
            log.error("meetingCacheService,setOfficialAppId error", (Throwable)e);
        }
    }

    private void addOfficialAccount(AuthorizationInfo authInfo, AuthorizerInfo appInfo, User user) {
        Date now = new Date();
        OfficialAccount account = new OfficialAccount();
        account.setBizId(user.getBizId());
        account.setCorpId(user.getCorpId());
        account.setNodeId(Long.valueOf(-1L));
        this.setAuthorizerInfo(account, appInfo, authInfo);
        account.setAuthTime(now);
        account.setAuthStatus(Integer.valueOf(1));
        account.setCreatorId(user.getId());
        account.setCreateTime(now);
        account.setUpdateTime(now);
        this.officialAccountMapper.insertSelective((Object)account);
        try {
            this.meetingCacheService.setOfficialAppId(user.getBizId(), account.getAppId());
        }
        catch (Exception e) {
            log.error("meetingCacheService,setOfficialAppId error", (Throwable)e);
        }
    }

    private void setAuthorizerInfo(OfficialAccount account, AuthorizerInfo authorizerInfo, AuthorizationInfo authorizationInfo) {
        account.setNickName(authorizerInfo.getNickName());
        account.setAlias(authorizerInfo.getAlias());
        account.setHeadImg(authorizerInfo.getHeadImg());
        account.setPrincipalName(authorizerInfo.getPrincipalName());
        account.setQrcodeUrl(authorizerInfo.getQrcodeUrl());
        account.setUserName(authorizerInfo.getUserName());
        account.setVerifyType(Integer.valueOf(authorizerInfo.getVerifyTypeInfo().getId().intValue()));
        account.setServiceType(Integer.valueOf(authorizerInfo.getServiceTypeInfo().getId().intValue()));
        int function = authorizerInfo.getBusinessInfo().getOpenStore() << 4 + authorizerInfo.getBusinessInfo().getOpenScan() << 3 + authorizerInfo.getBusinessInfo().getOpenPay() << 2 + authorizerInfo.getBusinessInfo().getOpenCard() << 1 + authorizerInfo.getBusinessInfo().getOpenShake();
        account.setBusinessInfo(Integer.valueOf(function));
        account.setAppId(authorizationInfo.getAuthorizerAppId());
        account.setAccessToken(authorizationInfo.getAuthorizerAccessToken());
        account.setRefreshToken(authorizationInfo.getAuthorizerRefreshToken());
        account.setTokenExpireTime(DateUtils.addSeconds((Date)new Date(), (int)((int)authorizationInfo.getExpires())));
        StringBuilder sb = new StringBuilder();
        sb.append(FUNCTION_ID_SPIT);
        for (FunctionInfo category : authorizationInfo.getFuncInfo()) {
            sb.append(category.getFuncscopeCategory().getId()).append(FUNCTION_ID_SPIT);
        }
        account.setFunctionInfo(sb.toString());
    }
}

