/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.menu.service.impl;

import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.menu.service.MenuTextReplyService;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.official.reply.entity.OfficialMenuTextReply;
import com.kuaike.scrm.dal.official.reply.mapper.OfficialMenuTextReplyMapper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuTextReplyServiceImpl
implements MenuTextReplyService {
    private static final Logger log = LoggerFactory.getLogger(MenuTextReplyServiceImpl.class);
    @Resource
    private OfficialMenuTextReplyMapper textReplyMapper;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private MessageService messageService;

    @Override
    public OfficialMenuTextReply getById(Long id) {
        log.info("get menu text reply with replyId={}", (Object)id);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID is null");
        return (OfficialMenuTextReply)this.textReplyMapper.selectByPrimaryKey((Object)id);
    }

    @Override
    public void receiveTextMenuClickEvent(Long autoMenuReplyTextId, String appId, String openId) {
        log.info("receive text menu click event with replyId={}, appId={}, openId={}", new Object[]{autoMenuReplyTextId, appId, openId});
        OfficialMenuTextReply reply = this.getById(autoMenuReplyTextId);
        if (reply == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u83dc\u5355\u56de\u590d");
        }
        TextMsg text = new TextMsg();
        text.setFromUserName(appId);
        text.setToUserName(openId);
        text.setContent(reply.getReplyMessage());
        this.sendMessageService.send((BaseRespMsg)text);
        this.messageService.saveMsg((BaseRespMsg)text, MsgSendType.SYS_SEND_FANS, -1L, -1L);
    }
}

