/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.menu.dto.req;

import cn.kinyun.scrm.weixin.common.dto.BaseParam;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuButton;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.MenuCreateEntity;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CreateMenuReq
extends BaseParam {
    private static final long serialVersionUID = -3604892212692248288L;
    private String appId;
    private MenuCreateEntity menuList;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.appId), (Object)"appId can not be null or empty");
        Preconditions.checkArgument((this.menuList != null ? 1 : 0) != 0, (Object)"menuList can not be null");
    }

    public static CreateMenuReq create(String appId, List<MenuButton> menuButtonList, Long operatorId) {
        CreateMenuReq req = new CreateMenuReq();
        req.setAppId(appId);
        req.setOperatorId(operatorId);
        MenuCreateEntity entity = new MenuCreateEntity();
        entity.setButton(menuButtonList);
        req.setMenuList(entity);
        return req;
    }

    public String getAppId() {
        return this.appId;
    }

    public MenuCreateEntity getMenuList() {
        return this.menuList;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setMenuList(MenuCreateEntity menuList) {
        this.menuList = menuList;
    }

    @Override
    public String toString() {
        return "CreateMenuReq(appId=" + this.getAppId() + ", menuList=" + this.getMenuList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateMenuReq)) {
            return false;
        }
        CreateMenuReq other = (CreateMenuReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        MenuCreateEntity this$menuList = this.getMenuList();
        MenuCreateEntity other$menuList = other.getMenuList();
        return !(this$menuList == null ? other$menuList != null : !this$menuList.equals(other$menuList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateMenuReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        MenuCreateEntity $menuList = this.getMenuList();
        result = result * 59 + ($menuList == null ? 43 : $menuList.hashCode());
        return result;
    }
}

