/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.material.service.OfficalMaterialSyncService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.sdk.api.WxMediaAPI;
import cn.kinyun.scrm.weixin.sdk.api.material.MaterialApi;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.ArticleDto;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.NewsContent;
import cn.kinyun.scrm.weixin.sdk.entity.material.req.AddNewsReq;
import cn.kinyun.scrm.weixin.sdk.entity.material.req.AddVideoReq;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.AddMaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.AddNewsResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.GetMaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.sdk.entity.media.MediaResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.Article;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import cn.kinyun.scrm.weixin.utils.DownloadUtils;
import cn.kinyun.scrm.weixin.utils.NewMaterialUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterial;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterialFile;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterialNews;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialFileMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialNewsMapper;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficalMaterialSyncServiceImpl
implements OfficalMaterialSyncService {
    private static final Logger log = LoggerFactory.getLogger(OfficalMaterialSyncServiceImpl.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(4);
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private MaterialApi materialApi;
    @Autowired
    private WxMediaAPI mediaApi;
    @Resource
    private OfficialMaterialFileMapper materialFileMapper;
    @Resource
    private OfficialAccountMaterialMapper officialAccountMaterialMapper;
    @Resource
    private OfficialAccountMaterialFileMapper officialAccountMaterialFileMapper;
    @Resource
    private OfficialAccountMaterialNewsMapper officialAccountMaterialNewsMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    private static final String WECHAT_NEW_COVER_PIC_PREFIX = "http://mmbiz.qpic.cn/mmbiz_jpg";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MsgData syncImageMaterial(OfficialMaterial imageM, String appId) {
        Preconditions.checkArgument((imageM != null ? 1 : 0) != 0, (Object)"material is null!");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null!");
        OfficialAccountMaterial officialAccountMaterial = this.officialAccountMaterialMapper.getByMaterialId(imageM.getId(), appId);
        String mediaId = this.getMediaIdFromDB(officialAccountMaterial, imageM, appId);
        if (mediaId != null) {
            return this.buildMsgData(mediaId, imageM);
        }
        String urlMd5 = MD5Utils.MD5Encode8((String)imageM.getUrl());
        OfficialMaterialFile materialFile = this.materialFileMapper.getByUrlMd5(urlMd5);
        File file = null;
        try {
            file = DownloadUtils.loadFile(imageM.getUrl(), materialFile.getFileFormat());
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            AddMaterialResp resp = this.materialApi.addMaterial(accessToken, WxMediaType.Image, file);
            this.addOfficialAccountMaterialFile(urlMd5, resp.getMediaId(), resp.getUrl(), appId, WxMediaType.Image.getValue(), materialFile.getBizId(), materialFile.getCorpId());
            this.addorModOfficialAccountMaterial(officialAccountMaterial, imageM.getId(), resp.getMediaId(), appId);
            MsgData msgData = this.buildMsgData(resp.getMediaId(), imageM);
            this.deleteFile(file);
            return msgData;
        }
        catch (WeixinException e) {
            try {
                log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e);
                throw e;
                catch (Exception e2) {
                    log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                this.deleteFile(file);
                throw throwable;
            }
        }
    }

    private void deleteFile(File file) {
        if (file != null) {
            file.delete();
            File parentUuidDir = file.getParentFile();
            if (parentUuidDir != null) {
                parentUuidDir.delete();
            }
        }
    }

    private MsgData buildMsgData(String mediaId, OfficialMaterial material) {
        MsgData msgData = new MsgData();
        msgData.setMediaId(mediaId);
        msgData.setTitle(material.getTitle());
        msgData.setDescription(material.getDigest());
        msgData.setMediaUrl(material.getUrl());
        msgData.setMediaType(material.getmType());
        return msgData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MsgData syncVoiceMaterial(OfficialMaterial voiceM, String appId) {
        Preconditions.checkArgument((voiceM != null ? 1 : 0) != 0, (Object)"material is null!");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null!");
        OfficialAccountMaterial officialAccountMaterial = this.officialAccountMaterialMapper.getByMaterialId(voiceM.getId(), appId);
        String mediaId = this.getMediaIdFromDB(officialAccountMaterial, voiceM, appId);
        if (mediaId != null) {
            return this.buildMsgData(mediaId, voiceM);
        }
        String urlMd5 = MD5Utils.MD5Encode8((String)voiceM.getUrl());
        OfficialMaterialFile materialFile = this.materialFileMapper.getByUrlMd5(urlMd5);
        File file = null;
        try {
            file = DownloadUtils.loadFile(voiceM.getUrl(), materialFile.getFileFormat());
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            AddMaterialResp resp = this.materialApi.addMaterial(accessToken, WxMediaType.Voice, file);
            this.addOfficialAccountMaterialFile(urlMd5, resp.getMediaId(), resp.getUrl(), appId, WxMediaType.Voice.getValue(), materialFile.getBizId(), materialFile.getCorpId());
            this.addorModOfficialAccountMaterial(officialAccountMaterial, voiceM.getId(), resp.getMediaId(), appId);
            MsgData msgData = this.buildMsgData(resp.getMediaId(), voiceM);
            this.deleteFile(file);
            return msgData;
        }
        catch (WeixinException e) {
            try {
                log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e);
                throw e;
                catch (Exception e2) {
                    log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                this.deleteFile(file);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MsgData syncVideoMaterial(OfficialMaterial videoM, String appId) {
        Preconditions.checkArgument((videoM != null ? 1 : 0) != 0, (Object)"material is null!");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null!");
        OfficialAccountMaterial officialAccountMaterial = this.officialAccountMaterialMapper.getByMaterialId(videoM.getId(), appId);
        String mediaId = this.getMediaIdFromDB(officialAccountMaterial, videoM, appId);
        if (mediaId != null) {
            return this.buildMsgData(mediaId, videoM);
        }
        String urlMd5 = MD5Utils.MD5Encode8((String)videoM.getUrl());
        OfficialMaterialFile materialFile = this.materialFileMapper.getByUrlMd5(urlMd5);
        File file = null;
        try {
            file = DownloadUtils.loadFile(videoM.getUrl(), materialFile.getFileFormat());
            AddVideoReq req = new AddVideoReq();
            req.setTitle(videoM.getTitle());
            req.setIntroduction(videoM.getDigest());
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            AddMaterialResp resp = this.materialApi.addVideo(accessToken, file, req);
            this.addOfficialAccountMaterialFile(urlMd5, resp.getMediaId(), resp.getUrl(), appId, WxMediaType.Video.getValue(), materialFile.getBizId(), materialFile.getCorpId());
            this.addorModOfficialAccountMaterial(officialAccountMaterial, videoM.getId(), resp.getMediaId(), appId);
            MsgData msgData = this.buildMsgData(resp.getMediaId(), videoM);
            this.deleteFile(file);
            return msgData;
        }
        catch (WeixinException e) {
            try {
                log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e);
                throw e;
                catch (Exception e2) {
                    log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                this.deleteFile(file);
                throw throwable;
            }
        }
    }

    @Override
    public MsgData syncNewsMaterial(List<OfficialMaterial> news, OfficialMaterial newsM, String appId) {
        Preconditions.checkArgument((newsM != null ? 1 : 0) != 0, (Object)"material is null!");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null!");
        OfficialAccountMaterial officialAccountMaterial = this.officialAccountMaterialMapper.getByMaterialId(newsM.getId(), appId);
        if (officialAccountMaterial != null) {
            if (officialAccountMaterial.getUpdateTime().after(newsM.getUpdateTime())) {
                this.refreshOfficialNews(officialAccountMaterial, true);
                return this.buildNewsMsgData(news, newsM, officialAccountMaterial.getMediaId());
            }
            String cover = newsM.getCover();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cover})) {
                boolean needSync = true;
                List coverUrls = Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)cover);
                for (String coverUrl : coverUrls) {
                    if (!coverUrl.startsWith(WECHAT_NEW_COVER_PIC_PREFIX)) continue;
                    needSync = false;
                    break;
                }
                if (!needSync) {
                    return this.buildNewsMsgData(news, newsM, officialAccountMaterial.getMediaId());
                }
            }
        }
        HashSet covers = Sets.newHashSet();
        HashSet images = Sets.newHashSet();
        HashMap md5Map = Maps.newHashMap();
        for (OfficialMaterial material : news) {
            String[] imagesArr;
            if (StringUtils.isNotBlank((CharSequence)material.getCover())) {
                md5Map.put(material.getCover(), MD5Utils.MD5Encode8((String)material.getCover()));
                covers.add(md5Map.get(material.getCover()));
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{material.getContent()})) continue;
            for (String image : imagesArr = NewMaterialUtils.getImgs(material.getContent())) {
                md5Map.put(image, MD5Utils.MD5Encode8((String)image));
                images.add(md5Map.get(image));
            }
        }
        ArrayList urlMd5List = Lists.newArrayList();
        urlMd5List.addAll(covers);
        urlMd5List.addAll(images);
        HashMap offmFileMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)urlMd5List)) {
            offmFileMap.putAll(this.officialAccountMaterialFileMapper.getListByUrlMd5((List)urlMd5List, appId).stream().collect(Collectors.groupingBy(OfficialAccountMaterialFile::getUrlMd5, Collectors.toMap(OfficialAccountMaterialFile::getmType, Function.identity()))));
        }
        Map fileMap = this.materialFileMapper.getListByUrlMd5((List)urlMd5List).stream().collect(Collectors.toMap(OfficialMaterialFile::getUrlMd5, Function.identity()));
        ConcurrentHashMap<String, Map<String, OfficialAccountMaterialFile>> syncOffmFileMap = new ConcurrentHashMap<String, Map<String, OfficialAccountMaterialFile>>(offmFileMap);
        ArrayList tasks = Lists.newArrayList();
        for (String cover : covers) {
            tasks.add(() -> {
                this.syncNewsImageToOfficial(cover, appId, WxMediaType.Thumb, fileMap, syncOffmFileMap);
                return 1L;
            });
        }
        for (String image : images) {
            tasks.add(() -> {
                this.syncNewsImageToOfficial(image, appId, WxMediaType.News, fileMap, syncOffmFileMap);
                return 1L;
            });
        }
        try {
            EXECUTOR_SERVICE.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        AddNewsReq req = this.buildAddNewsReq(news, syncOffmFileMap);
        String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
        AddNewsResp resp = this.materialApi.addNews(accessToken, req);
        if (!StringUtils.isNotBlank((CharSequence)resp.getMediaId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u540c\u6b65\u56fe\u6587\u7d20\u6750\u5230\u7d20\u6750\u5e93\u5931\u8d25" + resp.getMediaId());
        }
        officialAccountMaterial = this.addorModOfficialAccountMaterial(officialAccountMaterial, newsM.getId(), resp.getMediaId(), appId);
        this.refreshOfficialNews(officialAccountMaterial, false);
        return this.buildNewsMsgData(news, newsM, resp.getMediaId());
    }

    private MsgData buildNewsMsgData(List<OfficialMaterial> news, OfficialMaterial newsM, String mediaId) {
        MsgData data = this.buildMsgData(mediaId, newsM);
        data.setArticles(Lists.newArrayList());
        for (OfficialMaterial m : news) {
            Article a = new Article();
            a.setTitle(m.getTitle());
            a.setPicUrl(m.getCover());
            data.getArticles().add(a);
        }
        return data;
    }

    private void refreshOfficialNews(OfficialAccountMaterial officialAccountMaterial, boolean compensateFresh) {
        try {
            List officialNewsList = this.officialAccountMaterialNewsMapper.getByOfficialMaterialId(officialAccountMaterial.getId());
            if (CollectionUtils.isNotEmpty((Collection)officialNewsList) && compensateFresh) {
                return;
            }
            String mediaId = officialAccountMaterial.getMediaId();
            String token = this.officialTokenService.getOfficialAccessToken(officialAccountMaterial.getAppId());
            GetMaterialResp material = this.materialApi.getMaterial(token, mediaId);
            if (material == null || material.getType() != 1) {
                log.warn("mediaId={} \u5728\u5fae\u4fe1\u7d20\u6750\u5e93\u4e0d\u5b58\u5728", (Object)mediaId);
                return;
            }
            NewsContent news = material.getNews();
            if (news != null && CollectionUtils.isNotEmpty((Collection)news.getNewsItem())) {
                List articles = news.getNewsItem();
                if (CollectionUtils.isEmpty((Collection)articles)) {
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)officialNewsList)) {
                    List officialNewsIds = officialNewsList.stream().map(OfficialAccountMaterialNews::getId).collect(Collectors.toList());
                    this.officialAccountMaterialNewsMapper.delByIds(officialNewsIds);
                }
                this.saveOfficialNews(articles, officialAccountMaterial.getId(), officialAccountMaterial.getBizId(), officialAccountMaterial.getCorpId());
            }
        }
        catch (WeixinException we) {
            log.error("get material from wechat error", (Throwable)we);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u6587\u5728\u516c\u4f17\u53f7\u540e\u53f0\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        catch (Exception e) {
            log.error("get material from wechat error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4fdd\u5b58\u516c\u4f17\u53f7\u56fe\u6587\u5931\u8d25");
        }
    }

    private void saveOfficialNews(List<ArticleDto> articles, Long officialAccountMaterialId, Long bizId, String corpId) {
        ArrayList newsList = Lists.newArrayList();
        int num = 0;
        for (ArticleDto article : articles) {
            OfficialAccountMaterialNews news = new OfficialAccountMaterialNews();
            news.setBizId(bizId);
            news.setCorpId(corpId);
            news.setNum(Integer.valueOf(num++));
            news.setOfficialAccountMaterialId(officialAccountMaterialId);
            news.setUrl(article.getUrl());
            newsList.add(news);
        }
        this.officialAccountMaterialNewsMapper.batchInsert((List)newsList);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String syncTmpImageMaterial(String url, String appId, String mType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)url), (Object)"url is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)mType), (Object)"mType is null");
        String urlMD5 = MD5Utils.MD5Encode8((String)url);
        OfficialAccountMaterialFile oamFile = this.officialAccountMaterialFileMapper.getByUrlMd5(urlMD5, appId, mType);
        if (oamFile != null && "tmp_image".equalsIgnoreCase(oamFile.getmType()) && DateUtil.getDateDiff((Date)oamFile.getCreateTime(), (Date)new Date()) < 3) {
            return oamFile.getMediaId();
        }
        OfficialAccount account = this.officialAccountMapper.getByAppId(appId);
        File file = null;
        try {
            String type = url.substring(url.lastIndexOf(46) + 1);
            file = DownloadUtils.loadFile(url, type);
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            MediaResult resp = this.mediaApi.upload(accessToken, WxMediaType.Image, file);
            this.addOfficialAccountMaterialFile(urlMD5, resp.getMediaId(), "", appId, WxMediaType.Tmp_image.getValue(), account.getBizId(), account.getCorpId());
            String string = resp.getMediaId();
            this.deleteFile(file);
            return string;
        }
        catch (WeixinException e) {
            try {
                log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e);
                throw e;
                catch (Exception e2) {
                    log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                this.deleteFile(file);
                throw throwable;
            }
        }
    }

    private AddNewsReq buildAddNewsReq(List<OfficialMaterial> news, Map<String, Map<String, OfficialAccountMaterialFile>> syncOffmFileMap) {
        AddNewsReq req = new AddNewsReq();
        req.setArticles((List)Lists.newArrayList());
        for (OfficialMaterial m : news) {
            ArticleDto article = new ArticleDto();
            article.setTitle(m.getTitle());
            if (StringUtils.isNotBlank((CharSequence)m.getCover())) {
                OfficialAccountMaterialFile coverFile = syncOffmFileMap.getOrDefault(MD5Utils.MD5Encode8((String)m.getCover()), Maps.newHashMap()).get(WxMediaType.Thumb.getValue());
                if (coverFile == null) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u7247\u540c\u6b65\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\u5931\u8d25");
                }
                article.setThumbMediaId(coverFile.getMediaId());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{m.getContent()})) {
                String[] images = NewMaterialUtils.getImgs(m.getContent());
                String newContent = m.getContent();
                for (String image : images) {
                    String imageUrl = MD5Utils.MD5Encode8((String)image);
                    OfficialAccountMaterialFile imageFile = syncOffmFileMap.getOrDefault(imageUrl, Maps.newHashMap()).get(WxMediaType.News.getValue());
                    if (imageFile == null) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u7247\u540c\u6b65\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\u5931\u8d25");
                    }
                    newContent = newContent.replace(image, imageFile.getUrl());
                }
                article.setContent(newContent);
            }
            article.setDigest(m.getDigest());
            article.setAuthor(m.getAuthor());
            req.getArticles().add(article);
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncNewsImageToOfficial(String url, String appId, WxMediaType wxMediaType, Map<String, OfficialMaterialFile> fileMap, Map<String, Map<String, OfficialAccountMaterialFile>> syncOffmFileMap) {
        File file = null;
        OfficialAccount account = this.officialAccountMapper.getByAppId(appId);
        try {
            OfficialAccountMaterialFile officialFile = syncOffmFileMap.getOrDefault(url, Maps.newHashMap()).get(wxMediaType.getValue());
            OfficialMaterialFile materialFile = fileMap.get(url);
            if (officialFile == null) {
                file = DownloadUtils.loadFile(materialFile.getUrl(), materialFile.getFileFormat());
                if (wxMediaType == WxMediaType.Thumb) {
                    String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
                    AddMaterialResp resp = this.materialApi.addMaterial(accessToken, WxMediaType.Thumb, file);
                    OfficialAccountMaterialFile tmpOfficialFile = this.buildOfficialAccountMaterialFile(url, resp.getMediaId(), resp.getUrl(), appId, wxMediaType.getValue(), account.getBizId(), account.getCorpId());
                    syncOffmFileMap.computeIfAbsent(url, k -> Maps.newHashMap());
                    syncOffmFileMap.get(url).put(wxMediaType.getValue(), tmpOfficialFile);
                } else {
                    String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
                    UploadImgResp resp = this.mediaApi.uploadImg(accessToken, file);
                    OfficialAccountMaterialFile tmpOfficialFile = this.buildOfficialAccountMaterialFile(url, null, resp.getUrl(), appId, WxMediaType.News.getValue(), account.getBizId(), account.getCorpId());
                    syncOffmFileMap.computeIfAbsent(url, k -> Maps.newHashMap());
                    syncOffmFileMap.get(url).put(wxMediaType.getValue(), tmpOfficialFile);
                }
            }
        }
        catch (WeixinException e) {
            log.error("\u7d20\u6750\u540c\u6b65\u5230\u516c\u4f17\u53f7\u5931\u8d25", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u516c\u4f17\u53f7\u7d20\u6750\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.deleteFile(file);
        }
    }

    private String getMediaIdFromDB(OfficialAccountMaterial officialAccountMaterial, OfficialMaterial material, String appId) {
        if (officialAccountMaterial != null && officialAccountMaterial.getUpdateTime().after(material.getUpdateTime())) {
            return officialAccountMaterial.getMediaId();
        }
        String urlMd5 = MD5Utils.MD5Encode8((String)material.getUrl());
        OfficialAccountMaterialFile materialFile = this.officialAccountMaterialFileMapper.getByUrlMd5(urlMd5, appId, material.getmType());
        if (materialFile != null) {
            this.addorModOfficialAccountMaterial(officialAccountMaterial, material.getId(), materialFile.getMediaId(), appId);
            return materialFile.getMediaId();
        }
        return null;
    }

    private void addOfficialAccountMaterialFile(String urlMd5, String mediaId, String url, String appId, String mType, Long bizId, String corpId) {
        OfficialAccountMaterialFile file = new OfficialAccountMaterialFile();
        file.setBizId(bizId);
        file.setCorpId(corpId);
        file.setAppId(appId);
        file.setMediaId(mediaId);
        file.setmType(mType);
        file.setUrl(url);
        file.setUrlMd5(urlMd5);
        this.officialAccountMaterialFileMapper.insertSelective((Object)file);
    }

    private OfficialAccountMaterialFile buildOfficialAccountMaterialFile(String urlMd5, String mediaId, String url, String appId, String mType, Long bizId, String corpId) {
        OfficialAccountMaterialFile file = new OfficialAccountMaterialFile();
        file.setBizId(bizId);
        file.setCorpId(corpId);
        file.setAppId(appId);
        file.setMediaId(mediaId);
        file.setmType(mType);
        file.setUrl(url);
        file.setUrlMd5(urlMd5);
        this.officialAccountMaterialFileMapper.insertSelective((Object)file);
        return file;
    }

    private OfficialAccountMaterial addorModOfficialAccountMaterial(OfficialAccountMaterial officialAccountMaterial, Long materialId, String mediaId, String appId) {
        OfficialAccount account = this.officialAccountMapper.getByAppId(appId);
        if (officialAccountMaterial == null) {
            officialAccountMaterial = new OfficialAccountMaterial();
            officialAccountMaterial.setBizId(account.getBizId());
            officialAccountMaterial.setCorpId(account.getCorpId());
            officialAccountMaterial.setMaterialId(materialId);
            officialAccountMaterial.setAppId(appId);
            officialAccountMaterial.setMediaId(mediaId);
            officialAccountMaterial.setCreateTime(new Date());
            this.officialAccountMaterialMapper.insertSelective((Object)officialAccountMaterial);
        } else {
            officialAccountMaterial.setMediaId(mediaId);
            officialAccountMaterial.setUpdateTime(new Date());
            this.officialAccountMaterialMapper.updateByPrimaryKeySelective((Object)officialAccountMaterial);
        }
        return officialAccountMaterial;
    }
}

