/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums.activity;

import com.kuaike.common.enums.EnumService;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BillboardOverlayType implements EnumService
{
    QRCODE(1, "qrcode", "\u4e8c\u7ef4\u7801"),
    FANS_AVATAR(2, "fans_avatar", "\u7c89\u4e1d\u5934\u50cf");

    private static final Map<String, BillboardOverlayType> TYPE_CACHE;
    private static final Map<Integer, BillboardOverlayType> VALUE_CACHE;
    private final int value;
    private final String type;
    private final String desc;

    private BillboardOverlayType(int value, String type, String desc) {
        this.value = value;
        this.type = type;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public static BillboardOverlayType getType(String type) {
        return TYPE_CACHE.get(type);
    }

    public static BillboardOverlayType getType(Integer value) {
        return VALUE_CACHE.get(value);
    }

    static {
        TYPE_CACHE = Arrays.stream(BillboardOverlayType.values()).collect(Collectors.toMap(BillboardOverlayType::getType, Function.identity()));
        VALUE_CACHE = Arrays.stream(BillboardOverlayType.values()).collect(Collectors.toMap(BillboardOverlayType::getValue, Function.identity()));
    }
}

