/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.common.service.impl;

import cn.kinyun.scrm.weixin.common.service.TemplateIndustryService;
import cn.kinyun.scrm.weixin.sdk.entity.template.Industry;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountIndustry;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountIndustryMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class TemplateIndustryServiceImpl
implements TemplateIndustryService {
    private static final Logger log = LoggerFactory.getLogger(TemplateIndustryServiceImpl.class);
    @Resource
    private OfficialAccountIndustryMapper industryMapper;

    @Override
    @Cacheable(cacheNames={"officialAccount"}, key="'industryInfo'")
    public Map<String, OfficialAccountIndustry> getIndustryMap() {
        log.info("query all industry info");
        List industries = this.industryMapper.selectAll();
        return industries.stream().collect(Collectors.toMap(OfficialAccountIndustry::getCode, Function.identity()));
    }

    @Override
    public boolean isSameIndustry(Industry industry, String industryId) {
        if (industry == null || StringUtils.isBlank((CharSequence)industryId)) {
            return false;
        }
        Map<String, OfficialAccountIndustry> industryMap = this.getIndustryMap();
        OfficialAccountIndustry expectIndustry = industryMap.get(industryId);
        if (expectIndustry == null) {
            return false;
        }
        return expectIndustry.getFirstIndustry().equalsIgnoreCase(industry.getFirstClass()) && expectIndustry.getSecondIndustry().equalsIgnoreCase(industry.getSecondClass());
    }

    @Override
    public String getIndustryCode(Industry industry) {
        Map<String, OfficialAccountIndustry> industryMap = this.getIndustryMap();
        for (String code : industryMap.keySet()) {
            OfficialAccountIndustry existIndustry = industryMap.get(code);
            if (industry == null) {
                return null;
            }
            if (!this.isSameIndustry(industry, existIndustry.getCode())) continue;
            return existIndustry.getCode();
        }
        return null;
    }
}

