/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.activity.utils;

import cn.kinyun.scrm.weixin.activity.dto.OverlayDto;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Billboard {
    private static final Logger log = LoggerFactory.getLogger(Billboard.class);
    private BufferedImage canvas;
    private BufferedImage bg;
    private final List<Overlay> list = new ArrayList<Overlay>();

    public boolean setBackground(String resource) {
        BufferedImage image = Billboard.download(resource);
        return this.setBackground(image);
    }

    public boolean setBackground(BufferedImage img) {
        if (img != null) {
            this.bg = img;
            return true;
        }
        return false;
    }

    public boolean addImage(OverlayDto dto) {
        if (dto.getOriginImage() != null) {
            return this.addImage(dto.getOriginImage(), dto.getX(), dto.getY(), dto.getW(), dto.getH(), dto.isRound());
        }
        if (dto.getImageUrl() != null) {
            return this.addImage(dto.getImageUrl(), dto.getX(), dto.getY(), dto.getW(), dto.getH(), dto.isRound());
        }
        return false;
    }

    public boolean addImage(String resource, int x, int y, int w, int h, boolean round) {
        BufferedImage img = Billboard.download(resource);
        return this.addImage(img, x, y, w, h, round);
    }

    public boolean addImage(BufferedImage img, int x, int y, int w, int h, boolean round) {
        if (img == null) {
            return false;
        }
        Overlay overlay = new Overlay();
        overlay.x = x;
        overlay.y = y;
        overlay.w = w;
        overlay.h = h;
        overlay.originImage = img;
        if (round) {
            img = Billboard.roundCorner(img);
        }
        if (w != img.getWidth() || h != img.getHeight()) {
            double sx = (double)w / (double)img.getWidth();
            double sy = (double)h / (double)img.getHeight();
            img = Billboard.scale(img, sx, sy);
        }
        overlay.scaledImage = img;
        this.list.add(overlay);
        return true;
    }

    public BufferedImage create() {
        int width = this.bg.getWidth();
        int height = this.bg.getHeight();
        log.info("bg.type={}", (Object)this.bg.getType());
        if (this.canvas == null || this.canvas.getWidth() != width || this.canvas.getHeight() != height) {
            this.canvas = new BufferedImage(width, height, 4);
        }
        Graphics2D g2 = this.canvas.createGraphics();
        g2.drawImage((Image)this.bg, 0, 0, null);
        for (Overlay o : this.list) {
            BufferedImage img = o.scaledImage;
            g2.drawImage(img, o.x, o.y, o.w, o.h, null);
        }
        g2.dispose();
        return this.canvas;
    }

    public boolean saveTo(File file) {
        if (this.canvas == null) {
            this.create();
        }
        try {
            ImageIO.write((RenderedImage)this.canvas, "jpg", file);
            return true;
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u6d77\u62a5\u56fe\u7247\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static BufferedImage roundCorner(BufferedImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        BufferedImage output = new BufferedImage(width, height, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Clear);
        g2.fill(new Rectangle(width, height));
        g2.setComposite(AlphaComposite.Src);
        g2.fill(new Ellipse2D.Double(0.0, 0.0, width, height));
        g2.setComposite(AlphaComposite.SrcIn);
        g2.drawImage((Image)input, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage scale(BufferedImage in, double sx, double sy) {
        AffineTransform matrix = new AffineTransform();
        matrix.scale(sx, sy);
        AffineTransformOp op = null;
        op = sx < 1.0 && sy < 1.0 ? new AffineTransformOp(matrix, 1) : new AffineTransformOp(matrix, 2);
        int width = (int)((double)in.getWidth() * sx);
        int height = (int)((double)in.getHeight() * sy);
        BufferedImage dstImage = new BufferedImage(width, height, in.getType());
        op.filter(in, dstImage);
        return dstImage;
    }

    public static BufferedImage download(String resource) {
        BufferedImage image = null;
        long start = System.currentTimeMillis();
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            return null;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
        }
        catch (IOException e) {
            return null;
        }
        try {
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                InputStream inStream = conn.getInputStream();
                image = ImageIO.read(inStream);
            }
        }
        catch (IOException e) {
            return null;
        }
        conn.disconnect();
        log.info("download image, time: {} ms, url: {}", (Object)(System.currentTimeMillis() - start), (Object)resource);
        return image;
    }

    class Overlay {
        int x;
        int y;
        int w;
        int h;
        BufferedImage originImage;
        BufferedImage scaledImage;

        Overlay() {
        }
    }
}

