/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.activity.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.ActiTemplateMsgDto;
import cn.kinyun.scrm.weixin.activity.dto.ActivityDto;
import cn.kinyun.scrm.weixin.activity.dto.OldActivityDto;
import cn.kinyun.scrm.weixin.activity.dto.OverlayDto;
import cn.kinyun.scrm.weixin.activity.dto.req.ActivityListReq;
import cn.kinyun.scrm.weixin.activity.dto.req.FansExtendReq;
import cn.kinyun.scrm.weixin.activity.dto.resp.ActivityListResp;
import cn.kinyun.scrm.weixin.activity.dto.resp.EventKeyDto;
import cn.kinyun.scrm.weixin.activity.dto.resp.FansExtendResp;
import cn.kinyun.scrm.weixin.activity.service.OfficialActivityService;
import cn.kinyun.scrm.weixin.activity.utils.Billboard;
import cn.kinyun.scrm.weixin.common.dto.ModifierDto;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.activity.ActivityStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityType;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.message.service.TemplateMsgService;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.CreateQrcodeReqDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialQrcodeService;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.account.CreateQrcodeResult;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.RedisDistributedLock;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialFansExtend;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialFansExtendMapper;
import com.kuaike.scrm.dal.official.fission.dto.ActivityQueryParam;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActi;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiCriteria;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiTask;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiResultMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiTaskMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialActivityServiceImpl
implements OfficialActivityService {
    private static final Logger log = LoggerFactory.getLogger(OfficialActivityServiceImpl.class);
    private static final String ACTI_LOCK = "acti_code_lock";
    @Autowired
    private AliyunOss aliyunOss;
    @Resource
    private OfficialActiMapper officialActiMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Resource
    private OfficialActiTaskMapper officialActiTaskMapper;
    @Resource
    private OfficialActiResultMapper officialActiResultMapper;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private TemplateMsgService templateMsgService;
    @Resource
    private OfficialFansExtendMapper officialFansExtendMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OfficialQrcodeService officialQrcodeService;
    @Autowired
    private WxOAuth2API wxOAuth2API;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private RedisDistributedLock redisDistributedLock;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public List<ActivityListResp> list(ActivityListReq params, Long operatorId) {
        log.info("query acti list with params={},operatorId={}", (Object)params, (Object)operatorId);
        Date now = new Date();
        ActivityQueryParam queryParam = ActivityQueryParam.builder().name(params.getName()).appId(params.getAppId()).template(params.getTemplate()).appName(params.getAppName()).beginTime(params.getBeginTime()).endTime(params.getEndTime()).status(params.getStatus()).pageDto(params.getPageDto()).bizId(LoginUtils.getCurrentUserBizId()).now(now).build();
        List list = this.officialActiMapper.queryList(queryParam);
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
            params.getPageDto().setCount(Integer.valueOf(this.officialActiMapper.countList(queryParam)));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        HashSet userIds = Sets.newHashSet();
        HashSet actiIds = Sets.newHashSet();
        HashSet accountIds = Sets.newHashSet();
        for (OfficialActi acti : list) {
            userIds.add(acti.getModifierId());
            actiIds.add(acti.getId());
            accountIds.add(acti.getAppId());
        }
        HashMap userMap = Maps.newHashMap();
        HashMap accountMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            userMap.putAll(this.userInfoService.queryUserInfoMap(userIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)accountIds)) {
            accountMap.putAll(this.officialAccountService.queryByAppIds(accountIds));
        }
        ArrayList result = Lists.newArrayList();
        Map amountMap = this.officialActiResultMapper.countRsing((Collection)actiIds);
        Map complementMap = this.officialActiTaskMapper.queryComplementMap((Collection)actiIds);
        for (OfficialActi acti : list) {
            ActivityListResp resp = this.buildOfficialActiListResp(acti, userMap);
            resp.setCompleteAmount(complementMap.getOrDefault(acti.getId(), 0));
            resp.setRisingAmount(amountMap.getOrDefault(acti.getId(), 0));
            ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), now, acti.getStatus());
            resp.setStatus(status.getStatus());
            resp.setStatusStr(status.getDesc());
            resp.setCover(acti.getCover());
            OfficialAccount account = (OfficialAccount)accountMap.get(acti.getAppId());
            resp.setAppName(Optional.ofNullable(account).map(OfficialAccount::getNickName).orElse(null));
            ActivityDto dto = null;
            try {
                dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
                dto.setApp(new StrIdAndNameDto(acti.getAppId(), account != null ? account.getNickName() : null));
            }
            catch (Exception e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u5185\u5bb9\u89e3\u6790\u5f02\u5e38");
            }
            resp.setAutoResp(dto.getAutoResp());
            result.add(resp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ActivityDto params, Long operatorId) {
        log.info("addOrMod official activity with params={}, operatorId={}", (Object)params, (Object)operatorId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getTemplate()), (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBeginTime() != null ? 1 : 0) != 0, (Object)"beginTime is null!");
        Preconditions.checkArgument((params.getEndTime() != null ? 1 : 0) != 0, (Object)"endTime is null!");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getTagIds()), (Object)"tagIds is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"name is null!");
        Preconditions.checkArgument((params.getTemplate().equals("001") || params.getTemplate().equals("000") || params.getTemplate().equals("002") ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u6b63\u786e");
        this.templateMsgService.checkAndSetTemplate(params.getAppId(), null);
        this.checkApp(params.getAppId());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        try {
            this.redisDistributedLock.lock(this.getRedisKey(params.getAppId()), 10, 30L, 60L);
            this.timeConflictCheck(params.getAppId(), params.getBeginTime(), params.getEndTime(), null);
            OfficialActi acti = new OfficialActi();
            acti.setBizId(userInfo.getBizId());
            acti.setCorpId(userInfo.getCorpId());
            this.build(acti, params, operatorId, operatorId);
            acti.setCode(this.getActiCode(acti.getTemplate(), new Date()));
            this.officialActiMapper.insertSelective((Object)acti);
            if (params.getTemplate().equals("002") && CollectionUtils.isNotEmpty(params.getOverlay())) {
                ActivityDto dto;
                String location = JacksonUtil.obj2Str(params.getOverlay());
                String url = this.createQrcode(acti, "openId");
                acti.setCover(this.getBillboardUrl(params.getCover(), location, url, operatorId, params.getAppId(), LoginUtils.getCurrentUserCorpId()));
                try {
                    dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u53c2\u6570\u4e0d\u6b63\u786e");
                }
                dto.setCover(acti.getCover());
                acti.setContent(JacksonUtil.obj2Str((Object)dto));
                this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
            }
            Long l = acti.getId();
            return l;
        }
        finally {
            this.redisDistributedLock.unlock(this.getRedisKey(params.getAppId()));
        }
    }

    private String getRedisKey(String appId) {
        return "acti:" + appId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(ActivityDto params, Long operatorId) {
        log.info("mod official activity with params={}, operatorId={}", (Object)params, (Object)operatorId);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getTemplate()), (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBeginTime() != null ? 1 : 0) != 0, (Object)"beginTime is null!");
        Preconditions.checkArgument((params.getEndTime() != null ? 1 : 0) != 0, (Object)"endTime is null!");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getTagIds()), (Object)"tagIds is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"name is null!");
        Preconditions.checkArgument((params.getTemplate().equals("001") || params.getTemplate().equals("000") || params.getTemplate().equals("002") ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u6b63\u786e");
        StopWatchDto timer = new StopWatchDto("activity_mod", true, log);
        timer.start("checkAndSetTemplate");
        this.templateMsgService.checkAndSetTemplate(params.getAppId(), null);
        timer.stop();
        this.checkApp(params.getAppId());
        timer.start("selectOfficialActi");
        OfficialActi acti = this.officialActiMapper.getById(params.getId());
        timer.stop();
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        this.timeConflictCheck(params.getAppId(), params.getBeginTime(), params.getEndTime(), params.getId());
        this.modDifferCheck(acti, params);
        String urlMark = MD5Utils.MD5Encode8((String)(params.getCover() + JacksonUtil.obj2Str(params.getOverlay())));
        String oldUrlMark = MD5Utils.MD5Encode8((String)(acti.getCover() + acti.getLocation()));
        if (params.getTemplate().equals("002") && (acti.getStatus().intValue() == ActivityStatus.DRAFT.getStatus() || !urlMark.equals(oldUrlMark)) && CollectionUtils.isNotEmpty(params.getOverlay())) {
            String location = JacksonUtil.obj2Str(params.getOverlay());
            timer.start("createQrcode");
            String url = this.createQrcode(acti, "openId");
            timer.stop();
            timer.start("getBillboardUrl");
            params.setCover(this.getBillboardUrl(params.getCover(), location, url, operatorId, params.getAppId(), acti.getCorpId()));
            timer.stop();
        }
        this.build(acti, params, acti.getCreatorId(), operatorId);
        acti.setStatus(Integer.valueOf(ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), new Date(), -1).getStatus()));
        acti.setUpdateTime(new Date());
        timer.start("updateOfficialActi");
        this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
        timer.stop();
        timer.print();
    }

    private void modDifferCheck(OfficialActi acti, ActivityDto params) {
        ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), new Date(), acti.getStatus());
        if (params.getTemplate().equals("001") || params.getTemplate().equals("000")) {
            List<ActiTemplateMsgDto> paramsMsgDtoList = params.getMsgDtoList();
            if (status == ActivityStatus.EFFECT || status == ActivityStatus.INVALID || status == ActivityStatus.FORBIDDEN) {
                Preconditions.checkArgument((boolean)acti.getAppId().equals(params.getAppId()), (Object)"\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u652f\u6301\u4fee\u6539\u516c\u4f17\u53f7");
                Preconditions.checkArgument((boolean)acti.getName().equals(params.getName()), (Object)"\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u652f\u6301\u4fee\u6539\u6d3b\u52a8\u540d\u79f0");
                String content = acti.getContent();
                try {
                    ActivityDto activityDto = (ActivityDto)JacksonUtil.str2Obj((String)content, ActivityDto.class);
                    List<ActiTemplateMsgDto> msgDtoList = activityDto.getMsgDtoList();
                    Preconditions.checkArgument((msgDtoList.size() == paramsMsgDtoList.size() ? 1 : 0) != 0, (Object)"\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u652f\u6301\u4fee\u6539\u9636\u6bb5");
                    for (int i = 0; i < paramsMsgDtoList.size(); ++i) {
                        Preconditions.checkArgument((paramsMsgDtoList.get(i).getType() == msgDtoList.get(i).getType() ? 1 : 0) != 0, (Object)"\u5df2\u7ecf\u751f\u6548\u7684\u6d3b\u52a8\u52a9\u529b\u9636\u6bb5\u4e0d\u80fd\u4fee\u6539");
                    }
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u6570\u636e\u89e3\u6790\u5f02\u5e38");
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void forbidden(Long actiId, Long operatorId) {
        log.info("forbidden official activity with id={}, operatorId={}", (Object)actiId, (Object)operatorId);
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        this.checkApp(acti.getAppId());
        acti.setStatus(Integer.valueOf(ActivityStatus.FORBIDDEN.getStatus()));
        acti.setModifierId(operatorId);
        acti.setUpdateTime(new Date());
        this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(Long actiId, Long operatorId) {
        log.info("enable official activity with id={}, operatorId={}", (Object)actiId, (Object)operatorId);
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        this.checkApp(acti.getAppId());
        ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), new Date(), ActivityStatus.INEFFECTIVE.getStatus());
        if (status == ActivityStatus.EFFECT || status == ActivityStatus.INEFFECTIVE) {
            this.timeConflictCheck(acti.getAppId(), acti.getBeginTime(), acti.getEndTime(), actiId);
        }
        acti.setStatus(Integer.valueOf(status.getStatus()));
        acti.setModifierId(operatorId);
        acti.setUpdateTime(new Date());
        this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
    }

    @Override
    public void del(Long actiId, Long operatorId) {
        log.info("delete official activity with id={}, operatorId={}", (Object)actiId, (Object)operatorId);
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        this.checkApp(acti.getAppId());
        acti.setIsDel(Integer.valueOf(1));
        this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
    }

    private OfficialAccount checkApp(String appId) {
        OfficialAccount app = this.officialAccountService.queryByAppId(appId);
        if (app == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728");
        }
        if (!app.getBizId().equals(LoginUtils.getCurrentUserBizId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5728\u64cd\u4f5c\u4eba\u5546\u6237\u4e0b");
        }
        return app;
    }

    @Override
    public long draft(ActivityDto params, Long operatorId) {
        log.info("addOrMod official activity draft with params={}, operatorId={}", (Object)params, (Object)operatorId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getTemplate()), (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getTemplate().equals("001") || params.getTemplate().equals("000") || params.getTemplate().equals("002") ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u6a21\u677f\u4e0d\u6b63\u786e");
        StopWatchDto timer = new StopWatchDto("draft", true, log);
        timer.start("checkApp");
        this.checkApp(params.getAppId());
        timer.stop();
        timer.start("checkAndSetTemplate");
        this.templateMsgService.checkAndSetTemplate(params.getAppId(), null);
        timer.stop();
        OfficialActi acti = null;
        if (params.getId() != null) {
            timer.start("selectOfficialActi");
            acti = this.officialActiMapper.getById(params.getId());
            timer.stop();
            if (acti == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8349\u7a3f\u4e0d\u5b58\u5728");
            }
        }
        if (acti == null) {
            acti = new OfficialActi();
            timer.start("getActiCode");
            acti.setCode(this.getActiCode(params.getTemplate(), new Date()));
            timer.stop();
        }
        this.build(acti, params, operatorId, operatorId);
        acti.setStatus(Integer.valueOf(ActivityStatus.DRAFT.getStatus()));
        if (acti.getId() == null) {
            timer.start("insertOfficialActi");
            this.officialActiMapper.insertSelective((Object)acti);
            timer.stop();
        } else {
            acti.setUpdateTime(new Date());
            timer.start("updateOfficialActi");
            this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
            timer.stop();
        }
        timer.print();
        return acti.getId();
    }

    private void timeConflictCheck(String appId, Date beginTime, Date endTime, Long excludeId) {
        Date today = DateUtil.getBeginOfDay((Date)new Date());
        if (today.after(endTime)) {
            return;
        }
        Date conditionBeginTime = today.after(beginTime) ? today : beginTime;
        ActivityQueryParam queryParam = ActivityQueryParam.builder().appIds((List)Lists.newArrayList((Object[])new String[]{appId})).beginTime(conditionBeginTime).endTime(endTime).bizId(LoginUtils.getCurrentUserBizId()).excludeId(excludeId).build();
        List actiList = this.officialActiMapper.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(actiList = actiList.stream().filter(a -> a.getStatus().intValue() == ActivityStatus.EFFECT.getStatus() || a.getStatus().intValue() == ActivityStatus.INEFFECTIVE.getStatus()).filter(a -> endTime.compareTo(a.getBeginTime()) >= 0 && conditionBeginTime.compareTo(a.getEndTime()) <= 0).collect(Collectors.toList()))) {
            OfficialActi acti = (OfficialActi)actiList.get(0);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0e\u88c2\u53d8\u6d3b\u52a8[" + acti.getCode() + "]\u65f6\u95f4\u51b2\u7a81");
        }
    }

    @Override
    public ActivityDto detail(Long actiId, Long operatorId) {
        log.info("query official activity detail with id={},operatorId={}", (Object)actiId, (Object)operatorId);
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        OfficialAccount account = this.checkApp(acti.getAppId());
        ActivityDto dto = null;
        try {
            dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
            dto.setApp(new StrIdAndNameDto(acti.getAppId(), account.getNickName()));
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u5185\u5bb9\u89e3\u6790\u5f02\u5e38");
        }
        Map tagNameMap = this.weworkTagMapper.queryTagIdAndName(LoginUtils.getCurrentUserCorpId(), dto.getTagIds());
        dto.setTags(Lists.newArrayList());
        dto.setId(acti.getId());
        dto.setCode(acti.getCode());
        for (String tagId : dto.getTagIds()) {
            WeworkTagDto tagDto = new WeworkTagDto();
            tagDto.setId(tagId);
            tagDto.setName((String)tagNameMap.get(tagId));
            dto.getTags().add(tagDto);
        }
        dto.setIsDraft(acti.getStatus() == 0 ? 1 : 0);
        return dto;
    }

    private ActivityListResp buildOfficialActiListResp(OfficialActi acti, Map<Long, UserInfoRespDto> userMap) {
        ActivityListResp resp = new ActivityListResp();
        resp.setId(acti.getId());
        resp.setName(acti.getName());
        resp.setBeginTime(acti.getBeginTime());
        resp.setEndTime(acti.getEndTime());
        resp.setTemplate(acti.getTemplate());
        resp.setUpdateTime(acti.getUpdateTime());
        UserInfoRespDto user = userMap.get(acti.getModifierId());
        ModifierDto modifier = new ModifierDto(acti.getModifierId(), "", "");
        if (user != null) {
            modifier.setName(user.getUsername());
            modifier.setNickName(user.getNickname());
        }
        resp.setModifier(modifier);
        resp.setCode(acti.getCode());
        return resp;
    }

    void build(OfficialActi acti, ActivityDto dto, Long createrId, Long modiferId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        acti.setBizId(userInfo.getBizId());
        acti.setCorpId(userInfo.getCorpId());
        acti.setAppId(dto.getAppId());
        acti.setTemplate(dto.getTemplate());
        acti.setName(dto.getName());
        acti.setBeginTime(dto.getBeginTime());
        acti.setEndTime(dto.getEndTime());
        acti.setCover(dto.getCover());
        acti.setLocation(JacksonUtil.obj2Str(dto.getOverlay()));
        if (acti.getId() == null) {
            acti.setCreatorId(createrId);
        }
        acti.setModifierId(modiferId);
        acti.setContent(JacksonUtil.obj2Str((Object)dto));
        acti.setTagIds("," + StringUtils.join(dto.getTagIds(), (String)","));
        Date now = new Date();
        ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), now, acti.getStatus() != null ? acti.getStatus() : 0);
        if (status.getStatus() == ActivityStatus.INVALID.getStatus()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u80fd\u521b\u5efa\u5df2\u5931\u6548\u7684\u6d3b\u52a8");
        }
        acti.setStatus(Integer.valueOf(status.getStatus()));
        List<ActiTemplateMsgDto> msgDtoList = dto.getMsgDtoList();
        if (CollectionUtils.isNotEmpty(msgDtoList)) {
            msgDtoList.sort(Comparator.comparing(ActiTemplateMsgDto::getGoal));
            int phaseCategories = 0;
            for (int i = 0; i < msgDtoList.size(); ++i) {
                ActiTemplateMsgDto msgDto = msgDtoList.get(i);
                phaseCategories |= msgDto.getType() << i;
            }
            dto.setPhaseCategories(phaseCategories);
        }
        acti.setContent(JacksonUtil.obj2Str((Object)dto));
    }

    @Override
    public FansExtendResp fansExtend(FansExtendReq params) {
        ActivityDto dto;
        Preconditions.checkArgument((params.getActiId() != null ? 1 : 0) != 0, (Object)"actiId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCode()), (Object)"code is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"appId is null!");
        OfficialActi acti = this.checkActivity(params.getActiId());
        try {
            dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u5185\u5bb9\u89e3\u6790\u5f02\u5e38");
        }
        String componentToken = this.componentTokenService.getComponentAccessToken();
        SnsAccessToken token = this.wxOAuth2API.getComponentAccessToken(params.getAppId(), params.getCode(), this.componentAppId, componentToken);
        OfficialActiTask task = this.officialActiTaskMapper.queryTask(acti.getId(), acti.getAppId(), token.getOpenId());
        FansExtendResp resp = new FansExtendResp();
        OfficialFansExtend extend = this.officialFansExtendMapper.getExtend(acti.getAppId(), token.getOpenId());
        if (extend != null) {
            resp.setName(extend.getName());
            resp.setMobile(extend.getMobile());
            resp.setProvince(extend.getProvince());
            resp.setCity(extend.getCity());
            resp.setAddress(extend.getAddress());
        }
        resp.setOddNo(task != null ? task.getOddNo() : "");
        resp.setStr5(dto.getStr5());
        resp.setStr6(dto.getStr6());
        resp.setOpenId(token.getOpenId());
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addFansExtand(FansExtendReq params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"name is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAddress()), (Object)"address is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getOpenId()), (Object)"openId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"appId is null!");
        OfficialFansExtend extend = this.officialFansExtendMapper.getExtend(params.getAppId(), params.getOpenId());
        if (extend == null) {
            extend = new OfficialFansExtend();
        }
        OfficialAccount account = this.officialAccountMapper.getByAppId(params.getAppId());
        extend.setAppId(params.getAppId());
        extend.setOpenId(params.getOpenId());
        extend.setName(params.getName());
        extend.setMobile(params.getMobile());
        extend.setProvince(params.getProvince());
        extend.setCity(params.getCity());
        extend.setAddress(params.getAddress());
        if (extend.getId() == null) {
            extend.setBizId(account.getBizId());
            extend.setCorpId(account.getCorpId());
            this.officialFansExtendMapper.insertSelective((Object)extend);
        } else {
            this.officialFansExtendMapper.updateByPrimaryKeySelective((Object)extend);
        }
        this.officialActiTaskMapper.updatetaskStatusWhenAddress(params.getAppId(), params.getOpenId());
    }

    @Override
    public void transferData(Long id) {
        log.info("transfer data start, id={}", (Object)id);
        List actiList = Lists.newArrayList();
        if (id == null) {
            OfficialActiCriteria example = new OfficialActiCriteria();
            example.createCriteria().andIsDelEqualTo(Integer.valueOf(0)).andTemplateIn((List)Lists.newArrayList((Object[])new String[]{"000", "001"}));
            actiList = this.officialActiMapper.selectByExample((Object)example);
        } else {
            OfficialActi acti = this.officialActiMapper.getById(id);
            if (acti != null) {
                actiList.add(acti);
            }
        }
        if (CollectionUtils.isEmpty((Collection)actiList)) {
            log.info("\u672a\u627e\u5230\u6d3b\u52a8");
            return;
        }
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5904\u7406\uff0c\u5904\u7406\u6570\u76ee:{}", (Object)actiList.size());
        for (OfficialActi acti : actiList) {
            OldActivityDto oldActivityDto;
            ActivityDto activityDto = new ActivityDto();
            if (acti.getTemplate().equals("000")) {
                activityDto.setPhaseCategories(1);
            } else {
                activityDto.setPhaseCategories(0);
            }
            acti.setCode(acti.getCode().replace("GZLB-1", "GZLB-2"));
            acti.setProcessKey("");
            acti.setTemplate("001");
            try {
                oldActivityDto = (OldActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), OldActivityDto.class);
            }
            catch (IOException e) {
                log.error("\u89e3\u6790json\u5931\u8d25, content={}", (Object)acti.getContent(), (Object)e);
                continue;
            }
            if (oldActivityDto.getGoal() == 0) continue;
            BeanUtils.copyProperties((Object)oldActivityDto, (Object)activityDto);
            activityDto.setMaxGoal(oldActivityDto.getGoal());
            activityDto.setTemplate("001");
            activityDto.setCode(acti.getCode());
            ActiTemplateMsgDto msgDto = new ActiTemplateMsgDto();
            msgDto.setGoal(oldActivityDto.getGoal());
            msgDto.setNoticeStr1(oldActivityDto.getNoticeStr1());
            msgDto.setNoticeStr2(oldActivityDto.getNoticeStr2());
            msgDto.setNoticeStr3(oldActivityDto.getNoticeStr3());
            msgDto.setDataUrl(oldActivityDto.getDataUrl());
            msgDto.setProcessKey(oldActivityDto.getProcessKey());
            msgDto.setStr3(oldActivityDto.getStr3());
            msgDto.setType(activityDto.getPhaseCategories() == 1 ? ActivityType.PHYSICS.getValue() : ActivityType.ELECTRONIC.getValue());
            msgDto.setIsLimitedReward(0);
            activityDto.setMsgDtoList(Lists.newArrayList((Object[])new ActiTemplateMsgDto[]{msgDto}));
            acti.setContent(JacksonUtil.obj2Str((Object)activityDto));
            this.officialActiMapper.updateByPrimaryKeySelective((Object)acti);
        }
        long end = System.currentTimeMillis();
        log.info("\u5904\u7406\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}s", (Object)((end - start) / 1000L));
    }

    private OfficialActi checkActivity(Long actiId) {
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return acti;
    }

    private String createQrcode(OfficialActi acti, String openId) {
        EventKeyDto dto = new EventKeyDto();
        dto.setType(ClickEventBizType.OFFICIAL_FISSION.getKey());
        dto.setId(acti.getId());
        dto.setOpenId(openId);
        String sceneStr = dto.pack();
        Date endTime = acti.getEndTime();
        long mills = endTime.getTime() - System.currentTimeMillis();
        int expireSeconds = (int)(mills / 1000L);
        CreateQrcodeReqDto req = new CreateQrcodeReqDto();
        req.setAppId(acti.getAppId());
        req.setSceneStr(sceneStr);
        req.setExpireSeconds(expireSeconds);
        CreateQrcodeResult result = null;
        try {
            result = this.officialQrcodeService.createTemp(req);
        }
        catch (WeixinException e) {
            log.error("\u521b\u5efa\u6d3b\u52a8\u4e8c\u7ef4\u7801\u5931\u8d25, appId={}, openId={}", new Object[]{acti.getAppId(), openId, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6d3b\u52a8\u4e8c\u7ef4\u7801\u5931\u8d25");
        }
        String ticket = result.getTicket();
        return this.officialQrcodeService.getQrcodeUrl(ticket);
    }

    private String getBillboardUrl(String cover, String location, String appQrCodeUrl, Long operatorId, String appId, String corpId) {
        List overlay = null;
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{location})) {
                overlay = JacksonUtil.str2List((String)location, OverlayDto.class);
            }
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25, value={}", (Object)location, (Object)e);
        }
        ArrayList overlays = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(overlay)) {
            for (OverlayDto dto : overlay) {
                String type = dto.getType();
                if (StringUtils.isBlank((CharSequence)type)) {
                    log.warn("\u672a\u77e5\u7c7b\u578b\u7684\u6d77\u62a5\u8986\u76d6\u56fe\u7247, overlay={}", (Object)dto);
                    continue;
                }
                if ("qrcode".equalsIgnoreCase(type)) {
                    dto.setImageUrl(appQrCodeUrl);
                } else {
                    log.warn("\u672a\u77e5\u7c7b\u578b\u7684\u6d77\u62a5\u8986\u76d6\u56fe\u7247, overlay={}", (Object)dto);
                }
                if (dto.getImageUrl() == null) continue;
                overlays.add(dto);
            }
        }
        if (CollectionUtils.isEmpty((Collection)overlays)) {
            return cover;
        }
        Billboard billboard = new Billboard();
        ArrayList tasks = Lists.newArrayList();
        tasks.add(() -> {
            billboard.setBackground(cover);
            return null;
        });
        for (OverlayDto dto : overlays) {
            tasks.add(() -> {
                billboard.addImage(dto);
                return null;
            });
        }
        ExecutorService exec = Executors.newFixedThreadPool(overlay != null ? overlay.size() + 1 : 5);
        try {
            exec.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        exec.shutdown();
        String filename = String.format("tmp_billboard_%d_%s_%d.jpg", operatorId, appId, System.currentTimeMillis());
        File file = new File(filename);
        billboard.saveTo(file);
        return this.aliyunOss.uploadFile(corpId, file, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getActiCode(String template, Date now) {
        String timeStr = DateUtil.getStrByDateFormate((Date)now, (String)"yyyyMMddhhmmss");
        String key = ACTI_LOCK + template + timeStr;
        this.redisDistributedLock.lock(key, 100, 20L, 50L);
        try {
            String valueStr = (String)this.redisTemplate.opsForValue().get((Object)key);
            if (valueStr == null) {
                valueStr = "0";
            }
            int value = Integer.parseInt(valueStr);
            this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(++value), 5L, TimeUnit.SECONDS);
            StringBuilder stringBuilder = new StringBuilder();
            if (template.equals("001")) {
                stringBuilder.append("GZLB-2");
            } else if (template.equals("000")) {
                stringBuilder.append("GZLB-1");
            } else {
                stringBuilder.append("GZLB-F");
            }
            stringBuilder.append(timeStr).append(String.format("%04d", value));
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.redisDistributedLock.unlock(key);
        }
    }
}

