/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.utils;

import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Expression;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.activity.entity.BehaviorRecord;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MatchUtils {
    private static final Logger log = LoggerFactory.getLogger(MatchUtils.class);

    private MatchUtils() {
    }

    public static boolean match(Map<String, String> context, Condition actCondition, BehaviorRecord behaviorRecord) {
        Map behaviorContext;
        if (!behaviorRecord.getConfId().equals(actCondition.getBehaviorConfId())) {
            return false;
        }
        Map<Object, Object> expMap = Maps.newHashMap();
        try {
            behaviorContext = (Map)JacksonUtil.str2Obj((String)behaviorRecord.getBehaviorContext(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25, json={}", (Object)behaviorRecord.getBehaviorContext(), (Object)e);
            return false;
        }
        if (CollectionUtils.isNotEmpty(actCondition.getExps())) {
            expMap = actCondition.getExps().stream().collect(Collectors.toMap(Expression::getField, Function.identity()));
        }
        for (Map.Entry entry : behaviorContext.entrySet()) {
            Expression expression;
            String field = (String)entry.getKey();
            if (!(expMap.containsKey(field) ? (expression = (Expression)expMap.get(field)) != null && !expression.match(behaviorContext) : context != null && context.containsKey(field) && context.get(field).equals(behaviorContext.get(field)))) continue;
            return false;
        }
        return true;
    }

    public static boolean match(Map<String, String> context, Condition actCondition, Behavior behavior) {
        if (!behavior.getConfId().equals(actCondition.getBehaviorConfId())) {
            return false;
        }
        Map<Object, Object> expMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(actCondition.getExps())) {
            expMap = actCondition.getExps().stream().collect(Collectors.toMap(Expression::getField, Function.identity()));
        }
        for (String field : behavior.getContext().keySet()) {
            Expression expression;
            if (!(expMap.containsKey(field) ? !(expression = (Expression)expMap.get(field)).match(behavior.getContext()) : context != null && context.containsKey(field) && context.get(field).equals(behavior.getContext().get(field)))) continue;
            return false;
        }
        return true;
    }

    public static boolean match(Map<String, String> context, List<Condition> actConditions, Behavior behavior) {
        for (Condition actCondition : actConditions) {
            if (!MatchUtils.match(context, actCondition, behavior)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Map<String, String> context, List<Condition> actConditions, BehaviorRecord behaviorRecord) {
        for (Condition actCondition : actConditions) {
            if (!MatchUtils.match(context, actCondition, behaviorRecord)) continue;
            return true;
        }
        return false;
    }
}

