/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.dto;

import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class Graph
implements Serializable {
    private static final long serialVersionUID = -3183776917590658512L;
    private int startNodeId;
    private int conditionRelation;
    private Map<String, String> context;
    private List<Condition> triggers;
    private List<Condition> matchTriggers;
    private List<Behavior> matchBehaviors;
    private List<Node> nodes;
    private List<Edge> edges;
    private Integer nearestNodeId;

    public static void validateGraph(Graph graph) {
        if (CollectionUtils.isEmpty(graph.getNodes())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u4e2d\u65e0\u8282\u70b9");
        }
        if (CollectionUtils.isEmpty(graph.getEdges()) && graph.getNodes().size() > 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u4e2d\u65e0\u8fb9");
        }
        if (graph.getEdges() == null) {
            graph.setEdges(Lists.newArrayList());
        }
        if (CollectionUtils.isEmpty(graph.getTriggers())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u89e6\u53d1\u6761\u4ef6");
        }
        Map<Integer, Node> nodeMap = graph.getNodes().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        Map<Integer, List<Integer>> edgeMap = graph.getEdges().stream().collect(Collectors.groupingBy(a -> a.getFromNodeId(), Collectors.mapping(a -> a.getToNodeId(), Collectors.toList())));
        Node startNode = (Node)nodeMap.get(graph.getStartNodeId());
        if (startNode == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u5f00\u59cb\u8282\u70b9");
        }
        if (nodeMap.size() < graph.getNodes().size()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8282\u70b9id\u91cd\u590d");
        }
        if (Graph.checkIsolated(graph, edgeMap)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u4e2d\u6709\u5b64\u7acb\u8282\u70b9");
        }
        if (Graph.checkCycle(graph, nodeMap, edgeMap)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u4e2d\u6709\u73af");
        }
    }

    private static boolean checkIsolated(Graph actGraph, Map<Integer, List<Integer>> edgeMap) {
        for (Node node : actGraph.getNodes()) {
            List<Integer> toNodeList;
            if (node.getId() == actGraph.getStartNodeId() || !CollectionUtils.isEmpty(toNodeList = edgeMap.get(node.getId()))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkCycle(Graph actGraph, Map<Integer, Node> nodeMap, Map<Integer, List<Integer>> edgeMap) {
        for (Node node : actGraph.getNodes()) {
            if (!Graph.deepCheek(nodeMap, edgeMap, Lists.newArrayList(), node)) continue;
            return true;
        }
        return false;
    }

    private static boolean deepCheek(Map<Integer, Node> nodeMap, Map<Integer, List<Integer>> edgeMap, List<Integer> deepList, Node node) {
        List<Integer> toNodeList = edgeMap.get(node.getId());
        if (CollectionUtils.isNotEmpty(toNodeList)) {
            node.setEdgNum(toNodeList.size());
            for (Integer nodeId : toNodeList) {
                if (deepList.contains(nodeId)) {
                    return true;
                }
                Node toNode = nodeMap.get(nodeId);
                ArrayList copyDeepList = Lists.newArrayList(deepList);
                copyDeepList.add(nodeId);
                if (!Graph.deepCheek(nodeMap, edgeMap, copyDeepList, toNode)) continue;
                return true;
            }
        } else {
            node.setEdgNum(0);
        }
        return false;
    }

    public boolean hasNextNode(int currentNodeId) {
        if (CollectionUtils.isNotEmpty(this.edges)) {
            for (Edge edge : this.edges) {
                if (edge.getFromNodeId() != currentNodeId) continue;
                return true;
            }
        }
        return false;
    }

    public List<Edge> filterEdges(int fromNodeId) {
        return this.edges.stream().filter(edge -> edge.getFromNodeId() == fromNodeId).collect(Collectors.toList());
    }

    public List<Condition> filterConditions(int fromNodeId) {
        ArrayList conditions = Lists.newArrayList();
        for (Edge edge : this.edges) {
            if (edge.getFromNodeId() != fromNodeId) continue;
            conditions.addAll(edge.getConditions());
        }
        return conditions;
    }

    public Node getNextNoConditionNode(int currentNodeId) {
        for (Edge edge : this.edges) {
            if (edge.getFromNodeId() != currentNodeId || !CollectionUtils.isEmpty(edge.getConditions())) continue;
            return this.getNode(edge.getToNodeId());
        }
        return null;
    }

    public Node getNode(int nodeId) {
        for (Node node : this.nodes) {
            if (nodeId != node.getId()) continue;
            return node;
        }
        return null;
    }

    public static List<List<Integer>> caculeAllpath(Graph actGraph) {
        Map<Integer, List<Integer>> edgeMap = actGraph.getEdges().stream().collect(Collectors.groupingBy(a -> a.getFromNodeId(), Collectors.mapping(a -> a.getToNodeId(), Collectors.toList())));
        ArrayList result = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        list.add(actGraph.getStartNodeId());
        result.add(list);
        Graph.getPath(edgeMap, list, actGraph.getStartNodeId(), result);
        return result;
    }

    private static void getPath(Map<Integer, List<Integer>> map, List<Integer> fatherPath, Integer fatherId, List<List<Integer>> result) {
        List<Integer> ids = map.get(fatherId);
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Integer nodeId : ids) {
                ArrayList tmpList = Lists.newArrayList(fatherPath);
                tmpList.add(nodeId);
                result.add(tmpList);
                Graph.getPath(map, tmpList, nodeId, result);
            }
        }
    }

    public Set<Integer> filterBehaviorConfIds() {
        HashSet result = Sets.newHashSet();
        for (Condition condition : this.getTriggers()) {
            result.add(condition.getBehaviorConfId());
        }
        for (Edge edge : this.edges) {
            if (!CollectionUtils.isNotEmpty(edge.getConditions())) continue;
            result.addAll(edge.getConditions().stream().map(a -> a.getBehaviorConfId()).collect(Collectors.toSet()));
        }
        return result;
    }

    public Set<Integer> filterOpConfIds() {
        HashSet result = Sets.newHashSet();
        for (Node node : this.nodes) {
            if (!CollectionUtils.isNotEmpty(node.getOps())) continue;
            result.addAll(node.getOps().stream().map(a -> a.getConfId()).collect(Collectors.toSet()));
        }
        return result;
    }

    public int getStartNodeId() {
        return this.startNodeId;
    }

    public int getConditionRelation() {
        return this.conditionRelation;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public List<Condition> getTriggers() {
        return this.triggers;
    }

    public List<Condition> getMatchTriggers() {
        return this.matchTriggers;
    }

    public List<Behavior> getMatchBehaviors() {
        return this.matchBehaviors;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Integer getNearestNodeId() {
        return this.nearestNodeId;
    }

    public void setStartNodeId(int startNodeId) {
        this.startNodeId = startNodeId;
    }

    public void setConditionRelation(int conditionRelation) {
        this.conditionRelation = conditionRelation;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void setTriggers(List<Condition> triggers) {
        this.triggers = triggers;
    }

    public void setMatchTriggers(List<Condition> matchTriggers) {
        this.matchTriggers = matchTriggers;
    }

    public void setMatchBehaviors(List<Behavior> matchBehaviors) {
        this.matchBehaviors = matchBehaviors;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public void setNearestNodeId(Integer nearestNodeId) {
        this.nearestNodeId = nearestNodeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartNodeId() != other.getStartNodeId()) {
            return false;
        }
        if (this.getConditionRelation() != other.getConditionRelation()) {
            return false;
        }
        Integer this$nearestNodeId = this.getNearestNodeId();
        Integer other$nearestNodeId = other.getNearestNodeId();
        if (this$nearestNodeId == null ? other$nearestNodeId != null : !((Object)this$nearestNodeId).equals(other$nearestNodeId)) {
            return false;
        }
        Map<String, String> this$context = this.getContext();
        Map<String, String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<Condition> this$triggers = this.getTriggers();
        List<Condition> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<Condition> this$matchTriggers = this.getMatchTriggers();
        List<Condition> other$matchTriggers = other.getMatchTriggers();
        if (this$matchTriggers == null ? other$matchTriggers != null : !((Object)this$matchTriggers).equals(other$matchTriggers)) {
            return false;
        }
        List<Behavior> this$matchBehaviors = this.getMatchBehaviors();
        List<Behavior> other$matchBehaviors = other.getMatchBehaviors();
        if (this$matchBehaviors == null ? other$matchBehaviors != null : !((Object)this$matchBehaviors).equals(other$matchBehaviors)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<Edge> this$edges = this.getEdges();
        List<Edge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Graph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartNodeId();
        result = result * 59 + this.getConditionRelation();
        Integer $nearestNodeId = this.getNearestNodeId();
        result = result * 59 + ($nearestNodeId == null ? 43 : ((Object)$nearestNodeId).hashCode());
        Map<String, String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<Condition> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<Condition> $matchTriggers = this.getMatchTriggers();
        result = result * 59 + ($matchTriggers == null ? 43 : ((Object)$matchTriggers).hashCode());
        List<Behavior> $matchBehaviors = this.getMatchBehaviors();
        result = result * 59 + ($matchBehaviors == null ? 43 : ((Object)$matchBehaviors).hashCode());
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public String toString() {
        return "Graph(startNodeId=" + this.getStartNodeId() + ", conditionRelation=" + this.getConditionRelation() + ", context=" + this.getContext() + ", triggers=" + this.getTriggers() + ", matchTriggers=" + this.getMatchTriggers() + ", matchBehaviors=" + this.getMatchBehaviors() + ", nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ", nearestNodeId=" + this.getNearestNodeId() + ")";
    }
}

