/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.ScrmOfficialService;
import com.kuaike.scrm.common.service.dto.resp.GetLatestOfficialAppIdResp;
import com.kuaike.scrm.common.service.dto.resp.GetOfficialAccessTokenResp;
import com.kuaike.scrm.common.service.dto.resp.JsApiCofnigData;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.SignUtil;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmOfficialServiceImpl
implements ScrmOfficialService {
    private static final Logger log = LoggerFactory.getLogger(ScrmOfficialServiceImpl.class);
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private OfficialTokenService officialTokenService;
    @Resource
    private ComponentTokenService platformInfoService;
    @Resource
    private WxOAuth2API wxOAuth2API;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private IdGen idGen;

    public GetLatestOfficialAppIdResp getLatestOfficialAppIdByBizId(Long bizId) {
        log.info("getLatestOfficialAppIdByBizId bizId:{}", (Object)bizId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId);
        GetLatestOfficialAppIdResp resp = new GetLatestOfficialAppIdResp();
        resp.setAppId(officialAccount == null ? null : officialAccount.getAppId());
        resp.setComponentAppId(this.componentTokenService.getWechatAppId());
        resp.setNickname(officialAccount == null ? "" : officialAccount.getNickName());
        resp.setHeadImg(officialAccount == null ? "" : officialAccount.getHeadImg());
        return resp;
    }

    public GetOfficialAccessTokenResp getOfficialAccessTokenByAppId(String appId) {
        log.info("getOfficialAccessTokenByAppId,appId:{}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        GetOfficialAccessTokenResp resp = new GetOfficialAccessTokenResp();
        String officialAccessToken = this.officialTokenService.getOfficialAccessToken(appId);
        resp.setAccessToken(officialAccessToken);
        resp.setComponentAppId(this.componentTokenService.getWechatAppId());
        return resp;
    }

    public String getOpenIdByAppIdAndCode(String appId, String code) {
        SnsAccessToken snsAccessToken;
        log.info("getOpenIdByAppIdAndCode,appId:{}, code:{}", (Object)appId, (Object)code);
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        String componentToken = this.platformInfoService.getComponentAccessToken();
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, this.componentAppId, componentToken);
        }
        catch (WeixinException e) {
            log.error("getOpenIdByAppIdAndCode getComponentAccessToken error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return snsAccessToken.getOpenId();
    }

    public String getComponentId() {
        return this.componentAppId;
    }

    public JsApiCofnigData generateJsApiData(Long bizId, String url) {
        log.info("getLatestOfficialAppIdByBizId bizId:{}", (Object)bizId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        JsApiCofnigData configData = new JsApiCofnigData();
        OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId);
        Preconditions.checkArgument((officialAccount != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u76f4\u64ad\u95f4\u6682\u672a\u5f00\u901a\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8");
        configData.setAppId(officialAccount.getAppId());
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        String jsapiTicket = this.componentTokenService.getComponentJsapiTicket();
        signMap.put("jsapi_ticket", jsapiTicket);
        String nonceStr = this.idGen.getNum();
        signMap.put("noncestr", nonceStr);
        int index = url.lastIndexOf(35);
        if (index != -1) {
            url = url.substring(0, index);
        }
        signMap.put("url", url);
        Integer timestamp = DateUtil.getCurTimeInt();
        signMap.put("timestamp", timestamp);
        String sign = SignUtil.formatUrlMap(signMap, (boolean)false, (boolean)true);
        configData.setTimeStamp(timestamp);
        configData.setNonceStr(nonceStr);
        configData.setSignature(sign);
        return configData;
    }
}

