/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import cn.kinyun.scrm.weixin.utils.FilterUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.dto.AccountOperatorQueryParam;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountOperator;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountOperatorCriteria;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountOperatorMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperatorServiceImpl
implements OperatorService {
    private static final Logger log = LoggerFactory.getLogger(OperatorServiceImpl.class);
    @Resource
    private OfficialAccountOperatorMapper operatorMapper;
    @Autowired
    private UserInfoService userInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(String appId, Integer roleId, Collection<Long> userIds, Long operatorId) {
        log.info("modify officla account operators with appId = {}, roleId={}, userIds={}, operatorId={}", new Object[]{appId, roleId, userIds, operatorId});
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7id\u4e3a\u7a7a");
        Preconditions.checkArgument((roleId != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e3a\u7a7a");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005id\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set<Long> userIdSet = FilterUtils.filterSet(userIds);
        if (CollectionUtils.isEmpty(userIdSet)) {
            this.delete(appId, roleId, operatorId);
            return;
        }
        OfficialAccountOperatorCriteria example = new OfficialAccountOperatorCriteria();
        example.createCriteria().andAppIdEqualTo(appId).andUserIdentityEqualTo(roleId);
        List exist = this.operatorMapper.selectByExample((Object)example);
        Set existUserIdSet = exist.stream().map(OfficialAccountOperator::getUserId).collect(Collectors.toSet());
        HashSet intersect = Sets.newHashSet(existUserIdSet);
        intersect.retainAll(userIdSet);
        if (CollectionUtils.isNotEmpty((Collection)intersect)) {
            userIdSet.removeAll(intersect);
            existUserIdSet.removeAll(intersect);
        }
        if (CollectionUtils.isNotEmpty(existUserIdSet)) {
            OfficialAccountOperatorCriteria filter = new OfficialAccountOperatorCriteria();
            filter.createCriteria().andAppIdEqualTo(appId).andUserIdentityEqualTo(roleId).andUserIdIn((List)Lists.newArrayList(existUserIdSet));
            this.operatorMapper.deleteByFilter(filter);
        }
        if (CollectionUtils.isNotEmpty(userIdSet)) {
            ArrayList list = Lists.newArrayList();
            userIdSet.forEach(userId -> {
                OfficialAccountOperator operator = new OfficialAccountOperator();
                operator.setBizId(userInfo.getBizId());
                operator.setCorpId(userInfo.getCorpId());
                operator.setAppId(appId);
                operator.setUserId(userId);
                operator.setUserIdentity(roleId);
                operator.setCreatorId(operatorId);
                list.add(operator);
            });
            this.operatorMapper.saveAll((Collection)list);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String appId, Integer roleId, Long operatorId) {
        log.info("delete operator with appId={}, roleId={}", (Object)appId, (Object)roleId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7id\u4e3a\u7a7a");
        Preconditions.checkArgument((roleId != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e3a\u7a7a");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005id\u4e3a\u7a7a");
        OfficialAccountOperatorCriteria filter = new OfficialAccountOperatorCriteria();
        filter.createCriteria().andAppIdEqualTo(appId).andUserIdentityEqualTo(roleId);
        this.operatorMapper.deleteByFilter(filter);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String appId) {
        log.info("delete operator with appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7id\u4e3a\u7a7a");
        OfficialAccountOperatorCriteria filter = new OfficialAccountOperatorCriteria();
        filter.createCriteria().andAppIdEqualTo(appId);
        this.operatorMapper.deleteByFilter(filter);
    }

    @Override
    public List<String> getPermitAppIds(Long userId, Integer roleId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null");
        return this.getPermitAppIds(userId, roleId, null);
    }

    @Override
    public List<String> getPermitAppIds(Long userId, Integer roleId, Collection<String> queryAppIds) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237id\u4e3a\u7a7a");
        List<Object> userIds = Lists.newArrayList((Object[])new Long[]{userId});
        boolean isSystemUser = this.userInfoService.checkIsSystemUser(userId);
        if (isSystemUser) {
            userIds = Collections.emptyList();
        }
        return this.getOperatorsWithUsers(userIds, roleId, queryAppIds).stream().map(OfficialAccountOperator::getAppId).collect(Collectors.toList());
    }

    @Override
    public int countOperators(Collection<Long> userIds, Integer roleId, Collection<String> queryAppIds) {
        AccountOperatorQueryParam operatorQuery = AccountOperatorQueryParam.builder().userIdentity(roleId).userIds(userIds).appIds(queryAppIds).bizId(LoginUtils.getCurrentUserBizId()).build();
        return this.operatorMapper.countOperators(operatorQuery);
    }

    @Override
    public List<OfficialAccountOperator> getOperatorsWithUsers(Collection<Long> userIds, Integer roleId, Collection<String> queryAppIds) {
        AccountOperatorQueryParam operatorQuery = AccountOperatorQueryParam.builder().userIdentity(roleId).userIds(userIds).appIds(queryAppIds).bizId(LoginUtils.getCurrentUserBizId()).build();
        List operators = this.operatorMapper.queryList(operatorQuery);
        if (CollectionUtils.isEmpty((Collection)operators)) {
            return Collections.emptyList();
        }
        return operators;
    }

    @Override
    public boolean hasRolePermission(Long userId, String appId, Integer roleId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237id\u4e3a\u7a7a");
        Preconditions.checkArgument((roleId != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        List<String> permitAppIds = this.getPermitAppIds(userId, roleId);
        if (CollectionUtils.isEmpty(permitAppIds)) {
            return false;
        }
        HashSet permit = Sets.newHashSet(permitAppIds);
        return permit.contains(appId);
    }

    @Override
    public boolean hasRolePermission(Long userId, Collection<String> appIds, Integer roleId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237id\u4e3a\u7a7a");
        Preconditions.checkArgument((roleId != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(appIds), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        List<String> permitAppIds = this.getPermitAppIds(userId, roleId);
        if (CollectionUtils.isEmpty(permitAppIds)) {
            return false;
        }
        HashSet permit = Sets.newHashSet(permitAppIds);
        return permit.containsAll(appIds);
    }

    @Override
    public boolean isManager(Long userId, String appId) {
        return this.hasRolePermission(userId, appId, UserIdentity.MANAGER.getValue());
    }

    @Override
    public boolean isManager(Long userId, Collection<String> appIds) {
        return this.hasRolePermission(userId, appIds, UserIdentity.MANAGER.getValue());
    }

    @Override
    public List<String> getCurrentUserAppIds(Integer roleId) {
        List accountOperators;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        AccountOperatorQueryParam operatorQuery = AccountOperatorQueryParam.builder().userIdentity(roleId).bizId(LoginUtils.getCurrentUserBizId()).build();
        boolean isSystemUser = this.userInfoService.checkIsSystemUser(currentUser.getId());
        if (!isSystemUser) {
            operatorQuery.setUserId(currentUser.getId());
        }
        if (CollectionUtils.isEmpty((Collection)(accountOperators = this.operatorMapper.queryList(operatorQuery)))) {
            return Collections.emptyList();
        }
        return accountOperators.stream().map(OfficialAccountOperator::getAppId).collect(Collectors.toList());
    }

    @Override
    public List<String> getCurrentManagerAppIds() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        return this.getCurrentUserAppIds(UserIdentity.MANAGER.getValue());
    }
}

