/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.enums.AuthStatus;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.CreateQrcodeReqDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialQrcodeService;
import cn.kinyun.scrm.weixin.sdk.api.account.WxQrcodeAPI;
import cn.kinyun.scrm.weixin.sdk.entity.account.CreateQrcodeResult;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficialQrcodeServiceImpl
implements OfficialQrcodeService {
    private static final Logger log = LoggerFactory.getLogger(OfficialQrcodeServiceImpl.class);
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private WxQrcodeAPI qrcodeApi;

    @Override
    public CreateQrcodeResult createTemp(CreateQrcodeReqDto params) {
        log.info("create temp qrcode with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getSceneId() != null || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getSceneStr()}) ? 1 : 0) != 0, (Object)"sceneId\u548csceneStr\u53ea\u8981\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        OfficialAccount account = this.officialAccountService.queryByAppId(params.getAppId());
        if (account == null || AuthStatus.AUTHORIZED.getValue() != account.getAuthStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u516c\u4f17\u53f7\u672a\u6388\u6743\u7ed9\u672c\u5e73\u53f0");
        }
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            if (params.getSceneId() != null) {
                return this.qrcodeApi.createQrcode(accessToken, params.getSceneId(), params.getExpireSeconds());
            }
            return this.qrcodeApi.createQrcode(accessToken, params.getSceneStr(), params.getExpireSeconds());
        }
        catch (WeixinException e) {
            log.error("Failed to create temp qrcode, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public CreateQrcodeResult create(CreateQrcodeReqDto params) {
        log.info("create permanent qrcode with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getSceneId() != null || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getSceneStr()}) ? 1 : 0) != 0, (Object)"sceneId\u548csceneStr\u53ea\u8981\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        OfficialAccount account = this.officialAccountService.queryByAppId(params.getAppId());
        if (account == null || AuthStatus.AUTHORIZED.getValue() != account.getAuthStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u516c\u4f17\u53f7\u672a\u6388\u6743\u7ed9\u672c\u5e73\u53f0");
        }
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            if (params.getSceneId() != null) {
                return this.qrcodeApi.createQrcode(accessToken, params.getSceneId());
            }
            return this.qrcodeApi.createQrcode(accessToken, params.getSceneStr());
        }
        catch (WeixinException e) {
            log.error("Failed to create qrcode, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public String getQrcodeUrl(String ticket) {
        return this.qrcodeApi.getQrcodeUrl(ticket);
    }
}

