/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.AccountType;
import cn.kinyun.scrm.weixin.enums.AuthStatus;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.OfficialAccountReqDto;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.OfficialAccountSettingReqDto;
import cn.kinyun.scrm.weixin.officialaccount.dto.resp.OfficialAccountDetailRespDto;
import cn.kinyun.scrm.weixin.officialaccount.dto.resp.OfficialAccountListRespDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.enums.EnumService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.dto.AccountQueryParam;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountOperator;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountPermissions;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountPermissionsMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.service.MeetingCacheService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountServiceImpl
implements OfficialAccountService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountServiceImpl.class);
    @Value(value="${wx.component.appid}")
    private String componentAppid;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private OfficialAccountPermissionsMapper permissionsMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private OperatorService operatorService;
    @Resource
    private MeetingCacheService meetingCacheService;

    @Override
    public List<OfficialAccountListRespDto> list(OfficialAccountReqDto params) {
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"user id must not be null");
        log.info("query official account list with params={}", (Object)params);
        List<String> appIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyList();
        }
        PageDto pageDto = params.getPageDto();
        AccountQueryParam queryParam = AccountQueryParam.builder().query(params.getQuery()).appIds(appIds).pageDto(pageDto).appId(params.getAppId()).descendOrderByBindTime(params.getDescendOrderByBindTime()).build();
        List accounts = this.officialAccountMapper.queryList(queryParam);
        Long count = this.officialAccountMapper.count(queryParam);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count.intValue()));
            pageDto.setCurPageCount(Integer.valueOf(accounts == null ? 0 : accounts.size()));
        }
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            return Collections.emptyList();
        }
        appIds = accounts.stream().map(OfficialAccount::getAppId).collect(Collectors.toList());
        List<OfficialAccountOperator> managers = this.operatorService.getOperatorsWithUsers(null, UserIdentity.MANAGER.getValue(), appIds);
        Map appId2ManagerIdMap = managers.stream().collect(Collectors.groupingBy(OfficialAccountOperator::getAppId, Collectors.mapping(OfficialAccountOperator::getUserId, Collectors.toSet())));
        HashSet staffIds = Sets.newHashSet();
        staffIds.addAll(managers.stream().map(OfficialAccountOperator::getUserId).collect(Collectors.toSet()));
        Map<Long, UserInfoRespDto> staffMap = this.userInfoService.queryUserInfoMap(staffIds);
        List orgs = this.organizationMapper.selectOrgByIds((Collection)accounts.stream().map(OfficialAccount::getNodeId).collect(Collectors.toList()));
        Map<Long, String> orgIdAndNameMap = orgs.stream().collect(Collectors.toMap(Organization::getId, Organization::getName));
        ArrayList result = Lists.newArrayList();
        accounts.forEach(account -> result.add(this.from((OfficialAccount)account, orgIdAndNameMap, appId2ManagerIdMap, staffMap)));
        return result;
    }

    private OfficialAccountListRespDto from(OfficialAccount account, Map<Long, String> orgIdAndNameMap, Map<String, Set<Long>> appId2ManagerIdMap, Map<Long, UserInfoRespDto> staffMap) {
        Set<Long> managerIds;
        OfficialAccountListRespDto dto = new OfficialAccountListRespDto();
        dto.setAppId(account.getAppId());
        dto.setName(account.getNickName());
        dto.setAccountTypeEnum(EnumConstant.from((EnumService)AccountType.getByValue(account.getServiceType())));
        dto.setBindTime(account.getAuthTime());
        dto.setHeadImg(account.getHeadImg());
        String orgName = orgIdAndNameMap.get(account.getNodeId());
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            dto.setOrganization(new IdAndNameDto(account.getNodeId(), orgName));
        }
        if (CollectionUtils.isNotEmpty(managerIds = appId2ManagerIdMap.get(account.getAppId()))) {
            ArrayList managers = Lists.newArrayList();
            for (Long managerId : managerIds) {
                UserInfoRespDto staffInfo = staffMap.get(managerId);
                if (staffInfo == null) continue;
                managers.add(new IdAndNameDto(staffInfo.getId(), staffInfo.getNickname()));
            }
            dto.setManagers(managers);
        }
        return dto;
    }

    private OfficialAccountDetailRespDto from(OfficialAccount officialAccount, Map<Long, OfficialAccountPermissions> functionInfoMap) {
        OfficialAccountDetailRespDto dto = new OfficialAccountDetailRespDto();
        dto.setName(officialAccount.getNickName());
        dto.setQrcodeUrl(officialAccount.getQrcodeUrl());
        dto.setHeadImg(officialAccount.getHeadImg());
        dto.setIntroduction(officialAccount.getSignature());
        dto.setFunctionInfo(Lists.newArrayList());
        List<IdAndNameDto> functionInfo = dto.getFunctionInfo();
        String functionInfoStr = officialAccount.getFunctionInfo();
        List functionIdStr = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)functionInfoStr);
        functionIdStr.forEach(s -> {
            Long id = Long.parseLong(s);
            OfficialAccountPermissions function = (OfficialAccountPermissions)functionInfoMap.get(id);
            if (function != null) {
                functionInfo.add(new IdAndNameDto(id, function.getDescription()));
            }
        });
        return dto;
    }

    @Override
    public OfficialAccountDetailRespDto detail(OfficialAccountReqDto params) {
        List<OfficialAccountOperator> officialAccountOperators;
        log.info("get official account detail with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"appId is null");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"userId is null");
        boolean isSystemUser = this.userInfoService.checkIsSystemUser(params.getOperatorId());
        if (!isSystemUser && CollectionUtils.isEmpty(officialAccountOperators = this.operatorService.getOperatorsWithUsers(Collections.singleton(params.getOperatorId()), null, Collections.singletonList(params.getAppId())))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u4eba\u5458\u4e0d\u4e3a\u8be5\u516c\u4f17\u53f7\u7ba1\u7406\u5458\u6216\u8005\u5ba2\u670d");
        }
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(params.getAppId());
        if (null == officialAccount || officialAccount.getAuthStatus().intValue() == AuthStatus.UNAUTHORIZED.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u53d6\u6d88\u6388\u6743");
        }
        Map<Long, OfficialAccountPermissions> functionInfoMap = this.getFunctionInfo();
        return this.from(officialAccount, functionInfoMap);
    }

    @Override
    @Cacheable(cacheNames={"officialAccount"}, key="'functionInfo'")
    public Map<Long, OfficialAccountPermissions> getFunctionInfo() {
        log.info("query all official account function info");
        List accountPermissions = this.permissionsMapper.selectAll();
        return accountPermissions.stream().collect(Collectors.toMap(OfficialAccountPermissions::getId, Function.identity()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(OfficialAccountReqDto params) {
        log.info("del official account with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"appId is null");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"userId is null");
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(params.getAppId());
        if (null == officialAccount) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664");
        }
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (!managerAppIds.contains(params.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u7ecf\u8425\u8005\u65e0\u6cd5\u5220\u9664\u516c\u4f17\u53f7");
        }
        officialAccount.setAuthStatus(Integer.valueOf(AuthStatus.UNAUTHORIZED.getValue()));
        officialAccount.setDeauthTime(new Date());
        this.officialAccountMapper.updateByPrimaryKeySelective((Object)officialAccount);
        this.operatorService.delete(params.getAppId());
        try {
            this.meetingCacheService.setOfficialAppId(officialAccount.getBizId(), "");
        }
        catch (Exception e) {
            log.error("meetingCacheService,getOfficialAppId error", (Throwable)e);
        }
    }

    @Override
    public List<IdAndNameDto> checkAuthorizedPermission(OfficialAccountReqDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"id is null");
        log.info("check official account function with params={}", (Object)params);
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(params.getAppId());
        if (null == officialAccount) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728");
        }
        String functionInfoStr = officialAccount.getFunctionInfo();
        List functionIdStr = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)functionInfoStr);
        Map<Long, OfficialAccountPermissions> functionInfo = this.getFunctionInfo();
        List essentialPermissions = functionInfo.values().stream().filter(a -> a.getIsEssential() == 1).collect(Collectors.toList());
        ArrayList result = Lists.newArrayList();
        for (OfficialAccountPermissions officialAccountPermission : essentialPermissions) {
            if (functionIdStr.contains(officialAccountPermission.getId().toString())) continue;
            OfficialAccountPermissions func = functionInfo.get(officialAccountPermission.getId());
            result.add(new IdAndNameDto(officialAccountPermission.getId(), (String)Optional.ofNullable(func).map(OfficialAccountPermissions::getDescription).orElse(null)));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void supportSetting(OfficialAccountSettingReqDto params) {
        log.info("official account settings with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005id\u4e3a\u7528");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getManagerIds()), (Object)"\u8fd0\u8425\u8005id\u4e3a\u7a7a");
        if (params.getManagerIds().size() > 25) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u540c\u4e00\u516c\u4f17\u53f7\u8fd0\u8425\u8005\u6570\u76ee\u4e0d\u80fd\u8d85\u8fc725\u4e2a");
        }
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (!managerAppIds.contains(params.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u7ecf\u8425\u8005\u65e0\u6cd5\u8bbe\u7f6e\u516c\u4f17\u53f7");
        }
        OfficialAccount app = this.officialAccountMapper.getByAppId(params.getAppId());
        if (app == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728");
        }
        if (app.getServiceType() != 2 || app.getVerifyType() != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u4e0d\u662f\u5fae\u4fe1\u8ba4\u8bc1\u7684\u8ba2\u9605\u53f7");
        }
        app.setNodeId(params.getNodeId());
        this.officialAccountMapper.updateByPrimaryKeySelective((Object)app);
        this.operatorService.modify(params.getAppId(), UserIdentity.MANAGER.getValue(), params.getManagerIds(), params.getOperatorId());
    }

    @Override
    public List<StrIdAndNameDto> simpleList(OfficialAccountReqDto params) {
        log.info("query app simple info with params={}", (Object)params);
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId must  not be null");
        boolean isSystemUser = this.userInfoService.checkIsSystemUser(params.getOperatorId());
        ArrayList userIds = Lists.newArrayList();
        if (!isSystemUser) {
            userIds.add(params.getOperatorId());
        }
        List<OfficialAccountOperator> operatorInfo = this.operatorService.getOperatorsWithUsers(userIds, UserIdentity.MANAGER.getValue(), null);
        PageDto pageDto = params.getPageDto();
        if (CollectionUtils.isEmpty(operatorInfo)) {
            if (pageDto != null) {
                pageDto.setCount(Integer.valueOf(0));
                pageDto.setCurPageCount(Integer.valueOf(0));
            }
            return Collections.emptyList();
        }
        List appIds = operatorInfo.stream().map(OfficialAccountOperator::getAppId).collect(Collectors.toList());
        AccountQueryParam queryParam = AccountQueryParam.builder().appIds(appIds).query(params.getQuery()).pageDto(pageDto).build();
        List accounts = this.officialAccountMapper.queryList(queryParam);
        Long count = this.officialAccountMapper.count(queryParam);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count.intValue()));
            pageDto.setCurPageCount(Integer.valueOf(accounts == null ? 0 : accounts.size()));
        }
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            return Collections.emptyList();
        }
        return accounts.stream().map(a -> new StrIdAndNameDto(a.getAppId(), a.getNickName())).collect(Collectors.toList());
    }

    @Override
    public List<OfficialAccount> queryOfficialAccountListByUserId(Long userId, Integer userIdentity, PageDto pageDto) {
        log.info("queryOfficialAccountListByUserId with userId={},userIdentity={},pageDto={}", new Object[]{userId, userIdentity, pageDto});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        List results = this.officialAccountMapper.queryOfficialAccountByUserId(userId, userIdentity, LoginUtils.getCurrentUserBizId(), pageDto);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(this.officialAccountMapper.countOfficialAccountByUserId(userId, userIdentity, LoginUtils.getCurrentUserBizId())));
            pageDto.setCurPageCount(Integer.valueOf(results.size()));
        }
        return results;
    }

    @Override
    public OfficialAccount queryByAppId(String appId) {
        log.info("queryByAppId with appId={}", (Object)appId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        return this.officialAccountMapper.getByAppId(appId);
    }

    @Override
    @Cacheable(cacheNames={"appId2Entity"}, key="#p0")
    public Long queryBuIdByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return 0L;
        }
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
        return officialAccount == null ? 0L : officialAccount.getBizId();
    }

    @Override
    public Map<String, OfficialAccount> queryByAppIds(Collection<String> appIds) {
        log.info("queryByAppIds with appIds={}", appIds);
        if (CollectionUtils.isEmpty(appIds)) {
            return Maps.newHashMap();
        }
        return this.officialAccountMapper.getByAppIds(appIds).stream().collect(Collectors.toMap(OfficialAccount::getAppId, Function.identity()));
    }

    @Override
    public OfficialAccount queryByUserName(String userName) {
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            return this.officialAccountMapper.queryByUserName(userName);
        }
        return null;
    }
}

