/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.common.NewsMessageHelper;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialCommonDtoReq;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.message.dto.ConvrMsg;
import cn.kinyun.scrm.weixin.message.dto.FansTalkSimpleDto;
import cn.kinyun.scrm.weixin.message.dto.MassMessageSendCondition;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.ConversationMsgsReq;
import cn.kinyun.scrm.weixin.message.dto.req.KeywordsMsgReq;
import cn.kinyun.scrm.weixin.message.dto.req.TalkHistorySearchReq;
import cn.kinyun.scrm.weixin.message.dto.resp.KeywordsMsgResp;
import cn.kinyun.scrm.weixin.message.service.EsMessageService;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.officialaccount.dto.resp.FansLatestMsgDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountFansService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.CopyrightCheckResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.utils.FilterUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.dal.official.base.dto.AppIdOpenIdDto;
import com.kuaike.scrm.dal.official.base.dto.FansHistoryMatchHitDto;
import com.kuaike.scrm.dal.official.base.dto.UserQueryParam;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMessageMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountServantSessionMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessage;
import com.kuaike.scrm.dal.official.massmsg.mapper.OfficialAccountMassMessageMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ws.schild.jave.FfmpegUtils;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private EsMessageService esMessageService;
    @Resource
    private OfficialAccountMessageMapper officialAccountMessageMapper;
    @Resource
    private OfficialAccountServantSessionMapper officialAccountServantSessionMapper;
    @Resource
    private OfficialAccountMassMessageMapper massMessageMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountFansService officialAccountFansService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Autowired
    private NewsMessageHelper newsMessageHelper;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Override
    public List<ConvrMsg> getList(ConversationMsgsReq params) {
        Integer direction;
        log.info("getList with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getOpenId()), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        StopWatchDto timer = new StopWatchDto("msgList", true, log);
        Integer count = params.getCount();
        if (count == null) {
            count = 10;
        }
        if ((direction = params.getDirection()) == null) {
            direction = 0;
        }
        boolean forward = direction != 0;
        timer.start("queryListPaged");
        List<ConvrMsg> list = this.esMessageService.queryListPaged(params.getAppId(), params.getOpenId(), params.getId(), count, forward, false, new int[0]);
        timer.stop();
        if (CollectionUtils.isEmpty(list)) {
            timer.print();
            return Lists.newArrayList();
        }
        List<ConvrMsg> sysMassMsgs = list.stream().filter(a -> a.getSendType().intValue() == MsgSendType.SYS_MASS_SEND_FANS.getValue()).collect(Collectors.toList());
        timer.start("setMassMsgContent");
        this.setMassMsgContent(sysMassMsgs);
        timer.stop();
        List<ConvrMsg> normalMsgs = list.stream().filter(a -> a.getSendType().intValue() != MsgSendType.SYS_MASS_SEND_FANS.getValue()).collect(Collectors.toList());
        timer.start("setNewsMsg");
        this.setNewsMsg(normalMsgs);
        timer.stop();
        timer.start("setNicknameAndHeadImgUrl");
        this.setNicknameAndHeadImgUrl(params.getAppId(), list);
        timer.stop();
        timer.print();
        return list;
    }

    private void setNewsMsg(List<ConvrMsg> normalMsgs) {
        if (CollectionUtils.isEmpty(normalMsgs)) {
            return;
        }
        for (ConvrMsg convrMsg : normalMsgs) {
            List<MaterialResultDto> materialResultDtos;
            String mediaId;
            MaterialResultDto materialResultDto;
            MsgData msgData = convrMsg.getMsgData();
            if (msgData == null || !MaterialType.NEWS.getValue().equalsIgnoreCase(msgData.getMediaType()) || (materialResultDto = this.commonMaterialService.getByMediaId(mediaId = msgData.getMediaId())) == null || !CollectionUtils.isNotEmpty(materialResultDtos = this.commonMaterialService.queryList(MaterialCommonDtoReq.builder().ids(Sets.newHashSet((Object[])new Long[]{materialResultDto.getId()})).build()))) continue;
            convrMsg.setNewsMaterialInfo(this.newsMessageHelper.buildNews(materialResultDtos.get(0)));
        }
    }

    private void setMassMsgContent(List<ConvrMsg> sysMassMsgs) {
        if (CollectionUtils.isNotEmpty(sysMassMsgs)) {
            List<MaterialResultDto> materialListRespList;
            Map<Long, OfficialAccountMassMessage> id2MassMsg = sysMassMsgs.stream().collect(Collectors.toMap(ConvrMsg::getId, a -> (OfficialAccountMassMessage)JSONObject.parseObject((String)a.getMsgData().getContent(), OfficialAccountMassMessage.class)));
            Set<Long> materialIds = id2MassMsg.values().stream().map(OfficialAccountMassMessage::getMaterialId).collect(Collectors.toSet());
            Map<Object, Object> materialMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(materialIds) && CollectionUtils.isNotEmpty(materialListRespList = this.commonMaterialService.queryList(MaterialCommonDtoReq.builder().ids(materialIds).build()))) {
                materialMap = materialListRespList.stream().collect(Collectors.toMap(OfficialMaterial::getId, Function.identity()));
            }
            List inputTextMassMsgIds = id2MassMsg.values().stream().filter(a -> a.getMaterialType().equals(MaterialType.TEXT.getValue()) && a.getMaterialId() == 0L).map(OfficialAccountMassMessage::getId).collect(Collectors.toList());
            HashMap inputTextMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(inputTextMassMsgIds)) {
                List massMessages = this.massMessageMapper.getByIds(inputTextMassMsgIds);
                massMessages.forEach(a -> {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSendCondition()})) {
                        MassMessageSendCondition sendCondition;
                        try {
                            sendCondition = (MassMessageSendCondition)JacksonUtil.str2Obj((String)a.getSendCondition(), MassMessageSendCondition.class);
                        }
                        catch (IOException e) {
                            log.error("parse massMsg json error", (Throwable)e);
                            inputTextMap.put(a.getId(), "\u6682\u4e0d\u652f\u6301\u7684\u6d88\u606f\u663e\u793a");
                            return;
                        }
                        inputTextMap.put(a.getId(), sendCondition.getContent());
                    }
                });
            }
            Map<Long, CopyrightCheckResult> checkResultMap = this.newsMessageHelper.getCopyrightCheckResults(id2MassMsg.values());
            for (ConvrMsg convrMsg : sysMassMsgs) {
                OfficialAccountMassMessage massMessage = id2MassMsg.get(convrMsg.getId());
                MsgData msgData = convrMsg.getMsgData();
                MaterialResultDto material = (MaterialResultDto)materialMap.get(massMessage.getMaterialId());
                if (material != null) {
                    msgData.setTitle(material.getTitle());
                    msgData.setContent(null);
                    if (massMessage.getMaterialType().equals(MaterialType.TEXT.getValue())) {
                        msgData.setContent(material.getContent());
                    } else {
                        msgData.setMediaUrl(material.getUrl());
                    }
                    if (!massMessage.getMaterialType().equals(MaterialType.NEWS.getValue())) continue;
                    convrMsg.setNewsMaterialInfo(this.newsMessageHelper.buildNews(checkResultMap, material, massMessage));
                    continue;
                }
                if (!massMessage.getMaterialType().equals(MaterialType.TEXT.getValue()) || massMessage.getMaterialId() != 0L) continue;
                msgData.setContent((String)inputTextMap.get(massMessage.getId()));
            }
        }
    }

    @Override
    public List<ConvrMsg> getListAround(ConversationMsgsReq params) {
        List<ConvrMsg> list;
        log.info("getListAround with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getOpenId()), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid\u4e3a\u7a7a");
        Integer count = params.getCount();
        if (count == null) {
            count = 10;
        }
        if (CollectionUtils.isEmpty(list = this.esMessageService.queryListAround(params.getAppId(), params.getOpenId(), params.getId(), count))) {
            return Lists.newArrayList();
        }
        this.setNicknameAndHeadImgUrl(params.getAppId(), list);
        return list;
    }

    @Override
    public List<ConvrMsg> getListBetween(ConversationMsgsReq params) {
        log.info("getListBetween with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getAppId()), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getOpenId()), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId1() != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid1\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId2() != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid2\u4e3a\u7a7a");
        List<ConvrMsg> list = this.esMessageService.queryListBetween(params.getAppId(), params.getOpenId(), params.getId1(), params.getId2(), params.getIncludeId1(), params.getIncludeId2());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        this.setNicknameAndHeadImgUrl(params.getAppId(), list);
        return list;
    }

    @Override
    public List<FansTalkSimpleDto> searchFansTalkHistory(String appId, Long userId, String query, Integer fansTalkCount) {
        List fanIds;
        log.info("searchFansTalkHistory with appId={},userId={},query={},fansTalkCount={}", new Object[]{appId, userId, query, fansTalkCount});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u5ba2\u670duserId\u4e3a\u7a7a");
        List<String> permits = this.operatorService.getPermitAppIds(userId, UserIdentity.SERVICE_PERSONNEL.getValue());
        Set<Object> appIds = Sets.newHashSet(permits);
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId})) {
            if (!appIds.contains(appId)) {
                return Collections.emptyList();
            }
            appIds = Collections.singleton(appId);
        }
        if (CollectionUtils.isEmpty((Collection)(fanIds = this.officialAccountMessageMapper.queryUserTalkedFans((Collection)appIds, userId)))) {
            return Collections.emptyList();
        }
        List<FansHistoryMatchHitDto> matchList = this.esMessageService.countHistory(fanIds, query, fansTalkCount);
        if (CollectionUtils.isEmpty(matchList)) {
            return Collections.emptyList();
        }
        Map appId2OpenIds = matchList.stream().collect(Collectors.groupingBy(FansHistoryMatchHitDto::getAppId, HashMap::new, Collectors.mapping(FansHistoryMatchHitDto::getOpenId, Collectors.toSet())));
        appIds = matchList.stream().map(FansHistoryMatchHitDto::getAppId).collect(Collectors.toSet());
        Map<String, OfficialAccount> appId2AccountMap = this.officialAccountService.queryByAppIds(appIds);
        HashMap appIdOpenId2Fans = Maps.newHashMap();
        appId2OpenIds.forEach((k, v) -> appIdOpenId2Fans.put(k, this.officialAccountFansService.queryByFansId((String)k, (Collection<String>)v)));
        return matchList.stream().map(a -> {
            OfficialAccountFans fans;
            FansTalkSimpleDto dto = new FansTalkSimpleDto();
            dto.setUserId(userId);
            dto.setAppId(a.getAppId());
            dto.setOpenId(a.getOpenId());
            dto.setMatchCount(a.getCount().intValue());
            OfficialAccount account = (OfficialAccount)appId2AccountMap.get(a.getAppId());
            if (account != null) {
                dto.setAppName(account.getNickName());
            }
            if ((fans = (OfficialAccountFans)((Map)appIdOpenId2Fans.getOrDefault(a.getAppId(), Maps.newHashMap())).get(a.getOpenId())) != null) {
                dto.setHeadImgUrl(fans.getHeadImgUrl());
                dto.setNickName(fans.getNickname());
                dto.setNoteName(fans.getNoteName());
            }
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<ConvrMsg> searchTalkHistoryList(TalkHistorySearchReq params) {
        log.info("Search fans talk history list with params={}", (Object)params);
        String query = params.getQuery();
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        String appId = params.getAppId();
        String openId = params.getOpenId();
        Long userId = params.getUserId();
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u5ba2\u670duserId\u4e3a\u7a7a");
        int count = this.officialAccountServantSessionMapper.checkIfHaveLinked(openId, appId, userId);
        if (count <= 0) {
            log.info("\u5ba2\u670d\u548c\u7c89\u4e1d\u672a\u5173\u8054\u8fc7");
            return Lists.newArrayList();
        }
        List<ConvrMsg> list = this.esMessageService.searchHistory(appId, openId, query, params.getPageDto());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        this.setNicknameAndHeadImgUrl(params.getAppId(), list);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfficialAccountMessage saveMsg(BaseRespMsg msg, MsgSendType sendType, Long servantSessionId, Long operatorId) {
        OfficialAccountMessage message = this.insert(msg, sendType, servantSessionId, operatorId);
        executorService.submit(() -> this.esMessageService.save(message));
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMsg(OfficialAccountMessage message) {
        this.officialAccountMessageMapper.insertSelective((Object)message);
        executorService.submit(() -> this.esMessageService.save(message));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(OfficialAccountMessage message) {
        log.info("insert message={}", (Object)message);
        this.officialAccountMessageMapper.insertSelective((Object)message);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfficialAccountMessage insert(BaseRespMsg msg, MsgSendType sendType, Long servantSessionId, Long operatorId) {
        log.info("insert message={}, sendType={}, servantSessionId={}, operatorId={}", new Object[]{msg, sendType, servantSessionId, operatorId});
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((sendType != null ? 1 : 0) != 0, (Object)"\u53d1\u9001\u7c7b\u578b\u4e3a\u7a7a");
        Preconditions.checkArgument((servantSessionId != null ? 1 : 0) != 0, (Object)"\u5ba2\u670d\u4f1a\u8bddID\u4e3a\u7a7a");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005ID\u4e3a\u7a7a");
        OfficialAccount account = this.officialAccountMapper.getByAppId(msg.getFromUserName());
        OfficialAccountMessage message = new OfficialAccountMessage();
        message.setBizId(account.getBizId());
        message.setCorpId(account.getCorpId());
        message.setOpenId(msg.getToUserName());
        message.setAppId(msg.getFromUserName());
        message.setMsgId(Long.valueOf(-1L));
        message.setMsgType(msg.getMsgType());
        message.setContent(JacksonUtil.obj2Str((Object)new MsgData(msg)));
        message.setSendType(Integer.valueOf(sendType.getValue()));
        message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
        message.setUserId(operatorId);
        message.setServantSessionId(servantSessionId);
        message.setCreateTime(new Date());
        this.officialAccountMessageMapper.insertSelective((Object)message);
        return message;
    }

    @Override
    public boolean msgExist(Long msgId) {
        return this.officialAccountMessageMapper.existsWithMsgId(msgId);
    }

    @Override
    public List<FansLatestMsgDto> queryFansLatestMsg(Long userId, Collection<AppIdOpenIdDto> appIdOpenIdDtos) {
        log.info("queryFansLatestMsg with appId={},appIdOpenIdDtos={}", (Object)userId, appIdOpenIdDtos);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(appIdOpenIdDtos), (Object)"appIdOpenIdDtos is null or empty");
        List list = this.officialAccountMessageMapper.queryFansLatestMsg(userId, appIdOpenIdDtos);
        return list.stream().map(a -> {
            FansLatestMsgDto dto = new FansLatestMsgDto();
            dto.setAppId(a.getAppId());
            try {
                MsgData msgData = (MsgData)JacksonUtil.str2Obj((String)a.getContent(), MsgData.class);
                dto.setContent(msgData);
            }
            catch (IOException e) {
                log.error("parse msgData error: ", (Throwable)e);
            }
            dto.setLatestTime(a.getCreateTime());
            dto.setOpenId(a.getOpenId());
            dto.setUserId(a.getUserId());
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<KeywordsMsgResp> queryKeywordMsg(KeywordsMsgReq params) {
        List<String> keywords;
        log.info("query keyword message with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getOpenId()}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        if (params.getCount() == null || params.getCount() < 0) {
            params.setCount(10);
        }
        if (CollectionUtils.isEmpty(keywords = params.getKeywords())) {
            return Collections.emptyList();
        }
        Set<String> filtered = FilterUtils.filterSet(keywords);
        if (CollectionUtils.isEmpty(keywords = filtered.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        return this.esMessageService.queryKeywordMsg(params.getAppId(), params.getOpenId(), keywords, params.getCount());
    }

    private void setNicknameAndHeadImgUrl(String appId, List<ConvrMsg> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        OfficialAccount officialAccount = this.officialAccountService.queryByAppId(appId);
        Set<String> openIds = list.stream().map(ConvrMsg::getOpenId).collect(Collectors.toSet());
        Map<String, OfficialAccountFans> fansInfoMap = this.officialAccountFansService.queryByFansId(appId, openIds);
        Set<Long> userIds = list.stream().map(ConvrMsg::getUserId).filter(it -> it != null && it > 0L).collect(Collectors.toSet());
        Map<Long, UserInfoRespDto> userInfoMap = this.userInfoService.queryUserInfoMap(userIds);
        list.forEach(msg -> {
            Integer sendType = msg.getSendType();
            if (sendType.intValue() == MsgSendType.RECV.getValue()) {
                OfficialAccountFans fansInfo = (OfficialAccountFans)fansInfoMap.get(msg.getOpenId());
                if (fansInfo != null) {
                    msg.setNickName(fansInfo.getNickname());
                    msg.setNoteName(fansInfo.getNoteName());
                    msg.setHeadImgUrl(fansInfo.getHeadImgUrl());
                }
            } else if (sendType.intValue() == MsgSendType.SEND.getValue()) {
                UserInfoRespDto userInfo = (UserInfoRespDto)userInfoMap.get(msg.getUserId());
                if (userInfo != null) {
                    msg.setNickName(userInfo.getNickname());
                    msg.setHeadImgUrl(userInfo.getAvatar());
                }
            } else if (sendType.intValue() == MsgSendType.SYS_SEND_FANS.getValue()) {
                msg.setSendType(MsgSendType.SEND.getValue());
                if (officialAccount != null) {
                    msg.setNickName(officialAccount.getNickName());
                    msg.setHeadImgUrl(officialAccount.getHeadImg());
                }
            } else if (sendType.intValue() == MsgSendType.SYS_MASS_SEND_FANS.getValue() && officialAccount != null) {
                msg.setNickName(officialAccount.getNickName());
                msg.setHeadImgUrl(officialAccount.getHeadImg());
            }
        });
    }

    @Override
    public ConvrMsg newConvrMsg(OfficialAccountMessage message) {
        log.info("new ConvrMsg with params={}", (Object)message);
        MsgData msgData = null;
        try {
            msgData = (MsgData)JacksonUtil.str2Obj((String)message.getContent(), MsgData.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790json\u5931\u8d25, value={}", (Object)message.getContent(), (Object)e);
        }
        ConvrMsg msg = new ConvrMsg();
        msg.setId(message.getId());
        msg.setAppId(message.getAppId());
        msg.setOpenId(message.getOpenId());
        msg.setUserId(message.getUserId());
        msg.setServantSessionId(message.getServantSessionId());
        msg.setSendType(message.getSendType());
        msg.setSyncStatus(message.getSyncStatus());
        msg.setMsgId(message.getMsgId());
        msg.setMsgType(message.getMsgType());
        msg.setMsgData(msgData);
        msg.setSendTime(message.getCreateTime());
        if (msg.getSendType() == null) {
            log.warn("msg send type is null, id={}", (Object)msg.getId());
        } else if (msg.getSendType().intValue() == MsgSendType.RECV.getValue()) {
            OfficialAccountFans fansInfo = this.officialAccountFansService.queryByFansId(msg.getAppId(), msg.getOpenId());
            if (fansInfo != null) {
                msg.setNickName(fansInfo.getNickname());
                msg.setNoteName(fansInfo.getNoteName());
                msg.setHeadImgUrl(fansInfo.getHeadImgUrl());
            }
        } else if (msg.getSendType().intValue() == MsgSendType.SEND.getValue()) {
            UserQueryParam param = new UserQueryParam();
            param.setIds((Collection)Lists.newArrayList((Object[])new Long[]{message.getUserId()}));
            List<UserInfoRespDto> staffs = this.userInfoService.queryList(param);
            UserInfoRespDto userInfo = null;
            if (CollectionUtils.isNotEmpty(staffs)) {
                userInfo = staffs.get(0);
            }
            if (userInfo != null) {
                msg.setNickName(userInfo.getNickname());
                msg.setHeadImgUrl(userInfo.getAvatar());
            }
        }
        return msg;
    }

    @Override
    public void setVoiceTranscodeInfo(String appId, File file, MsgData msgData) {
        String url;
        File amr2Mp3File;
        log.info("setVoiceTranscodeInfo with file={} msgData={}", (Object)file, (Object)msgData);
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file is null");
        Preconditions.checkArgument((msgData != null ? 1 : 0) != 0, (Object)"msgData is null");
        String format = FfmpegUtils.getSuffix(file.getName());
        if (("amr".equalsIgnoreCase(format) || "wma".equalsIgnoreCase(format) || "wav".equalsIgnoreCase(format)) && (amr2Mp3File = FfmpegUtils.getAudioMp3(file)) != null) {
            file = amr2Mp3File;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url = this.aliyunOss.uploadFile(appId, file, file.getName())})) {
            msgData.setFormat("mp3");
            msgData.setMediaUrl(url);
        }
        msgData.setDuration(FfmpegUtils.getDuration(file));
    }
}

