/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.common.NewsMessageHelper;
import cn.kinyun.scrm.weixin.common.dto.EnumDto;
import cn.kinyun.scrm.weixin.common.dto.ModifierDto;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.AuthStatus;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.OperateType;
import cn.kinyun.scrm.weixin.enums.SendStatus;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.enums.message.SendWay;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialCommonDtoReq;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.message.dto.MassMessageSendCondition;
import cn.kinyun.scrm.weixin.message.dto.MassMsgErrStatus;
import cn.kinyun.scrm.weixin.message.dto.req.MassMessgaeReqDto;
import cn.kinyun.scrm.weixin.message.dto.resp.MassMessageRespDto;
import cn.kinyun.scrm.weixin.message.dto.resp.MassMsgStatRespDto;
import cn.kinyun.scrm.weixin.message.service.MassMessageService;
import cn.kinyun.scrm.weixin.officialaccount.dto.resp.FansListRespDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import cn.kinyun.scrm.weixin.officialaccount.service.impl.OfficialAccountFansServiceImpl;
import cn.kinyun.scrm.weixin.sdk.api.WxMassMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.CopyrightCheckResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.MassSendJobFinishEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.req.DelMassMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgStatus;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.RedisDistributedLock;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.massmsg.dto.MassMessageQueryParam;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessage;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessageDetail;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessageLog;
import com.kuaike.scrm.dal.official.massmsg.mapper.OfficialAccountMassMessageDetailMapper;
import com.kuaike.scrm.dal.official.massmsg.mapper.OfficialAccountMassMessageLogMapper;
import com.kuaike.scrm.dal.official.massmsg.mapper.OfficialAccountMassMessageMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MassMessageServiceImpl
implements MassMessageService {
    private static final Logger log = LoggerFactory.getLogger(MassMessageServiceImpl.class);
    @Resource
    private OfficialAccountMassMessageMapper massMessageMapper;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private WxMassMsgAPI wxMassMsgAPI;
    @Autowired
    private OfficialTokenService officialTokenService;
    @Resource
    private OfficialAccountMassMessageDetailMapper massMessageDetailMapper;
    @Resource
    private OfficialAccountFansMapper officialAccountFansMapper;
    @Resource
    private OfficialAccountMassMessageLogMapper logMapper;
    @Autowired
    @Qualifier(value="objectRedisTemplate")
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private RedisDistributedLock redisLock;
    @Autowired
    private NewsMessageHelper newsMessageHelper;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private static final String SPLITTER = ",";
    private static final String SUCCESS_STATUS = "send success";

    @Override
    public List<MassMessageRespDto> list(MassMessgaeReqDto params) {
        List<MaterialResultDto> materials;
        log.info("query mass message with params={}", (Object)params);
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId is null");
        PageDto pageDto = params.getPageDto();
        List<String> permitAppIds = this.operatorService.getPermitAppIds(params.getOperatorId(), UserIdentity.MANAGER.getValue());
        if (CollectionUtils.isEmpty(permitAppIds)) {
            this.resetPage(pageDto);
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)params.getAppId())) {
            if (permitAppIds.contains(params.getAppId())) {
                permitAppIds = Collections.singletonList(params.getAppId());
            } else {
                this.resetPage(pageDto);
                return Collections.emptyList();
            }
        }
        HashSet conditionMaterialIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)params.getQuery()) && CollectionUtils.isNotEmpty(materials = this.commonMaterialService.queryList(MaterialCommonDtoReq.builder().query(params.getQuery()).build()))) {
            conditionMaterialIds.addAll(materials.stream().map(OfficialMaterial::getId).collect(Collectors.toSet()));
        }
        MassMessageQueryParam queryParam = this.newQueryParam(params, permitAppIds, conditionMaterialIds);
        List massMessages = this.massMessageMapper.queryList(queryParam);
        Integer count = this.massMessageMapper.count(queryParam);
        if (pageDto != null) {
            pageDto.setCount(count);
            pageDto.setCurPageCount(Integer.valueOf(massMessages == null ? 0 : massMessages.size()));
        }
        if (CollectionUtils.isEmpty((Collection)massMessages)) {
            return Collections.emptyList();
        }
        Map<Long, CopyrightCheckResult> checkResultMap = this.newsMessageHelper.getCopyrightCheckResults(massMessages);
        Map<String, OfficialAccount> appMap = this.officialAccountService.queryByAppIds(this.collectMassMsgAppIds(massMessages));
        HashMap materialMap = Maps.newHashMap();
        this.fillMaterialMap(massMessages, materialMap);
        List logs = this.logMapper.queryByMassMsgIds((Collection)massMessages.stream().map(OfficialAccountMassMessage::getId).collect(Collectors.toList()));
        HashMap msgLogsMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)logs)) {
            msgLogsMap.putAll(logs.stream().collect(Collectors.groupingBy(OfficialAccountMassMessageLog::getMassMessageId)));
        }
        Set<Long> staffIds = this.collectStaffIds(massMessages, logs);
        Map<Long, UserInfoRespDto> staffMap = this.userInfoService.queryUserInfoMap(staffIds);
        ArrayList result = Lists.newArrayList();
        for (OfficialAccountMassMessage massMessage : massMessages) {
            result.add(this.from(massMessage, appMap, staffMap, materialMap, checkResultMap, msgLogsMap));
        }
        return result;
    }

    private Set<Long> collectStaffIds(List<OfficialAccountMassMessage> massMessages, List<OfficialAccountMassMessageLog> logs) {
        HashSet staffIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(massMessages)) {
            for (OfficialAccountMassMessage massMessage : massMessages) {
                staffIds.add(massMessage.getCreatorId());
                staffIds.add(massMessage.getUpdatorId());
            }
        }
        if (CollectionUtils.isNotEmpty(logs)) {
            staffIds.addAll(logs.stream().map(OfficialAccountMassMessageLog::getOperatorId).collect(Collectors.toSet()));
        }
        return staffIds;
    }

    private Set<String> collectMassMsgAppIds(List<OfficialAccountMassMessage> massMessages) {
        HashSet appIds = Sets.newHashSet();
        if (massMessages == null) {
            return appIds;
        }
        List appStrList = massMessages.stream().map(OfficialAccountMassMessage::getAppIds).collect(Collectors.toList());
        for (String appStr : appStrList) {
            appIds.addAll(Splitter.on((String)SPLITTER).omitEmptyStrings().splitToList((CharSequence)appStr));
        }
        return appIds;
    }

    private MassMessageQueryParam newQueryParam(MassMessgaeReqDto params, List<String> permitAppIds, Set<Long> conditionMaterialIds) {
        MassMessageQueryParam queryParam = new MassMessageQueryParam();
        BeanUtils.copyProperties((Object)params, (Object)queryParam);
        queryParam.setAppIds(permitAppIds);
        queryParam.setMaterialIds(conditionMaterialIds);
        queryParam.setTextContent(params.getQuery());
        return queryParam;
    }

    private void fillMaterialMap(List<OfficialAccountMassMessage> massMessages, Map<Long, MaterialResultDto> materialMap) {
        Set<Long> materialIds = massMessages.stream().map(OfficialAccountMassMessage::getMaterialId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            List<MaterialResultDto> materialListRespList = this.commonMaterialService.queryList(MaterialCommonDtoReq.builder().ids(materialIds).build());
            materialMap.putAll(materialListRespList.stream().collect(Collectors.toMap(OfficialMaterial::getId, Function.identity())));
        }
    }

    public MassMessageRespDto from(OfficialAccountMassMessage massMessage, Map<String, OfficialAccount> appMap, Map<Long, UserInfoRespDto> staffMap, Map<Long, MaterialResultDto> materialMap, Map<Long, CopyrightCheckResult> checkResultMap, Map<Long, List<OfficialAccountMassMessageLog>> msgLogsMap) {
        UserInfoRespDto updator;
        MassMessageRespDto respDto = new MassMessageRespDto();
        respDto.setId(massMessage.getId());
        String appIdStr = massMessage.getAppIds();
        if (StringUtils.isNotBlank((CharSequence)appIdStr)) {
            List appIds = Splitter.on((String)SPLITTER).omitEmptyStrings().splitToList((CharSequence)appIdStr);
            for (String appId : appIds) {
                OfficialAccount app = appMap.get(appId);
                if (app == null) continue;
                respDto.getAppInfo().add(new StrIdAndNameDto(appId, app.getNickName()));
            }
        }
        MaterialType materialType = MaterialType.getByValue(massMessage.getMaterialType());
        Long materialId = massMessage.getMaterialId();
        String sendCondition = massMessage.getSendCondition();
        if (materialType != null) {
            respDto.setMaterialType(new EnumDto(materialType.getValue(), materialType.getDesc()));
            if (materialType == MaterialType.TEXT && (materialId == null || materialId <= 0L)) {
                MassMessageSendCondition cond = (MassMessageSendCondition)JSONObject.parseObject((String)sendCondition, MassMessageSendCondition.class);
                respDto.setContent(cond == null ? null : cond.getContent());
            } else {
                MaterialResultDto material = materialMap.get(materialId);
                if (material != null) {
                    respDto.setTitle(material.getTitle());
                    if (massMessage.getMaterialType().equals(MaterialType.TEXT.getValue())) {
                        respDto.setContent(material.getContent());
                    } else if (massMessage.getMaterialType().equals(MaterialType.VOICE.getValue())) {
                        String transcodeUrl = material.getTranscodeUrl();
                        respDto.setContent(StringUtils.isNotBlank((CharSequence)transcodeUrl) ? transcodeUrl : material.getUrl());
                    } else {
                        respDto.setContent(material.getUrl());
                    }
                    if (massMessage.getMaterialType().equals(MaterialType.NEWS.getValue())) {
                        respDto.setNewsMaterialInfo(this.newsMessageHelper.buildNews(checkResultMap, material, massMessage));
                    }
                }
            }
        }
        respDto.setSendTime(massMessage.getSendTime());
        respDto.setSendCondition(sendCondition);
        SendStatus sendStatus = SendStatus.getByValue(massMessage.getSendStatus());
        if (sendStatus != null) {
            respDto.setSendStatus(new EnumDto(sendStatus.getValue(), sendStatus.getDesc()));
        }
        respDto.setCreateTime(massMessage.getCreateTime());
        respDto.setUpdateTime(massMessage.getUpdateTime());
        UserInfoRespDto creator = staffMap.get(massMessage.getCreatorId());
        if (creator != null) {
            respDto.setCreator(new ModifierDto(creator.getId(), creator.getUsername(), creator.getNickname()));
        }
        if ((updator = staffMap.get(massMessage.getUpdatorId())) != null) {
            respDto.setUpdator(new ModifierDto(updator.getId(), updator.getUsername(), updator.getNickname()));
        }
        List<OfficialAccountMassMessageLog> logs = msgLogsMap.get(massMessage.getId());
        ArrayList records = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(logs)) {
            logs.forEach(a -> {
                MassMessageRespDto.OperateRecord operateRecord = new MassMessageRespDto.OperateRecord();
                operateRecord.setOperateTime(a.getOperateTime());
                operateRecord.setOperateType(OperateType.toEnumDto(OperateType.valueOf(a.getOperateType())));
                UserInfoRespDto userInfoRespDto = (UserInfoRespDto)staffMap.get(a.getOperatorId());
                if (userInfoRespDto != null) {
                    operateRecord.setOperator(new IdAndNameDto(userInfoRespDto.getId(), userInfoRespDto.getNickname()));
                }
                records.add(operateRecord);
            });
        }
        respDto.setOperateRecords(records);
        return respDto;
    }

    private void resetPage(PageDto pageDto) {
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(0));
            pageDto.setCurPageCount(Integer.valueOf(0));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(MassMessageSendCondition params) {
        log.info("addOrMod or mod mass message with params={}", (Object)params);
        params.validate(true);
        this.checkDataAccess(params.getOperatorId(), params.getAppIds());
        this.checkAppAuthed(params.getAppIds());
        if (params.getId() == null) {
            this.dealWechatCondition(params, true);
        }
        this.checkMaterial(params);
        this.checkManageTime(params.getSendTime());
        OfficialAccountMassMessage massMessage = new OfficialAccountMassMessage();
        if (params.getId() != null) {
            massMessage = (OfficialAccountMassMessage)this.massMessageMapper.selectByPrimaryKey((Object)params.getId());
            if (null == massMessage) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bf9\u5e94\u7684\u7fa4\u53d1\u6d88\u606f\u4e0d\u5b58\u5728");
            }
            if (!massMessage.getSendStatus().equals(SendStatus.WAITTING_SEND.getValue())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53ea\u6709\u5f85\u53d1\u9001\u7684\u6d88\u606f\u53ef\u4ee5\u7f16\u8f91");
            }
            this.convertToEntity(massMessage, params);
            massMessage.setSendCondition(JSONObject.toJSONString((Object)params));
            this.massMessageMapper.updateByPrimaryKeySelective((Object)massMessage);
            this.logMapper.insertSelective((Object)this.constructLog(massMessage.getId(), OperateType.UPDATE, new Date(), params.getOperatorId()));
        } else {
            this.convertToEntity(massMessage, params);
            massMessage.setCreatorId(params.getOperatorId());
            massMessage.setCreateTime(new Date());
            this.massMessageMapper.insertSelective((Object)massMessage);
            params.setId(massMessage.getId());
            massMessage.setSendCondition(JSONObject.toJSONString((Object)params));
            this.massMessageMapper.updateByPrimaryKeySelective((Object)massMessage);
            this.logMapper.insertSelective((Object)this.constructLog(massMessage.getId(), OperateType.ADD, new Date(), params.getOperatorId()));
        }
    }

    private void checkAppAuthed(List<String> appIds) {
        Map<String, OfficialAccount> appMap = this.officialAccountService.queryByAppIds(appIds);
        List deauthedApps = appMap.values().stream().filter(a -> a.getAuthStatus().intValue() == AuthStatus.UNAUTHORIZED.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deauthedApps)) {
            OfficialAccount deauthedApp = (OfficialAccount)deauthedApps.get(0);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7" + deauthedApp.getNickName() + "\u5df2\u7ecf\u53d6\u6d88\u6388\u6743");
        }
    }

    private void checkMaterial(MassMessageSendCondition params) {
        Long materialId = params.getMaterialId();
        String materialType = params.getMaterialType();
        if (MaterialType.TEXT.getValue().equals(materialType) && (materialId == null || materialId <= 0L)) {
            return;
        }
        OfficialMaterial material = this.commonMaterialService.getMaterial(materialId);
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        this.validate(material, materialType);
    }

    private OfficialAccountMassMessageLog constructLog(Long massMessageId, OperateType operateType, Date operateTime, Long operatorId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialAccountMassMessageLog msgLog = new OfficialAccountMassMessageLog();
        msgLog.setBizId(userInfo.getBizId());
        msgLog.setMassMessageId(massMessageId);
        msgLog.setOperateType(String.valueOf((Object)operateType));
        msgLog.setOperateTime(operateTime);
        msgLog.setOperatorId(operatorId);
        return msgLog;
    }

    private void convertToEntity(OfficialAccountMassMessage massMessage, MassMessageSendCondition params) {
        if (params.getSendWay().intValue() == SendWay.DELAY.getValue()) {
            massMessage.setSendTime(params.getSendTime());
        } else {
            massMessage.setSendTime(new Date());
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        massMessage.setBizId(userInfo.getBizId());
        massMessage.setCorpId(userInfo.getCorpId());
        massMessage.setAppIds(SPLITTER + Joiner.on((String)SPLITTER).join(params.getAppIds()) + SPLITTER);
        massMessage.setMaterialType(params.getMaterialType());
        massMessage.setMaterialId(params.getMaterialId());
        massMessage.setSendStatus(SendStatus.WAITTING_SEND.getValue());
        massMessage.setUpdatorId(params.getOperatorId());
        massMessage.setUpdateTime(new Date());
    }

    private void dealWechatCondition(MassMessageSendCondition params, boolean consume) {
        log.info("deal wechat condition with params={}, consumer={}", (Object)params, (Object)consume);
        Map<String, Integer> appId2FansCountMap = this.fansTagService.statFansCount(params.getAppIds(), params.getTagIds(), params.getSendScope(), params.getTagRelation(), params.getAreaInfo(), params.getSex());
        HashMap app2SubtractCount = Maps.newHashMap();
        for (String appId : params.getAppIds()) {
            Integer count = appId2FansCountMap.getOrDefault(appId, 0);
            if (consume && count > 1000000) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6309\u7167\u6807\u7b7e\u7fa4\u53d1\u7684\u7c89\u4e1d\u6570\u4e00\u6b21\u4e0d\u80fd\u8d85\u8fc7100\u4e07");
            }
            if (consume && count < 2) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5fae\u4fe1\u63a5\u53e3\u9650\u5236\u53d1\u9001\u7684\u7c89\u4e1d\u6570\u4e0d\u5f97\u5c11\u4e8e2\u4eba");
            }
            app2SubtractCount.put(appId, count);
        }
        app2SubtractCount.forEach((k, v) -> {
            Date sendDate = params.getSendTime() == null ? new Date() : params.getSendTime();
            int subtractCount = v / 10000;
            if (v % 10000 > 0) {
                ++subtractCount;
            }
            this.dealInvocationCount((String)k, sendDate, consume ? subtractCount : -subtractCount);
        });
    }

    @Override
    public MassMessageRespDto detail(MassMessgaeReqDto params) {
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"ID is null");
        List<MassMessageRespDto> list = this.list(params);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    private void dealInvocationCount(String appId, Date sendTime, int subtractCount) {
        Preconditions.checkArgument((subtractCount <= 100 ? 1 : 0) != 0, (Object)"\u6bcf\u5929\u7fa4\u53d1\u7684\u7c89\u4e1d\u6570\u4e0d\u80fd\u591a\u4e8e100\u4e07");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String bizKey = appId + sdf.format(sendTime);
        String suffixKey = "_mass_msg_rest_send_count";
        this.redisLock.lock(bizKey, 10, 60L, 500L);
        String redisKey = this.redisKeyPrefix + bizKey + suffixKey;
        Object obj = this.redisTemplate.opsForValue().get((Object)redisKey);
        Date date = DateUtil.getEndOfDay((Date)sendTime);
        int restCount = 100;
        if (obj == null) {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)(restCount -= subtractCount), (long)(DateUtil.getMinuteDiff((Date)new Date(), (Date)date) + 1), TimeUnit.MINUTES);
        } else {
            restCount = (Integer)obj;
            if (subtractCount > restCount) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, sdf.format(sendTime) + "\u7fa4\u53d1\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
            }
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)(restCount -= subtractCount), (long)(DateUtil.getMinuteDiff((Date)new Date(), (Date)date) + 1), TimeUnit.MINUTES);
        }
        log.info("\u516c\u4f17\u53f7:{}, \u65e5\u671f:{}, \u672c\u6b21\u6d88\u8017\u63a5\u53e3\u8c03\u7528\u6b21\u6570:{}, \u5f53\u5929\u5269\u4f59\u63a5\u53e3\u8c03\u7528\u6b21\u6570:{}", new Object[]{appId, sendTime, subtractCount, restCount});
        this.redisLock.unlock(bizKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(MassMessageSendCondition params) {
        log.info("del mass message with params={}", (Object)params);
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId is null");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id is null");
        OfficialAccountMassMessage massMessage = (OfficialAccountMassMessage)this.massMessageMapper.selectByPrimaryKey((Object)params.getId());
        if (null == massMessage) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        ArrayList appIds = Lists.newArrayList((Iterable)Splitter.on((String)SPLITTER).omitEmptyStrings().splitToList((CharSequence)massMessage.getAppIds()));
        this.checkDataAccess(params.getOperatorId(), appIds);
        if (massMessage.getSendStatus().equals(SendStatus.WAITTING_SEND.getValue())) {
            MassMessageSendCondition sendCondition = (MassMessageSendCondition)JSONObject.parseObject((String)massMessage.getSendCondition(), MassMessageSendCondition.class);
            this.dealWechatCondition(sendCondition, false);
            this.massMessageMapper.logicalDel(massMessage.getId());
        } else if (massMessage.getSendStatus().equals(SendStatus.SEND_SUCCESS.getValue())) {
            this.massMessageMapper.logicalDel(massMessage.getId());
            Executors.newSingleThreadExecutor().submit(() -> {
                for (String appId : appIds) {
                    String token = this.officialTokenService.getOfficialAccessToken(appId);
                    List msgIds = this.massMessageDetailMapper.getByMassMsgIdAndAppIds(massMessage.getId(), appIds);
                    this.massMessageDetailMapper.delByMassMsgIdAndAppIds(massMessage.getId(), appIds);
                    for (String msgId : msgIds) {
                        DelMassMsg delMassMsg = new DelMassMsg();
                        delMassMsg.setMsgId(msgId);
                        this.wxMassMsgAPI.deleteMsg(token, delMassMsg);
                    }
                }
            });
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u4e2d\u4e0d\u5141\u8bb8\u5220\u9664");
        }
    }

    private void checkDataAccess(Long operatorId, List<String> appIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(appIds), (Object)"\u516c\u4f17\u53f7\u4e3a\u7a7a");
        List<String> permitAppIds = this.operatorService.getPermitAppIds(operatorId, UserIdentity.MANAGER.getValue());
        appIds.retainAll(permitAppIds);
        if (CollectionUtils.isEmpty(appIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u516c\u4f17\u53f7\u64cd\u4f5c\u6743\u9650");
        }
    }

    @Override
    public List<MassMsgStatRespDto> statistic(MassMessageSendCondition params) {
        log.info("mass message statistic with params={}", (Object)params);
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId is null");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id is null");
        OfficialAccountMassMessage massMessage = (OfficialAccountMassMessage)this.massMessageMapper.selectByPrimaryKey((Object)params.getId());
        if (null == massMessage) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        ArrayList appIds = Lists.newArrayList((Iterable)Splitter.on((String)SPLITTER).omitEmptyStrings().splitToList((CharSequence)massMessage.getAppIds()));
        this.checkDataAccess(params.getOperatorId(), appIds);
        List details = this.massMessageDetailMapper.queryByMassMsgId(params.getId());
        Map<String, OfficialAccount> appMap = this.officialAccountService.queryByAppIds(appIds);
        Map<Object, Object> countMap = Maps.newHashMap();
        if (Lists.newArrayList((Object[])new String[]{SendStatus.WAITTING_SEND.getValue(), SendStatus.SENDING.getValue()}).contains(massMessage.getSendStatus())) {
            MassMessageSendCondition sendCondition = (MassMessageSendCondition)JSONObject.parseObject((String)massMessage.getSendCondition(), MassMessageSendCondition.class);
            countMap = this.fansTagService.statFansCount(sendCondition.getAppIds(), sendCondition.getTagIds(), sendCondition.getSendScope(), sendCondition.getTagRelation(), sendCondition.getAreaInfo(), sendCondition.getSex());
            return this.newMassMsgStatRespDtoList(details, appMap, massMessage, countMap, true);
        }
        return this.newMassMsgStatRespDtoList(details, appMap, massMessage, countMap, false);
    }

    private List<MassMsgStatRespDto> newMassMsgStatRespDtoList(List<OfficialAccountMassMessageDetail> details, Map<String, OfficialAccount> appMap, OfficialAccountMassMessage massMessage, Map<String, Integer> localCountMap, boolean needLocalCount) {
        Map<String, List<OfficialAccountMassMessageDetail>> app2DetailMap = details.stream().collect(Collectors.groupingBy(OfficialAccountMassMessageDetail::getAppId));
        ArrayList result = Lists.newArrayList();
        for (String appId : appMap.keySet()) {
            OfficialAccount app = appMap.get(appId);
            MassMsgStatRespDto dto = new MassMsgStatRespDto();
            if (app != null) {
                dto.setApp(new StrIdAndNameDto(app.getAppId(), app.getNickName()));
            }
            List<OfficialAccountMassMessageDetail> appMassMsgDetails = app2DetailMap.get(appId);
            int sendTotalNum = 0;
            int sendSuccessNum = 0;
            if (CollectionUtils.isNotEmpty(appMassMsgDetails)) {
                int success = 0;
                int failed = 0;
                int sending = 0;
                for (OfficialAccountMassMessageDetail detail : appMassMsgDetails) {
                    sendTotalNum += detail.getTotalCount().intValue();
                    sendSuccessNum += detail.getSuccessCount().intValue();
                    if (WxMsgStatus.SENDING.name().equals(detail.getSendStatus())) {
                        ++sending;
                        continue;
                    }
                    if (WxMsgStatus.SEND_FAIL.name().equals(detail.getSendStatus())) {
                        ++failed;
                        continue;
                    }
                    if (WxMsgStatus.DELETE.name().equals(detail.getSendStatus())) {
                        ++failed;
                        continue;
                    }
                    if (!WxMsgStatus.SEND_SUCCESS.name().equals(detail.getSendStatus())) continue;
                    ++success;
                }
                log.info("appId:{}, success:{}, failed:{}, sending:{}", new Object[]{appId, success, failed, sending});
                if (sending > 0) {
                    dto.setSendStatus(new StrIdAndNameDto(SendStatus.SENDING.getValue(), SendStatus.SENDING.getDesc()));
                } else if (failed > 0) {
                    dto.setSendStatus(new StrIdAndNameDto(SendStatus.SEND_FAIL.getValue(), SendStatus.SEND_FAIL.getDesc()));
                } else {
                    dto.setSendStatus(new StrIdAndNameDto(SendStatus.SEND_SUCCESS.getValue(), SendStatus.SEND_SUCCESS.getDesc()));
                }
            } else {
                dto.setSendStatus(new StrIdAndNameDto(SendStatus.WAITTING_SEND.getValue(), SendStatus.WAITTING_SEND.getDesc()));
            }
            if (needLocalCount) {
                dto.setSendTotalNum(localCountMap.getOrDefault(appId, 0));
            } else {
                dto.setSendTotalNum(sendTotalNum);
            }
            dto.setSendSuccessNum(sendSuccessNum);
            dto.setSendTime(massMessage.getSendTime());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void massMessageEventCallback(MassSendJobFinishEvent event) {
        log.info("send mass message complete, callback from wechat with params={}", (Object)event);
        String toUserName = event.getToUserName();
        OfficialAccount officialAccount = this.officialAccountService.queryByUserName(toUserName);
        if (null == officialAccount) {
            log.warn("valid official account not found, event={}", (Object)event);
            return;
        }
        OfficialAccountMassMessageDetail detail = this.massMessageDetailMapper.getByMsgId(officialAccount.getAppId(), event.getMsgId());
        if (detail == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672c\u5730\u6d88\u606f\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        detail.setResultContent(JSONObject.toJSONString((Object)event));
        detail.setUpdateTime(new Date());
        if (event.getStatus().equalsIgnoreCase(SUCCESS_STATUS)) {
            detail.setTotalCount(event.getTotalCount());
            detail.setSuccessCount(event.getSentCount());
            detail.setFailCount(event.getErrorCount());
            detail.setSendStatus(SendStatus.SEND_SUCCESS.getDesc());
        } else {
            detail.setSuccessCount(event.getSentCount());
            detail.setFailCount(event.getErrorCount());
            detail.setSendStatus(SendStatus.SEND_FAIL.getDesc());
        }
        if (event.getStatus().toLowerCase().matches("err\\(\\d+\\)")) {
            String desc = MassMsgErrStatus.getDesc(event.getStatus().toLowerCase(Locale.getDefault()));
            if (StringUtils.isBlank((CharSequence)desc)) {
                desc = "unknown error";
            }
            log.warn("send mass msg error, status:{}, desc:{}", (Object)event.getStatus(), (Object)desc);
        }
        this.massMessageDetailMapper.updateByPrimaryKeySelective((Object)detail);
    }

    @Override
    public List<FansListRespDto> fansPreview(MassMessageSendCondition params) {
        log.info("fans preview with massMsgSendCondition={}", (Object)params);
        params.baseValidate();
        this.checkDataAccess(params.getOperatorId(), params.getAppIds());
        PageDto pageDto = params.getPageDto();
        Map<String, List<String>> appOpenIds = this.fansTagService.getOpenIdsByCondition(params.getAppIds(), params.getTagIds(), params.getTagRelation(), params.getSendScope(), params.getAreaInfo(), params.getSex(), pageDto);
        ArrayList fansIds = Lists.newArrayList();
        appOpenIds.forEach((appId, openIds) -> {
            for (String openId : openIds) {
                fansIds.add(MD5Utils.MD5((String)(appId + "_" + openId)));
            }
        });
        if (CollectionUtils.isEmpty((Collection)fansIds)) {
            this.resetPage(pageDto);
            return Collections.emptyList();
        }
        List fansList = this.officialAccountFansMapper.selectByUniqueIds((Collection)fansIds);
        Map<String, OfficialAccount> appMap = this.officialAccountService.queryByAppIds(params.getAppIds());
        Map<String, List<WeworkTagDto>> fansId2TagMap = this.fansTagService.queryFansTagInfo(fansIds);
        ArrayList result = Lists.newArrayList();
        fansList.forEach(fans -> result.add(OfficialAccountFansServiceImpl.buildFansRespInfo(fans, fansId2TagMap, appMap, Maps.newHashMap())));
        return result;
    }

    private void validate(OfficialMaterial material, String materialType) {
        MaterialType mType = MaterialType.getByValue(materialType);
        Preconditions.checkArgument((mType != null ? 1 : 0) != 0, (Object)"materialType invalid");
        switch (mType) {
            case TEXT: {
                Preconditions.checkArgument((boolean)material.getmType().equals("text"));
                break;
            }
            case VIDEO: {
                Preconditions.checkArgument((boolean)material.getmType().equals("video"));
                break;
            }
            case VOICE: {
                Preconditions.checkArgument((boolean)material.getmType().equals("voice"));
                break;
            }
            case IMAGE: {
                Preconditions.checkArgument((boolean)material.getmType().equals("image"));
                break;
            }
            case NEWS: {
                Preconditions.checkArgument((boolean)material.getmType().equals("news"));
                break;
            }
            default: {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u652f\u6301\u7fa4\u53d1\u7684\u6d88\u606f\u7c7b\u578b");
            }
        }
    }

    private void checkManageTime(Date sendTime) {
        try {
            String timeStr;
            if (sendTime == null) {
                sendTime = new Date();
            }
            boolean isValid = true;
            String startTimeBizKey = ":OfficeAccount:startWechatServiceTime";
            String endTimeBizKey = ":OfficeAccount:endWechatServiceTime";
            ValueOperations valueOperations = this.redisTemplate.opsForValue();
            Object startObj = valueOperations.get((Object)(this.redisKeyPrefix + startTimeBizKey));
            Object endObj = valueOperations.get((Object)(this.redisKeyPrefix + endTimeBizKey));
            SimpleDateFormat formatSdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            SimpleDateFormat parseSdf = new SimpleDateFormat("yyyy-MM-ddHH:mm:ss", Locale.getDefault());
            if (startObj != null) {
                String startTimeStr = (String)startObj;
                timeStr = formatSdf.format(sendTime) + startTimeStr;
                Date startManageTime = parseSdf.parse(timeStr);
                if (sendTime.before(startManageTime)) {
                    isValid = false;
                }
            }
            if (endObj != null) {
                String endTimeStr = (String)endObj;
                timeStr = formatSdf.format(sendTime) + endTimeStr;
                Date endManageTime = parseSdf.parse(timeStr);
                if (sendTime.after(endManageTime)) {
                    isValid = false;
                }
            }
            if (!isValid) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d1\u9001\u65f6\u95f4\u4e0d\u5728\u8fd0\u8425\u65f6\u95f4\u5185");
            }
        }
        catch (ParseException e) {
            log.error("\u53c2\u6570\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
    }
}

