/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.dto.req;

import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.Article;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.ImageMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MenuItem;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MenuMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MiniProgramMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MpNewsMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MpVideoMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MusicMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.NewsMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VideoMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VoiceMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.WxCardMsg;
import java.io.Serializable;
import java.util.List;

public class SendCustomMsgReqDto
implements Serializable {
    private static final long serialVersionUID = -8107127211552951305L;
    private Long bizId;
    private String corpId;
    private String openId;
    private String appId;
    private long userId;
    private Long materialId;
    private String msgType;
    private MsgData msgData;
    private boolean cancelSend;

    public BaseRespMsg toBaseRespMsg() {
        Object msg = null;
        if (this.msgType == null || this.msgType.isEmpty()) {
            return null;
        }
        msg = "text".equalsIgnoreCase(this.msgType) ? this.toTextMsg() : ("image".equalsIgnoreCase(this.msgType) ? this.toImageMsg() : ("voice".equalsIgnoreCase(this.msgType) ? this.toVoiceMsg() : ("video".equalsIgnoreCase(this.msgType) ? this.toVideoMsg() : ("music".equalsIgnoreCase(this.msgType) ? this.toMusicMsg() : ("mpnews".equalsIgnoreCase(this.msgType) ? this.toMpNewsMsg() : ("news".equalsIgnoreCase(this.msgType) ? this.toNewsMsg() : ("msgmenu".equalsIgnoreCase(this.msgType) ? this.toMenuMsg() : ("wxcard".equalsIgnoreCase(this.msgType) ? this.toWxCardMsg() : ("miniprogrampage".equalsIgnoreCase(this.msgType) ? this.toMiniProgramMsg() : ("mpvideo".equalsIgnoreCase(this.msgType) ? this.toMpVideoMsg() : null))))))))));
        if (msg != null) {
            this.setBase((BaseRespMsg)msg);
        }
        return msg;
    }

    public TextMsg toTextMsg() {
        TextMsg msg = new TextMsg();
        if (this.msgData != null) {
            msg.setContent(this.msgData.getContent());
        }
        return msg;
    }

    public ImageMsg toImageMsg() {
        ImageMsg msg = new ImageMsg();
        if (this.msgData != null) {
            msg.setMediaId(this.msgData.getMediaId());
        }
        return msg;
    }

    public VoiceMsg toVoiceMsg() {
        VoiceMsg msg = new VoiceMsg();
        if (this.msgData != null) {
            msg.setMediaId(this.msgData.getMediaId());
        }
        return msg;
    }

    public VideoMsg toVideoMsg() {
        VideoMsg msg = new VideoMsg();
        if (this.msgData != null) {
            msg.setMediaId(this.msgData.getMediaId());
            msg.setThumbMediaId(this.msgData.getThumbMediaId());
            msg.setTitle(this.msgData.getTitle());
            msg.setDescription(this.msgData.getDescription());
        }
        return msg;
    }

    public MpVideoMsg toMpVideoMsg() {
        MpVideoMsg msg = new MpVideoMsg();
        if (this.msgData != null) {
            msg.setMediaId(this.msgData.getMediaId());
        }
        return msg;
    }

    public MusicMsg toMusicMsg() {
        MusicMsg msg = new MusicMsg();
        if (this.msgData != null) {
            msg.setTitle(this.msgData.getTitle());
            msg.setDescription(this.msgData.getDescription());
            msg.setMusicUrl(this.msgData.getMusicUrl());
            msg.setHQMusicUrl(this.msgData.getHqMusicUrl());
            msg.setThumbMediaId(this.msgData.getThumbMediaId());
        }
        return msg;
    }

    public MpNewsMsg toMpNewsMsg() {
        MpNewsMsg msg = new MpNewsMsg();
        if (this.msgData != null) {
            msg.setMediaId(this.msgData.getMediaId());
        }
        return msg;
    }

    public NewsMsg toNewsMsg() {
        List<Article> list;
        NewsMsg msg = new NewsMsg();
        if (this.msgData != null && (list = this.msgData.getArticles()) != null && list.size() > 0) {
            list.forEach(it -> msg.add(it));
        }
        return msg;
    }

    public MenuMsg toMenuMsg() {
        MenuMsg msg = new MenuMsg();
        if (this.msgData != null) {
            msg.setHeadContent(this.msgData.getHeadContent());
            List<MenuItem> list = this.msgData.getList();
            if (list != null && list.size() > 0) {
                list.forEach(it -> msg.addItem(it));
            }
            msg.setTailContent(this.msgData.getTailContent());
        }
        return msg;
    }

    public WxCardMsg toWxCardMsg() {
        WxCardMsg msg = new WxCardMsg();
        if (this.msgData != null) {
            msg.setCardId(this.msgData.getCardId());
            msg.setCardExt(this.msgData.getCardExt());
        }
        return msg;
    }

    public MiniProgramMsg toMiniProgramMsg() {
        MiniProgramMsg msg = new MiniProgramMsg();
        if (this.msgData != null) {
            msg.setTitle(this.msgData.getTitle());
            msg.setAppId(this.msgData.getAppId());
            msg.setPagePath(this.msgData.getPagePath());
            msg.setThumbMediaId(this.msgData.getThumbMediaId());
        }
        return msg;
    }

    public void setBase(BaseRespMsg msg) {
        msg.setToUserName(this.openId);
        msg.setFromUserName(this.appId);
        msg.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getAppId() {
        return this.appId;
    }

    public long getUserId() {
        return this.userId;
    }

    public Long getMaterialId() {
        return this.materialId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public MsgData getMsgData() {
        return this.msgData;
    }

    public boolean isCancelSend() {
        return this.cancelSend;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMsgData(MsgData msgData) {
        this.msgData = msgData;
    }

    public void setCancelSend(boolean cancelSend) {
        this.cancelSend = cancelSend;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendCustomMsgReqDto)) {
            return false;
        }
        SendCustomMsgReqDto other = (SendCustomMsgReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        if (this.isCancelSend() != other.isCancelSend()) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$materialId = this.getMaterialId();
        Long other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !((Object)this$materialId).equals(other$materialId)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        MsgData this$msgData = this.getMsgData();
        MsgData other$msgData = other.getMsgData();
        return !(this$msgData == null ? other$msgData != null : !((Object)this$msgData).equals(other$msgData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendCustomMsgReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $userId = this.getUserId();
        result = result * 59 + (int)($userId >>> 32 ^ $userId);
        result = result * 59 + (this.isCancelSend() ? 79 : 97);
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : ((Object)$materialId).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        MsgData $msgData = this.getMsgData();
        result = result * 59 + ($msgData == null ? 43 : ((Object)$msgData).hashCode());
        return result;
    }

    public String toString() {
        return "SendCustomMsgReqDto(bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", openId=" + this.getOpenId() + ", appId=" + this.getAppId() + ", userId=" + this.getUserId() + ", materialId=" + this.getMaterialId() + ", msgType=" + this.getMsgType() + ", msgData=" + this.getMsgData() + ", cancelSend=" + this.isCancelSend() + ")";
    }
}

