/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.material.dto.NewsMaterialDto;
import cn.kinyun.scrm.weixin.material.dto.SimpleUserInfoDto;
import cn.kinyun.scrm.weixin.material.dto.req.AddNewsMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.DelMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialListReq;
import cn.kinyun.scrm.weixin.material.dto.req.ModNewsMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.resp.ChildNewsMaterialResp;
import cn.kinyun.scrm.weixin.material.dto.resp.NewsMaterialListResp;
import cn.kinyun.scrm.weixin.material.dto.resp.NewsMaterialResp;
import cn.kinyun.scrm.weixin.material.dto.resp.OfficialNewsInfo;
import cn.kinyun.scrm.weixin.material.enums.MaterialFileLimit;
import cn.kinyun.scrm.weixin.material.enums.MaterialType;
import cn.kinyun.scrm.weixin.material.enums.PlatformType;
import cn.kinyun.scrm.weixin.material.service.NewsMaterialService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialNewsMapper;
import com.kuaike.scrm.dal.official.material.dto.OfficialSyncNewsInfoDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialGroup;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialRecycle;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialGroupMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialRecycleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsMaterialServiceImpl
implements NewsMaterialService {
    private static final Logger log = LoggerFactory.getLogger(NewsMaterialServiceImpl.class);
    private static final String TITLE_SPLIT = ";";
    @Resource
    private OfficialMaterialMapper materialMapper;
    @Resource
    private OfficialMaterialGroupMapper materialGroupMapper;
    @Resource
    private OfficialMaterialFileMapper materialFileMapper;
    @Resource
    private OfficialMaterialRecycleMapper materialRecycleMapper;
    @Autowired
    private NodeService nodeService;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private OfficialAccountMaterialNewsMapper officialAccountMaterialNewsMapper;
    @Autowired
    private UserInfoService userInfoService;

    @Override
    public List<NewsMaterialListResp> list(MaterialListReq params, Long operatorId) {
        log.info("list material with params={},operatorId={}", (Object)params, (Object)operatorId);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List materialList = this.materialMapper.queryNews(params.getTitle(), params.getUserId(), params.getNodeId(), params.getGroupId(), Integer.valueOf(params.getSingleNews()), userInfo.getBizId(), params.getPageDto());
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(materialList.size()));
            params.getPageDto().setCount(Integer.valueOf(this.materialMapper.countNews(params.getTitle(), params.getUserId(), params.getNodeId(), params.getGroupId(), Integer.valueOf(params.getSingleNews()), userInfo.getBizId(), params.getPageDto())));
        }
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Lists.newArrayList();
        }
        HashSet userIds = Sets.newHashSet();
        HashSet groupIds = Sets.newHashSet();
        for (OfficialMaterial material : materialList) {
            userIds.add(material.getCreatorId());
            userIds.add(material.getModifierId());
            groupIds.add(material.getGroupId());
        }
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        Map<Long, String> groupMap = this.materialGroupMapper.queryListByIds((List)Lists.newArrayList((Iterable)groupIds)).stream().collect(Collectors.toMap(OfficialMaterialGroup::getId, OfficialMaterialGroup::getGroupName));
        Map nodeMap = this.nodeService.getNodeMap(userInfo.getBizId());
        groupMap.put(-1L, "\u672a\u5206\u7ec4");
        ArrayList result = Lists.newArrayList();
        for (OfficialMaterial material : materialList) {
            NewsMaterialListResp resp = this.buildListResp(material);
            Node node = (Node)nodeMap.get(material.getNodeId());
            if (node != null) {
                resp.setNodeName(node.getName());
            }
            resp.setGroupName(groupMap.get(material.getGroupId()));
            UserInfoRespDto creator = userMap.get(material.getCreatorId());
            UserInfoRespDto modifier = userMap.get(material.getModifierId());
            if (creator != null) {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), creator.getUsername(), creator.getUsername()));
            } else {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), null, null));
            }
            if (modifier != null) {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), modifier.getUsername(), modifier.getUsername()));
            } else {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), null, null));
            }
            result.add(resp);
        }
        return result;
    }

    private NewsMaterialListResp buildListResp(OfficialMaterial material) {
        NewsMaterialListResp resp = new NewsMaterialListResp();
        resp.setId(material.getId());
        resp.setTitles(Lists.newArrayList((Object[])material.getTitle().split(TITLE_SPLIT)));
        resp.setCovers(Lists.newArrayList((Object[])material.getCover().split(TITLE_SPLIT)));
        resp.setGroupId(material.getGroupId());
        resp.setNodeId(material.getNodeId());
        resp.setPlatformType(material.getPlatformType());
        resp.setCreateTime(material.getCreateTime());
        resp.setUpdateTime(material.getUpdateTime());
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addNews(AddNewsMaterialReq params, Long operatorId) {
        log.info("add news with params ={} operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        this.checkCover(params.getCoverMap());
        this.checkImage(params.getImageMap());
        OfficialMaterial material = new OfficialMaterial();
        this.buildPMaterial(material, params.getTitles(), params.getCovers(), operatorId, params.getNodeId(), params.getGroupId());
        this.materialMapper.insertSelective((Object)material);
        List<OfficialMaterial> list = this.buildChildrenMaterials(material.getId(), params.getNews(), params.getNodeId(), params.getGroupId(), operatorId);
        this.materialMapper.batchInsert(list);
        return material.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modNews(ModNewsMaterialReq params, Long operatorId) {
        log.info("mod news with params ={} operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        this.checkCover(params.getCoverMap());
        this.checkImage(params.getImageMap());
        OfficialMaterial material = this.validateMaterial(params.getId());
        this.buildPMaterial(material, params.getTitles(), params.getCovers(), operatorId, material.getNodeId(), material.getGroupId());
        this.materialMapper.updateByPrimaryKeySelective((Object)material);
        this.materialMapper.delChildNews(material.getId());
        List<OfficialMaterial> list = this.buildChildrenMaterials(material.getId(), params.getNews(), material.getNodeId(), material.getGroupId(), operatorId);
        this.materialMapper.batchInsert(list);
    }

    private OfficialMaterial validateMaterial(Long id) {
        OfficialMaterial material = (OfficialMaterial)this.materialMapper.selectByPrimaryKey((Object)id);
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        if (!material.getmType().equals(MaterialType.NEWS.getType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u975e\u56fe\u6587\u7d20\u6750");
        }
        if (material.getPid() != 0L) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u56fe\u6587\u7d20\u6750\u4e0d\u662f\u591a\u56fe\u6587\u7d20\u6750");
        }
        return material;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delNews(DelMaterialReq params, Long operatorId) {
        log.info("mod news with params ={} operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        OfficialMaterial material = this.validateMaterial(params.getId());
        ArrayList recycleList = Lists.newArrayList();
        OfficialMaterialRecycle recycle = new OfficialMaterialRecycle();
        BeanUtils.copyProperties((Object)material, (Object)recycle);
        recycleList.add(recycle);
        List children = this.materialMapper.getNewsDetail(material.getId());
        recycleList.addAll(children.stream().map(a -> {
            OfficialMaterialRecycle r = new OfficialMaterialRecycle();
            BeanUtils.copyProperties((Object)a, (Object)r);
            return r;
        }).collect(Collectors.toList()));
        this.materialMapper.deleteByPrimaryKey((Object)material.getId());
        this.materialMapper.delChildNews(material.getId());
        this.materialRecycleMapper.batchInsert((List)recycleList);
    }

    @Override
    public NewsMaterialResp detail(Long materialId, Long operatorId) {
        Preconditions.checkArgument((materialId != null ? 1 : 0) != 0, (Object)"materialId is null!");
        OfficialMaterial material = this.validateMaterial(materialId);
        NewsMaterialResp resp = new NewsMaterialResp();
        HashSet userIds = Sets.newHashSet();
        userIds.add(material.getCreatorId());
        userIds.add(material.getModifierId());
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        UserInfoRespDto creator = userMap.get(material.getCreatorId());
        UserInfoRespDto modifier = userMap.get(material.getModifierId());
        if (creator != null) {
            resp.setCreator(new IdAndNameDto(material.getCreatorId(), creator.getUsername()));
        } else {
            resp.setCreator(new IdAndNameDto(material.getCreatorId(), null));
        }
        resp.setCreateTime(material.getCreateTime());
        resp.setUpdateTime(material.getUpdateTime());
        if (modifier != null) {
            resp.setModifier(new IdAndNameDto(material.getModifierId(), modifier.getUsername()));
        } else {
            resp.setModifier(new IdAndNameDto(material.getModifierId(), null));
        }
        resp.setGroupId(material.getGroupId());
        if (material.getGroupId() == -1L) {
            resp.setGroupName("\u672a\u5206\u7ec4");
        } else {
            OfficialMaterialGroup group = (OfficialMaterialGroup)this.materialGroupMapper.selectByPrimaryKey((Object)material.getGroupId());
            if (group != null) {
                resp.setGroupName(group.getGroupName());
            }
        }
        List children = this.materialMapper.getNewsDetail(material.getId());
        resp.setId(materialId);
        resp.setNews(Lists.newArrayList());
        for (OfficialMaterial m : children) {
            resp.getNews().add(this.buildMaterialDto(m));
        }
        return resp;
    }

    @Override
    public NewsMaterialDto preview(Long materialId, int num, Long operatorId) {
        Preconditions.checkArgument((materialId != null ? 1 : 0) != 0, (Object)"materialId is null!");
        this.validateMaterial(materialId);
        OfficialMaterial child = this.materialMapper.getByNum(materialId, Integer.valueOf(num));
        if (child == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        return this.buildMaterialDto(child);
    }

    @Override
    public List<ChildNewsMaterialResp> childList(MaterialListReq params, Long operatorId) {
        PageDto page;
        boolean needPage;
        log.info("query child news with params ={} operatorId={}", (Object)params, (Object)operatorId);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Set<Long> fullOrgIds = this.getFullOrgIds(currentUser);
        if (CollectionUtils.isEmpty(fullOrgIds)) {
            return Collections.emptyList();
        }
        Set<Object> matOrgIds = Sets.newHashSet(fullOrgIds);
        if (params.getNodeId() != null) {
            if (!matOrgIds.contains(params.getNodeId())) {
                return Collections.emptyList();
            }
            matOrgIds = Collections.singleton(params.getNodeId());
        }
        boolean bl = needPage = (page = params.getPageDto()) != null;
        if (needPage) {
            PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize(), (boolean)true);
        }
        List materialList = this.materialMapper.queryChildNews(params.getTitle(), params.getGroupId(), (Collection)matOrgIds);
        if (needPage) {
            PageInfo pageInfo = new PageInfo(materialList);
            page.setCount(Integer.valueOf((int)pageInfo.getTotal()));
            page.setCurPageCount(Integer.valueOf(pageInfo.getSize()));
        }
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Collections.emptyList();
        }
        List matIds = materialList.stream().map(OfficialMaterial::getId).collect(Collectors.toList());
        List groupIds = materialList.stream().map(OfficialMaterial::getGroupId).collect(Collectors.toList());
        List officialAccounts = this.officialAccountMapper.queryServiceAccountByOrgs(currentUser.getBizId(), fullOrgIds);
        List appIds = officialAccounts.stream().map(OfficialAccount::getAppId).collect(Collectors.toList());
        HashMap matId2SyncAppIdsMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(appIds)) {
            List syncNewsInfo = this.officialAccountMaterialNewsMapper.querySyncMatAppList(appIds, matIds);
            matId2SyncAppIdsMap.putAll(syncNewsInfo.stream().collect(Collectors.groupingBy(OfficialSyncNewsInfoDto::getMatId, Collectors.toMap(OfficialSyncNewsInfoDto::getAppId, OfficialSyncNewsInfoDto::getId, (o, n) -> n, HashMap::new))));
        }
        Map<Long, String> groupMap = this.materialGroupMapper.queryListByIds((List)Lists.newArrayList(groupIds)).stream().collect(Collectors.toMap(OfficialMaterialGroup::getId, OfficialMaterialGroup::getGroupName));
        groupMap.put(-1L, "\u672a\u5206\u7ec4");
        ArrayList result = Lists.newArrayList();
        materialList.forEach(a -> result.add(this.newSingleNewsMaterialResp((OfficialMaterial)a, officialAccounts, matId2SyncAppIdsMap, groupMap, currentUser)));
        return result;
    }

    private ChildNewsMaterialResp newSingleNewsMaterialResp(OfficialMaterial material, List<OfficialAccount> officialAccounts, Map<Long, Map<String, Long>> matId2SyncAppIdsMap, Map<Long, String> groupMap, CurrentUserInfo currentUser) {
        ChildNewsMaterialResp resp = new ChildNewsMaterialResp();
        resp.setId(material.getId());
        resp.setCover(material.getCover());
        resp.setTitle(material.getTitle());
        resp.setGroupId(material.getGroupId());
        resp.setGroupName(groupMap.get(material.getGroupId()));
        resp.setUpdateTime(material.getUpdateTime());
        resp.setDigest(material.getDigest());
        resp.setAppNewsInfo(Lists.newArrayList());
        resp.setMaterialType(MaterialType.NEWS.getType());
        Long manageNodeId = null;
        UserRoleRespDto curRole = currentUser.getCurRole();
        if (curRole != null && CollectionUtils.isNotEmpty((Collection)curRole.getManageNodes())) {
            List manageNodeList = curRole.getManageNodes();
            manageNodeId = ((Node)manageNodeList.get(manageNodeList.size() - 1)).getId();
        }
        LinkedList syncAppNewsInfo = Lists.newLinkedList();
        LinkedList unsyncAppNewsInfo = Lists.newLinkedList();
        List<OfficialNewsInfo> appNewsInfo = resp.getAppNewsInfo();
        OfficialNewsInfo syncHead = null;
        OfficialNewsInfo syncSecond = null;
        OfficialNewsInfo unsyncHead = null;
        OfficialNewsInfo unsyncSecond = null;
        for (OfficialAccount officialAccount : officialAccounts) {
            OfficialNewsInfo officialNewsInfo = new OfficialNewsInfo();
            officialNewsInfo.setAppId(officialAccount.getAppId());
            officialNewsInfo.setAppName(officialAccount.getNickName());
            Map<String, Long> appId2IdMap = matId2SyncAppIdsMap.getOrDefault(material.getId(), Maps.newHashMap());
            Long appSyncNewsId = appId2IdMap.get(officialAccount.getAppId());
            Long appNodeId = officialAccount.getNodeId();
            if (appSyncNewsId != null) {
                officialNewsInfo.setIsSync(1);
                officialNewsInfo.setAppSyncNewsId(appSyncNewsId);
                if (appNodeId.equals(currentUser.getUserNodeId())) {
                    syncHead = officialNewsInfo;
                    continue;
                }
                if (appNodeId.equals(manageNodeId)) {
                    syncSecond = officialNewsInfo;
                    continue;
                }
                syncAppNewsInfo.add(officialNewsInfo);
                continue;
            }
            if (appNodeId.equals(currentUser.getUserNodeId())) {
                unsyncHead = officialNewsInfo;
                continue;
            }
            if (appNodeId.equals(manageNodeId)) {
                unsyncSecond = officialNewsInfo;
                continue;
            }
            unsyncAppNewsInfo.add(officialNewsInfo);
        }
        if (syncSecond != null) {
            syncAppNewsInfo.addFirst(syncSecond);
        }
        if (syncHead != null) {
            syncAppNewsInfo.addFirst(syncHead);
        }
        if (unsyncSecond != null) {
            unsyncAppNewsInfo.addFirst(unsyncSecond);
        }
        if (unsyncHead != null) {
            unsyncAppNewsInfo.addFirst(unsyncHead);
        }
        appNewsInfo.addAll(syncAppNewsInfo);
        appNewsInfo.addAll(unsyncAppNewsInfo);
        return resp;
    }

    private Set<Long> getFullOrgIds(CurrentUserInfo currentUser) {
        Long userNodeId;
        Map nodeMap;
        Node node;
        HashSet fullNodeIds = Sets.newHashSet();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        UserRoleRespDto curRole = currentUser.getCurRole();
        if (curRole != null && CollectionUtils.isNotEmpty((Collection)curRole.getManageNodes())) {
            Set nodeIds = curRole.getManageNodes().stream().map(Node::getId).collect(Collectors.toSet());
            fullNodeIds.addAll(this.nodeService.getPosterityIds(nodeIds, userInfo.getBizId()));
        }
        if ((node = (Node)(nodeMap = this.nodeService.getNodeMap(userInfo.getBizId())).get(userNodeId = currentUser.getUserNodeId())) != null) {
            fullNodeIds.addAll(node.getIds());
        }
        HashSet fullOrgIds = Sets.newHashSet();
        for (Long nodeId : fullNodeIds) {
            Node fNode = (Node)nodeMap.get(nodeId);
            if (fNode == null || fNode.getType() != 1L) continue;
            fullOrgIds.add(fNode.getId());
        }
        return fullOrgIds;
    }

    private NewsMaterialDto buildMaterialDto(OfficialMaterial material) {
        NewsMaterialDto dto = new NewsMaterialDto();
        dto.setId(material.getId());
        dto.setTitle(material.getTitle());
        dto.setCover(material.getCover());
        dto.setAuthor(material.getAuthor());
        dto.setDigest(material.getDigest());
        dto.setContent(material.getContent());
        return dto;
    }

    private void buildPMaterial(OfficialMaterial material, List<String> titles, List<String> covers, Long operatorId, Long nodeId, Long groupId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (material.getId() == null) {
            material.setCreatorId(operatorId);
            material.setModifierId(operatorId);
        } else {
            material.setModifierId(operatorId);
        }
        material.setBizId(userInfo.getBizId());
        material.setCorpId(userInfo.getCorpId());
        material.setTitle(StringUtils.join(titles, (String)TITLE_SPLIT));
        material.setCover(StringUtils.join(covers, (String)TITLE_SPLIT));
        material.setPlatformType(Integer.valueOf(PlatformType.OFFICAL_ACCOUNT.getType() | PlatformType.WECHAT_MOMENTS.getType()));
        material.setmType(MaterialType.NEWS.getType());
        material.setNodeId(nodeId);
        material.setGroupId(groupId);
        material.setUpdateTime(new Date());
        material.setNum(Integer.valueOf(titles.size()));
    }

    private List<OfficialMaterial> buildChildrenMaterials(Long pid, List<NewsMaterialDto> dtos, Long nodeId, Long groupId, Long operatorId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (NewsMaterialDto dto : dtos) {
            OfficialMaterial material = new OfficialMaterial();
            material.setBizId(userInfo.getBizId());
            material.setCorpId(userInfo.getCorpId());
            material.setPid(pid);
            material.setNum(Integer.valueOf(i++));
            material.setPlatformType(Integer.valueOf(PlatformType.OFFICAL_ACCOUNT.getType()));
            material.setmType(MaterialType.NEWS.getType());
            material.setTitle(dto.getTitle());
            material.setCover(dto.getCover());
            material.setContent(dto.getContent());
            material.setAuthor(dto.getAuthor());
            material.setDigest(dto.getDigest());
            material.setUrl("");
            material.setNodeId(nodeId);
            material.setGroupId(groupId);
            material.setCreatorId(operatorId);
            material.setModifierId(operatorId);
            list.add(material);
        }
        return list;
    }

    private void checkCover(Map<String, String> coverMap) {
        if (!MapUtils.isEmpty(coverMap)) {
            Map fileMap = this.materialFileMapper.getListByUrlMd5((List)Lists.newArrayList(coverMap.values())).stream().collect(Collectors.toMap(OfficialMaterialFile::getUrlMd5, Function.identity()));
            for (Map.Entry<String, String> entry : coverMap.entrySet()) {
                String url = entry.getKey();
                String urlMd5 = entry.getValue();
                OfficialMaterialFile file = (OfficialMaterialFile)fileMap.get(urlMd5);
                if (file == null) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u627e\u4e0d\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u7cfb\u7edf", url));
                }
                if (!MaterialFileLimit.OFFICAL_ACCOUNT_THUMB.checkFormat(file.getFileFormat())) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u683c\u5f0f%s", url, MaterialFileLimit.OFFICAL_ACCOUNT_THUMB.getFormat()));
                }
                if (MaterialFileLimit.OFFICAL_ACCOUNT_THUMB.checkSize(file.getFileSize())) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u9650\u5236\u5927\u5c0f%sK", url, MaterialFileLimit.OFFICAL_ACCOUNT_THUMB.getSize()));
            }
        }
    }

    private void checkImage(Map<String, String> imageMap) {
        if (!MapUtils.isEmpty(imageMap)) {
            Map fileMap = this.materialFileMapper.getListByUrlMd5((List)Lists.newArrayList(imageMap.values())).stream().collect(Collectors.toMap(OfficialMaterialFile::getUrlMd5, Function.identity()));
            for (Map.Entry<String, String> entry : imageMap.entrySet()) {
                String url = entry.getKey();
                String urlMd5 = entry.getValue();
                OfficialMaterialFile file = (OfficialMaterialFile)fileMap.get(urlMd5);
                if (file == null) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u627e\u4e0d\u5230\uff0c\u8bf7\u5148\u4e0a\u4f20\u5230\u7cfb\u7edf", url));
                }
                if (!MaterialFileLimit.OFFICAL_ACCOUNT_NEWS.checkFormat(file.getFileFormat())) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u7684\u683c\u5f0f%s", url, MaterialFileLimit.OFFICAL_ACCOUNT_NEWS.getFormat()));
                }
                if (MaterialFileLimit.OFFICAL_ACCOUNT_NEWS.checkSize(file.getFileSize())) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u94fe\u63a5\uff1a%s\u5bf9\u5e94\u7684\u56fe\u7247\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff0c\u9650\u5236\u5927\u5c0f%sK", url, MaterialFileLimit.OFFICAL_ACCOUNT_NEWS.getSize()));
            }
        }
    }
}

