/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.enums;

public enum PlatformType {
    WEIXIN(1, "\u5fae\u4fe1"),
    OFFICAL_ACCOUNT(2, "\u516c\u4f17\u53f7"),
    WECHAT_MOMENTS(4, "\u670b\u53cb\u5708");

    private int type;
    private String desc;

    private PlatformType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static int getPlateform(boolean isWexin, boolean isOffcialAccount) {
        return (isWexin ? PlatformType.WEIXIN.type : 0) + (isOffcialAccount ? PlatformType.OFFICAL_ACCOUNT.type : 0);
    }

    public static int getPlateform(boolean isWexin, boolean isOffcialAccount, boolean isWechatMoments) {
        return (isWexin ? PlatformType.WEIXIN.type : 0) + (isOffcialAccount ? PlatformType.OFFICAL_ACCOUNT.type : 0) + (isWechatMoments ? PlatformType.WECHAT_MOMENTS.type : 0);
    }

    public static int getAllPlatform() {
        int value = 0;
        for (PlatformType type : PlatformType.values()) {
            value |= type.getType();
        }
        return value;
    }
}

