/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.common;

import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.OriginalStatus;
import cn.kinyun.scrm.weixin.material.dto.resp.NewsMaterialResultDto;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.ArticleCheckResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.CopyrightCheckResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.MassSendJobFinishEvent;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.enums.EnumService;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessage;
import com.kuaike.scrm.dal.official.massmsg.entity.OfficialAccountMassMessageDetail;
import com.kuaike.scrm.dal.official.massmsg.mapper.OfficialAccountMassMessageDetailMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class NewsMessageHelper {
    @Resource
    private OfficialAccountMassMessageDetailMapper massMessageDetailMapper;

    public Map<Long, CopyrightCheckResult> getCopyrightCheckResults(Collection<OfficialAccountMassMessage> massMessages) {
        HashMap checkResultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(massMessages)) {
            return checkResultMap;
        }
        List finishedNewsMsg = massMessages.stream().filter(a -> a.getMaterialType().equalsIgnoreCase(MaterialType.NEWS.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(finishedNewsMsg)) {
            List finishedDetails = this.massMessageDetailMapper.queryOneByMassMsgIds(finishedNewsMsg.stream().map(a -> a.getId()).collect(Collectors.toList()));
            for (OfficialAccountMassMessageDetail finishDetail : finishedDetails) {
                String resultContent = finishDetail.getResultContent();
                if (!StringUtils.isNotBlank((CharSequence)resultContent)) continue;
                MassSendJobFinishEvent finishEventDto = (MassSendJobFinishEvent)JSONObject.parseObject((String)resultContent, MassSendJobFinishEvent.class);
                checkResultMap.put(finishDetail.getMassMessageId(), finishEventDto.getCopyrightCheckResult());
            }
        }
        return checkResultMap;
    }

    public List<NewsMaterialResultDto> buildNews(MaterialResultDto material) {
        return this.buildNews(Maps.newHashMap(), material, null);
    }

    public List<NewsMaterialResultDto> buildNews(Map<Long, CopyrightCheckResult> checkResultMap, MaterialResultDto material, OfficialAccountMassMessage massMessage) {
        CopyrightCheckResult copyrightCheckResult;
        if (material == null || !material.getmType().equalsIgnoreCase(MaterialType.NEWS.getValue())) {
            return Collections.emptyList();
        }
        ArrayList newsMaterialInfo = Lists.newArrayList();
        boolean isAllOriginal = false;
        boolean isUnknown = true;
        Map<Object, Object> indexCheckResult = Maps.newHashMap();
        if (massMessage != null && massMessage.getMaterialType().equals(String.valueOf((Object)MaterialType.NEWS)) && (copyrightCheckResult = checkResultMap.get(massMessage.getId())) != null) {
            isUnknown = false;
            if (OriginalStatus.ORIGINAL != OriginalStatus.getByValue(copyrightCheckResult.getCheckState())) {
                List resultList = copyrightCheckResult.getResultList();
                if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                    indexCheckResult = resultList.stream().collect(Collectors.toMap(a -> a.getArticleIdx() - 1, Function.identity(), (o, n) -> n));
                }
            } else {
                isAllOriginal = true;
            }
        }
        List subNews = material.getSubNews();
        for (int i = 0; i < subNews.size(); ++i) {
            NewsMaterialResultDto newsMaterialResultDto = new NewsMaterialResultDto();
            BeanUtils.copyProperties(subNews.get(i), (Object)newsMaterialResultDto);
            if (!isUnknown) {
                if (isAllOriginal) {
                    newsMaterialResultDto.setCheckState(EnumConstant.from((EnumService)OriginalStatus.ORIGINAL));
                } else {
                    ArticleCheckResult articleCheckResult = (ArticleCheckResult)indexCheckResult.get(i);
                    if (articleCheckResult == null) {
                        newsMaterialResultDto.setCheckState(EnumConstant.from((EnumService)OriginalStatus.ORIGINAL));
                    } else {
                        newsMaterialResultDto.setCheckState(EnumConstant.from((EnumService)OriginalStatus.getByValue(articleCheckResult.getAuditState())));
                    }
                }
            }
            newsMaterialInfo.add(newsMaterialResultDto);
        }
        return newsMaterialInfo;
    }
}

