/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.chatgpt.dto.req.ChatGptTextReq;
import cn.kinyun.scrm.chatgpt.dto.resp.ChatGptTextResp;
import cn.kinyun.scrm.chatgpt.dto.resp.ChatGptTextRespItem;
import cn.kinyun.scrm.chatgpt.service.ChatGptService;
import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.service.ChatGptAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ChatGptAutoReplyServiceImpl
implements ChatGptAutoReplyService {
    private static final Logger log = LoggerFactory.getLogger(ChatGptAutoReplyServiceImpl.class);
    @Value(value="${chatgpt.weixin.reply.enable:true}")
    private Boolean isEnable;
    @Autowired
    private ChatGptService chatGptService;
    @Autowired
    private LogicAutoReplyService logicAutoReplyService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private SettingService settingService;
    private static final String CHAT_GPT_CONF_KEY = "ChatGPT.weixin.reply.enable";

    @Override
    public boolean onRecvMsg(String appId, String openId, String content) {
        log.info("ChatGPT receive, appId={}, openId={}, content={}", new Object[]{appId, openId, content});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, openId, content})) {
            return false;
        }
        if (Boolean.FALSE.equals(this.isEnable)) {
            log.info("ChatGPT is disabled.");
            return false;
        }
        OfficialAccount account = this.officialAccountService.queryByAppId(appId);
        if (account == null) {
            log.warn("appId:{} not found.", (Object)appId);
            return false;
        }
        Boolean chatGPTConf = this.settingService.getBooleanOrDefault(account.getBizId(), CHAT_GPT_CONF_KEY, Boolean.valueOf(true));
        if (Boolean.FALSE.equals(chatGPTConf)) {
            log.info("bizId: {}, ChatGPT is disabled", (Object)account.getBizId());
            return false;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.getChatGPTRecvMsg(account.getBizId(), account.getCorpId(), appId, openId, content);
            }
            catch (Exception e) {
                log.error("async get chatGPT msg error: ", (Throwable)e);
            }
        });
        return true;
    }

    private void getChatGPTRecvMsg(Long bizId, String corpId, String appId, String openId, String content) {
        ChatGptTextReq req = new ChatGptTextReq();
        req.setText(content);
        ChatGptTextResp resp = null;
        try {
            resp = this.chatGptService.text(req);
            if (resp == null) {
                log.warn("ChatGPT\u81ea\u52a8\u56de\u590d\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("ChatGPT\u81ea\u52a8\u56de\u590d\u5931\u8d25", (Throwable)e);
        }
        if (resp == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)resp.getChoices())) {
            log.warn("ChatGPT\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        AutoReplyMsgDto dto = new AutoReplyMsgDto();
        dto.setType(AutoReplyMessageType.TEXT.getValue());
        dto.setContent(((ChatGptTextRespItem)resp.getChoices().get(0)).getText().trim());
        this.logicAutoReplyService.send(dto, appId, openId, bizId, corpId);
    }
}

