/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.netschool.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.QueryRefundOrderListReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderSkuListReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.dto.resp.PageRefundOrderListResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderListResp;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerRefundOrderService;
import cn.kinyun.pay.business.dto.vo.PayMessageDto;
import cn.kinyun.pay.business.enums.PayChannelType;
import cn.kinyun.scrm.netschool.service.NetSchoolOrderService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.NetSchoolGoodsTypeEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.system.dto.request.AddNetSchoolOrderReq;
import com.kuaike.scrm.system.dto.request.AddNetSchoolRefundOrderReq;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import com.kuaike.scrm.system.utils.NetSchoolGoodsId;
import com.kuaike.scrm.wework.contact.dto.CustomerOrderDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetSchoolOrderServiceImpl
implements NetSchoolOrderService {
    private static final Logger log = LoggerFactory.getLogger(NetSchoolOrderServiceImpl.class);
    @Autowired
    private PayRecordMapper payRecordMapper;
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private CcCustomerRefundOrderService ccCustomerRefundOrderService;
    @Autowired
    private ScrmNetSchoolService scrmNetSchoolService;
    @Autowired
    private ShopSkuMapper shopSkuMapper;
    @Autowired
    private ShopOrderMapper shopOrderMapper;
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    private ThreadPoolExecutor executeService = new ThreadPoolExecutor(1, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("batchPushNetSchoolOrderExecutor"), new ThreadPoolExecutor.DiscardPolicy());
    private static final Set<Integer> NEED_PUSH_TO_NET_SCHOOL_ORDER_STATUS = Sets.newHashSet((Object[])new Integer[]{OrderStatusEnum.SUCCESSED.getValue(), OrderStatusEnum.HAD_PAY.getValue(), OrderStatusEnum.WAIT_DELIVERY.getValue()});

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public void pushOrderToNetSchool(PayMessageDto payMessageDto) {
        log.info("pushOrderToNetSchool, payMessageDto: {}", (Object)payMessageDto);
        String orderNum = payMessageDto.getOrderNum();
        String orderNo = payMessageDto.getBizOrderNum();
        ShopOrder exist = new ShopOrder();
        exist.setOutOrderId(orderNum);
        ShopOrder shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
        if (shopOrder != null) {
            log.info("meeting order already handle, outOrderId: {}", (Object)orderNum);
            return;
        }
        PayRecord payRecord = this.payRecordMapper.queryByPayTradeNo(orderNum);
        if (payRecord == null) {
            log.info("pushOrderToNetSchool, not pay record, orderNum:{}", (Object)orderNum);
            return;
        }
        this.pushByOrder(payRecord.getBizId(), payRecord, orderNo);
    }

    @Override
    public void pushOrderToNetSchool(String orderNo) {
        log.info("pushOrderToNetSchool, orderNo: {}", (Object)orderNo);
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            log.info("orderNo is empty");
            return;
        }
        List payRecordList = this.payRecordMapper.queryPayRecordByOrderNo(orderNo);
        if (CollectionUtils.isEmpty((Collection)payRecordList)) {
            log.info("payRecordList is null, orderNo:{}", (Object)orderNo);
            return;
        }
        PayRecord payRecord = (PayRecord)payRecordList.get(0);
        if (payRecord == null) {
            log.info("payRecord is null, orderNo:{}", (Object)orderNo);
            return;
        }
        this.pushByOrder(payRecord.getBizId(), payRecord, orderNo);
    }

    private void pushByOrder(Long bizId, PayRecord payRecord, String orderNo) {
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(payRecord.getOrderNum());
        if (payOrder == null) {
            log.info("not find payOrder, orderNo: {}", (Object)payRecord.getOrderNum());
            return;
        }
        if (payOrder.getPayStatus().intValue() != PayStatusEnum.PAID.getValue()) {
            log.info("pay order is not paid, payOrderNo: {}, payStatus: {}", (Object)payOrder.getOrderNum(), (Object)payOrder.getPayStatus());
            return;
        }
        String corpId = payRecord.getCorpId();
        QueryOrderListReq req = new QueryOrderListReq();
        req.setBizId(bizId);
        req.setOrderNo(orderNo);
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(req);
        if (pageOrderListResp == null || CollectionUtils.isEmpty((Collection)pageOrderListResp.getList())) {
            log.info("not find order req: {}", (Object)req);
            return;
        }
        OrderListResp resp = (OrderListResp)pageOrderListResp.getList().get(0);
        String mobile = resp.getCustomerMobile();
        String address = resp.getDeliveryAddress();
        Long orderPay = resp.getPaidAmount();
        Date orderTime = resp.getOrderTime();
        List skuList = resp.getSkuList();
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            log.info("skuList is empty");
            return;
        }
        OrderSkuResp orderSkuResp = (OrderSkuResp)skuList.get(0);
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(orderSkuResp.getSkuNo());
        if (Objects.isNull(shopSpu)) {
            log.info("shop spu is empty, skuNo: {}", (Object)orderSkuResp.getSkuNo());
            return;
        }
        Integer payChannel = payRecord.getPayChannelType() >= PayChannelType.WEIXIN_NATIVE.getValue() && payRecord.getPayChannelType() <= PayChannelType.WEIXIN_PRE_CREATE.getValue() ? Integer.valueOf(1) : (payRecord.getPayChannelType() >= PayChannelType.ALIPAY_PRE_CREATE.getValue() && payRecord.getPayChannelType() <= PayChannelType.ALIPAY_PAGE.getValue() ? Integer.valueOf(2) : (payRecord.getPayChannelType().equals(PayChannelType.OFFLINE_CASH.getValue()) ? Integer.valueOf(8) : Integer.valueOf(12)));
        Date payTime = payRecord.getUpdateTime();
        AddNetSchoolOrderReq addOrderReq = new AddNetSchoolOrderReq();
        addOrderReq.setMobile(mobile);
        addOrderReq.setAddress(address);
        addOrderReq.setOrderNo(orderNo);
        addOrderReq.setPayStatus(Integer.valueOf(2));
        if (GoodsOrderSource.NET_SCHOOL.getSource() == shopSpu.getSource().intValue()) {
            Long netSchoolGoodsId = NetSchoolGoodsId.getOriginId((String)shopSpu.getOutProductId());
            addOrderReq.setShopId(netSchoolGoodsId);
            Integer goodsType = NetSchoolGoodsId.getGoodsType((String)shopSpu.getOutProductId());
            Integer shopType = NetSchoolGoodsTypeEnum.getShopType((Integer)goodsType);
            if (shopType != null) {
                addOrderReq.setShopType(shopType);
            } else {
                log.info("pushOrderToNetSchool, goodsType is not support:{}", (Object)goodsType);
            }
            addOrderReq.setIsScrmGoods(Boolean.valueOf(false));
        } else {
            addOrderReq.setIsScrmGoods(Boolean.valueOf(true));
            String goodsName = (String)JSON.parseObject((String)shopSpu.getSpuBody()).get((Object)"title");
            addOrderReq.setGoodsName(goodsName);
        }
        addOrderReq.setPaidPrice(Long.valueOf(orderPay / 100L));
        addOrderReq.setLogisticMobile(mobile);
        addOrderReq.setLogisticConsignee(resp.getCustomerName());
        if (StringUtils.isBlank((CharSequence)addOrderReq.getLogisticConsignee())) {
            addOrderReq.setLogisticConsignee(mobile);
        }
        addOrderReq.setPayType(payChannel);
        addOrderReq.setCreatedAt(Long.valueOf(orderTime.getTime() / 1000L));
        addOrderReq.setPaidAt(Long.valueOf(payTime.getTime() / 1000L));
        User user = (User)this.userMapper.selectByPrimaryKey((Object)resp.getCreateBy());
        if (user != null && user.getNetSchoolUserId() != null) {
            addOrderReq.setUserId(String.valueOf(user.getNetSchoolUserId()));
            addOrderReq.setScrmAdminId(user.getNetSchoolUserId());
        } else {
            addOrderReq.setUserId("0");
            addOrderReq.setScrmAdminId(Integer.valueOf(0));
        }
        addOrderReq.setNickname(resp.getCustomerName());
        addOrderReq.setSchoolId(String.valueOf(shopSpu.getNetSchoolId()));
        CrmLeadsInfoReq infoReq = new CrmLeadsInfoReq();
        infoReq.setBizId(bizId);
        infoReq.setCorpId(corpId);
        infoReq.setMobile(mobile);
        try {
            CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(infoReq);
            if (leads != null) {
                addOrderReq.setScrmId(leads.getNum());
            }
        }
        catch (Exception e) {
            log.info("infoReq:{}", (Object)infoReq);
            log.error("get leads error: ", (Throwable)e);
        }
        addOrderReq.setServiceCycle(resp.getRealServicePeriod());
        addOrderReq.setServiceCycleFree(resp.getFreeServicePeriod());
        addOrderReq.setServiceCycleTime(DateUtil.dateToTimestampLong((Date)resp.getRealServicePeriodTime()));
        addOrderReq.setServiceCycleFreeTime(DateUtil.dateToTimestampLong((Date)resp.getFreeServicePeriodTime()));
        addOrderReq.setExamType(shopSpu.getExamType());
        addOrderReq.setSpecificExam(shopSpu.getSpecificExam());
        this.scrmNetSchoolService.addNetSchoolOrder(bizId, addOrderReq, null);
    }

    @Override
    public void pushOrderToNetSchool(CustomerOrderDto orderDto) {
        if (!NEED_PUSH_TO_NET_SCHOOL_ORDER_STATUS.contains(orderDto.getOrderStatus())) {
            log.info("order status is not successed, orderNo: {}, orderStatus: {}", (Object)orderDto.getOrderNo(), (Object)orderDto.getOrderStatus());
            return;
        }
        String mobile = orderDto.getCustomerMobile();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.info("mobile is empty");
            return;
        }
        String address = orderDto.getReceiveAddress();
        String orderNo = orderDto.getOrderNo();
        String skuNo = ((OrderSkuListReq)orderDto.getOrderSkuListReqs().get(0)).getSkuNo();
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(skuNo);
        if (Objects.isNull(shopSpu)) {
            log.info("shop spu is empty, skuNo: {}", (Object)skuNo);
            return;
        }
        long orderPay = 0L;
        for (OrderRecordReq recordReq : orderDto.getOrderRecordReqs()) {
            orderPay += recordReq.getPayAmount().longValue();
        }
        Date orderTime = orderDto.getOrderCreateTime();
        if (orderTime == null) {
            orderTime = new Date();
        }
        Integer payChannel = 8;
        Date payTime = new Date();
        AddNetSchoolOrderReq addOrderReq = new AddNetSchoolOrderReq();
        addOrderReq.setMobile(mobile);
        addOrderReq.setAddress(address);
        addOrderReq.setOrderNo(orderNo);
        addOrderReq.setPayStatus(Integer.valueOf(2));
        if (shopSpu.getSource().intValue() == GoodsOrderSource.NET_SCHOOL.getSource()) {
            Long netSchoolGoodsId = NetSchoolGoodsId.getOriginId((String)shopSpu.getOutProductId());
            addOrderReq.setShopId(netSchoolGoodsId);
            Integer goodsType = NetSchoolGoodsId.getGoodsType((String)shopSpu.getOutProductId());
            Integer shopType = NetSchoolGoodsTypeEnum.getShopType((Integer)goodsType);
            if (shopType != null) {
                addOrderReq.setShopType(shopType);
            } else {
                log.info("pushOrderToNetSchool, goodsType is not support:{}", (Object)goodsType);
            }
            addOrderReq.setIsScrmGoods(Boolean.valueOf(false));
        } else {
            String goodsName = (String)JSON.parseObject((String)shopSpu.getSpuBody()).get((Object)"title");
            addOrderReq.setGoodsName(goodsName);
            addOrderReq.setIsScrmGoods(Boolean.valueOf(true));
        }
        addOrderReq.setPaidPrice(Long.valueOf(orderPay / 100L));
        addOrderReq.setLogisticMobile(mobile);
        addOrderReq.setLogisticConsignee(orderDto.getCustomerName());
        if (StringUtils.isBlank((CharSequence)addOrderReq.getLogisticConsignee())) {
            addOrderReq.setLogisticConsignee(mobile);
        }
        addOrderReq.setPayType(payChannel);
        addOrderReq.setCreatedAt(Long.valueOf(orderTime.getTime() / 1000L));
        addOrderReq.setPaidAt(Long.valueOf(payTime.getTime() / 1000L));
        User user = (User)this.userMapper.selectByPrimaryKey((Object)orderDto.getCreateBy());
        if (user != null && user.getNetSchoolUserId() != null) {
            addOrderReq.setUserId(String.valueOf(user.getNetSchoolUserId()));
            addOrderReq.setScrmAdminId(user.getNetSchoolUserId());
        } else {
            addOrderReq.setUserId("0");
            addOrderReq.setScrmAdminId(Integer.valueOf(0));
        }
        addOrderReq.setNickname(orderDto.getCustomerName());
        addOrderReq.setSchoolId(String.valueOf(shopSpu.getNetSchoolId()));
        CrmLeadsInfoReq infoReq = new CrmLeadsInfoReq();
        infoReq.setBizId(orderDto.getBizId());
        infoReq.setCorpId(orderDto.getCorpId());
        infoReq.setMobile(mobile);
        try {
            CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(infoReq);
            if (leads != null) {
                addOrderReq.setScrmId(leads.getNum());
            }
        }
        catch (Exception e) {
            log.info("infoReq: {}", (Object)infoReq);
            log.error("get leads error: ", (Throwable)e);
        }
        addOrderReq.setServiceCycle(orderDto.getRealServicePeriod());
        addOrderReq.setServiceCycleFree(orderDto.getFreeServicePeriod());
        addOrderReq.setServiceCycleTime(DateUtil.dateToTimestampLong((Date)orderDto.getRealServicePeriodTime()));
        addOrderReq.setServiceCycleFreeTime(DateUtil.dateToTimestampLong((Date)orderDto.getFreeServicePeriodTime()));
        this.scrmNetSchoolService.addNetSchoolOrder(orderDto.getBizId(), addOrderReq, null);
    }

    @Override
    public void batchPushOrderToNetSchool(List<CustomerOrderDto> orderDtoList) {
        if (CollectionUtils.isNotEmpty(orderDtoList)) {
            for (CustomerOrderDto orderDto : orderDtoList) {
                while (this.executeService.getQueue().remainingCapacity() == 0) {
                    ThreadUtil.sleep((long)100L);
                }
                this.executeService.submit(() -> this.pushOrderToNetSchool(orderDto));
            }
        }
    }

    @Override
    public void pushRefundOrderToNetSchool(PayMessageDto payMessageDto) {
        User user;
        PayRefundRecord refundRecord = this.payRefundRecordMapper.queryRefundRecords(payMessageDto.getBizRefundNum());
        if (refundRecord.getRefundStatus().intValue() != RefundStatusEnum.REFUNDED.getValue()) {
            log.info("refund record is not refunded, orderNo: {}, refundStatus: {}", (Object)refundRecord.getOrderNum(), (Object)refundRecord.getRefundStatus());
            return;
        }
        Long bizId = refundRecord.getBizId();
        String orderNo = payMessageDto.getBizOrderNum();
        QueryOrderListReq req = new QueryOrderListReq();
        req.setBizId(bizId);
        req.setOrderNo(orderNo);
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(req);
        if (pageOrderListResp == null || CollectionUtils.isEmpty((Collection)pageOrderListResp.getList())) {
            log.info("not find order req: {}", (Object)req);
            return;
        }
        OrderListResp resp = (OrderListResp)pageOrderListResp.getList().get(0);
        List skuList = resp.getSkuList();
        OrderSkuResp orderSkuResp = (OrderSkuResp)skuList.get(0);
        String skuNo = orderSkuResp.getSkuNo();
        List shopSkus = this.shopSkuMapper.queryByStringProductId(skuNo);
        if (CollectionUtils.isEmpty((Collection)shopSkus)) {
            log.info("shop skus is empty, skuNo: {}", (Object)skuNo);
            return;
        }
        ShopSku shopSku = (ShopSku)shopSkus.get(0);
        if (shopSku.getSource().intValue() != GoodsOrderSource.NET_SCHOOL.getSource()) {
            log.info("goods source is not netschool shopSku: {}", (Object)shopSku.getId());
            return;
        }
        AddNetSchoolRefundOrderReq refundOrderReq = new AddNetSchoolRefundOrderReq();
        refundOrderReq.setOrderNo(orderNo);
        refundOrderReq.setRefundNo(refundRecord.getRefundNum());
        refundOrderReq.setRefundAmount(Long.valueOf(refundRecord.getRefundAmount() + refundRecord.getOfflineRefundAmount()));
        refundOrderReq.setRefundAt(Long.valueOf(refundRecord.getUpdateTime().getTime() / 1000L));
        refundOrderReq.setRefundType(refundRecord.getRefundType());
        QueryRefundOrderListReq listReq = new QueryRefundOrderListReq();
        listReq.setBizId(bizId);
        listReq.setPageDto(PageDto.getDefPageDto());
        listReq.setRefundNo(refundRecord.getRefundNum());
        PageRefundOrderListResp pageRefundOrderListResp = this.ccCustomerRefundOrderService.refundOrderList(listReq);
        if (pageRefundOrderListResp != null && CollectionUtils.isNotEmpty((Collection)pageRefundOrderListResp.getList())) {
            RefundOrderListResp refundOrderResp = (RefundOrderListResp)pageRefundOrderListResp.getList().get(0);
            refundOrderReq.setReason(refundOrderResp.getReason());
            refundOrderReq.setRefundRemark(refundOrderResp.getRemark());
        }
        if ((user = (User)this.userMapper.selectByPrimaryKey((Object)refundRecord.getCreateBy())) != null && user.getNetSchoolUserId() != null) {
            refundOrderReq.setScrmAdminId(user.getNetSchoolUserId());
        } else {
            refundOrderReq.setScrmAdminId(Integer.valueOf(0));
        }
        this.scrmNetSchoolService.addNetSchoolRefundOrder(bizId, refundOrderReq, null);
    }
}

