/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.dto.MajorCustomerListRes;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerMsgHit;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsClickLog;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRelCriteria;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerMsgHitMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsClickLogMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.meeting.dto.reponse.HitKeywordRes;
import com.kuaike.scrm.meeting.dto.reponse.MeetingGoodsInfoResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingGoodsStatisticResp;
import com.kuaike.scrm.meeting.dto.request.HitKeywordReq;
import com.kuaike.scrm.meeting.dto.request.MajorCustomerReq;
import com.kuaike.scrm.meeting.dto.request.MeetingGoodsStatisticReq;
import com.kuaike.scrm.meeting.service.MeetingStatisticService;
import com.kuaike.scrm.order.dto.AddressInfo;
import com.kuaike.scrm.order.dto.ProductInfo;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.model.OrderEsModel;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeetingStatisticServiceImpl
implements MeetingStatisticService {
    private static final Logger log = LoggerFactory.getLogger(MeetingStatisticServiceImpl.class);
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingCustomerMsgHitMapper meetingCustomerMsgHitMapper;
    @Autowired
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Autowired
    private GoodsOrderEsService goodsOrderEsService;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private MeetingGoodsClickLogMapper meetingGoodsClickLogMapper;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public List<MajorCustomerListRes> queryMajorCustomerList(MajorCustomerReq params) {
        log.info("query major customer list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        Long bizId = userInfo.getBizId();
        PageDto pageDto = params.getPageDto();
        List resList = null;
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.meetingCustomerInfoMapper.queryMajorCustomerList(bizId, params.getMeetingId(), params.getName()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            resList = page.getResult();
        } else {
            resList = this.meetingCustomerInfoMapper.queryMajorCustomerList(bizId, params.getMeetingId(), params.getName());
        }
        return resList;
    }

    @Override
    public Map<Long, Integer> queryMajorCustomerCount(List<Long> meetingIds) {
        log.info("queryMajorCustomerCount  params: {}", meetingIds);
        return this.meetingCustomerMsgHitMapper.queryMeetingMajorCount(LoginUtils.getCurrentUserBizId(), meetingIds);
    }

    @Override
    public List<HitKeywordRes> queryMajorCustomerHitList(HitKeywordReq params) {
        log.info("query major customer hit list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        List list = null;
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.meetingCustomerMsgHitMapper.queryMsgHitList(bizId, params.getMeetingId(), params.getCustomerId()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            list = page.getResult();
        } else {
            list = this.meetingCustomerMsgHitMapper.queryMsgHitList(bizId, params.getMeetingId(), params.getCustomerId());
        }
        ArrayList result = Lists.newArrayList();
        for (MeetingCustomerMsgHit msgHit : list) {
            HitKeywordRes res = new HitKeywordRes();
            res.setContent(msgHit.getContent());
            res.setChatTime(msgHit.getChatTime());
            res.setKeywords(Splitter.on((String)";").splitToList((CharSequence)msgHit.getKeywords()));
            result.add(res);
        }
        return result;
    }

    @Override
    public void exportMajorCustomerList(HttpServletResponse response, MajorCustomerReq params) {
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)params.getMeetingId());
        if (meeting == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u76f4\u64ad");
        }
        String fileName = meeting.getTitle() + "-\u91cd\u70b9\u5ba2\u6237.xlsx";
        try {
            List<MajorCustomerListRes> resList = this.queryMajorCustomerList(params);
            OutputStream fileWriter = this.getWebOutputStream(response, fileName);
            ArrayList heads = Lists.newArrayList();
            ArrayList head1 = Lists.newArrayList((Object[])new String[]{"\u5ba2\u6237\u540d\u79f0"});
            ArrayList head2 = Lists.newArrayList((Object[])new String[]{"\u547d\u4e2d\u5173\u952e\u8bcd\u6b21\u6570"});
            ArrayList head3 = Lists.newArrayList((Object[])new String[]{"\u624b\u673a\u53f7"});
            heads.add(head1);
            heads.add(head2);
            heads.add(head3);
            ArrayList table = Lists.newArrayList();
            for (MajorCustomerListRes res : resList) {
                ArrayList row = Lists.newArrayList();
                row.add(res.getName());
                row.add(res.getHitCount());
                row.add(res.getMobile());
                table.add(row);
            }
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileWriter).head((List)heads)).sheet("sheet").doWrite((Collection)table);
        }
        catch (Exception e) {
            log.error("export major customer list error: ", (Throwable)e);
        }
    }

    private OutputStream getWebOutputStream(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        return response.getOutputStream();
    }

    @Override
    public List<MeetingGoodsStatisticResp> getMeetingGoodsStatistic(MeetingGoodsStatisticReq req) {
        Long bizId = req.getBizId();
        log.info("getMeetingGoodsStatistic meetingNum: {}, bizId: {}", (Object)req.getMeetingNum(), (Object)bizId);
        ArrayList resps = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)req.getMeetingNum())) {
            return resps;
        }
        Meeting meeting = this.meetingMapper.selectByNum(req.getMeetingNum());
        if (meeting == null) {
            log.info("getMeetingGoodsStatistic get meeting is null");
            return resps;
        }
        Long meetingId = meeting.getId();
        log.info("getMeetingGoodsStatistic get meetingId: {}, meetingNum: {}", (Object)meetingId, (Object)req.getMeetingNum());
        MeetingGoodsRelCriteria criteria = new MeetingGoodsRelCriteria();
        criteria.createCriteria().andBizIdEqualTo(bizId).andMeetingIdEqualTo(meetingId).andStatusEqualTo(YnEnum.YES.getValue());
        List meetingGoodsRels = this.meetingGoodsRelMapper.selectByExample((Object)criteria);
        if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
            log.info("getMeetingGoodsStatistic query meetingGoodsRels is empty, meetingId: {}, bizId: {}", (Object)meetingId, (Object)bizId);
            return resps;
        }
        List goodProductIds = meetingGoodsRels.stream().map(MeetingGoodsRel::getGoodsProductId).collect(Collectors.toList());
        List shopSpus = this.shopSpuMapper.queryByProductIds("-1", goodProductIds);
        Map<String, ShopSpu> spuId2Spu = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, a -> a));
        log.info("getMeetingGoodsStatistic spuId2Spu: {}", spuId2Spu);
        List<OrderEsModel> orderEsModelList = this.goodsOrderEsService.queryMeetingOrderList(meetingId, null, null, null).stream().filter(a -> a.getStatus().equals(OrderStatus.PAID.getStatus())).collect(Collectors.toList());
        Map<String, List<OrderEsModel>> orderEsMap = this.getOrderEsModelMap(orderEsModelList);
        log.info("getMeetingGoodsStatistic orderEsMap: {}", orderEsMap);
        List clickLogs = this.meetingGoodsClickLogMapper.queryClickLogsBy(bizId, meetingId, null);
        Map<String, List<MeetingGoodsClickLog>> clickLogMap = clickLogs.stream().collect(Collectors.groupingBy(MeetingGoodsClickLog::getGoodsProductId));
        log.info("getMeetingGoodsStatistic clickLogMap: {}", clickLogMap);
        for (String pid : goodProductIds) {
            List<MeetingGoodsClickLog> clickLogList;
            MeetingGoodsStatisticResp resp = new MeetingGoodsStatisticResp();
            resp.setMeetingNum(req.getMeetingNum());
            ShopSpu spu = spuId2Spu.get(pid);
            if (Objects.isNull(spu)) continue;
            SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)spu.getSpuBody(), SpuCreateReq.class);
            resp.setGoodsName(spuCreateReq.getTitle());
            resp.setGoodsProductId(pid);
            resp.setClickCount(0);
            resp.setClickUserCount(0);
            if (clickLogMap != null && CollectionUtils.isNotEmpty(clickLogList = clickLogMap.get(pid))) {
                resp.setClickCount(clickLogList.size());
                Set clickInfoIds = clickLogList.stream().map(MeetingGoodsClickLog::getBjyNumber).collect(Collectors.toSet());
                resp.setClickUserCount(clickInfoIds.size());
            }
            List<OrderEsModel> orderEsModels = orderEsMap.get(pid);
            resp.setOrderCount(0);
            resp.setDealUserCount(0);
            resp.setTotalOrderAmount(Float.valueOf(0.0f));
            if (CollectionUtils.isNotEmpty(orderEsModels)) {
                resp.setOrderCount(orderEsModels.size());
                long orderAmount = 0L;
                for (OrderEsModel sModel : orderEsModels) {
                    orderAmount += sModel.getOrderDetail().getPriceInfo().getOrderPrice().longValue();
                }
                Float amount = Float.valueOf((float)orderAmount / 10000.0f);
                resp.setTotalOrderAmount(amount);
                Set customerNums = orderEsModels.stream().map(OrderEsModel::getCustomerNum).collect(Collectors.toSet());
                resp.setDealUserCount(customerNums.size());
            }
            resps.add(resp);
        }
        return resps;
    }

    private Map<String, List<OrderEsModel>> getOrderEsModelMap(List<OrderEsModel> orderEsModelList) {
        HashMap esModelMap = Maps.newHashMap();
        HashSet pidList = Sets.newHashSet();
        for (OrderEsModel model : orderEsModelList) {
            List productInfos = model.getOrderDetail().getProductInfos();
            List pids = productInfos.stream().map(ProductInfo::getProductId).collect(Collectors.toList());
            pidList.addAll(pids);
        }
        log.info("getOrderEsModelMap get pid: {}, modelSize: {}", (Object)pidList, (Object)orderEsModelList.size());
        for (String pid : pidList) {
            ArrayList models = Lists.newArrayList();
            for (OrderEsModel model : orderEsModelList) {
                List productInfos = model.getOrderDetail().getProductInfos();
                List pids = productInfos.stream().map(ProductInfo::getProductId).collect(Collectors.toList());
                if (!pids.contains(pid)) continue;
                models.add(model);
            }
            esModelMap.put(pid, models);
        }
        return esModelMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<MeetingGoodsInfoResp> getMeetingGoodsInfoList(MeetingGoodsStatisticReq req) {
        Long bizId = req.getBizId();
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        Preconditions.checkArgument((req.getType() != null ? 1 : 0) != 0, (Object)"\u70b9\u51fb\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)req.getMeetingNum())) {
            log.info("getMeetingGoodsInfoList meetingNum is null");
            return null;
        }
        Meeting meeting = this.meetingMapper.selectByNum(req.getMeetingNum());
        if (meeting == null) {
            log.info("getMeetingGoodsStatistic get meeting is null");
            return null;
        }
        Long meetingId = meeting.getId();
        ArrayList productIds = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)req.getProductId())) {
            MeetingGoodsRelCriteria criteria = new MeetingGoodsRelCriteria();
            criteria.createCriteria().andBizIdEqualTo(bizId).andMeetingIdEqualTo(meetingId).andStatusEqualTo(YnEnum.YES.getValue());
            List meetingGoodsRels = this.meetingGoodsRelMapper.selectByExample((Object)criteria);
            if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
                return null;
            }
            List goodProductIds = meetingGoodsRels.stream().map(MeetingGoodsRel::getGoodsProductId).collect(Collectors.toList());
            log.info("getMeetingGoodsInfoList get goodProductIds: {}, meetingId : {}", goodProductIds, (Object)meetingId);
            productIds.addAll(goodProductIds);
        } else {
            productIds.add(req.getProductId());
        }
        log.info("getMeetingGoodsInfoList bizId: {}, param: {}, productIds: {}", new Object[]{bizId, req, productIds});
        List orderEsModelList = this.goodsOrderEsService.queryMeetingOrderList(meetingId, null, null, null);
        Map<String, List<OrderEsModel>> orderEsMap = this.getOrderEsModelMap(orderEsModelList);
        List customerInfos = this.meetingCustomerInfoMapper.queryCustomerInfosByMeetingId(bizId, meetingId);
        Map<String, MeetingCustomerInfo> bjyNumMap = customerInfos.stream().collect(Collectors.toMap(MeetingCustomerInfo::getBjyNumber, a -> a));
        List shopSpus = this.shopSpuMapper.queryByProductIds("-1", (Collection)productIds);
        Map<String, ShopSpu> spuId2Spu = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, a -> a));
        log.info("getMeetingGoodsInfoList spuId2Spu: {}", spuId2Spu);
        ArrayList resps = Lists.newArrayList();
        for (String productId : productIds) {
            List newOrderEsModels;
            Object amount;
            long orderAmount;
            ShopSpu spu = spuId2Spu.get(productId);
            if (Objects.isNull(spu)) {
                return null;
            }
            SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)spu.getSpuBody(), SpuCreateReq.class);
            String productName = spuCreateReq.getTitle();
            log.info("getMeetingGoodsInfoList get productName: {}", (Object)productName);
            List<OrderEsModel> orderEsModels = orderEsMap.get(productId);
            if (req.getType() == 1) {
                void var23_26;
                List clickLogs = this.meetingGoodsClickLogMapper.queryClickLogsBy(bizId, meetingId, productId);
                Set bjyNums = clickLogs.stream().map(MeetingGoodsClickLog::getBjyNumber).collect(Collectors.toSet());
                Map<String, List<MeetingGoodsClickLog>> clickLogMap = clickLogs.stream().collect(Collectors.groupingBy(MeetingGoodsClickLog::getBjyNumber));
                Object var23_24 = null;
                if (CollectionUtils.isNotEmpty(orderEsModels)) {
                    Map<String, List<OrderEsModel>> map = orderEsModels.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getExtInfo().getBjyNumber())).collect(Collectors.groupingBy(a -> a.getExtInfo().getBjyNumber()));
                }
                log.info("getMeetingGoodsInfoList orderESMap: {}, bjyNums: {}", (Object)var23_26, bjyNums);
                for (String bjyNum : bjyNums) {
                    MeetingGoodsInfoResp resp = new MeetingGoodsInfoResp();
                    resp.setOrderCount(0);
                    resp.setOrderAmount(Float.valueOf(0.0f));
                    resp.setClickCount(0);
                    resps.add(resp);
                    MeetingCustomerInfo customerInfo = bjyNumMap.get(bjyNum);
                    if (customerInfo != null) {
                        List newEsModels;
                        List esModels;
                        resp.setMobile(customerInfo.getBjyMobile());
                        if (StringUtils.isNotEmpty((CharSequence)customerInfo.getUnionId())) {
                            String customerNum;
                            CustomerDetailResp detailResp;
                            resp.setWechatName(customerInfo.getName());
                            WeworkContact contact = this.weworkContactMapper.selectByCorpIdAndUnionId(corpId, customerInfo.getUnionId());
                            if (contact != null && (detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum = contact.getCustomerNum())) != null) {
                                resp.setCustomerName(detailResp.getName());
                                resp.setMobile(detailResp.getMobile1());
                            }
                        }
                        if (StringUtils.isNotEmpty((CharSequence)customerInfo.getBjyMobile()) && StringUtils.isEmpty((CharSequence)resp.getCustomerName())) {
                            WeworkContact contact;
                            CustomerDetailResp detailResp;
                            String sCustomerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, customerInfo.getBjyMobile());
                            log.info("getMeetingGoodsInfoList sCustomerNum: {}, mobile: {}", (Object)sCustomerNum, (Object)customerInfo.getBjyMobile());
                            if (StringUtils.isNotEmpty((CharSequence)sCustomerNum) && (detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, sCustomerNum)) != null) {
                                resp.setCustomerName(detailResp.getName());
                            }
                            String cCustomerNum = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, customerInfo.getBjyMobile());
                            log.info("getMeetingGoodsInfoList cCustomerNum: {}, mobile: {}", (Object)cCustomerNum, (Object)customerInfo.getBjyMobile());
                            if (StringUtils.isNotEmpty((CharSequence)cCustomerNum) && (contact = this.weworkContactMapper.queryContact(corpId, cCustomerNum)) != null) {
                                resp.setWechatName(contact.getName());
                            }
                        }
                        if (var23_26 != null && CollectionUtils.isNotEmpty((Collection)(esModels = (List)var23_26.get(customerInfo.getBjyNumber()))) && CollectionUtils.isNotEmpty(newEsModels = esModels.stream().filter(a -> a.getStatus().equals(OrderStatus.PAID.getStatus())).collect(Collectors.toList()))) {
                            String customerNum;
                            CustomerDetailResp detailResp;
                            AddressInfo addressInfo;
                            OrderEsModel esModel = (OrderEsModel)newEsModels.get(0);
                            if (StringUtils.isEmpty((CharSequence)resp.getMobile()) && esModel.getOrderDetail().getDeliveryInfoDto() != null && (addressInfo = esModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo()) != null) {
                                resp.setMobile(addressInfo.getTelNumber());
                            }
                            if (StringUtils.isEmpty((CharSequence)resp.getCustomerName()) && (detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum = esModel.getCustomerNum())) != null) {
                                resp.setCustomerName(detailResp.getName());
                            }
                            resp.setOrderCount(newEsModels.size());
                            orderAmount = 0L;
                            for (OrderEsModel sModel : newEsModels) {
                                orderAmount += sModel.getOrderDetail().getPriceInfo().getOrderPrice().longValue();
                            }
                            amount = Float.valueOf((float)orderAmount / 10000.0f);
                            resp.setOrderAmount((Float)amount);
                        }
                    }
                    List clickLogList = (List)clickLogMap.get(bjyNum);
                    resp.setClickCount(clickLogList.size());
                    resp.setProductName(productName);
                    if (StringUtils.isEmpty((CharSequence)resp.getCustomerName())) {
                        resp.setCustomerName("--");
                    }
                    if (StringUtils.isEmpty((CharSequence)resp.getWechatName())) {
                        resp.setWechatName("--");
                    }
                    if (!StringUtils.isEmpty((CharSequence)resp.getMobile())) continue;
                    resp.setMobile("--");
                }
            }
            if (req.getType() == 2 && CollectionUtils.isNotEmpty(orderEsModels)) {
                newOrderEsModels = orderEsModels.stream().filter(a -> a.getStatus().equals(OrderStatus.PAID.getStatus())).collect(Collectors.toList());
                Map<String, List<OrderEsModel>> subEsModelMap = null;
                if (CollectionUtils.isNotEmpty(newOrderEsModels)) {
                    subEsModelMap = newOrderEsModels.stream().collect(Collectors.groupingBy(OrderEsModel::getCustomerNum));
                }
                log.info("getMeetingGoodsInfoList subEsModelMap: {}", subEsModelMap);
                if (subEsModelMap != null) {
                    for (Map.Entry entry : subEsModelMap.entrySet()) {
                        List models;
                        MeetingGoodsInfoResp resp = new MeetingGoodsInfoResp();
                        resp.setOrderCount(0);
                        resp.setOrderAmount(Float.valueOf(0.0f));
                        resps.add(resp);
                        String customerNum = (String)entry.getKey();
                        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
                        if (detailResp != null) {
                            resp.setCustomerName(detailResp.getName());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(models = (List)entry.getValue()))) {
                            AddressInfo addressInfo;
                            OrderEsModel esModel = (OrderEsModel)models.get(0);
                            String bjyNumber = esModel.getExtInfo().getBjyNumber();
                            MeetingCustomerInfo customerInfo = bjyNumMap.get(bjyNumber);
                            if (customerInfo != null) {
                                if (StringUtils.isNotEmpty((CharSequence)customerInfo.getUnionId())) {
                                    resp.setWechatName(customerInfo.getName());
                                }
                                resp.setMobile(customerInfo.getBjyMobile());
                            }
                            if (StringUtils.isEmpty((CharSequence)resp.getMobile()) && esModel.getOrderDetail().getDeliveryInfoDto() != null && (addressInfo = esModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo()) != null) {
                                resp.setMobile(addressInfo.getTelNumber());
                            }
                            resp.setOrderCount(models.size());
                            orderAmount = 0L;
                            for (OrderEsModel sModel : models) {
                                orderAmount += sModel.getOrderDetail().getPriceInfo().getOrderPrice().longValue();
                            }
                            amount = Float.valueOf((float)orderAmount / 10000.0f);
                            resp.setOrderAmount((Float)amount);
                            resp.setProductName(productName);
                        }
                        if (StringUtils.isEmpty((CharSequence)resp.getWechatName()) && StringUtils.isNotEmpty((CharSequence)resp.getMobile())) {
                            WeworkContact contact;
                            String cCustomerNum = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, resp.getMobile());
                            log.info("getMeetingGoodsInfoList cCustomerNum: {}, mobile: {}", (Object)cCustomerNum, (Object)resp.getMobile());
                            if (StringUtils.isNotEmpty((CharSequence)cCustomerNum) && (contact = this.weworkContactMapper.queryContact(corpId, cCustomerNum)) != null) {
                                resp.setWechatName(contact.getName());
                            }
                        }
                        if (StringUtils.isEmpty((CharSequence)resp.getCustomerName())) {
                            resp.setCustomerName("--");
                        }
                        if (StringUtils.isEmpty((CharSequence)resp.getWechatName())) {
                            resp.setWechatName("--");
                        }
                        if (!StringUtils.isEmpty((CharSequence)resp.getMobile())) continue;
                        resp.setMobile("--");
                    }
                }
            }
            if (req.getType() != 3 || !CollectionUtils.isNotEmpty(orderEsModels) || !CollectionUtils.isNotEmpty(newOrderEsModels = orderEsModels.stream().filter(a -> a.getStatus().equals(OrderStatus.PAID.getStatus())).collect(Collectors.toList()))) continue;
            for (OrderEsModel esModel : newOrderEsModels) {
                AddressInfo addressInfo;
                MeetingCustomerInfo customerInfo;
                MeetingGoodsInfoResp meetingGoodsInfoResp = new MeetingGoodsInfoResp();
                meetingGoodsInfoResp.setPaidAmount(Float.valueOf(0.0f));
                resps.add(meetingGoodsInfoResp);
                CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, esModel.getCustomerNum());
                if (detailResp != null) {
                    meetingGoodsInfoResp.setCustomerName(detailResp.getName());
                }
                if ((customerInfo = bjyNumMap.get(esModel.getExtInfo().getBjyNumber())) != null) {
                    if (StringUtils.isNotEmpty((CharSequence)customerInfo.getUnionId())) {
                        meetingGoodsInfoResp.setWechatName(customerInfo.getName());
                    }
                    meetingGoodsInfoResp.setMobile(customerInfo.getBjyMobile());
                }
                if (StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getMobile()) && esModel.getOrderDetail().getDeliveryInfoDto() != null && (addressInfo = esModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo()) != null) {
                    meetingGoodsInfoResp.setMobile(addressInfo.getTelNumber());
                }
                meetingGoodsInfoResp.setOrderNo(esModel.getOrderId());
                if (esModel.getOrderDetail().getPriceInfo().getOrderPrice() != null) {
                    meetingGoodsInfoResp.setPaidAmount(Float.valueOf((float)esModel.getOrderDetail().getPriceInfo().getOrderPrice().longValue() / 10000.0f));
                }
                meetingGoodsInfoResp.setProductName(productName);
                if (StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getWechatName()) && StringUtils.isNotEmpty((CharSequence)meetingGoodsInfoResp.getMobile())) {
                    WeworkContact contact;
                    String cCustomerNum = this.ccCustomerNumService.getContactCustomerNumByMobile(bizId, meetingGoodsInfoResp.getMobile());
                    log.info("getMeetingGoodsInfoList cCustomerNum: {}, mobile: {}", (Object)cCustomerNum, (Object)meetingGoodsInfoResp.getMobile());
                    if (StringUtils.isNotEmpty((CharSequence)cCustomerNum) && (contact = this.weworkContactMapper.queryContact(corpId, cCustomerNum)) != null) {
                        meetingGoodsInfoResp.setWechatName(contact.getName());
                    }
                }
                if (StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getCustomerName())) {
                    meetingGoodsInfoResp.setCustomerName("--");
                }
                if (StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getWechatName())) {
                    meetingGoodsInfoResp.setWechatName("--");
                }
                if (StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getMobile())) {
                    meetingGoodsInfoResp.setMobile("--");
                }
                if (!StringUtils.isEmpty((CharSequence)meetingGoodsInfoResp.getOrderNo())) continue;
                meetingGoodsInfoResp.setOrderNo("--");
            }
        }
        log.info("getMeetingGoodsInfoList get resp size: {}", (Object)resps.size());
        if (StringUtils.isNotEmpty((CharSequence)req.getQuery()) && CollectionUtils.isNotEmpty((Collection)resps)) {
            log.info("getMeetingGoodsInfoList query : {}", (Object)req.getQuery());
            ArrayList filterResp = Lists.newArrayList();
            for (MeetingGoodsInfoResp resp : resps) {
                if (!(StringUtils.isNotEmpty((CharSequence)resp.getMobile()) && resp.getMobile().contains(req.getQuery()) || StringUtils.isNotEmpty((CharSequence)resp.getWechatName()) && resp.getWechatName().contains(req.getQuery())) && (!StringUtils.isNotEmpty((CharSequence)resp.getCustomerName()) || !resp.getCustomerName().contains(req.getQuery()))) continue;
                filterResp.add(resp);
            }
            return filterResp;
        }
        return resps;
    }
}

