/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.DeptModMsgType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.dto.DepartmentModMsg;
import com.kuaike.scrm.common.service.dto.UserModDto;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingShareMembers;
import com.kuaike.scrm.dal.meeting.entity.MeetingShareOrg;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingShareMembersMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingShareOrgMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.meeting.dto.ShareMemberDto;
import com.kuaike.scrm.meeting.dto.request.MeetingAddOrModReqDto;
import com.kuaike.scrm.meeting.service.MeetingShareMemberService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingShareMemberServiceImpl
implements MeetingShareMemberService {
    private static final Logger log = LoggerFactory.getLogger(MeetingShareMemberServiceImpl.class);
    @Autowired
    private NodeService nodeService;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingShareMembersMapper meetingShareMembersMapper;
    @Autowired
    private MeetingShareOrgMapper meetingShareOrgMapper;

    @Override
    public List<String> getShareMembers(Long bizId, String corpId, Long meetingId) {
        MeetingAddOrModReqDto reqDto;
        log.info("get share members, bizId={}, corpId={}, meetingId={}", new Object[]{bizId, corpId, meetingId});
        Preconditions.checkArgument((bizId != null && bizId > 0L ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((meetingId != null && meetingId > 0L ? 1 : 0) != 0, (Object)"meetingId\u4e0d\u80fd\u4e3a\u7a7a");
        Meeting meeting = this.meetingMapper.queryById(bizId, corpId, meetingId);
        if (meeting == null) {
            log.info("detail, \u67e5\u8be2\u4e0d\u5230\u4f1a\u8bae:{}", (Object)meetingId);
            return Collections.emptyList();
        }
        try {
            reqDto = (MeetingAddOrModReqDto)JSONObject.parseObject((String)meeting.getParams(), MeetingAddOrModReqDto.class);
            if (reqDto == null) {
                log.warn("parse meeting params failed, meetingId={}, params={}", (Object)meetingId, (Object)meeting.getParams());
                return Collections.emptyList();
            }
        }
        catch (Exception e) {
            log.error("parse meeting params failed, meetingId={}, params={}", new Object[]{meetingId, meeting.getParams(), e});
            return Collections.emptyList();
        }
        List<ShareMemberDto> list = this.getShareMembers(bizId, corpId, reqDto.getWeworkUserNums(), reqDto.getNodeIds());
        if (CollectionUtils.isEmpty(list)) {
            log.warn("getShareMembers is empty");
            return Collections.emptyList();
        }
        return list.stream().map(ShareMemberDto::getWeworkUserNum).collect(Collectors.toList());
    }

    @Override
    public List<ShareMemberDto> getShareMembers(Long bizId, String corpId, List<String> weworkUserNums, List<Long> nodeIds) {
        log.info("get share members, bizId={}, corpId={}, weworkUserNums={}, nodeIds={}", new Object[]{bizId, corpId, weworkUserNums, nodeIds});
        if (CollectionUtils.isEmpty(weworkUserNums) && CollectionUtils.isEmpty(nodeIds)) {
            log.info("weworkUserNums and nodeIds is empty");
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        HashSet<String> weworkUserNumSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(weworkUserNums)) {
            Map wuNumAndIdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
            log.info("wuNumAndIdMap={}", (Object)wuNumAndIdMap);
            for (String weworkUserNum : weworkUserNums) {
                if (!wuNumAndIdMap.containsKey(weworkUserNum) || weworkUserNumSet.contains(weworkUserNum)) {
                    log.info("ignore weworkUserNum={}", (Object)weworkUserNum);
                    continue;
                }
                ShareMemberDto shareMemberDto = new ShareMemberDto();
                shareMemberDto.setWeworkUserNum(weworkUserNum);
                shareMemberDto.setWeworkUserId((String)wuNumAndIdMap.get(weworkUserNum));
                shareMemberDto.setHidden(NumberUtils.INTEGER_ZERO);
                list.add(shareMemberDto);
                weworkUserNumSet.add(weworkUserNum);
            }
        }
        if (CollectionUtils.isNotEmpty(nodeIds)) {
            Set allNodeIds = this.nodeService.getPosterityIds(nodeIds, bizId);
            Set deptIds = this.organizationMapper.queryDepartmentIds((Collection)allNodeIds);
            Set deptWeworkUserNums = this.weworkDepartmentUserMapper.queryUserNumByDeptIds(corpId, (Collection)deptIds);
            Map wuNumAndIdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums((Collection)deptWeworkUserNums);
            log.info("getShareMembers deptIds={}, wuNumAndIdMap={}", (Object)deptIds, (Object)wuNumAndIdMap);
            if (wuNumAndIdMap != null && !wuNumAndIdMap.isEmpty()) {
                for (String weworkUserNum : deptWeworkUserNums) {
                    if (!wuNumAndIdMap.containsKey(weworkUserNum) || weworkUserNumSet.contains(weworkUserNum)) {
                        log.info("ignore weworkUserNum={}", (Object)weworkUserNum);
                        continue;
                    }
                    ShareMemberDto shareMemberDto = new ShareMemberDto();
                    shareMemberDto.setWeworkUserNum(weworkUserNum);
                    shareMemberDto.setWeworkUserId((String)wuNumAndIdMap.get(weworkUserNum));
                    shareMemberDto.setHidden(NumberUtils.INTEGER_ONE);
                    list.add(shareMemberDto);
                    weworkUserNumSet.add(weworkUserNum);
                }
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveOrganizations(Long bizId, Long userId, Long meetingId, List<Long> nodeIds) {
        log.info("batchSaveOrganizations bizId={}, userId={}, meetingId={}, nodeIds={}", new Object[]{bizId, userId, meetingId, nodeIds});
        if (CollectionUtils.isEmpty(nodeIds)) {
            log.info("batchSaveOrganizations nodeIds is empty");
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList list = Lists.newArrayList();
        for (Long orgId : nodeIds) {
            if (orgId == null || ids.contains(orgId)) {
                log.info("ignore orgId={}", (Object)orgId);
                continue;
            }
            ids.add(orgId);
            MeetingShareOrg meetingShareOrg = new MeetingShareOrg();
            meetingShareOrg.setBizId(bizId);
            meetingShareOrg.setCreateBy(userId);
            meetingShareOrg.setUpdateBy(userId);
            meetingShareOrg.setCreateTime(new Date());
            meetingShareOrg.setUpdateTime(new Date());
            meetingShareOrg.setOrgId(orgId);
            meetingShareOrg.setMeetingId(meetingId);
            meetingShareOrg.setIsDeleted(NumberUtils.INTEGER_ZERO);
            list.add(meetingShareOrg);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("batchSaveOrganizations list is empty");
            return;
        }
        this.meetingShareOrgMapper.batchInsert((List)list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveMembers(Long bizId, String corpId, Long userId, Long meetingId, List<ShareMemberDto> shareMemberList) {
        log.info("batchSaveMembers bizId={}, corpId={}, userId={}, meetingId={}, shareMemberList={}", new Object[]{bizId, corpId, userId, meetingId, shareMemberList});
        if (CollectionUtils.isEmpty(shareMemberList)) {
            log.info("batchSaveMembers shareMemberList is empty");
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (ShareMemberDto dto : shareMemberList) {
            MeetingShareMembers meetingShareMembers = new MeetingShareMembers();
            meetingShareMembers.setBizId(bizId);
            meetingShareMembers.setCorpId(corpId);
            meetingShareMembers.setCreateBy(userId);
            meetingShareMembers.setUpdateBy(userId);
            meetingShareMembers.setCreateTime(new Date());
            meetingShareMembers.setUpdateTime(new Date());
            meetingShareMembers.setWeworkUserNum(dto.getWeworkUserNum());
            meetingShareMembers.setMeetingId(meetingId);
            meetingShareMembers.setHidden(dto.getHidden());
            meetingShareMembers.setIsDeleted(NumberUtils.INTEGER_ZERO);
            list.add(meetingShareMembers);
        }
        this.meetingShareMembersMapper.batchInsert((List)list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateOrganizations(Long bizId, Long userId, Long meetingId, List<Long> nodeIds) {
        log.info("batchUpdateOrganizations bizId={}, userId={}, meetingId={}, nodeIds={}", new Object[]{bizId, userId, meetingId, nodeIds});
        HashSet<Long> newNodeIds = new HashSet<Long>(nodeIds);
        List existsOrgs = this.meetingShareOrgMapper.selectByMeetingId(meetingId);
        if (CollectionUtils.isNotEmpty((Collection)existsOrgs)) {
            ArrayList needDelOrgIds = Lists.newArrayListWithCapacity((int)existsOrgs.size());
            for (MeetingShareOrg org : existsOrgs) {
                if (newNodeIds.contains(org.getOrgId())) continue;
                needDelOrgIds.add(org.getOrgId());
            }
            if (CollectionUtils.isNotEmpty((Collection)needDelOrgIds)) {
                log.info("batchUpdateOrganizations needDelOrgIds={}", (Object)needDelOrgIds);
                this.meetingShareOrgMapper.batchDeleteByOrgIds(meetingId, (List)needDelOrgIds);
            }
            ArrayList needAddOrgIds = Lists.newArrayListWithCapacity((int)newNodeIds.size());
            Set existsOrgIds = existsOrgs.stream().map(MeetingShareOrg::getOrgId).collect(Collectors.toSet());
            for (Long orgId : newNodeIds) {
                if (existsOrgIds.contains(orgId)) continue;
                needAddOrgIds.add(orgId);
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddOrgIds)) {
                log.info("batchUpdateOrganizations needAddOrgIds={}", (Object)needAddOrgIds);
                this.batchSaveOrganizations(bizId, userId, meetingId, needAddOrgIds);
            }
        } else {
            log.info("batchUpdateOrganizations existsOrgs is empty");
            if (CollectionUtils.isNotEmpty(nodeIds)) {
                this.batchSaveOrganizations(bizId, userId, meetingId, nodeIds);
            } else {
                log.info("batchUpdateOrganizations nodeIds is empty");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateMembers(Long bizId, String corpId, Long userId, Long meetingId, List<ShareMemberDto> shareMemberList) {
        log.info("batchUpdateMembers bizId={}, corpId={}, userId={}, meetingId={}, shareMemberList={}", new Object[]{bizId, corpId, userId, meetingId, shareMemberList});
        Map newWeworkUserNums = shareMemberList.stream().collect(Collectors.toMap(ShareMemberDto::getWeworkUserNum, Function.identity()));
        List existsMembers = this.meetingShareMembersMapper.selectByMeetingId(meetingId);
        Set existsWeworkUserNums = existsMembers.stream().map(MeetingShareMembers::getWeworkUserNum).collect(Collectors.toSet());
        log.info("batchUpdateMembers existsMembers={}", existsWeworkUserNums);
        ArrayList needDelMembers = Lists.newArrayListWithCapacity((int)existsMembers.size());
        ArrayList needUpdateMembers = Lists.newArrayListWithCapacity((int)existsMembers.size());
        for (MeetingShareMembers member : existsMembers) {
            if (newWeworkUserNums.containsKey(member.getWeworkUserNum())) {
                ShareMemberDto dto = (ShareMemberDto)newWeworkUserNums.get(member.getWeworkUserNum());
                if (dto.getHidden() == null || dto.getHidden().equals(member.getHidden())) continue;
                member.setHidden(dto.getHidden());
                member.setUpdateBy(userId);
                member.setUpdateTime(new Date());
                member.setIsDeleted(NumberUtils.INTEGER_ZERO);
                needUpdateMembers.add(member);
                continue;
            }
            needDelMembers.add(member.getWeworkUserNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelMembers)) {
            log.info("batchUpdateMembers needDelMembers={}", (Object)needDelMembers);
            this.meetingShareMembersMapper.delMembersByMeetingIdAndMemberNums(meetingId, userId, (Collection)needDelMembers);
        }
        if (CollectionUtils.isNotEmpty((Collection)needUpdateMembers)) {
            log.info("batchUpdateMembers needUpdateMembers={}", (Object)needUpdateMembers);
            this.meetingShareMembersMapper.batchUpdate((List)needUpdateMembers);
        }
        ArrayList needAddMembers = Lists.newArrayListWithCapacity((int)shareMemberList.size());
        for (ShareMemberDto dto : shareMemberList) {
            if (existsWeworkUserNums.contains(dto.getWeworkUserNum())) continue;
            needAddMembers.add(dto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAddMembers)) {
            this.batchSaveMembers(bizId, corpId, userId, meetingId, needAddMembers);
        }
    }

    @Override
    public void onDepartmentMod(DepartmentModMsg message) {
        log.info("onDepartmentMod message={}", (Object)message);
        try {
            DeptModMsgType msgType = DeptModMsgType.get((int)message.getMsgType());
            if (msgType == null) {
                log.warn("onDepartmentMod msgType={} not support", (Object)message.getMsgType());
                return;
            }
            switch (msgType) {
                case CREATE_USER: {
                    this.onCreateUser(message);
                    break;
                }
                case UPDATE_USER: {
                    this.onUpdateUser(message);
                    break;
                }
                case DELETE_USER: {
                    this.onDeleteUser(message);
                    break;
                }
                default: {
                    log.info("onDepartmentMod msgType={} not support", (Object)msgType.getDesc());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("onDepartmentMod error", (Throwable)e);
        }
    }

    private void onCreateUser(DepartmentModMsg message) {
        log.info("onCreateUser message={}", (Object)message);
        Long bizId = message.getBizId();
        String corpId = message.getCorpId();
        for (UserModDto dto : message.getUserList()) {
            try {
                this.appendMeetingShareMember(bizId, corpId, dto);
            }
            catch (Exception e) {
                log.error("onUpdateUser error", (Throwable)e);
            }
        }
    }

    private void onUpdateUser(DepartmentModMsg message) {
        log.info("onUpdateUser message={}", (Object)message);
        Long bizId = message.getBizId();
        String corpId = message.getCorpId();
        for (UserModDto dto : message.getUserList()) {
            try {
                this.appendMeetingShareMember(bizId, corpId, dto);
            }
            catch (Exception e) {
                log.error("onUpdateUser error", (Throwable)e);
            }
        }
    }

    private void appendMeetingShareMember(Long bizId, String corpId, UserModDto dto) {
        log.info("append meeting share member, bizId={}, corpId={}, dto={}", new Object[]{bizId, corpId, dto});
        if (CollectionUtils.isEmpty((Collection)dto.getParentNodeIds())) {
            log.info("current node ids is empty");
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getAddDeptIds())) {
            List meetingIds = this.meetingShareOrgMapper.selectMeetingIdByUnStartOrgs(bizId, (Collection)dto.getParentNodeIds());
            if (CollectionUtils.isEmpty((Collection)meetingIds)) {
                log.info("meetingIds is empty");
                return;
            }
            Set existsMeetingIds = this.meetingShareMembersMapper.selectMeetingIdByExistsShareMembers(meetingIds, dto.getWeworkUserNum());
            if (existsMeetingIds == null) {
                log.info("existsMeetingIds is empty");
                existsMeetingIds = Collections.emptySet();
            }
            ArrayList list = Lists.newArrayListWithCapacity((int)meetingIds.size());
            for (Long meetingId2 : meetingIds) {
                if (existsMeetingIds.contains(meetingId2)) {
                    log.info("existsMeetingIds contains meetingId={}", (Object)meetingId2);
                    continue;
                }
                MeetingShareMembers meetingShareMembers = new MeetingShareMembers();
                meetingShareMembers.setBizId(bizId);
                meetingShareMembers.setCorpId(corpId);
                meetingShareMembers.setCreateBy(Long.valueOf(-1L));
                meetingShareMembers.setUpdateBy(Long.valueOf(-1L));
                meetingShareMembers.setCreateTime(new Date());
                meetingShareMembers.setUpdateTime(new Date());
                meetingShareMembers.setWeworkUserNum(dto.getWeworkUserNum());
                meetingShareMembers.setMeetingId(meetingId2);
                meetingShareMembers.setHidden(NumberUtils.INTEGER_ONE);
                meetingShareMembers.setIsDeleted(NumberUtils.INTEGER_ZERO);
                list.add(meetingShareMembers);
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                log.info("batch insert share member list={}", (Object)list);
                this.meetingShareMembersMapper.batchInsert((List)list);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getDelDeptIds())) {
            List list = this.meetingShareMembersMapper.selectUnStartHiddenMembers(bizId, (Collection)Lists.newArrayList((Object[])new String[]{dto.getWeworkUserNum()}));
            if (CollectionUtils.isEmpty((Collection)list)) {
                log.info("list is empty");
                return;
            }
            List meetings = list.stream().map(a -> a.getMeetingId()).distinct().collect(Collectors.toList());
            List shareOrgs = this.meetingShareOrgMapper.selectByMeetingIds(meetings);
            Map meetingId2OrgIds = shareOrgs.stream().collect(Collectors.groupingBy(MeetingShareOrg::getMeetingId, Collectors.mapping(MeetingShareOrg::getOrgId, Collectors.toList())));
            HashSet deleteMeetingIds = Sets.newHashSet();
            meetingId2OrgIds.forEach((meetingId, orgIds) -> {
                if (CollectionUtils.isEmpty((Collection)orgIds)) {
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)CollectionUtils.intersection((Iterable)orgIds, (Iterable)dto.getParentNodeIds()))) {
                    deleteMeetingIds.add(meetingId);
                }
            });
            List ids = list.stream().filter(a -> !deleteMeetingIds.contains(a.getMeetingId())).map(MeetingShareMembers::getId).collect(Collectors.toList());
            log.info("batch delete share member, list={}", ids);
            if (CollectionUtils.isNotEmpty(ids)) {
                this.meetingShareMembersMapper.deleteByIds(ids);
            }
        }
    }

    private void onDeleteUser(DepartmentModMsg message) {
        log.info("onDeleteUser message={}", (Object)message);
        Long bizId = message.getBizId();
        List weworkUserNums = message.getUserList().stream().map(UserModDto::getWeworkUserNum).collect(Collectors.toList());
        List list = this.meetingShareMembersMapper.selectUnStartHiddenMembers(bizId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("list is empty");
            return;
        }
        log.info("batch delete share member, list={}", (Object)list);
        List ids = list.stream().map(MeetingShareMembers::getId).collect(Collectors.toList());
        this.meetingShareMembersMapper.deleteByIds(ids);
    }
}

