/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.entity.MeetingShareChannelRecord;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingJoinQuitLogMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingShareChannelRecordMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.meeting.dto.reponse.WeworkUserMeetinChannelRespDto;
import com.kuaike.scrm.meeting.dto.request.BatchGenerateShareLinkReqDto;
import com.kuaike.scrm.meeting.service.MeetingShareChannelRecordService;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingCusParamEncryRelService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.service.MeetingUrlService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MeetingShareChannelRecordServiceImpl
implements MeetingShareChannelRecordService {
    private static final Logger log = LoggerFactory.getLogger(MeetingShareChannelRecordServiceImpl.class);
    @Autowired
    private MeetingShareChannelRecordMapper meetingShareChannelRecordMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private ParamEncryMapper paramEncryMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private MeetingJoinQuitLogMapper meetingJoinQuitLogMapper;
    @Autowired
    private MeetingSettingMapper meetingSettingMapper;
    @Resource
    private MeetingCusParamEncryRelService meetingCusParamEncryRelService;
    @Resource
    private MeetingUrlService meetingUrlService;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private MeetingBjyMapper meetingBjyMapper;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Value(value="${baijiacloud.quickenter.url}")
    private String quickEnterUrl;

    @Override
    public void batchGenerateShareLink(BatchGenerateShareLinkReqDto reqDto) {
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)reqDto.getMeetingId());
        Preconditions.checkArgument((boolean)Objects.nonNull(meeting), (Object)"\u4f1a\u8bae\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(reqDto.getChannelIds()), (Object)"\u8bf7\u9009\u62e9\u6e20\u9053");
        Map channelMap = this.channelMapper.getIdByNums(meeting.getBizId(), reqDto.getChannelIds());
        Collection channelIds = channelMap.values();
        List records = this.meetingShareChannelRecordMapper.queryMyMeetingShareLinks(reqDto.getWeworkUserNum(), reqDto.getMeetingId(), channelIds);
        log.info("batchGenerateShareLink.reqDto:{}, records:{}", (Object)reqDto, (Object)records);
        Preconditions.checkArgument((boolean)CollectionUtils.isEmpty((Collection)records), (Object)"\u90e8\u5206\u6216\u8005\u5168\u90e8\u6e20\u9053\u5df2\u7ecf\u751f\u6210\u6e20\u9053\u94fe\u63a5\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210");
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSetting(LoginUtils.getCurrentUser().getBizId());
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u6ca1\u6709\u914d\u7f6e\u767e\u5bb6\u4e91\u76f4\u64ad\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u4f01\u5fae\u7ba1\u7406\u5458");
        this.buildParamEncryList(meeting, channelMap);
    }

    void buildParamEncryList(Meeting meeting, Map<String, Long> channelMap) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Date now = new Date();
        for (Map.Entry<String, Long> entry : channelMap.entrySet()) {
            Long channelId = entry.getValue();
            ParamEncry param = new ParamEncry();
            param.setCreateTime(now);
            String num = this.idGen.getNum();
            param.setNum(num);
            param.setType(NumberUtils.INTEGER_ONE);
            MeetingParams mp = new MeetingParams(meeting.getId(), "-1", user.getWeworkUserNum(), "-1", NumberUtils.INTEGER_MINUS_ONE, channelId);
            param.setParams(JacksonUtil.obj2Str((Object)mp));
            this.paramEncryMapper.insert((Object)param);
            log.info("buildParamEncryList.meeting:{}, channelId:{}, param:{}", new Object[]{meeting, channelId, param});
            this.meetingCusParamEncryRelService.insertWhenInsertParamEncry(meeting.getBizId(), num, meeting.getId(), "-1", channelId);
            this.buildAndInsertShareChannelRecord(meeting, param, user, channelId, entry.getKey(), mp);
        }
    }

    void buildAndInsertShareChannelRecord(Meeting meeting, ParamEncry param, CurrentUserInfo user, long channelId, String channelNum, MeetingParams meetingParams) {
        String meetingUrl;
        MeetingShareChannelRecord meetingShareChannelRecord = new MeetingShareChannelRecord();
        Date now = new Date();
        meetingShareChannelRecord.setAvatarUrl("");
        meetingShareChannelRecord.setBizId(user.getBizId());
        meetingShareChannelRecord.setChannelId(channelId);
        meetingShareChannelRecord.setChannelQrcodeUrl("");
        if (YnEnum.YES.getValue().equals(meeting.getLiveDeliverySwitch())) {
            meetingUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), channelNum, meeting.getNum(), user.getWeworkUserNum(), false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
            try {
                this.meetingCacheService.setInviteChannel(user.getBizId(), Long.valueOf(channelId), channelNum);
            }
            catch (Exception e) {
                log.error("buildAndInsertShareChannelRecord,setInviteChannel error", (Throwable)e);
            }
            try {
                this.meetingCacheService.setInviteUserId(meeting.getBizId(), user.getWeworkUserNum(), meeting.getEndTime(), user.getId());
            }
            catch (Exception e) {
                log.error("meetingCacheService,setInviteUserId error", (Throwable)e);
            }
            try {
                this.meetingCacheService.setMeetingParamWhenGenChannelInvite(meeting.getBizId(), meeting.getId(), Long.valueOf(channelId), meetingParams, meeting.getEndTime());
            }
            catch (Exception e) {
                log.error("meetingCacheService,setMeetingParamWhenGenChannelInvite error", (Throwable)e);
            }
        } else {
            meetingUrl = this.getMeetingChannelUrl(meeting.getMeetingInfo(), param.getNum(), meeting.getInviteInfoType());
        }
        meetingShareChannelRecord.setChannelUrl(meetingUrl);
        meetingShareChannelRecord.setCorpId(user.getCorpId());
        meetingShareChannelRecord.setCreateTime(now);
        meetingShareChannelRecord.setFillWords("");
        meetingShareChannelRecord.setIsDownload(NumberUtils.INTEGER_ZERO.intValue());
        meetingShareChannelRecord.setMeetingId(meeting.getId().longValue());
        meetingShareChannelRecord.setNum(param.getNum());
        meetingShareChannelRecord.setStatus(NumberUtils.INTEGER_ZERO.intValue());
        meetingShareChannelRecord.setUpdateTime(now);
        meetingShareChannelRecord.setWeworkUserNum(user.getWeworkUserNum());
        this.meetingShareChannelRecordMapper.insert((Object)meetingShareChannelRecord);
        log.info("buildAndInsertShareChannelRecord.meeting:{}, channelId:{}, param:{}", new Object[]{meeting, channelId, param});
    }

    String getMeetingChannelUrl(String meetingInfo, String encryNum, Integer inviteInfoType) {
        if (StringUtils.isNotBlank((CharSequence)meetingInfo)) {
            if (meetingInfo.contains("&${customstr}")) {
                meetingInfo = meetingInfo.replace("${customstr}", "customstr=" + encryNum);
            } else if (meetingInfo.contains("${customstr}")) {
                meetingInfo = meetingInfo.replace("${customstr}", "&customstr=" + encryNum);
            }
        }
        log.info("getMeetingChannelUrl inviteInfoType : {}, meetingInfo: {}", (Object)inviteInfoType, (Object)meetingInfo);
        meetingInfo = inviteInfoType == 1 ? this.handleH5MeetingInfo(meetingInfo) : this.handleMeetingInfo(meetingInfo);
        return meetingInfo;
    }

    private String handleMeetingInfo(String input) {
        String meetingInfo = input;
        if (meetingInfo.contains("\u76f4\u64ad\u94fe\u63a5")) {
            String[] infoList;
            for (String info : infoList = meetingInfo.split("\\r?\\n")) {
                if (!info.contains("\u76f4\u64ad\u94fe\u63a5")) continue;
                meetingInfo = MeetingShareChannelRecordServiceImpl.getUrlFromString(info);
            }
        }
        log.info("handleMeetingInfo meetingInfo : {}", (Object)meetingInfo);
        return meetingInfo;
    }

    private String handleH5MeetingInfo(String input) {
        String meetingInfo = input;
        if (meetingInfo.contains("link")) {
            String[] infoList;
            for (String info : infoList = meetingInfo.split(",")) {
                if (!info.contains("link")) continue;
                meetingInfo = MeetingShareChannelRecordServiceImpl.getUrlFromString(info);
            }
        }
        log.info("handleH5MeetingInfo meetingInfo : {}", (Object)meetingInfo);
        return meetingInfo;
    }

    private static String getUrlFromString(String data) {
        String regex = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
        Pattern p = Pattern.compile(regex);
        Matcher matcher = p.matcher(data);
        if (matcher.find()) {
            return matcher.group();
        }
        return data;
    }

    @Override
    public Collection<Long> getWeworkUserMeetingChannelIds(long meetingId) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        List records = this.meetingShareChannelRecordMapper.queryMyMeetingShareLinks(user.getWeworkUserNum(), Long.valueOf(meetingId), null);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            return records.stream().map(MeetingShareChannelRecord::getChannelId).collect(Collectors.toSet());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<WeworkUserMeetinChannelRespDto> queryWeworkUserMeetingChannels(long meetingId) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Long bizId = user.getBizId();
        List records = this.meetingShareChannelRecordMapper.queryMyMeetingShareLinks(user.getWeworkUserNum(), Long.valueOf(meetingId), null);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Collections.emptyList();
        }
        Map<Long, Channel> channelMap = this.getChannelMap(bizId, records);
        ArrayList result = Lists.newArrayList();
        for (MeetingShareChannelRecord meetingShareChannelRecord : records) {
            WeworkUserMeetinChannelRespDto dto = this.convertToDto(meetingShareChannelRecord);
            Channel channel = channelMap.get(meetingShareChannelRecord.getChannelId());
            if (channel != null) {
                dto.setChannelName(channel.getName());
            }
            Long count = this.meetingJoinQuitLogMapper.queryCountByChannelId(Long.valueOf(meetingId), Long.valueOf(meetingShareChannelRecord.getChannelId()));
            log.info("queryWeworkUserMeetingChannels count : {}, meetingId: {}, channelId: {}", new Object[]{count, meetingId, meetingShareChannelRecord.getChannelId()});
            dto.setCount(count.intValue());
            result.add(dto);
        }
        return result;
    }

    WeworkUserMeetinChannelRespDto convertToDto(MeetingShareChannelRecord meetingShareChannelRecord) {
        WeworkUserMeetinChannelRespDto dto = new WeworkUserMeetinChannelRespDto();
        dto.setChannelId(meetingShareChannelRecord.getChannelId());
        dto.setCreateTime(meetingShareChannelRecord.getCreateTime().getTime());
        dto.setUpdateTime(meetingShareChannelRecord.getUpdateTime().getTime());
        dto.setMeetingId(meetingShareChannelRecord.getMeetingId());
        String channelUrl = this.handleMeetingInfo(meetingShareChannelRecord.getChannelUrl());
        dto.setMeetingUrl(channelUrl);
        dto.setParamNum(meetingShareChannelRecord.getNum());
        return dto;
    }

    Map<Long, Channel> getChannelMap(Long bizId, List<MeetingShareChannelRecord> records) {
        Set channelIds = records.stream().map(MeetingShareChannelRecord::getChannelId).collect(Collectors.toSet());
        List channels = this.channelMapper.queryChannels(bizId, channelIds);
        return CollectionUtils.isNotEmpty((Collection)channels) ? channels.stream().collect(Collectors.toMap(Channel::getId, p -> p)) : Maps.newHashMap();
    }
}

