/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AppOpenBaseReqDto;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BjyMeetingInstallServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(BjyMeetingInstallServiceImpl.class);
    @Value(value="${app.bjyMeeting.appCode}")
    private String appCode;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private MeetingSettingMapper settingMapper;
    @Autowired
    private IdGen idGen;

    public String getAppCode() {
        return this.appCode;
    }

    public void install(AppBindings bindings) {
        this.addOrModBjySetting(bindings);
    }

    public void update(AppBindings bindings) {
        this.addOrModBjySetting(bindings);
    }

    private void addOrModBjySetting(AppBindings bindings) {
        AppOpenBaseReqDto reqDto = null;
        if (StringUtils.isBlank((CharSequence)bindings.getConfigJson())) {
            log.info("getConfigJson is null");
            return;
        }
        try {
            log.info("BjyMeetingInstall getConfigJson: {}", (Object)bindings.getConfigJson());
            reqDto = (AppOpenBaseReqDto)JacksonUtil.str2Obj((String)bindings.getConfigJson(), AppOpenBaseReqDto.class);
        }
        catch (IOException e) {
            log.error("reqDto  str2Obj error", (Throwable)e);
        }
        if (ObjectUtils.isEmpty(reqDto)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bjy\u4f1a\u8bae\u53c2\u6570\u914d\u7f6e\u4e3a\u7a7a");
        }
        bindings.setUpdateBy(Long.valueOf(-1L));
        bindings.setUpdateTime(new Date());
        bindings.setConfigJson(JacksonUtil.obj2Str((Object)reqDto));
        this.bindingsMapper.updateByPrimaryKey((Object)bindings);
        log.info("addOrModBjySetting params: {}", (Object)reqDto);
        MeetingSetting setting = this.settingMapper.getSetting(bindings.getBizId());
        if (setting == null) {
            setting = new MeetingSetting();
            setting.setNum(this.idGen.getNum());
            setting.setBizId(bindings.getBizId());
            setting.setCorpId(bindings.getCorpId());
            setting.setCreateBy(Long.valueOf(-1L));
            setting.setCreateTime(new Date());
            setting.setUpdateTime(new Date());
            setting.setDominSite(reqDto.getUrl());
            setting.setBjyId(reqDto.getFkId());
            setting.setBjyKey(reqDto.getFkKey());
            this.settingMapper.insertSelective((Object)setting);
        } else {
            setting.setUpdateBy(Long.valueOf(-1L));
            setting.setUpdateTime(new Date());
            setting.setDominSite(reqDto.getUrl());
            setting.setBjyId(reqDto.getFkId());
            setting.setBjyKey(reqDto.getFkKey());
            this.settingMapper.updateByPrimaryKey((Object)setting);
        }
    }
}

