/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto;

import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTagGroup;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;

public class MeetingTagInfo
extends MeetingTag {
    public static MeetingTag convertToPO(Meeting meeting, WeworkTag tag, WeworkTagGroup tagGroup, CurrentUserInfo user, int type) {
        MeetingTag mt = new MeetingTag();
        Date now = new Date();
        mt.setMeetingId(meeting.getNum());
        mt.setBizId(user.getBizId().longValue());
        mt.setCorpId(user.getCorpId());
        mt.setCreateBy(user.getWeworkUserNum());
        mt.setCreateByName(user.getName());
        mt.setType(type);
        mt.setCreateTime(now);
        mt.setUpdateTime(now);
        mt.setTagId(tag.getNum());
        mt.setTagName(tag.getName());
        mt.setTagGroupId(tagGroup.getNum());
        mt.setTagGroupName(tagGroup.getNum());
        return mt;
    }

    public static List<MeetingTag> batchConvertToPO(Meeting meeting, List<WeworkTag> tags, WeworkTagGroup tagGroup, CurrentUserInfo user, int type) {
        ArrayList mts = Lists.newArrayList();
        MeetingTag mt = null;
        if (CollectionUtils.isNotEmpty(tags)) {
            for (WeworkTag tag : tags) {
                mt = MeetingTagInfo.convertToPO(meeting, tag, tagGroup, user, type);
                mts.add(mt);
            }
        }
        return mts;
    }

    public static MeetingTagInfo convertPOToDto(MeetingTag source) {
        MeetingTagInfo target = new MeetingTagInfo();
        BeanUtils.copyProperties((Object)source, (Object)((Object)target), (String[])new String[]{"createTime", "updateTime", "dtos"});
        target.setCreateTime(source.getCreateTime());
        target.setUpdateTime(source.getUpdateTime());
        return target;
    }

    public static List<MeetingTagInfo> batchConvertPOToDto(List<MeetingTag> tags) {
        ArrayList mts = Lists.newArrayList();
        MeetingTagInfo mt = null;
        if (CollectionUtils.isNotEmpty(tags)) {
            for (MeetingTag tag : tags) {
                mt = MeetingTagInfo.convertPOToDto(tag);
                mts.add(mt);
            }
        }
        return mts;
    }

    public String toString() {
        return "MeetingTagInfo()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingTagInfo)) {
            return false;
        }
        MeetingTagInfo other = (MeetingTagInfo)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingTagInfo;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

