/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.wework.sdk.api.WwMaterialApi;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.material.dto.response.UploadVoiceFileResp;
import com.kuaike.scrm.material.service.UploadImageService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadImageServiceImpl
implements UploadImageService {
    private static final Logger log = LoggerFactory.getLogger(UploadImageServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private WwMaterialApi wwMaterialApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    private static final String TEMP_DIR = "./tmp";
    @Value(value="${silk-v3-decoder.path:}")
    private String basePath;

    /*
     * Exception decompiling
     */
    @Override
    public String uploadImage(MultipartFile file, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String upload(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private String buildNewFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            return UUID.randomUUID().toString() + "." + extension;
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public UploadVoiceFileResp uploadVoiceFile(MultipartFile file) {
        String voiceUrl = this.upload(file);
        log.info("uploadVoiceFile voiceUrl: {}", (Object)voiceUrl);
        UploadVoiceFileResp resp = new UploadVoiceFileResp();
        resp.setMp3Url(voiceUrl);
        if (StringUtils.isNotBlank((CharSequence)voiceUrl)) {
            String silkUrl = this.transMp3ToSilk(voiceUrl);
            log.info("uploadVoiceFile silkUrl: {}", (Object)silkUrl);
            resp.setSilkUrl(silkUrl);
        }
        return resp;
    }

    @Override
    public String transMp3ToSilk(String fileUrl) {
        String corpId = LoginUtils.getCurrentUserCorpId();
        log.info("transMp3ToSilk fileUrl: {}", (Object)fileUrl);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileUrl), (Object)"fileUrl is not blank");
        String extName = FilenameUtils.getExtension((String)fileUrl);
        String fileName = FilenameUtils.getBaseName((String)fileUrl);
        String fileKey = UploadImageServiceImpl.getFileKey(fileUrl);
        log.info("transMp3ToSilk fileUrl:{}, extName: {}, fileName: {}, fileKey: {}", new Object[]{fileUrl, extName, fileName, fileKey});
        String aliYunUrl = null;
        boolean errorFlag = false;
        StopWatchDto watch = new StopWatchDto("transMp3ToSilk", true, log);
        watch.start("\u4e0b\u8f7d\u6587\u4ef6");
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpClientUtils.download((String)fileUrl);
        }
        catch (Exception e) {
            errorFlag = true;
            log.error("transMp3ToSilk download error; fileUrl:{}, e", (Object)fileUrl, (Object)e);
        }
        watch.stop();
        log.info("transMp3ToSilk download :{}", (Object)fileUrl);
        if (errorFlag) {
            return "";
        }
        watch.start("\u5199\u5165mp3\u6587\u4ef6");
        String localPath = FilenameUtils.getName((String)fileUrl);
        log.info("transMp3ToSilk write localPath: {}", (Object)localPath);
        File source = new File(localPath);
        try (FileOutputStream fos = new FileOutputStream(source);){
            IOUtils.write((byte[])bytes, (OutputStream)fos);
        }
        catch (IOException e) {
            errorFlag = true;
            log.error("transMp3ToSilk write error; fileUrl:{}", (Object)fileUrl, (Object)e);
        }
        watch.stop();
        log.info("\u5199\u5165mp3\u6587\u4ef6,fileName:{}", (Object)fileName);
        if (errorFlag) {
            return "";
        }
        watch.start("mp3\u8f6c\u7801silk");
        File target = this.convertToSilk(this.basePath, source.getAbsolutePath());
        boolean isExist = target.exists();
        watch.stop();
        log.info("mp3\u8f6c\u7801silk, localPath :{}, isExist: {}", (Object)target.getAbsolutePath(), (Object)isExist);
        watch.start("\u4e0a\u4f20silk\u6587\u4ef6");
        try {
            aliYunUrl = this.aliyunOss.uploadFile(corpId, target, fileKey);
        }
        catch (Exception e) {
            log.error("uploadFile target:{}", (Object)target.getAbsolutePath(), (Object)e);
        }
        log.info("uploadFile success, url:{}", (Object)aliYunUrl);
        watch.stop();
        log.info("\u4e0a\u4f20silk \u6587\u4ef6,fileName:{}", (Object)fileName);
        FileUtils.deleteQuietly((File)source);
        FileUtils.deleteQuietly((File)target);
        watch.print();
        return aliYunUrl;
    }

    private File convertToSilk(String basePath, String fileName) {
        return this.convert(basePath, fileName, "silk", "converter_silk.sh");
    }

    private File convert(String basePath, String fileName, String format, String shell) {
        log.info("convert basePath:{}, fileName:{}, format:{}", new Object[]{basePath, fileName, format});
        String[] command = new String[]{basePath + shell, fileName, format};
        try {
            Process ps = Runtime.getRuntime().exec(command);
            int exitValue = ps.waitFor();
            if (0 != exitValue) {
                log.error("call shell failed. error code is :" + exitValue);
            }
        }
        catch (Exception e) {
            log.error("convert error \u6587\u4ef6\u8f6c\u7801\u5931\u8d25\uff0c fileName:{}", (Object)fileName, (Object)e);
            Thread.currentThread().interrupt();
        }
        String localPath = FilenameUtils.removeExtension((String)fileName) + "." + format;
        log.info("after convert localPath:{}", (Object)localPath);
        return new File(localPath);
    }

    private static String getFileKey(String path) {
        String[] split = path.split("/");
        if (split.length > 2) {
            String lastStr = split[split.length - 1];
            return lastStr + ".silk";
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String uploadWithFileOriginName(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

