/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.dto.PlanWeworkUserDto;
import com.kuaike.scrm.dal.region.entity.RegionPlanCycleUser;
import com.kuaike.scrm.dal.region.mapper.RegionPlanCycleUserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.regionplan.service.RegionPlanCycleUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RegionPlanCycleUserServiceImpl
implements RegionPlanCycleUserService {
    private static final Logger log = LoggerFactory.getLogger(RegionPlanCycleUserServiceImpl.class);
    @Resource
    private RegionPlanCycleUserMapper regionPlanCycleUserMapper;

    @Override
    public void saveCycleUser(Long planId, Long planGroupId, Long planWorkCycleId, List<String> weworkUserNums) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        List<String> curList = this.getCycleUsers(corpId, planId, planGroupId, planWorkCycleId);
        ArrayList addLisit = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            if (!curList.contains(weworkUserNum)) {
                addLisit.add(this.buildCycleUser(bizId, corpId, planId, planGroupId, planWorkCycleId, weworkUserNum, userInfo.getId()));
                continue;
            }
            curList.remove(weworkUserNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)addLisit)) {
            this.regionPlanCycleUserMapper.batchInsert((Collection)addLisit);
        }
        if (CollectionUtils.isNotEmpty(curList)) {
            this.regionPlanCycleUserMapper.delWorkCycleUsers(corpId, planId, planGroupId, planWorkCycleId, curList, userInfo.getId());
        }
    }

    @Override
    public void delCycleUser(String corpId, Long planId, Long planGroupId, String planWorkCycleNum, Long userId) {
        this.regionPlanCycleUserMapper.delCycleUserByWorkCycleNum(corpId, planId, planGroupId, planWorkCycleNum, userId);
    }

    @Override
    public List<String> getCycleUsers(String corpId, Long planId, Long planGroupId, Long planWorkCycleId) {
        return this.regionPlanCycleUserMapper.queryWorkCycleUser(corpId, planId, planGroupId, planWorkCycleId);
    }

    @Override
    public List<WeworkUserDto> getCycleUserInfo(String corpId, Long planId, Long planGroupId, Long planWorkCycleId) {
        List list = this.regionPlanCycleUserMapper.queryWorkCycleUserInfo(corpId, planId, planGroupId, planWorkCycleId);
        ArrayList result = Lists.newArrayList();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            result.add(weworkUserDto);
        }
        return result;
    }

    @Override
    public List<WeworkUserDto> getTimeLineUserInfo(String corpId, Long planId, Long planGroupId, List<Long> workCycleIds) {
        List list = this.regionPlanCycleUserMapper.queryUserInfo(corpId, planId, planGroupId, workCycleIds);
        ArrayList result = Lists.newArrayList();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            result.add(weworkUserDto);
        }
        return result;
    }

    private RegionPlanCycleUser buildCycleUser(Long bizId, String corpId, Long planId, Long planGroupId, Long planWorkCycleId, String weworkUserNum, Long userId) {
        Date curDate = new Date();
        RegionPlanCycleUser cycleUser = new RegionPlanCycleUser();
        cycleUser.setBizId(bizId);
        cycleUser.setCorpId(corpId);
        cycleUser.setPlanId(planId);
        cycleUser.setPlanGroupId(planGroupId);
        cycleUser.setPlanWorkCycleId(planWorkCycleId);
        cycleUser.setWeworkUserNum(weworkUserNum);
        cycleUser.setCreateBy(userId);
        cycleUser.setUpdateBy(userId);
        cycleUser.setCreateTime(curDate);
        cycleUser.setUpdateTime(curDate);
        return cycleUser;
    }
}

