/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.service.impl;

import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.AutoPassType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.region.entity.RegionPlanAutoPassConfig;
import com.kuaike.scrm.dal.region.mapper.RegionPlanAutoPassConfigMapper;
import com.kuaike.scrm.regionplan.dto.AutoPassDto;
import com.kuaike.scrm.regionplan.service.RegionPlanAutoPassService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RegionPlanAutoPassServiceImpl
implements RegionPlanAutoPassService {
    private static final Logger log = LoggerFactory.getLogger(RegionPlanAutoPassServiceImpl.class);
    @Resource
    private RegionPlanAutoPassConfigMapper regionPlanAutoPassConfigMapper;

    @Override
    public void saveAutoPass(Long planId, Long planGroupId, Long planWorkCycleId, AutoPassDto autoPassDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        Date curDate = new Date();
        RegionPlanAutoPassConfig autoPassConfig = this.getRegionPlanAutoPass(corpId, planId, planGroupId, planWorkCycleId);
        if (autoPassConfig != null) {
            autoPassConfig.setAutoPass(autoPassDto.getIsAutoPass());
            autoPassConfig.setAutoPassType(autoPassDto.getType());
            if (autoPassDto.getType().intValue() == AutoPassType.TIME_PASS_TYPE.getValue()) {
                autoPassConfig.setPassStart(DateUtil.getDate((String)autoPassDto.getStartTime(), (String)"HH:mm"));
                autoPassConfig.setPassEnd(DateUtil.getDate((String)autoPassDto.getEndTime(), (String)"HH:mm"));
            }
            autoPassConfig.setUpdateBy(userInfo.getId());
            autoPassConfig.setUpdateTime(curDate);
            this.regionPlanAutoPassConfigMapper.updateByPrimaryKeySelective((Object)autoPassConfig);
        } else {
            autoPassConfig = new RegionPlanAutoPassConfig();
            autoPassConfig.setBizId(bizId);
            autoPassConfig.setCorpId(corpId);
            autoPassConfig.setPlanId(planId);
            autoPassConfig.setPlanGroupId(planGroupId);
            autoPassConfig.setPlanWorkCycleId(planWorkCycleId);
            autoPassConfig.setAutoPass(autoPassDto.getIsAutoPass());
            autoPassConfig.setAutoPassType(autoPassDto.getType());
            if (autoPassDto.getType().intValue() == AutoPassType.TIME_PASS_TYPE.getValue()) {
                autoPassConfig.setPassStart(DateUtil.getDate((String)autoPassDto.getStartTime(), (String)"HH:mm"));
                autoPassConfig.setPassEnd(DateUtil.getDate((String)autoPassDto.getEndTime(), (String)"HH:mm"));
            }
            autoPassConfig.setCreateBy(userInfo.getId());
            autoPassConfig.setUpdateBy(userInfo.getId());
            autoPassConfig.setUpdateTime(curDate);
            autoPassConfig.setCreateTime(curDate);
            autoPassConfig.setIsDeleted(Integer.valueOf(0));
            this.regionPlanAutoPassConfigMapper.insertSelective((Object)autoPassConfig);
        }
    }

    @Override
    public RegionPlanAutoPassConfig getRegionPlanAutoPass(String corpId, Long planId, Long planGroupId, Long planWorkCycleId) {
        return this.regionPlanAutoPassConfigMapper.queryAutoPassConfig(corpId, planId, planGroupId, planWorkCycleId);
    }

    @Override
    public AutoPassDto getAutoPassConfig(String corpId, Long planId, Long planGroupId, Long planWorkCycleId) {
        RegionPlanAutoPassConfig autoPassConfig = this.getRegionPlanAutoPass(corpId, planId, planGroupId, planWorkCycleId);
        if (autoPassConfig == null) {
            log.info("auto pass config corpId: {}, planId: {}, planGroupId: {}, planWorkCycleId: {}", new Object[]{corpId, planId, planGroupId, planWorkCycleId});
            return null;
        }
        AutoPassDto autoPassDto = new AutoPassDto();
        autoPassDto.setIsAutoPass(autoPassConfig.getAutoPass());
        autoPassDto.setType(autoPassConfig.getAutoPassType());
        if (autoPassDto.getType().intValue() == AutoPassType.TIME_PASS_TYPE.getValue()) {
            autoPassDto.setStartTime(DateUtil.dateToDateString((Date)autoPassConfig.getPassStart(), (String)"HH:mm"));
            autoPassDto.setEndTime(DateUtil.dateToDateString((Date)autoPassConfig.getPassEnd(), (String)"HH:mm"));
        }
        return autoPassDto;
    }

    @Override
    public int curCycleAutoPass(String corpId, Long planId, Long planGroupId, Long planWorkCycleId) {
        RegionPlanAutoPassConfig autoPassConfig = this.getRegionPlanAutoPass(corpId, planId, planGroupId, planWorkCycleId);
        Date curTime = DateUtil.getDate((String)DateUtil.dateToDateString((Date)new Date(), (String)"HH:mm"), (String)"HH:mm");
        if (autoPassConfig == null) {
            return 1;
        }
        if (autoPassConfig.getAutoPass() == 0) {
            return 0;
        }
        if (autoPassConfig.getAutoPassType().intValue() == AutoPassType.DAY_PASS_TYPE.getValue()) {
            return 1;
        }
        if (autoPassConfig.getAutoPassType().intValue() == AutoPassType.TIME_PASS_TYPE.getValue()) {
            if (autoPassConfig.getPassStart().compareTo(curTime) <= 0 && autoPassConfig.getPassEnd().after(curTime)) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    @Override
    public void delCycleAutoPass(String corpId, Long planId, Long planGroupId, String planWorkCycleNum, Long userId) {
        this.regionPlanAutoPassConfigMapper.delCycleAutoPassByWorkCycleNum(corpId, planId, planGroupId, planWorkCycleNum, userId);
    }
}

