/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import cn.kinyun.wework.sdk.api.external.ContactWayClient;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.DeptModMsgType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.dto.DepartmentModMsg;
import com.kuaike.scrm.common.service.dto.UserModDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.marketing.dto.PlanGroupQrcodeDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroup;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroupUser;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.entity.MarketingRefreshQrcodeTask;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRefreshQrcodeTaskMapper;
import com.kuaike.scrm.dal.region.entity.RegionPlanQrcodeUser;
import com.kuaike.scrm.dal.region.mapper.RegionPlanQrcodeUserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.marketing.dto.ConfigQrcodeError;
import com.kuaike.scrm.marketing.dto.MarketingCacheDto;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.dto.client.MarketingGroupInfoDto;
import com.kuaike.scrm.marketing.enums.MarketingAllocType;
import com.kuaike.scrm.marketing.service.MarketingAllocService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.regionplan.service.RegionPlanAutoPassService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingQrcodeServiceImp
implements MarketingQrcodeService {
    private static final Logger log = LoggerFactory.getLogger(MarketingQrcodeServiceImp.class);
    @Value(value="${kafka.topic.task_config_contact_way}")
    private String configContactWayTaskTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private RegionPlanQrcodeUserMapper regionPlanQrcodeUserMapper;
    @Resource
    private MarketingPlanGroupMapper marketingPlanGroupMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ContactWayClient contactWayClient;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private MarketingRefreshQrcodeTaskMapper marketingRefreshQrcodeTaskMapper;
    @Autowired
    private OrgService orgService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    private final ExecutorService executeService = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(128), (ThreadFactory)new NamedThreadFactory("refreshQrcodeTask"), new ThreadPoolExecutor.DiscardPolicy());
    @Resource
    private MarketingAllocService marketingAllocService;
    @Autowired
    private RegionPlanAutoPassService regionPlanAutoPassService;

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public List<MarketingGroupInfoDto> queryPlanGroupInfo(Long planId, Long channelId) {
        List groups = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(planId);
        if (CollectionUtils.isEmpty((Collection)groups)) {
            log.error("queryPlanGroupInfo,groups is empty,planId:{}", (Object)planId);
            return Collections.emptyList();
        }
        HashSet<Long> noAllocTypeGroupIds = new HashSet<Long>();
        HashMap<Long, String> haveAllocTypeGroupIds = new HashMap<Long, String>();
        for (MarketingPlanGroup group : groups) {
            Integer allocType = group.getAllocType();
            MarketingAllocType marketingAllocType = MarketingAllocType.get(allocType);
            if (marketingAllocType == null || MarketingAllocType.NO_ALLOC.equals((Object)marketingAllocType)) {
                noAllocTypeGroupIds.add(group.getId());
                continue;
            }
            haveAllocTypeGroupIds.put(group.getId(), group.getName());
        }
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(noAllocTypeGroupIds)) {
            List list = this.marketingQrcodeMapper.getNoAllocTypePlanGroupQrcodeInfo(planId, channelId, noAllocTypeGroupIds);
            for (PlanGroupQrcodeDto groupQrcodeDto : list) {
                MarketingGroupInfoDto groupInfoDto = new MarketingGroupInfoDto();
                groupInfoDto.setId(groupQrcodeDto.getState());
                groupInfoDto.setName(groupQrcodeDto.getName());
                result.add(groupInfoDto);
            }
        }
        if (!haveAllocTypeGroupIds.isEmpty()) {
            for (Map.Entry entry : haveAllocTypeGroupIds.entrySet()) {
                Long groupId = (Long)entry.getKey();
                String name = (String)entry.getValue();
                String allocState = this.getQrcodeStateFromAllocCache(planId, groupId);
                if (StringUtils.isBlank((CharSequence)allocState)) {
                    log.error("queryPlanGroupInfo,allocState is blank,groupId:{}", (Object)groupId);
                    continue;
                }
                MarketingGroupInfoDto groupInfoDto = new MarketingGroupInfoDto();
                groupInfoDto.setId(allocState);
                groupInfoDto.setName(name);
                result.add(groupInfoDto);
            }
        }
        return result;
    }

    private String getQrcodeStateFromAllocCache(Long planId, Long groupId) {
        MarketingCacheDto redisAllocCache;
        if (planId == null) {
            return null;
        }
        if (groupId == null) {
            return null;
        }
        log.info("getQrcodeStateFromAllocCache,planId:{},groupId:{}", (Object)planId, (Object)groupId);
        try {
            redisAllocCache = this.marketingAllocService.getRedisAllocCache(planId, groupId);
        }
        catch (Exception e) {
            log.error("getQrcodeStateFromAllocCache,marketingAllocService.getRedisAllocCache error", (Throwable)e);
            return null;
        }
        if (redisAllocCache == null) {
            log.error("getQrcodeStateFromAllocCache,redisAllocCache is null");
            return null;
        }
        log.info("getQrcodeStateFromAllocCache,planId:{},groupId:{},redisAllocCache:{}", new Object[]{planId, groupId, redisAllocCache});
        Long groupUserId = redisAllocCache.getGroupUserId();
        if (groupUserId == null) {
            log.error("getQrcodeStateFromAllocCache,redisAllocCache groupUserId is null");
            return null;
        }
        return this.marketingQrcodeMapper.queryStateByGroupUserId(groupUserId);
    }

    @Override
    public String getQrcode(ClientParamsDto params) {
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u6d3b\u52a8\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setState(num);
        marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectOne((Object)marketingQrcode);
        if (marketingQrcode == null || marketingQrcode.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6e20\u9053\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664");
        }
        return marketingQrcode.getQrCodeUrl();
    }

    @Override
    public void saveMarketingQrcode(Long bizId, String corpId, Long userId, Long planId, Set<Long> planGroupIds) {
        List groupList = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(planId);
        MarketingPlanGroupUser query = new MarketingPlanGroupUser();
        query.setPlanId(planId);
        query.setIsDeleted(Integer.valueOf(0));
        List groupUserList = this.marketingPlanGroupUserMapper.select((Object)query);
        HashMap<Long, ArrayList> groupUserMap = new HashMap<Long, ArrayList>();
        for (MarketingPlanGroupUser groupUser : groupUserList) {
            if (groupUserMap.containsKey(groupUser.getPlanGroupId())) {
                ((List)groupUserMap.get(groupUser.getPlanGroupId())).add(groupUser);
                continue;
            }
            groupUserMap.put(groupUser.getPlanGroupId(), Lists.newArrayList((Object[])new MarketingPlanGroupUser[]{groupUser}));
        }
        List marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        Map<String, Long> qrcodeMap = this.getMarketingQrCodeMap(planId);
        ArrayList adds = Lists.newArrayList();
        Collection<Long> dels = null;
        for (MarketingChannel channel : marketingChannels) {
            for (MarketingPlanGroup group : groupList) {
                Integer allocType = group.getAllocType();
                if (allocType == null || allocType == MarketingAllocType.NO_ALLOC.getType()) {
                    String key = channel.getChannelId() + "-" + group.getId();
                    if (!qrcodeMap.containsKey(key)) {
                        MarketingQrcode marketingQrcode = this.buildMarketingQrcode(bizId, corpId, planId, channel.getChannelId(), group.getId(), null, userId);
                        adds.add(marketingQrcode);
                        continue;
                    }
                    qrcodeMap.remove(key);
                    continue;
                }
                if (allocType != MarketingAllocType.WEIGHT.getType()) continue;
                List groupUsers = (List)groupUserMap.get(group.getId());
                for (MarketingPlanGroupUser groupUser : groupUsers) {
                    String key = channel.getChannelId() + "-" + group.getId() + "-" + groupUser.getId();
                    if (!qrcodeMap.containsKey(key)) {
                        MarketingQrcode marketingQrcode = this.buildMarketingQrcode(bizId, corpId, planId, channel.getChannelId(), group.getId(), groupUser.getId(), userId);
                        adds.add(marketingQrcode);
                        continue;
                    }
                    qrcodeMap.remove(key);
                }
            }
        }
        dels = qrcodeMap.values();
        if (CollectionUtils.isNotEmpty(planGroupIds)) {
            this.marketingQrcodeMapper.updateMarktingQrcodeByGroup(userId, planId, planGroupIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)adds)) {
            Lists.partition((List)adds, (int)100).forEach(list -> this.marketingQrcodeMapper.batchInsert((Collection)list));
        }
        if (CollectionUtils.isNotEmpty(dels)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByIds(userId, dels);
        }
    }

    @Override
    public void saveMarketingQrcode(Long bizId, String corpId, Long userId, Long planId, boolean weworkUserChange) {
        List marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        List marketingQrcodes = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(planId);
        HashMap qrcodeMap = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : marketingQrcodes) {
            qrcodeMap.put(marketingQrcode.getChannelId(), marketingQrcode.getId());
        }
        ArrayList adds = Lists.newArrayList();
        for (MarketingChannel channel : marketingChannels) {
            Long channelId = channel.getChannelId();
            if (qrcodeMap.containsKey(channelId)) continue;
            adds.add(this.buildMarketingQrcode(bizId, corpId, planId, channelId, -1L, null, userId));
        }
        if (CollectionUtils.isNotEmpty((Collection)adds)) {
            Lists.partition((List)adds, (int)100).forEach(list -> this.marketingQrcodeMapper.batchInsert((Collection)list));
        }
        if (weworkUserChange && CollectionUtils.isNotEmpty((Collection)marketingQrcodes)) {
            this.marketingQrcodeMapper.updateMarktingQrcodeByGroup(userId, planId, (Collection)Lists.newArrayList((Object[])new Long[]{-1L}));
        }
    }

    private MarketingQrcode buildMarketingQrcode(Long bizId, String corpId, Long planId, Long channelId, Long planGroupId, Long planGroupUserId, Long userId) {
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setBizId(bizId);
        marketingQrcode.setCorpId(corpId);
        marketingQrcode.setPlanId(planId);
        marketingQrcode.setState(this.idGen.getNum());
        marketingQrcode.setChannelId(channelId);
        marketingQrcode.setPlanGroupId(planGroupId);
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        marketingQrcode.setIsDeleted(Integer.valueOf(0));
        marketingQrcode.setIsSync(Integer.valueOf(0));
        marketingQrcode.setCreateBy(userId);
        marketingQrcode.setCreateTime(new Date());
        marketingQrcode.setUpdateBy(userId);
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setPlanGroupUserId(planGroupUserId);
        return marketingQrcode;
    }

    private Map<String, Long> getMarketingQrCodeMap(Long planId) {
        List marketingQrcodes = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(planId);
        HashMap qrcodeMap = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : marketingQrcodes) {
            String key = marketingQrcode.getChannelId() + "-" + marketingQrcode.getPlanGroupId();
            if (marketingQrcode.getPlanGroupUserId() != null) {
                key = marketingQrcode.getChannelId() + "-" + marketingQrcode.getPlanGroupId() + "-" + marketingQrcode.getPlanGroupUserId();
            }
            qrcodeMap.put(key, marketingQrcode.getId());
        }
        return qrcodeMap;
    }

    @Override
    public void delMarketingQrcodeByGroup(Long userId, Long planId, Set<Long> planGroupIds) {
        if (CollectionUtils.isNotEmpty(planGroupIds)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByGroup(userId, planId, planGroupIds);
        }
    }

    @Override
    public void delMarketingQrcodeByChannel(Long userId, Long planId, Set<Long> channelIds) {
        if (CollectionUtils.isNotEmpty(channelIds)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByChannel(userId, planId, channelIds);
        }
    }

    @Override
    public void delMarketingQrcodeByPlan(Long userId, Long planId) {
        this.marketingQrcodeMapper.delMarketingQrcodeByPlan(userId, planId);
    }

    @Override
    @Transactional
    public void configQrcode(MarketingQrcode marketingQrcode) {
        Long planId = marketingQrcode.getPlanId();
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (marketingPlan.getType().intValue() == PlanType.CHANNEL_PLAN.getValue() || marketingPlan.getType().intValue() == PlanType.FRIEND_FISSION_PLAN.getValue()) {
            this.handConfigChannelPlan(marketingQrcode);
        } else if (marketingPlan.getType().intValue() == PlanType.REGION_PLAN.getValue()) {
            this.handConfigRegionPlan(marketingQrcode);
        }
    }

    private void handConfigChannelPlan(MarketingQrcode marketingQrcode) {
        if (marketingQrcode.getIsDeleted() == 1) {
            this.delQrcode(marketingQrcode);
        } else if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            this.updateQrcode(marketingQrcode);
        } else {
            this.addQrcode(marketingQrcode);
        }
    }

    private void handConfigRegionPlan(MarketingQrcode marketingQrcode) {
        if (marketingQrcode.getIsDeleted() == 1) {
            log.info("marketingQrcodeId: {}, configId: {}", (Object)marketingQrcode.getId(), (Object)marketingQrcode.getQrConfigId());
            this.delQrcode(marketingQrcode);
        } else if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            this.updateRegionQrcode(marketingQrcode);
        } else {
            this.addRegionQrcode(marketingQrcode);
        }
    }

    @Override
    public MarketingQrcode getMarketingQrcode(Long bizId, String corpId, String state) {
        return this.marketingQrcodeMapper.queryMarketingQrcodeByState(bizId, corpId, state);
    }

    @Override
    public void sendNotSyncQrCodeToKafka(Long planId) {
        List ids = this.marketingQrcodeMapper.queryMarketingQrcodeIdByPlan(planId);
        log.info("sync qrcode ids: {}", (Object)ids);
        for (Long id : ids) {
            this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)Long.toString(id), (Object)Long.toString(id));
        }
    }

    @Override
    public void resetMarketQrcodeByPlan(Long bizId, String corpId, Long userId, Long planId) {
        this.saveMarketingQrcode(bizId, corpId, userId, planId, Sets.newHashSet());
    }

    @Override
    public List<ConfigQrcodeError> getConfigQrcodeErrors(Long planId) {
        Map planGroupNameMap = this.marketingPlanGroupMapper.getPlanGroupNameMap(planId);
        List list = this.marketingQrcodeMapper.queryConfigQrcodeNotSync(planId);
        HashMap map = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : list) {
            String errorMsg;
            if (StringUtils.isEmpty((CharSequence)marketingQrcode.getSyncErrorMsg()) || !(errorMsg = marketingQrcode.getSyncErrorMsg()).contains(":")) continue;
            String[] errorArr = errorMsg.split(":");
            String errorCode = errorArr[0];
            if (map.containsKey(marketingQrcode.getPlanGroupId())) continue;
            ConfigQrcodeError qrcodeError = new ConfigQrcodeError();
            qrcodeError.setGroupName((String)planGroupNameMap.get(marketingQrcode.getPlanGroupId()));
            qrcodeError.setErrorMsg(this.getConfigErrorMsg(errorCode, errorArr[1]));
            map.put(marketingQrcode.getPlanGroupId(), qrcodeError);
        }
        return new ArrayList<ConfigQrcodeError>(map.values());
    }

    @Override
    public Map<String, MarketingQrcode> getPlanOfQrcode(String corpId, Long planId) {
        List list = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanIdAll(planId);
        HashMap result = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : list) {
            String key = MessageFormat.format("channelId:{0}-regionInfoId:{1}", marketingQrcode.getChannelId(), marketingQrcode.getRegionInfoId());
            result.put(key, marketingQrcode);
        }
        return result;
    }

    @Override
    public MarketingQrcode buildRegionQrcode(Long bizId, String corpId, Long planId, Long planGroupId, Long channelId, Long regionInfoId, Long userId) {
        Date curDate = new Date();
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setBizId(bizId);
        marketingQrcode.setCorpId(corpId);
        marketingQrcode.setPlanId(planId);
        marketingQrcode.setState(this.idGen.getNum());
        marketingQrcode.setChannelId(channelId);
        marketingQrcode.setPlanGroupId(planGroupId);
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        marketingQrcode.setIsDeleted(Integer.valueOf(0));
        marketingQrcode.setIsSync(Integer.valueOf(0));
        marketingQrcode.setCreateBy(userId);
        marketingQrcode.setCreateTime(curDate);
        marketingQrcode.setUpdateBy(userId);
        marketingQrcode.setUpdateTime(curDate);
        marketingQrcode.setRegionInfoId(regionInfoId);
        return marketingQrcode;
    }

    @Override
    public void updateQrcodeByDeptMod(DepartmentModMsg dto) {
        log.info("updateQrcodeByDeptMod: dto:{}", (Object)dto);
        if (dto == null) {
            log.error("updateQrcodeByDeptMod: \u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String corpId = dto.getCorpId();
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.error("updateQrcodeByDeptMod: \u6839\u636ecorpId\u67e5\u8be2bizId\u4e3a\u7a7a\uff0ccorpId:{}", (Object)corpId);
            return;
        }
        HashSet updatePlanIdSet = Sets.newHashSet();
        DeptModMsgType msgType = DeptModMsgType.get((int)dto.getMsgType());
        switch (msgType) {
            case UPDATE_USER: {
                Set<Long> userUpdatePlanIds = this.handleUserMod(bizId, dto.getUserList());
                log.info("updateQrcodeByDeptMod: \u5904\u7406\u7528\u6237\u53d8\u66f4, bizId:{}, userUpdatePlanIds:{}", (Object)bizId, (Object)updatePlanIdSet);
                if (!CollectionUtils.isNotEmpty(userUpdatePlanIds)) break;
                updatePlanIdSet.addAll(userUpdatePlanIds);
                break;
            }
            case DELETE_DEPT: {
                Set<Long> delDeptPlanIds = this.handleDeptDel(bizId, dto.getDelDeptIds());
                log.info("updateQrcodeByDeptMod: \u5904\u7406\u90e8\u95e8\u53d8\u66f4\uff0cbizId:{}, delDeptPlanIds:{}", (Object)bizId, delDeptPlanIds);
                if (!CollectionUtils.isNotEmpty(delDeptPlanIds)) break;
                updatePlanIdSet.addAll(delDeptPlanIds);
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)updatePlanIdSet)) {
            Lists.partition((List)Lists.newArrayList((Iterable)updatePlanIdSet), (int)300).forEach(planIds -> {
                log.info("updateQrcodeByDeptMod: \u66f4\u65b0\u6e20\u9053\u6d3b\u7801\uff0cbizId:{}, \u66f4\u65b0planIds:{}", (Object)bizId, planIds);
                Set qrcodeIds = this.marketingQrcodeMapper.queryMarketingQrcodeIdByPlanIds(bizId, (Collection)planIds);
                Set existQrcodeIds = this.marketingRefreshQrcodeTaskMapper.queryQrcodeIdsByBizId(bizId);
                Sets.SetView diffQrcodeIds = Sets.difference((Set)qrcodeIds, (Set)existQrcodeIds);
                log.info("updateQrcodeByDeptMod: \u66f4\u65b0\u6e20\u9053\u6d3b\u7801\uff0cbizId:{}, qrcodeIds:{},existQrcodeIds:{},diffQrcodeIds:{}", new Object[]{bizId, qrcodeIds, existQrcodeIds, diffQrcodeIds});
                ArrayList taskList = Lists.newArrayList();
                for (Long qrcodeId : diffQrcodeIds) {
                    MarketingRefreshQrcodeTask task = new MarketingRefreshQrcodeTask();
                    task.setBizId(bizId);
                    task.setIsDeleted(NumberUtils.INTEGER_ZERO);
                    task.setIsSync(NumberUtils.INTEGER_ZERO);
                    task.setCreateBy(Long.valueOf(-1L));
                    task.setCreateTime(new Date());
                    task.setUpdateBy(Long.valueOf(-1L));
                    task.setUpdateTime(new Date());
                    task.setMarketingQrcodeId(qrcodeId);
                    task.setSyncErrorMsg("");
                    taskList.add(task);
                }
                if (CollectionUtils.isNotEmpty((Collection)taskList)) {
                    this.marketingRefreshQrcodeTaskMapper.batchInsert((List)taskList);
                }
            });
        }
    }

    @Override
    public void refreshQrcodeTask() {
        log.info("refreshQrcodeTask: ");
        List qrcodeIds = this.marketingRefreshQrcodeTaskMapper.queryNeedExecuteQrcodeIds();
        if (CollectionUtils.isEmpty((Collection)qrcodeIds)) {
            log.info("refreshQrcodeTask: \u65e0\u9700\u8981\u66f4\u65b0\u7684\u4e8c\u7ef4\u7801");
            return;
        }
        Lists.partition((List)qrcodeIds, (int)200).forEach(ids -> this.executeService.execute(() -> {
            try {
                this.doRefreshQrcode((List<Long>)ids);
            }
            catch (Exception e) {
                log.error("refreshQrcodeTask: \u5f02\u5e38, ids:{}, e = ", ids, (Object)e);
            }
        }));
    }

    private void doRefreshQrcode(List<Long> ids) {
        List qrcodeList = this.marketingQrcodeMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)qrcodeList)) {
            log.info("refreshQrcodeTask: qrcodeList\u4e3a\u7a7a, ids:{}", ids);
            this.marketingRefreshQrcodeTaskMapper.updateSyncByQrcodeIds(ids, "\u4e8c\u7ef4\u7801\u5df2\u88ab\u5220\u9664");
            return;
        }
        HashSet addQrcodeIds = Sets.newHashSet();
        HashSet updateQrcodeIds = Sets.newHashSet();
        for (MarketingQrcode marketingQrcode : qrcodeList) {
            Long qrcodeId = marketingQrcode.getId();
            try {
                if (StringUtils.isBlank((CharSequence)marketingQrcode.getQrConfigId())) {
                    this.addQrcode(marketingQrcode);
                    addQrcodeIds.add(qrcodeId);
                    continue;
                }
                this.updateQrcode(marketingQrcode);
                updateQrcodeIds.add(qrcodeId);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5931\u8d25, bizId:{}, qrcodeId:{}, planId:{}, planGroupId:{}", new Object[]{marketingQrcode.getBizId(), qrcodeId, marketingQrcode.getPlanId(), marketingQrcode.getPlanGroupId()});
                this.marketingRefreshQrcodeTaskMapper.updateSyncByQrcodeIds((Collection)Lists.newArrayList((Object[])new Long[]{qrcodeId}), e.getMessage());
            }
        }
        log.info("refreshQrcodeTask: ids:{}, addQrcodeIds:{}, updateQrcodeIds:{}", new Object[]{ids, addQrcodeIds, updateQrcodeIds});
        if (CollectionUtils.isNotEmpty((Collection)addQrcodeIds)) {
            this.marketingRefreshQrcodeTaskMapper.updateSyncByQrcodeIds((Collection)addQrcodeIds, "configId\u4e3a\u7a7a\uff0c\u751f\u6210\u4e8c\u7ef4\u7801");
        }
        if (CollectionUtils.isNotEmpty((Collection)updateQrcodeIds)) {
            this.marketingRefreshQrcodeTaskMapper.updateSyncByQrcodeIds((Collection)updateQrcodeIds, "");
        }
    }

    private Set<Long> handleUserMod(Long bizId, List<UserModDto> userList) {
        log.info("handleUserMod: bizId:{}, userList:{}", (Object)bizId, userList);
        if (CollectionUtils.isEmpty(userList)) {
            log.info("handleUserMod: userList\u4e3a\u7a7a\uff0cbizId:{}", (Object)bizId);
            return Sets.newHashSet();
        }
        HashSet allDeptIds = Sets.newHashSet();
        for (UserModDto userModDto : userList) {
            if (CollectionUtils.isNotEmpty((Collection)userModDto.getAddDeptIds())) {
                allDeptIds.addAll(userModDto.getAddDeptIds());
            }
            if (!CollectionUtils.isNotEmpty((Collection)userModDto.getDelDeptIds())) continue;
            allDeptIds.addAll(userModDto.getDelDeptIds());
        }
        Set<Long> allParentOrgIds = this.toParentOrgIds(bizId, allDeptIds);
        if (CollectionUtils.isEmpty(allParentOrgIds)) {
            log.info("handleUserMod: allParentOrgIds\u4e3a\u7a7a\uff0cbizId:{}, allDeptIds:{}", (Object)bizId, (Object)allDeptIds);
            return Sets.newHashSet();
        }
        List planIds = this.marketingPlanGroupUserMapper.queryPlanIdByOrgId(bizId, allParentOrgIds);
        log.info("handleUserMod: bizId:{}, allParentOrgIds:{}, planIds:{}", new Object[]{bizId, allParentOrgIds, planIds});
        return Sets.newHashSet((Iterable)planIds);
    }

    private Set<Long> handleDeptDel(Long bizId, Collection<Integer> delDeptIds) {
        log.info("handleDeptDel: bizId:{}, delDeptIds:{}", (Object)bizId, delDeptIds);
        if (CollectionUtils.isEmpty(delDeptIds)) {
            log.info("handleDeptDel: delDeptIds\u4e3a\u7a7a\uff0cbizId:{}", (Object)bizId);
            return Sets.newHashSet();
        }
        Set<Long> delParentOrgIds = this.toParentOrgIds(bizId, Sets.newHashSet(delDeptIds));
        if (CollectionUtils.isEmpty(delParentOrgIds)) {
            log.info("handleDeptDel: delParentOrgIds\u4e3a\u7a7a\uff0cbizId:{}, delDeptIds:{}", (Object)bizId, delDeptIds);
            return Sets.newHashSet();
        }
        List planIds = this.marketingPlanGroupUserMapper.queryPlanIdByOrgId(bizId, delParentOrgIds);
        log.info("handleDeptDel: bizId:{}, allParentOrgIds:{}, planIds:{}", new Object[]{bizId, delParentOrgIds, planIds});
        return Sets.newHashSet((Iterable)planIds);
    }

    private Set<Long> toParentOrgIds(Long bizId, Set<Integer> deptIds) {
        if (CollectionUtils.isEmpty(deptIds)) {
            return Sets.newHashSet();
        }
        HashSet resultSet = Sets.newHashSet();
        List orgIds = this.organizationMapper.queryOrgIdByDepartmentIds(bizId, deptIds);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            log.info("toParentOrgIds: orgIds\u4e3a\u7a7a, bizId:{}, deptIds:{}", (Object)bizId, deptIds);
            return Sets.newHashSet();
        }
        for (Long orgId : orgIds) {
            resultSet.add(orgId);
            List parentOrgIds = this.orgService.getParentNodeIdsByBizIdAndNodeId(bizId, orgId);
            if (!CollectionUtils.isNotEmpty((Collection)parentOrgIds)) continue;
            resultSet.addAll(orgIds);
        }
        return resultSet;
    }

    private String getConfigErrorMsg(String errorCode, String errorMsg) {
        String result = errorMsg;
        if (errorCode.equals("error(40098)")) {
            result = "\u5b58\u5728\u6210\u5458\u6ca1\u5b9e\u540d";
        } else if (errorCode.equals("error(41054)")) {
            result = "\u5b58\u5728\u6210\u5458\u6ca1\u6fc0\u6d3b";
        }
        return result;
    }

    private void delQrcode(MarketingQrcode marketingQrcode) {
        log.info("delQrcode params configId: {}, id: ", (Object)marketingQrcode.getQrConfigId(), (Object)marketingQrcode.getId());
        if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            this.contactWayClient.delete(marketingQrcode.getCorpId(), marketingQrcode.getQrConfigId());
        }
        marketingQrcode.setIsDeleted(Integer.valueOf(1));
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void addQrcode(MarketingQrcode marketingQrcode) {
        log.info("addQrcode params: {}", (Object)marketingQrcode);
        ContactWay contactWayConfig = new ContactWay();
        int autoPass = this.regionPlanAutoPassService.curCycleAutoPass(marketingQrcode.getCorpId(), marketingQrcode.getPlanId(), -1L, null);
        contactWayConfig.setType(Integer.valueOf(2));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setSkipVerify(Objects.equals(autoPass, 1));
        contactWayConfig.setState(marketingQrcode.getState());
        List<String> weworkUserIds = this.getQrcodeUserIds(marketingQrcode);
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return;
        }
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        ConfigIdResp configIdResp = this.contactWayClient.create(marketingQrcode.getCorpId(), contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl(configIdResp.getQrCode());
        marketingQrcode.setQrConfigId(configIdResp.getConfigId());
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
        this.saveQrcodeAutoPass(marketingQrcode, autoPass);
    }

    private void updateQrcode(MarketingQrcode marketingQrcode) {
        log.info("updateQrcode params: {}", (Object)marketingQrcode);
        if (StringUtils.isBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            log.warn("updateQrcode qrconfigid is null");
            return;
        }
        ContactWay contactWayConfig = new ContactWay();
        List<String> weworkUserIds = this.getQrcodeUserIds(marketingQrcode);
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("updateQrcode weworkUserIds is null");
            return;
        }
        int autoPass = this.regionPlanAutoPassService.curCycleAutoPass(marketingQrcode.getCorpId(), marketingQrcode.getPlanId(), -1L, null);
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setSkipVerify(Objects.equals(autoPass, 1));
        contactWayConfig.setConfigId(marketingQrcode.getQrConfigId());
        this.contactWayClient.update(marketingQrcode.getCorpId(), contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setSyncErrorMsg("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
        this.saveQrcodeAutoPass(marketingQrcode, autoPass);
    }

    private List<String> getQrcodeUserIds(MarketingQrcode marketingQrcode) {
        MarketingPlanGroup group = (MarketingPlanGroup)this.marketingPlanGroupMapper.selectByPrimaryKey((Object)marketingQrcode.getPlanGroupId());
        boolean sysAlloc = false;
        if (group != null && group.getAllocType() != null && group.getAllocType() == MarketingAllocType.WEIGHT.getType()) {
            sysAlloc = true;
        }
        List<String> weworkUserIds = Lists.newArrayList();
        if (!sysAlloc) {
            weworkUserIds = this.marketingPlanGroupUserMapper.queryGroupUserIds(marketingQrcode.getPlanId(), marketingQrcode.getPlanGroupId());
            Set<String> userIdByOrgId = this.getUserByPlan(marketingQrcode.getBizId(), marketingQrcode.getCorpId(), marketingQrcode.getPlanId(), marketingQrcode.getPlanGroupId());
            if (CollectionUtils.isNotEmpty(userIdByOrgId)) {
                weworkUserIds.addAll(userIdByOrgId);
            }
        } else {
            Set<String> userIdByOrgId;
            Long planGroupUserId = marketingQrcode.getPlanGroupUserId();
            MarketingPlanGroupUser groupUser = (MarketingPlanGroupUser)this.marketingPlanGroupUserMapper.selectByPrimaryKey((Object)planGroupUserId);
            if (groupUser != null && StringUtils.isNotBlank((CharSequence)groupUser.getWeworkUserNum())) {
                String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(groupUser.getWeworkUserNum());
                weworkUserIds.add(weworkUserId);
            } else if (groupUser != null && groupUser.getOrgId() != 0L && CollectionUtils.isNotEmpty(userIdByOrgId = this.getOrgUser(marketingQrcode.getBizId(), marketingQrcode.getCorpId(), groupUser.getOrgId()))) {
                weworkUserIds.addAll(userIdByOrgId);
            }
        }
        log.info("qrcodeId: {} weworkUserIds: {}", (Object)marketingQrcode.getId(), (Object)weworkUserIds);
        return weworkUserIds;
    }

    private Set<String> getUserByPlan(Long bizId, String corpId, Long planId, Long planGroupId) {
        List orgIds = this.marketingPlanGroupUserMapper.queryGroupOrgIds(planId, planGroupId);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            log.info("getUserByPlan: bizId:{}, planId:{}, planGroupId:{}", new Object[]{bizId, planId, planGroupId});
            return Sets.newHashSet();
        }
        Set subOrgIds = this.nodeService.getPosterityIds((Collection)orgIds, bizId);
        Set deptIds = this.orgService.getDepartmentIds(subOrgIds);
        Set userIdsByDeptIds = this.weworkDepartmentUserMapper.selectWeworkUserId(corpId, (Collection)deptIds);
        log.info("getUserByPlan: bizId:{}, planId:{}, planGroupId:{}, orgIds:{}, deptIds:{}, userIdsByDeptIds:{}", new Object[]{bizId, planId, planGroupId, orgIds, deptIds, userIdsByDeptIds});
        return userIdsByDeptIds;
    }

    private Set<String> getOrgUser(Long bizId, String corpId, Long orgId) {
        Set subOrgIds = this.nodeService.getPosterityIds((Collection)Sets.newHashSet((Object[])new Long[]{orgId}), bizId);
        Set deptIds = this.orgService.getDepartmentIds(subOrgIds);
        Set userIdsByDeptIds = this.weworkDepartmentUserMapper.selectWeworkUserId(corpId, (Collection)deptIds);
        log.info("getUserByPlan: bizId:{} orgId:{}, deptIds:{}, userIdsByDeptIds:{}", new Object[]{bizId, orgId, deptIds, userIdsByDeptIds});
        return userIdsByDeptIds;
    }

    private void updateRegionQrcode(MarketingQrcode marketingQrcode) {
        Long qrcodeId;
        Long planId;
        Map userMap;
        List<String> weworkUserIds;
        log.info("update region qrcode params: {}", (Object)JSON.toJSONString((Object)marketingQrcode));
        if (StringUtils.isBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            log.warn("update region qrcode configId is null");
            return;
        }
        String corpId = marketingQrcode.getCorpId();
        if (this.containDisableUser(corpId, weworkUserIds = (userMap = this.regionPlanQrcodeUserMapper.queryPlanCurQrcodeUserMap(corpId, planId = marketingQrcode.getPlanId(), qrcodeId = marketingQrcode.getId())).keySet().stream().collect(Collectors.toList()))) {
            log.info("not update qy qrcode marketingQrcodeId: {}", (Object)marketingQrcode.getId());
            return;
        }
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("update region qrcode weworkUserIds is null");
            return;
        }
        Integer autoPass = (Integer)userMap.get(weworkUserIds.get(0));
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setConfigId(marketingQrcode.getQrConfigId());
        contactWayConfig.setSkipVerify(Objects.equals(autoPass, 1));
        this.contactWayClient.update(marketingQrcode.getCorpId(), contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setSyncErrorMsg("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private boolean containDisableUser(String corpId, List<String> weworkUserIds) {
        List weworkUserList = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserIds);
        boolean result = false;
        String disableWeworkUserId = null;
        for (WeworkUser weworkUser : weworkUserList) {
            if (weworkUser.getEnableQrcode() == 1) continue;
            result = true;
            disableWeworkUserId = weworkUser.getWeworkUserId();
            log.info("not update qy qrcode, disableWeworkUserId: {}", (Object)disableWeworkUserId);
            break;
        }
        return result;
    }

    private void addRegionQrcode(MarketingQrcode marketingQrcode) {
        log.info("addRegionQrcode params: {}", (Object)marketingQrcode);
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setType(Integer.valueOf(2));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(marketingQrcode.getState());
        Map userMap = this.regionPlanQrcodeUserMapper.queryPlanCurQrcodeUserMap(marketingQrcode.getCorpId(), marketingQrcode.getPlanId(), marketingQrcode.getId());
        List<String> weworkUserIds = userMap.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return;
        }
        if (this.containDisableUser(marketingQrcode.getCorpId(), weworkUserIds)) {
            log.info("not update qy qrcode marketingQrcodeId: {}", (Object)marketingQrcode.getId());
            return;
        }
        Integer autoPass = (Integer)userMap.get(weworkUserIds.get(0));
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        contactWayConfig.setSkipVerify(Objects.equals(autoPass, 1));
        ConfigIdResp configIdResp = this.contactWayClient.create(marketingQrcode.getCorpId(), contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl(configIdResp.getQrCode());
        marketingQrcode.setQrConfigId(configIdResp.getConfigId());
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void saveQrcodeAutoPass(MarketingQrcode qrcode, Integer autoPass) {
        Date curTime = new Date();
        List regionPlanQrcodeUsers = this.regionPlanQrcodeUserMapper.queryPlanQrcodeUserList(qrcode.getCorpId(), qrcode.getPlanId(), qrcode.getId());
        if (CollectionUtils.isNotEmpty((Collection)regionPlanQrcodeUsers)) {
            RegionPlanQrcodeUser qrcodeUser = (RegionPlanQrcodeUser)regionPlanQrcodeUsers.get(0);
            if (!Objects.equals(qrcodeUser.getAutoPass(), autoPass)) {
                qrcodeUser.setAutoPass(autoPass);
                qrcodeUser.setUpdateBy(qrcode.getUpdateBy());
                qrcodeUser.setUpdateTime(curTime);
                this.regionPlanQrcodeUserMapper.updateByPrimaryKeySelective((Object)qrcodeUser);
            }
        } else {
            RegionPlanQrcodeUser qrcodeUser = new RegionPlanQrcodeUser();
            qrcodeUser.setBizId(qrcode.getBizId());
            qrcodeUser.setCorpId(qrcode.getCorpId());
            qrcodeUser.setPlanId(qrcode.getPlanId());
            qrcodeUser.setPlanQrcodeId(qrcode.getId());
            qrcodeUser.setAutoPass(autoPass);
            qrcodeUser.setWeworkUserNum("");
            qrcodeUser.setIsDeleted(Integer.valueOf(0));
            qrcodeUser.setUpdateBy(qrcode.getUpdateBy());
            qrcodeUser.setCreateBy(qrcode.getCreateBy());
            qrcodeUser.setUpdateTime(curTime);
            qrcodeUser.setCreateTime(curTime);
            this.regionPlanQrcodeUserMapper.insertSelective((Object)qrcodeUser);
        }
    }

    @Override
    public void refreshQrcodeAutoPass(MarketingQrcode qrcode) {
        log.info("refresh qrcode auto pass qrcode:{}", (Object)qrcode);
        List regionPlanQrcodeUsers = this.regionPlanQrcodeUserMapper.queryPlanQrcodeUserList(qrcode.getCorpId(), qrcode.getPlanId(), qrcode.getId());
        Integer beforeAutoPass = null;
        if (CollectionUtils.isEmpty((Collection)regionPlanQrcodeUsers)) {
            log.info("not found qrcode autopass config");
        } else {
            RegionPlanQrcodeUser qrcodeUser = (RegionPlanQrcodeUser)regionPlanQrcodeUsers.get(0);
            beforeAutoPass = qrcodeUser.getAutoPass();
        }
        Integer autoPass = this.regionPlanAutoPassService.curCycleAutoPass(qrcode.getCorpId(), qrcode.getPlanId(), -1L, null);
        if (!Objects.equals(beforeAutoPass, autoPass)) {
            qrcode.setIsSync(Integer.valueOf(0));
            qrcode.setUpdateTime(new Date());
            this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)qrcode);
            this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)Long.toString(qrcode.getId()), (Object)Long.toString(qrcode.getId()));
        }
    }
}

