/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.LongIdAndNameDto;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.marketing.enums.MarketingAllocType;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.util.CollectionUtils;

public class MarketingPlanGroupDto
extends BaseDto {
    private Long groupId;
    private String name;
    private List<String> weworkUserIds;
    private List<Long> deptIds;
    private List<String> weworkTagIds;
    private Integer isDeleted;
    private Integer allocType;
    private List<WeworkUserDto> weworkUserList;
    private List<LongIdAndNameDto> deptList;

    public void checkParams() {
        if (this.name == null) {
            this.name = "";
        }
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.weworkUserIds) || !CollectionUtils.isEmpty(this.deptIds) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u5206\u7ec4\u6210\u5458\u548c\u90e8\u95e8\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.weworkTagIds) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u5206\u7ec4\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.weworkUserIds == null) {
            this.weworkUserIds = Lists.newArrayList();
        }
        if (this.deptIds == null) {
            this.deptIds = Lists.newArrayList();
        }
        if (this.allocType != null) {
            MarketingAllocType marketingAllocType = MarketingAllocType.get(this.allocType);
            Preconditions.checkArgument((marketingAllocType != null ? 1 : 0) != 0, (Object)"\u5206\u914d\u6a21\u5f0f\u4e0d\u5b58\u5728");
            if (MarketingAllocType.WEIGHT.equals((Object)marketingAllocType)) {
                this.checkWeight();
            }
        }
    }

    public void checkWeight() {
        Integer weight;
        for (WeworkUserDto weworkUserDto : this.weworkUserList) {
            weight = weworkUserDto.getWeight();
            String nickname = weworkUserDto.getNickname();
            Preconditions.checkArgument((weight != null ? 1 : 0) != 0, (Object)(nickname + "\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a"));
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)(nickname + "\u6743\u91cd\u4e0d\u80fd\u5c0f\u4e8e1"));
        }
        for (LongIdAndNameDto longIdAndNameDto : this.deptList) {
            weight = longIdAndNameDto.getWeight();
            String deptName = longIdAndNameDto.getName();
            Preconditions.checkArgument((weight != null ? 1 : 0) != 0, (Object)(deptName + "\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a"));
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)(deptName + "\u6743\u91cd\u4e0d\u80fd\u5c0f\u4e8e1"));
        }
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getWeworkUserIds() {
        return this.weworkUserIds;
    }

    public List<Long> getDeptIds() {
        return this.deptIds;
    }

    public List<String> getWeworkTagIds() {
        return this.weworkTagIds;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getAllocType() {
        return this.allocType;
    }

    public List<WeworkUserDto> getWeworkUserList() {
        return this.weworkUserList;
    }

    public List<LongIdAndNameDto> getDeptList() {
        return this.deptList;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWeworkUserIds(List<String> weworkUserIds) {
        this.weworkUserIds = weworkUserIds;
    }

    public void setDeptIds(List<Long> deptIds) {
        this.deptIds = deptIds;
    }

    public void setWeworkTagIds(List<String> weworkTagIds) {
        this.weworkTagIds = weworkTagIds;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setAllocType(Integer allocType) {
        this.allocType = allocType;
    }

    public void setWeworkUserList(List<WeworkUserDto> weworkUserList) {
        this.weworkUserList = weworkUserList;
    }

    public void setDeptList(List<LongIdAndNameDto> deptList) {
        this.deptList = deptList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketingPlanGroupDto)) {
            return false;
        }
        MarketingPlanGroupDto other = (MarketingPlanGroupDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$allocType = this.getAllocType();
        Integer other$allocType = other.getAllocType();
        if (this$allocType == null ? other$allocType != null : !((Object)this$allocType).equals(other$allocType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$weworkUserIds = this.getWeworkUserIds();
        List<String> other$weworkUserIds = other.getWeworkUserIds();
        if (this$weworkUserIds == null ? other$weworkUserIds != null : !((Object)this$weworkUserIds).equals(other$weworkUserIds)) {
            return false;
        }
        List<Long> this$deptIds = this.getDeptIds();
        List<Long> other$deptIds = other.getDeptIds();
        if (this$deptIds == null ? other$deptIds != null : !((Object)this$deptIds).equals(other$deptIds)) {
            return false;
        }
        List<String> this$weworkTagIds = this.getWeworkTagIds();
        List<String> other$weworkTagIds = other.getWeworkTagIds();
        if (this$weworkTagIds == null ? other$weworkTagIds != null : !((Object)this$weworkTagIds).equals(other$weworkTagIds)) {
            return false;
        }
        List<WeworkUserDto> this$weworkUserList = this.getWeworkUserList();
        List<WeworkUserDto> other$weworkUserList = other.getWeworkUserList();
        if (this$weworkUserList == null ? other$weworkUserList != null : !((Object)this$weworkUserList).equals(other$weworkUserList)) {
            return false;
        }
        List<LongIdAndNameDto> this$deptList = this.getDeptList();
        List<LongIdAndNameDto> other$deptList = other.getDeptList();
        return !(this$deptList == null ? other$deptList != null : !((Object)this$deptList).equals(other$deptList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarketingPlanGroupDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $allocType = this.getAllocType();
        result = result * 59 + ($allocType == null ? 43 : ((Object)$allocType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $weworkUserIds = this.getWeworkUserIds();
        result = result * 59 + ($weworkUserIds == null ? 43 : ((Object)$weworkUserIds).hashCode());
        List<Long> $deptIds = this.getDeptIds();
        result = result * 59 + ($deptIds == null ? 43 : ((Object)$deptIds).hashCode());
        List<String> $weworkTagIds = this.getWeworkTagIds();
        result = result * 59 + ($weworkTagIds == null ? 43 : ((Object)$weworkTagIds).hashCode());
        List<WeworkUserDto> $weworkUserList = this.getWeworkUserList();
        result = result * 59 + ($weworkUserList == null ? 43 : ((Object)$weworkUserList).hashCode());
        List<LongIdAndNameDto> $deptList = this.getDeptList();
        result = result * 59 + ($deptList == null ? 43 : ((Object)$deptList).hashCode());
        return result;
    }

    public String toString() {
        return "MarketingPlanGroupDto(groupId=" + this.getGroupId() + ", name=" + this.getName() + ", weworkUserIds=" + this.getWeworkUserIds() + ", deptIds=" + this.getDeptIds() + ", weworkTagIds=" + this.getWeworkTagIds() + ", isDeleted=" + this.getIsDeleted() + ", allocType=" + this.getAllocType() + ", weworkUserList=" + this.getWeworkUserList() + ", deptList=" + this.getDeptList() + ")";
    }
}

