/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.utils;

import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.customerupdate.dto.ImportRow;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerUpdateImportUtil {
    private static final Logger log = LoggerFactory.getLogger(CustomerUpdateImportUtil.class);
    private static final int MAX_DATA_ROW = 5000;
    public static final int HEADER_ROW = 2;
    public static final int DATA_START_ROW = 3;
    public static final int REMARK_ROW = 0;
    public static final short REMARK_ROW_HEIGHT = 80;
    public static final short FONT_HEIGHT_IN_POINTS = 12;
    public static final short ROW_HEIGHT_IN_POINTS = 18;
    public static final int NAME_ROW = 2;
    public static final short COLUMN_WIDTH_IN_POINTS = 14;
    public static final int DATA_ROW = 3;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String WEWORK_CUSTOMER_UPDATE_REMARK = "\u8bf4\u660e\n1\u3001UnionID\u548c\u624b\u673a\u53f7\u4e3a\u7cbe\u786e\u5339\u914d\uff0cUnionID\u4f18\u5148\u5339\u914d\u3002\n2\u3001\u201c\u5ba2\u6237\u6807\u7b7e\u3001\u5ba2\u6237\u9636\u6bb5\u3001\u6570\u636e\u6e20\u9053\u201d \u9700\u786e\u8ba4\u7cfb\u7edf\u4e2d\u6709\u6b64\u6570\u636e\u8fdb\u884c\u5bf9\u5e94\uff0c\u5426\u5219\u65e0\u6cd5\u6210\u529f\u5bfc\u5165\u3002\u591a\u4e2a\u6807\u7b7e\u7528\u9017\u53f7\u9694\u5f00\u3002\n3\u3001\u4e92\u901a\u624b\u673a\u53f7\uff1a\u5982\u586b\u5199\u4f1a\u548c\u5bf9\u5e94unionID\u7684\u5fae\u4fe1\u5ba2\u6237\u8fdb\u884c\u4e92\u901a\u3002\uff08\u5982\u5339\u914d\u6761\u4ef6\u901a\u8fc7\u624b\u673a\u53f7\u5339\u914d\u5219\u65e0\u6cd5\u66f4\u65b0\u624b\u673a\u53f7\uff0c\u8bf7\u624b\u52a8\u5728\u7cfb\u7edf\u4e2d\u4fee\u6539\uff09";
    public static final String MOBILE_CUSTOMER_UPDATE_REMARK = "\u8bf4\u660e\n1\u3001\u624b\u673a\u53f7\u4e3a\u7cbe\u786e\u5339\u914d\uff0c\u91cd\u590d\u624b\u673a\u53f7\u4f1a\u8fc7\u6ee4\u3002\n2\u3001\u201c\u5ba2\u6237\u6807\u7b7e\u3001\u5ba2\u6237\u9636\u6bb5\u3001\u6570\u636e\u6e20\u9053\u201d \u9700\u786e\u8ba4\u7cfb\u7edf\u4e2d\u6709\u6b64\u6570\u636e\u8fdb\u884c\u5bf9\u5e94\uff0c\u5426\u5219\u65e0\u6cd5\u6210\u529f\u5bfc\u5165\u3002\u591a\u4e2a\u6807\u7b7e\u7528\u9017\u53f7\u9694\u5f00\u3002\n3\u3001\u7ed1\u5b9a\u4eba\uff1a\u9700\u548c\u201c\u4f01\u4e1a\u8bbe\u7f6e>\u7528\u6237\u89d2\u8272\u201d \u83dc\u5355\u4e2d\u7528\u6237\u7684\u201c\u552f\u4e00\u6807\u8bc6\u201d\u503c\u4fdd\u6301\u5bf9\u5e94\uff0c\u5426\u5219\u65e0\u6cd5\u6210\u529f\u66f4\u65b0\u3002\n4\u3001\u4e1a\u52a1\u4fe1\u606f\uff1a\u4e1a\u52a1\u4fe1\u606f\u5fc5\u987b\u8ddf\u5404\u4e2a\u4e1a\u52a1\u4fe1\u606f\u5b57\u6bb5\u683c\u5f0f\u76f8\u5339\u914d\uff0c\u5426\u5219\u65e0\u6cd5\u6210\u529f\u8fdb\u884c\u66f4\u65b0\u3002";
    public static final List<String> WEWORK_CUSTOMER_EXCEL_HEADER = Lists.newArrayList((Object[])new String[]{"UnionID", "\u624b\u673a\u53f7", "\u6807\u7b7e\u7ec4\u540d", "\u6807\u7b7e", "\u5907\u6ce8\u540d", "\u5ba2\u6237\u63cf\u8ff0", "\u5ba2\u6237\u9636\u6bb5", "\u6570\u636e\u6e20\u9053", "\u4e92\u901a\u624b\u673a\u53f7"});
    public static final List<String> MOBILE_CUSTOMER_EXCEL_FIXED_HEADER = Lists.newArrayList((Object[])new String[]{"\u624b\u673a\u53f7", "\u5ba2\u6237\u540d\u79f0", "\u6807\u7b7e\u7ec4\u540d", "\u6807\u7b7e", "\u7ed1\u5b9a\u4eba", "\u5ba2\u6237\u9636\u6bb5", "\u6570\u636e\u6e20\u9053"});
    public static final String CUSTOMER_UPDATE_IMPORT_RECORD_KEY = "customer_update_import_record_num_%s";
    public static final int CUSTOMER_UPDATE_IMPORT_RECORD_KEY_EXPIRE = 3600;
    public static final String DOT_SPLIT = ",|\uff0c";

    private CustomerUpdateImportUtil() {
    }

    public static List<ImportRow> scan(File file, Workbook workbook, Sheet sheet, int columnSize) {
        ArrayList data = Lists.newArrayList();
        int totalRows = 0;
        for (int row = 3; row <= sheet.getLastRowNum(); ++row) {
            List<Object> rowData = CustomerUpdateImportUtil.getRowData(sheet, row, columnSize);
            log.info("scan #{}:{}", (Object)row, rowData);
            if (CollectionUtils.isEmpty(rowData)) {
                log.warn("\u7f3a\u5c11\u6570\u636e #{}", (Object)row);
                continue;
            }
            if (++totalRows > 5000) {
                CustomerUpdateImportUtil.release(file, workbook);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6bcf\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u5f97\u8d85\u8fc75000\u884c!");
            }
            ImportRow importRow = new ImportRow();
            importRow.setIndex(row);
            importRow.setData(rowData);
            data.add(importRow);
        }
        return data;
    }

    public static void release(File file, Workbook workbook) {
        if (file != null && file.exists() && file.delete()) {
            log.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)file.getAbsolutePath());
        }
        if (workbook != null) {
            try {
                log.info("\u5173\u95ed\u5de5\u4f5c\u7c3f");
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("\u5173\u95ed\u5de5\u4f5c\u7c3f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static List<Object> getRowData(Sheet sheet, int index, int columnSize) {
        Row row = sheet.getRow(index);
        if (row == null) {
            return Collections.emptyList();
        }
        boolean isEmpty = true;
        ArrayList data = Lists.newArrayListWithCapacity((int)columnSize);
        for (int i = 0; i < columnSize; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                data.add(null);
                continue;
            }
            Object o = CustomerUpdateImportUtil.getCellValue(cell);
            data.add(o);
            if (o == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(o))) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            return Collections.emptyList();
        }
        return data;
    }

    private static Object getCellValue(Cell cell) {
        CellType cellType = cell.getCellType();
        if (cellType == null) {
            return null;
        }
        switch (cellType) {
            case STRING: 
            case _NONE: {
                return StringUtils.trim((String)cell.getStringCellValue());
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)cell.getNumericCellValue()) : Double.valueOf(cell.getNumericCellValue());
            }
            case FORMULA: {
                if (cell.getCachedFormulaResultType() == CellType.NUMERIC) {
                    return cell.getNumericCellValue();
                }
                return cell.getCachedFormulaResultType() == CellType.STRING ? StringUtils.trim((String)cell.getStringCellValue()) : null;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static XSSFWorkbook createWorkbook(List<String> headers, Integer taskType) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("sheet1");
        XSSFRow remarkRow = sheet.createRow(0);
        CellRangeAddress rangeAddress = new CellRangeAddress(0, 0, 0, headers.size() - 1);
        sheet.addMergedRegion(rangeAddress);
        remarkRow.setHeightInPoints(80.0f);
        XSSFCell remarkCell = remarkRow.createCell(0);
        if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == taskType.intValue()) {
            remarkCell.setCellValue(WEWORK_CUSTOMER_UPDATE_REMARK);
        } else {
            remarkCell.setCellValue(MOBILE_CUSTOMER_UPDATE_REMARK);
        }
        XSSFCellStyle remarkCellStyle = workbook.createCellStyle();
        remarkCellStyle.setWrapText(true);
        remarkCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        remarkCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        remarkCell.setCellStyle((CellStyle)remarkCellStyle);
        XSSFFont font = workbook.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(true);
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)12);
        XSSFCellStyle matchStyle = CustomerUpdateImportUtil.createCellStyle(workbook);
        matchStyle.setFont((Font)font);
        XSSFRow matchRow = sheet.createRow(NumberUtils.INTEGER_ONE.intValue());
        matchRow.setHeightInPoints(18.0f);
        if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == taskType.intValue()) {
            CellRangeAddress weworkMatchRange = new CellRangeAddress(1, 1, 0, 1);
            sheet.addMergedRegion(weworkMatchRange);
            XSSFCell weworkMatchCell = matchRow.createCell(0);
            weworkMatchCell.setCellValue("\u66f4\u65b0\u5b57\u6bb5");
            weworkMatchCell.setCellStyle((CellStyle)matchStyle);
            XSSFCellStyle weworkUpdateStyle = CustomerUpdateImportUtil.createCellStyle(workbook);
            weworkUpdateStyle.setFont((Font)font);
            CellRangeAddress weworkUpdateRange = new CellRangeAddress(1, 1, 2, headers.size() - 1);
            sheet.addMergedRegion(weworkUpdateRange);
            XSSFCell weworkUpdateCell = matchRow.createCell(1);
            weworkUpdateCell.setCellValue("\u66f4\u65b0\u5b57\u6bb5");
            weworkUpdateStyle.setFillForegroundColor(IndexedColors.GREEN.getIndex());
            weworkUpdateCell.setCellStyle((CellStyle)weworkUpdateStyle);
        } else {
            XSSFCell matchCell = matchRow.createCell(0);
            matchCell.setCellValue("\u5339\u914d\u6761\u4ef6");
            matchStyle.setFillForegroundColor(IndexedColors.BLUE.getIndex());
            matchCell.setCellStyle((CellStyle)matchStyle);
            XSSFCellStyle updateStyle = CustomerUpdateImportUtil.createCellStyle(workbook);
            updateStyle.setFont((Font)font);
            CellRangeAddress updateRange = new CellRangeAddress(1, 1, 1, headers.size() - 1);
            sheet.addMergedRegion(updateRange);
            XSSFCell updateCell = matchRow.createCell(1);
            updateCell.setCellValue("\u66f4\u65b0\u5b57\u6bb5");
            updateStyle.setFillForegroundColor(IndexedColors.GREEN.getIndex());
            updateCell.setCellStyle((CellStyle)updateStyle);
        }
        XSSFRow fieldNameRow = sheet.createRow(2);
        fieldNameRow.setHeightInPoints(18.0f);
        XSSFCellStyle cellStyle = CustomerUpdateImportUtil.createCellStyle(workbook);
        int columns = headers.size();
        for (int i = 0; i < columns; ++i) {
            sheet.setColumnWidth(i, 3584);
            String columnName = headers.get(i);
            XSSFCell fieldNameCell = fieldNameRow.createCell(i);
            fieldNameCell.setCellStyle((CellStyle)cellStyle);
            fieldNameCell.setCellValue((RichTextString)new XSSFRichTextString(columnName));
        }
        return workbook;
    }

    private static XSSFCellStyle createCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(true);
        font.setFontHeightInPoints((short)12);
        style.setFont((Font)font);
        return style;
    }
}

