/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.dto.req;

import cn.kinyun.crm.common.service.dto.req.CrmTemplateReq;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CustomerUpdateTemplateReq {
    private Integer taskType;
    private String productLineId;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.taskType), (Object)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        TaskTypeEnum taskTypeEnum = TaskTypeEnum.get(this.taskType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)taskTypeEnum), (Object)"\u4efb\u52a1\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5");
        if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == this.taskType.intValue()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.productLineId), (Object)"\u9500\u552e\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public CrmTemplateReq convert2CrmTemplateReq(CurrentUserInfo userInfo) {
        CrmTemplateReq crmTemplateReq = new CrmTemplateReq();
        crmTemplateReq.setBizId(userInfo.getBizId());
        crmTemplateReq.setCorpId(userInfo.getCorpId());
        crmTemplateReq.setOperatorId(userInfo.getId());
        crmTemplateReq.setProductLineId(this.productLineId);
        return crmTemplateReq;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getProductLineId() {
        return this.productLineId;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setProductLineId(String productLineId) {
        this.productLineId = productLineId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerUpdateTemplateReq)) {
            return false;
        }
        CustomerUpdateTemplateReq other = (CustomerUpdateTemplateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        String this$productLineId = this.getProductLineId();
        String other$productLineId = other.getProductLineId();
        return !(this$productLineId == null ? other$productLineId != null : !this$productLineId.equals(other$productLineId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerUpdateTemplateReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        String $productLineId = this.getProductLineId();
        result = result * 59 + ($productLineId == null ? 43 : $productLineId.hashCode());
        return result;
    }

    public String toString() {
        return "CustomerUpdateTemplateReq(taskType=" + this.getTaskType() + ", productLineId=" + this.getProductLineId() + ")";
    }
}

