/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.roomplan.service.impl;

import cn.kinyun.scrm.page.auth.service.OauthService;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.StatisticType;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.marketing.dto.PlanChannelDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.friendfission.dto.RelateChannelRes;
import com.kuaike.scrm.roomplan.dto.RoomPlanChannelDto;
import com.kuaike.scrm.roomplan.service.RoomPlanChannelService;
import com.kuaike.scrm.system.service.ChannelService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RoomPlanChannelServiceImpl
implements RoomPlanChannelService {
    private static final Logger log = LoggerFactory.getLogger(RoomPlanChannelServiceImpl.class);
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${room-plan.url.format}")
    private String roomPlanUrlFormat;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private OauthService oauthService;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public void addRelate(RelateChannelRes params) {
        log.info("add relate params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            log.info("room plan is not exist");
            return;
        }
        if (marketingPlan.getIsDeleted() == 1) {
            log.info("room plan status error");
            return;
        }
        if (marketingPlan.getType().intValue() != PlanType.ROOM_PLAN.getValue()) {
            log.info("is not room plan type");
            return;
        }
        Long planId = marketingPlan.getId();
        List channelIdList = this.channelService.getChannelIdByNum(params.getChannelIds());
        this.addRoomPlanChannels(bizId, corpId, userId, planId, channelIdList, marketingPlan.getStatsType());
    }

    @Override
    public List<RoomPlanChannelDto> list(BaseDto params) {
        log.info("room plan channel list params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getType().intValue() != PlanType.ROOM_PLAN.getValue()) {
            log.info("room plan is not exist");
            return null;
        }
        Long planId = marketingPlan.getId();
        if (params.getPageDto() != null) {
            int total = this.marketingChannelMapper.queryPlanChannelCount(corpId, planId, params.getName());
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        List channelList = this.marketingChannelMapper.queryPlanOfChannelList(corpId, planId, params.getPageDto());
        ArrayList result = Lists.newArrayListWithCapacity((int)channelList.size());
        for (PlanChannelDto itemDto : channelList) {
            RoomPlanChannelDto dto = new RoomPlanChannelDto();
            dto.setId(itemDto.getNum());
            dto.setChannelName(itemDto.getName());
            if (itemDto.getChannelId() == -1L) {
                dto.setChannelName("\u4f01\u4e1a\u5fae\u4fe1");
            }
            dto.setUrl(itemDto.getUrl());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ChannelDto> remainChannelList(BaseDto params) {
        log.info("room plan remain channel params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getType().intValue() != PlanType.ROOM_PLAN.getValue()) {
            log.info("room plan is not exist");
            return null;
        }
        Long planId = marketingPlan.getId();
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            int total = this.marketingChannelMapper.queryPlanRemainChannelCount(corpId, planId, params.getName());
            pageDto.setCount(Integer.valueOf(total));
        }
        List list = this.marketingChannelMapper.queryPlanRemainChannelList(corpId, planId, params.getName(), params.getPageDto());
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (Channel channel : list) {
            ChannelDto channelDto = new ChannelDto();
            channelDto.setId(channel.getNum());
            channelDto.setName(channel.getName());
            result.add(channelDto);
        }
        return result;
    }

    @Override
    public void addRoomPlanChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds, Integer statisticType) {
        if (CollectionUtils.isEmpty(channelIds)) {
            log.warn("saveMarketingChannels channels is null");
            return;
        }
        List list = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        List curChannelIds = list.stream().map(it -> it.getChannelId()).collect(Collectors.toList());
        channelIds.removeAll(curChannelIds);
        this.insertMarketingChannels(bizId, corpId, userId, planId, channelIds, statisticType);
    }

    private void insertMarketingChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds, Integer statisticType) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return;
        }
        ArrayList marketingChannels = Lists.newArrayList();
        for (Long channelId : channelIds) {
            MarketingChannel marketingChannel = new MarketingChannel();
            marketingChannel.setNum(this.idGen.getNum());
            marketingChannel.setBizId(bizId);
            marketingChannel.setCorpId(corpId);
            marketingChannel.setPlanId(planId);
            marketingChannel.setChannelId(channelId);
            String url = MessageFormat.format(this.roomPlanUrlFormat, marketingChannel.getNum());
            if (statisticType.intValue() == StatisticType.STATISTIC_UV_DETAIL.getValue()) {
                String shortUrl = this.oauthService.wrapUrl(bizId, url);
                marketingChannel.setUrl(shortUrl);
            } else {
                marketingChannel.setUrl(url);
            }
            marketingChannel.setUrl(url);
            marketingChannel.setCreateBy(userId);
            marketingChannel.setCreateTime(new Date());
            marketingChannel.setUpdateBy(userId);
            marketingChannel.setUpdateTime(new Date());
            marketingChannel.setIsDeleted(Integer.valueOf(0));
            marketingChannels.add(marketingChannel);
        }
        this.marketingChannelMapper.batchInsert((Collection)marketingChannels);
    }
}

