/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.dto.PlanWeworkUserDto;
import com.kuaike.scrm.dal.region.entity.RegionPlanAlternativeUser;
import com.kuaike.scrm.dal.region.mapper.RegionPlanAlternativeUserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.regionplan.service.AlternativeUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlternativeUserServiceImpl
implements AlternativeUserService {
    private static final Logger log = LoggerFactory.getLogger(AlternativeUserServiceImpl.class);
    @Resource
    private RegionPlanAlternativeUserMapper regionPlanAlternativeUserMapper;

    @Override
    public void saveAlternativeUser(Long planId, Long planGroupId, List<String> weworkUserNums) {
        if (weworkUserNums == null) {
            weworkUserNums = Lists.newArrayList();
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        List curList = this.regionPlanAlternativeUserMapper.queryRegionAlternativeUser(corpId, planId, planGroupId);
        ArrayList addList = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            if (!curList.contains(weworkUserNum)) {
                addList.add(weworkUserNum);
                continue;
            }
            curList.remove(weworkUserNum);
        }
        ArrayList insertList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            for (String weworkUserNum : addList) {
                insertList.add(this.buildAlternativeUser(bizId, corpId, planId, planGroupId, weworkUserNum, userInfo.getId()));
            }
            this.regionPlanAlternativeUserMapper.batchInsert((Collection)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)curList)) {
            this.regionPlanAlternativeUserMapper.delRegionAlternativeUser(corpId, planId, planGroupId, (Collection)curList, userInfo.getId());
        }
    }

    private RegionPlanAlternativeUser buildAlternativeUser(Long bizId, String corpId, Long planId, Long planGroupId, String weworkUserNum, Long userId) {
        RegionPlanAlternativeUser alternativeUser = new RegionPlanAlternativeUser();
        Date curDate = new Date();
        alternativeUser.setBizId(bizId);
        alternativeUser.setCorpId(corpId);
        alternativeUser.setPlanId(planId);
        alternativeUser.setPlanGroupId(planGroupId);
        alternativeUser.setWeworkUserNum(weworkUserNum);
        alternativeUser.setUpdateBy(userId);
        alternativeUser.setUpdateTime(curDate);
        alternativeUser.setCreateBy(userId);
        alternativeUser.setCreateTime(curDate);
        alternativeUser.setIsDeleted(Integer.valueOf(0));
        return alternativeUser;
    }

    @Override
    public List<WeworkUserDto> getAlternativeUserList(String corpId, Long planId, Long planGroupId) {
        List list = this.regionPlanAlternativeUserMapper.queryRegionAlternativeUserInfo(corpId, planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        for (PlanWeworkUserDto userDto : list) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(userDto.getWeworkUserNum());
            weworkUserDto.setNickname(userDto.getNickname());
            weworkUserDto.setAvatar(userDto.getAvatar());
            result.add(weworkUserDto);
        }
        return result;
    }
}

