/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.marketing.mapper.MarketingConfigMapper;
import com.kuaike.scrm.friendfission.dto.FissionBillboardDto;
import com.kuaike.scrm.friendfission.dto.FissionSwitchDto;
import com.kuaike.scrm.marketing.dto.ChannelWelcomeConfigDto;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MarketingConfigServiceImp
implements MarketingConfigService {
    private static final Logger log = LoggerFactory.getLogger(MarketingConfigServiceImp.class);
    @Resource
    private MarketingConfigMapper marketingConfigMapper;

    @Override
    public void save(Long bizId, String corpId, Long userId, Long planId, Integer type, String configJson) {
        MarketingConfig marketingPlanConfig = this.getMarketingPlanConfig(bizId, corpId, planId, type);
        if (configJson == null) {
            configJson = "";
        }
        if (marketingPlanConfig != null) {
            marketingPlanConfig.setConfigJson(configJson);
            marketingPlanConfig.setIsDeleted(Integer.valueOf(0));
            marketingPlanConfig.setUpdateBy(userId);
            marketingPlanConfig.setUpdateTime(new Date());
            this.marketingConfigMapper.updateByPrimaryKeySelective((Object)marketingPlanConfig);
        } else {
            MarketingConfig planConfig = new MarketingConfig();
            planConfig.setBizId(bizId);
            planConfig.setCorpId(corpId);
            planConfig.setConfigJson(configJson);
            planConfig.setConfigType(type);
            planConfig.setPlanId(planId);
            planConfig.setCreateBy(userId);
            planConfig.setCreateTime(new Date());
            planConfig.setUpdateBy(userId);
            planConfig.setUpdateTime(new Date());
            planConfig.setIsDeleted(Integer.valueOf(0));
            this.marketingConfigMapper.insertSelective((Object)planConfig);
        }
    }

    @Override
    public void save(Long bizId, String corpId, Long userId, Long planId, Integer type, Object configJson) {
        String str = JacksonUtil.obj2Str((Object)configJson);
        this.save(bizId, corpId, userId, planId, type, str);
    }

    @Override
    public void save(Long bizId, String corpId, Long userId, Long planId, Integer type, List<String> configJsons) {
        String configJson;
        int i;
        List list = this.marketingConfigMapper.queryTypeConfigs(corpId, planId, type);
        for (i = 0; i < configJsons.size(); ++i) {
            configJson = configJsons.get(i);
            if (configJson != null) continue;
            configJsons.set(i, "");
        }
        for (i = 0; i < list.size(); ++i) {
            MarketingConfig marketingConfig = (MarketingConfig)list.get(i);
            if (i < configJsons.size()) {
                String configJson2 = configJsons.get(i);
                marketingConfig.setConfigJson(configJson2);
                marketingConfig.setIsDeleted(Integer.valueOf(0));
                marketingConfig.setUpdateBy(userId);
                marketingConfig.setUpdateTime(new Date());
            } else {
                marketingConfig.setIsDeleted(Integer.valueOf(1));
                marketingConfig.setUpdateTime(new Date());
                marketingConfig.setUpdateBy(userId);
            }
            this.marketingConfigMapper.updateByPrimaryKeySelective((Object)marketingConfig);
        }
        if (configJsons.size() > list.size()) {
            for (i = list.size(); i < configJsons.size(); ++i) {
                configJson = configJsons.get(i);
                MarketingConfig planConfig = new MarketingConfig();
                planConfig.setBizId(bizId);
                planConfig.setCorpId(corpId);
                planConfig.setConfigJson(configJson);
                planConfig.setConfigType(type);
                planConfig.setPlanId(planId);
                planConfig.setCreateBy(userId);
                planConfig.setCreateTime(new Date());
                planConfig.setUpdateBy(userId);
                planConfig.setUpdateTime(new Date());
                planConfig.setIsDeleted(Integer.valueOf(0));
                this.marketingConfigMapper.insertSelective((Object)planConfig);
            }
        }
    }

    @Override
    public void save(Long bizId, String corpId, Long userId, Long planId, List<ChannelWelcomeConfigDto> channelWelcomeConfigDtos) {
        HashMap channelRemarkMap = Maps.newHashMap();
        HashMap channelWelcomeMap = Maps.newHashMap();
        for (ChannelWelcomeConfigDto configDto : channelWelcomeConfigDtos) {
            if (StringUtils.isNotBlank((CharSequence)configDto.getAddFriendRemark())) {
                channelRemarkMap.put(configDto.getChannelId(), configDto.getAddFriendRemark());
            }
            if (configDto.getAddFriendWelcome() == null) continue;
            channelWelcomeMap.put(configDto.getChannelId(), JacksonUtil.obj2Str((Object)configDto.getAddFriendWelcome()));
        }
        this.saveChannelConfig(bizId, corpId, userId, planId, MarketingConfigType.AUTO_REMARK.getValue(), channelRemarkMap);
        this.saveChannelConfig(bizId, corpId, userId, planId, MarketingConfigType.FRIEND_WELCOME.getValue(), channelWelcomeMap);
    }

    private void saveChannelConfig(Long bizId, String corpId, Long userId, Long planId, Integer configType, Map<String, String> channelConfigMap) {
        ArrayList updateList = Lists.newArrayList();
        ArrayList insertList = Lists.newArrayList();
        List existsList = this.marketingConfigMapper.queryConfigListByChannel(bizId, corpId, planId, configType);
        Map<Object, Object> existsMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)existsList)) {
            existsMap = existsList.stream().collect(Collectors.toMap(MarketingConfig::getChannelNum, Function.identity()));
        }
        for (Map.Entry<String, String> entry : channelConfigMap.entrySet()) {
            String channelNum = entry.getKey();
            String configJson = entry.getValue();
            MarketingConfig config = (MarketingConfig)existsMap.get(channelNum);
            if (config == null) {
                config = new MarketingConfig();
                config.setBizId(bizId);
                config.setCorpId(corpId);
                config.setConfigJson(configJson);
                config.setConfigType(configType);
                config.setPlanId(planId);
                config.setCreateBy(userId);
                config.setCreateTime(new Date());
                config.setUpdateBy(userId);
                config.setUpdateTime(new Date());
                config.setIsDeleted(Integer.valueOf(0));
                config.setChannelNum(channelNum);
                insertList.add(config);
            } else {
                config.setUpdateTime(new Date());
                config.setUpdateBy(userId);
                config.setConfigJson(configJson);
                updateList.add(config);
            }
            existsMap.remove(channelNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.marketingConfigMapper.batchInsert((Collection)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.marketingConfigMapper.batchUpdate((Collection)updateList);
        }
        if (!existsMap.isEmpty()) {
            List delIds = existsMap.values().stream().map(MarketingConfig::getId).collect(Collectors.toList());
            this.marketingConfigMapper.batchDel(delIds, userId);
        }
    }

    @Override
    public List<ChannelWelcomeConfigDto> getChannelConfigs(Long bizId, String corpId, Long planId) {
        ArrayList result = Lists.newArrayList();
        List channelConfigList = this.marketingConfigMapper.queryConfigListByChannel(bizId, corpId, planId, null);
        HashMap remarkMap = Maps.newHashMap();
        HashMap welcomeMap = Maps.newHashMap();
        HashSet channelNums = Sets.newHashSet();
        for (MarketingConfig config : channelConfigList) {
            String channelNum = config.getChannelNum();
            if (config.getConfigType().intValue() == MarketingConfigType.AUTO_REMARK.getValue() && StringUtils.isNotBlank((CharSequence)config.getConfigJson())) {
                remarkMap.put(channelNum, config.getConfigJson());
            } else if (config.getConfigType().intValue() == MarketingConfigType.FRIEND_WELCOME.getValue() && StringUtils.isNotBlank((CharSequence)config.getConfigJson())) {
                welcomeMap.put(channelNum, config.getConfigJson());
            }
            channelNums.add(channelNum);
        }
        for (String channelNum : channelNums) {
            ChannelWelcomeConfigDto configDto = new ChannelWelcomeConfigDto();
            configDto.setChannelId(channelNum);
            configDto.setAddFriendRemark((String)remarkMap.get(channelNum));
            FriendWelcomeDto friendWelcomeDto = null;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)welcomeMap.get(channelNum)))) {
                try {
                    friendWelcomeDto = (FriendWelcomeDto)JacksonUtil.str2Obj((String)((String)welcomeMap.get(channelNum)), FriendWelcomeDto.class);
                }
                catch (IOException e) {
                    log.error("");
                }
            }
            configDto.setAddFriendWelcome(friendWelcomeDto);
            result.add(configDto);
        }
        return result;
    }

    @Override
    public MarketingConfig getMarketingPlanConfig(Long bizId, String corpId, Long planId, String channelNum, Integer type) {
        return this.marketingConfigMapper.queryMarketingConfigByChannel(bizId, corpId, planId, channelNum, type);
    }

    @Override
    public MarketingConfig getMarketingPlanConfig(Long bizId, String corpId, Long planId, Integer type) {
        return this.marketingConfigMapper.queryMarketingConfig(bizId, corpId, planId, type);
    }

    @Override
    public void delMarketingConfig(Long planId, Long userId) {
        this.marketingConfigMapper.delMarketingConfig(planId, userId);
    }

    @Override
    public String getRemarkConfig(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.AUTO_REMARK.getValue());
        if (marketingConfig != null) {
            return marketingConfig.getConfigJson();
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getFriendWelcomeConfig(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.FRIEND_WELCOME.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getSpreadReply(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.SPREAD_REPLY.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getSuccessInviteReply(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.SUCCESS_INVITE_REPLY.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getRepeatInviteReply(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.REPEAT_INVITE_REPLY.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getFinishReply(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.FINISH_REPLY.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FriendWelcomeDto getLimitNewCustomerReply(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.LIMIT_NEW_CUSTOMER_REPLY.getValue());
        if (marketingConfig != null) {
            try {
                return (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public FissionSwitchDto getSwitchConfig(String corpId, Long planId) {
        MarketingConfig marketingConfig = this.getMarketingPlanConfig(null, corpId, planId, MarketingConfigType.FISSION_SWITCH.getValue());
        if (marketingConfig != null) {
            try {
                return (FissionSwitchDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FissionSwitchDto.class);
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<FissionBillboardDto> getBillboardConfig(String corpId, Long planId) {
        List list = this.marketingConfigMapper.queryTypeConfigs(corpId, planId, Integer.valueOf(MarketingConfigType.FISSION_BILL_BOARD.getValue()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            try {
                ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
                for (MarketingConfig marketingConfig : list) {
                    FissionBillboardDto billboardDto = (FissionBillboardDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FissionBillboardDto.class);
                    result.add(billboardDto);
                }
                return result;
            }
            catch (IOException e) {
                log.error("get friend welcome config parse json error: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Map<Long, List<MarketingConfig>> getBillboardConfigByCorpIdAndPlanIds(String corpId, Set<Long> planIds) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            log.warn("corpId\u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(planIds)) {
            log.warn("planIds\u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        List marketingConfigs = this.marketingConfigMapper.queryConfigByCropIdAndPlanIdsAndType(corpId, planIds, Integer.valueOf(MarketingConfigType.FISSION_BILL_BOARD.getValue()));
        if (CollectionUtils.isEmpty((Collection)marketingConfigs)) {
            log.info("\u6839\u636ecorpId:{}, planIds:{}, configType:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", new Object[]{corpId, planIds, MarketingConfigType.FISSION_BILL_BOARD.getDesc()});
            return Collections.emptyMap();
        }
        return marketingConfigs.stream().collect(Collectors.groupingBy(MarketingConfig::getPlanId));
    }
}

