/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.entity.MarketingBounsCode;
import com.kuaike.scrm.dal.marketing.entity.MarketingBounsCodeSub;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingBounsCodeMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingBounsCodeSubMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.marketing.dto.BounsAddReqDto;
import com.kuaike.scrm.marketing.dto.BounsAwardReqDto;
import com.kuaike.scrm.marketing.dto.BounsExportReqDto;
import com.kuaike.scrm.marketing.dto.BounsListRespDto;
import com.kuaike.scrm.marketing.dto.BounsReqDto;
import com.kuaike.scrm.marketing.dto.BounsSubListRespDto;
import com.kuaike.scrm.marketing.dto.BounsSubReqDto;
import com.kuaike.scrm.marketing.dto.ImportBoundResDto;
import com.kuaike.scrm.marketing.service.MarketingBounsService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingBounsServiceImpl
implements MarketingBounsService {
    private static final Logger log = LoggerFactory.getLogger(MarketingBounsServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private MarketingBounsCodeMapper bounsCodeMapper;
    @Autowired
    private MarketingBounsCodeSubMapper bounsCodeSubMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private UserMapper userMapper;
    private static final int HEADER_ROWS = 0;
    private static final int MAX_ROWS = 5000;
    private static final String IMPORT_FILE_DIR = "./importDir/marketingBouns";
    private static final String[] HEADERS = new String[]{"\u7801\u540d\u79f0", "\u662f\u5426\u53d1\u653e", "\u5ba2\u6237\u6635\u79f0", "\u53d1\u653e\u65f6\u95f4", "\u53d1\u653e\u6d3b\u52a8"};

    @Override
    public ImportBoundResDto importBounsExcel(InputStream inp) {
        ImportBoundResDto importResultDto;
        try {
            Workbook workbook = MarketingBounsServiceImpl.create(inp);
            importResultDto = this.parseExcel(workbook);
            File dir = new File(IMPORT_FILE_DIR);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault());
            String fileName = IMPORT_FILE_DIR + File.pathSeparator + simpleDateFormat.format(new Date()) + "_\u5151\u6362\u7801.xlsx";
            File file = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            String fileUrl = this.aliyunOss.uploadFile(LoginUtils.getCurrentUser().getCorpId(), file, file.getName());
            log.info("importBounsExcel get fileUrl: {}", (Object)fileUrl);
            importResultDto.setFileUrl(fileUrl);
            log.info("importBounsExcel: importResultDto :{}", (Object)importResultDto);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return importResultDto;
    }

    private ImportBoundResDto parseExcel(Workbook workbook) {
        int numberOfSheets = workbook.getNumberOfSheets();
        if (numberOfSheets != 1) {
            log.warn("excel\u6587\u4ef6sheet\u9875\u6570\u4e3a:{}", (Object)numberOfSheets);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6587\u4ef6\u4e2dsheet\u9875\u6570\u4e0d\u4e3a1");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        log.info("parseExcel physicalNumberOfRows: {}", (Object)physicalNumberOfRows);
        if (physicalNumberOfRows - 0 > 5000) {
            log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(physicalNumberOfRows - 0));
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
        }
        int columnNum = sheet.getRow(0).getPhysicalNumberOfCells();
        log.info("parseExcel columnNum: {}", (Object)columnNum);
        if (columnNum > 3) {
            log.warn("excel\u6a21\u677f\u4e0d\u7b26\u5408\u89c4\u8303");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6a21\u677f\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        ImportBoundResDto impResDto = new ImportBoundResDto();
        ArrayList bounsList = Lists.newArrayList();
        int totalCount = physicalNumberOfRows - 0;
        log.info("parseExcel totalCount: {}", (Object)totalCount);
        int i = 0;
        int invalidateRowCount = 0;
        int dataStartRow = -1;
        while (i < totalCount) {
            Row row;
            if (Objects.isNull(row = sheet.getRow(++dataStartRow))) continue;
            Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
            if (Objects.isNull(cell)) {
                ++i;
                ++invalidateRowCount;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String bouns = cell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)bouns) || bouns.length() > 100) {
                ++i;
                log.info("get bouns: {}", (Object)bouns);
                continue;
            }
            if (bounsList.contains(bouns)) {
                ++i;
                log.info("bounsList contain bouns: {}", (Object)bouns);
                continue;
            }
            bounsList.add(bouns);
            ++i;
        }
        if (CollectionUtils.isEmpty((Collection)bounsList)) {
            log.warn("bounsList:{}", (Object)bounsList);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u5c11\u9700\u5bfc\u51651\u6761");
        }
        log.info("parseExcel totalCount: {}, invalidateRowCount: {}", (Object)totalCount, (Object)invalidateRowCount);
        impResDto.setTotalCount(totalCount - invalidateRowCount);
        impResDto.setBounsList(bounsList);
        impResDto.setValidCount(bounsList.size());
        log.info("parseExcel: impResDto :{}", (Object)impResDto);
        return impResDto;
    }

    private static Workbook create(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    @Override
    public void exportBounsExcel(BounsExportReqDto reqDto, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("exportBounsExcel,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getId()), (Object)"\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingBounsCode bounsCode = this.bounsCodeMapper.getBounsByNum(reqDto.getId(), currentUser.getCorpId());
        if (Objects.isNull(bounsCode)) {
            log.warn("\u6839\u636eid:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(bounsCode.getName());
        String fileName = bounsCode.getName() + "_\u5151\u6362\u7801\u4f7f\u7528\u8be6\u60c5.xls";
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int i = 0; i < HEADERS.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(HEADERS[i]);
            cell.setCellValue((RichTextString)text);
        }
        List bounsCodeSubs = this.bounsCodeSubMapper.getBounsSubById(bounsCode.getId(), currentUser.getCorpId(), reqDto.getContactName(), null, null);
        List<Object> dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)bounsCodeSubs)) {
            log.warn("\u6839\u636eid:{}\u672a\u67e5\u8be2\u5230\u5151\u6362\u7801\u5b50\u8868\u8bb0\u5f55", (Object)bounsCode.getId());
        } else {
            dtos = this.getBounsSubList(bounsCodeSubs, currentUser.getCorpId());
        }
        if (dtos.size() > 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
            int rowNum = 1;
            for (BounsSubListRespDto bounsSubListRespDto : dtos) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                ssRow.createCell(0).setCellValue(bounsSubListRespDto.getContent());
                String statusDesc = bounsSubListRespDto.getStatus() == 0 ? "\u672a\u53d1\u653e" : "\u5df2\u53d1\u653e";
                ssRow.createCell(1).setCellValue(statusDesc);
                ssRow.createCell(2).setCellValue(bounsSubListRespDto.getContactName());
                if (Objects.nonNull(bounsSubListRespDto.getSendTime())) {
                    ssRow.createCell(3).setCellValue(simpleDateFormat.format(bounsSubListRespDto.getSendTime()));
                }
                ssRow.createCell(4).setCellValue(bounsSubListRespDto.getMarketingName());
                ++rowNum;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58excel\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void addBouns(BounsAddReqDto addReqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("addBouns,params:{}, operatorId:{}, corpId:{}", new Object[]{addReqDto, currentUser.getId(), currentUser.getCorpId()});
        addReqDto.validate();
        MarketingBounsCode bounsCode = this.addMarketingBounsCode(addReqDto.getName(), currentUser);
        this.bounsCodeMapper.insertSelective((Object)bounsCode);
        ArrayList codeSubs = Lists.newArrayList();
        for (String content : addReqDto.getBounsList()) {
            MarketingBounsCodeSub codeSub = new MarketingBounsCodeSub();
            codeSub.setNum(this.idGen.getNum());
            codeSub.setBizId(currentUser.getBizId());
            codeSub.setCorpId(currentUser.getCorpId());
            codeSub.setCreateBy(currentUser.getId());
            codeSub.setCodeId(bounsCode.getId());
            codeSub.setContent(content);
            codeSubs.add(codeSub);
        }
        if (CollectionUtils.isNotEmpty((Collection)codeSubs)) {
            this.bounsCodeSubMapper.insertBounsSubList((List)codeSubs);
        }
    }

    private MarketingBounsCode addMarketingBounsCode(String bounsName, CurrentUserInfo userInfo) {
        MarketingBounsCode bounsCode = new MarketingBounsCode();
        bounsCode.setNum(this.idGen.getNum());
        bounsCode.setBizId(userInfo.getBizId());
        bounsCode.setCorpId(userInfo.getCorpId());
        bounsCode.setCreateBy(userInfo.getId());
        bounsCode.setCreateTime(DateUtil.getDate());
        bounsCode.setName(bounsName);
        return bounsCode;
    }

    @Override
    public List<BounsListRespDto> getBounsList(BounsReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("getBounsList,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("getBounsList userIds: {}", (Object)userIds);
        List bounsCodes = this.bounsCodeMapper.getBounsList(currentUser.getCorpId(), (Collection)userIds, Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)bounsCodes)) {
            log.warn("getBounsList, \u672a\u67e5\u8be2\u5230\u5151\u6362\u7801\u5b50\u8868\u8bb0\u5f55");
            return Collections.emptyList();
        }
        int count = this.bounsCodeMapper.getBounsCount(currentUser.getCorpId(), (Collection)userIds);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(bounsCodes.size()));
        List createByList = bounsCodes.stream().map(MarketingBounsCode::getCreateBy).collect(Collectors.toList());
        Map userMap = null;
        if (CollectionUtils.isNotEmpty(createByList)) {
            userMap = this.userMapper.selectUserIdAndNameByIds(currentUser.getBizId(), currentUser.getCorpId(), createByList);
        }
        log.info("getBounsList userMap: {}", userMap);
        ArrayList respDtos = Lists.newArrayList();
        for (MarketingBounsCode bounsCode : bounsCodes) {
            BounsListRespDto respDto = new BounsListRespDto();
            respDto.setId(bounsCode.getNum());
            respDto.setCodeName(bounsCode.getName());
            respDto.setCreateTime(bounsCode.getCreateTime());
            if (Objects.nonNull(userMap)) {
                respDto.setCreatorName((String)userMap.get(bounsCode.getCreateBy()));
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public List<BounsListRespDto> getUseBounsList() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("getUseBounsList operatorId:{}, corpId:{}", (Object)currentUser.getId(), (Object)currentUser.getCorpId());
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("getUseBounsList userIds: {}", (Object)userIds);
        List bounsCodes = this.bounsCodeMapper.getUseBounsList(currentUser.getCorpId(), (Collection)userIds);
        log.info("getUseBounsList bounsCodes: {}", (Object)bounsCodes);
        if (CollectionUtils.isEmpty((Collection)bounsCodes)) {
            log.warn("getUseBounsList, \u672a\u67e5\u8be2\u5230\u5151\u6362\u7801\u5b50\u8868\u8bb0\u5f55");
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (MarketingBounsCode bounsCode : bounsCodes) {
            BounsListRespDto respDto = new BounsListRespDto();
            respDto.setId(bounsCode.getNum());
            respDto.setCodeName(bounsCode.getName());
            respDto.setCreateTime(bounsCode.getCreateTime());
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public List<BounsSubListRespDto> getBounsSubList(BounsSubReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("getBounsSubList,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        MarketingBounsCode bounsCode = this.bounsCodeMapper.getBounsByNum(reqDto.getId(), currentUser.getCorpId());
        if (Objects.isNull(bounsCode)) {
            log.warn("\u6839\u636eid:{}\u672a\u67e5\u8be2\u5230\u5151\u6362\u7801\u8bb0\u5f55", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        }
        List bounsCodeSubs = this.bounsCodeSubMapper.getBounsSubById(bounsCode.getId(), currentUser.getCorpId(), reqDto.getContactName(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)bounsCodeSubs)) {
            log.warn("\u6839\u636eid:{}\u672a\u67e5\u8be2\u5230\u5151\u6362\u7801\u5b50\u8868\u8bb0\u5f55", (Object)bounsCode.getId());
            return Collections.emptyList();
        }
        int count = this.bounsCodeSubMapper.getCountBounsSubById(bounsCode.getId(), currentUser.getCorpId(), reqDto.getContactName());
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(bounsCodeSubs.size()));
        return this.getBounsSubList(bounsCodeSubs, currentUser.getCorpId());
    }

    private List<BounsSubListRespDto> getBounsSubList(List<MarketingBounsCodeSub> bounsCodeSubs, String corpId) {
        Set marketingIds = bounsCodeSubs.stream().map(MarketingBounsCodeSub::getMarketingId).filter(Objects::nonNull).collect(Collectors.toSet());
        log.info("getBounsSubList marketingIds: {}", marketingIds);
        Set contactIds = bounsCodeSubs.stream().map(MarketingBounsCodeSub::getContactId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        log.info("getBounsSubList contactIds: {}", contactIds);
        Map<Long, String> marketingNameMap = null;
        if (CollectionUtils.isNotEmpty(marketingIds)) {
            List marketingPlans = this.marketingPlanMapper.queryByIds(corpId, marketingIds);
            if (CollectionUtils.isNotEmpty((Collection)marketingPlans)) {
                marketingNameMap = marketingPlans.stream().collect(Collectors.toMap(MarketingPlan::getId, MarketingPlan::getName));
            } else {
                log.info("getBounsSubList marketingPlans is empty");
            }
        }
        log.info("getBounsSubList marketingNameMap: {}", marketingNameMap);
        Map<String, WeworkContact> marketingContactMap = null;
        if (CollectionUtils.isNotEmpty(contactIds)) {
            List weworkContacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, contactIds);
            if (CollectionUtils.isNotEmpty((Collection)weworkContacts)) {
                marketingContactMap = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a));
            } else {
                log.info("getBounsSubList weworkContacts is empty");
            }
        }
        log.info("getBounsSubList marketingContactMap: {}", marketingContactMap);
        ArrayList dtos = Lists.newArrayList();
        for (MarketingBounsCodeSub bounsCodeSub : bounsCodeSubs) {
            WeworkContact contact;
            BounsSubListRespDto respDto = new BounsSubListRespDto();
            respDto.setId(bounsCodeSub.getNum());
            respDto.setContent(bounsCodeSub.getContent());
            respDto.setStatus(bounsCodeSub.getStatus());
            if (Objects.nonNull(marketingNameMap)) {
                respDto.setMarketingName(marketingNameMap.get(bounsCodeSub.getMarketingId()));
            }
            if (Objects.nonNull(marketingContactMap) && Objects.nonNull(contact = marketingContactMap.get(bounsCodeSub.getContactId()))) {
                respDto.setContactAvatar(contact.getAvatar());
                respDto.setContactName(contact.getName());
            }
            respDto.setSendTime(bounsCodeSub.getSendTime());
            dtos.add(respDto);
        }
        return dtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarketingBounsCodeSub getBounsCode(BounsAwardReqDto reqDto, String corpId) {
        reqDto.validate();
        List bounsCodeSubs = this.bounsCodeSubMapper.getBounsSubAwardList(reqDto.getBounsId(), corpId);
        if (CollectionUtils.isEmpty((Collection)bounsCodeSubs)) {
            log.info("getBounsCode \u672a\u83b7\u53d6\u5230\u53ef\u7528\u7684\u5151\u6362\u7801\u5217\u8868");
            return null;
        }
        MarketingBounsCodeSub bounsCodeSub = (MarketingBounsCodeSub)bounsCodeSubs.get(0);
        this.bounsCodeSubMapper.updateBounsSub(bounsCodeSub.getId(), reqDto.getMarketingId(), reqDto.getMarketingType(), reqDto.getContactId(), reqDto.getContactName());
        return bounsCodeSub;
    }
}

