/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroupUser;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.marketing.dto.MarketingCacheDto;
import com.kuaike.scrm.marketing.enums.MarketingAllocType;
import com.kuaike.scrm.marketing.service.MarketingAllocService;
import com.kuaike.trace.utils.TraceIdUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Service;

@Service
public class MarketingAllocServiceImpl
implements MarketingAllocService {
    private static final Logger log = LoggerFactory.getLogger(MarketingAllocServiceImpl.class);
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private static final String MARKETING_REDIS_ALLOC_KEY_PREFIX = "marketing:alloc:{0}:{1}";
    private static final String SCRIPT = "local values = ARGV\nlocal result\nredis.call(\"del\",KEYS[1]) \nfor k,v in ipairs(values) do\n    result = redis.call('LPUSH',KEYS[1],v)\nend\nreturn 1";
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(2048), (ThreadFactory)new NamedThreadFactory("marketingAllocService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    @Override
    public void genRedisAllocCache(Long marketingPlanId) {
        log.info("genRedisAllocCache,marketingPlanId:{}", (Object)marketingPlanId);
        if (marketingPlanId == null) {
            return;
        }
        List marketingPlanGroupUsers = this.marketingPlanGroupUserMapper.queryHaveAllocTypeUsers(marketingPlanId);
        if (CollectionUtils.isEmpty((Collection)marketingPlanGroupUsers)) {
            log.info("genRedisAllocCache,marketingPlanId:{},marketingPlanGroupUsers is empty", (Object)marketingPlanId);
            return;
        }
        String traceId = TraceIdUtils.getTraceId();
        this.threadPool.submit(() -> {
            TraceIdUtils.setTraceId((String)traceId);
            this.handleData(marketingPlanId, marketingPlanGroupUsers);
        });
    }

    private void handleData(Long marketingPlanId, List<MarketingPlanGroupUser> marketingPlanGroupUsers) {
        Long planGroupId;
        if (CollectionUtils.isEmpty(marketingPlanGroupUsers)) {
            return;
        }
        HashMap<Long, List> groupUsersMap = new HashMap<Long, List>();
        for (MarketingPlanGroupUser marketingPlanGroupUser : marketingPlanGroupUsers) {
            planGroupId = marketingPlanGroupUser.getPlanGroupId();
            List orDefault = groupUsersMap.getOrDefault(planGroupId, new ArrayList());
            orDefault.add(marketingPlanGroupUser);
            groupUsersMap.put(planGroupId, orDefault);
        }
        for (Map.Entry entry : groupUsersMap.entrySet()) {
            Integer groupAllocType;
            MarketingAllocType marketingAllocType;
            planGroupId = (Long)entry.getKey();
            List groupUsers = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)groupUsers) || (marketingAllocType = MarketingAllocType.get(groupAllocType = ((MarketingPlanGroupUser)groupUsers.get(0)).getGroupAllocType())) == null || !MarketingAllocType.WEIGHT.equals((Object)marketingAllocType)) continue;
            HashSet<Integer> weights = new HashSet<Integer>();
            HashMap<Long, Integer> userIdWeightMap = new HashMap<Long, Integer>();
            for (MarketingPlanGroupUser planGroupUser : groupUsers) {
                Integer weight = planGroupUser.getWeight();
                Long id = planGroupUser.getId();
                if (weight == null || weight <= 0) continue;
                weights.add(weight);
                userIdWeightMap.put(id, weight);
            }
            if (userIdWeightMap.isEmpty()) {
                log.info("genRedisAllocCache,groupId:{},weight is empty", (Object)planGroupId);
                continue;
            }
            int gcd = MarketingAllocServiceImpl.findGCD(weights);
            this.insertWeightRedisCache(marketingPlanId, planGroupId, gcd, userIdWeightMap);
        }
    }

    private void insertWeightRedisCache(Long planId, Long groupId, int gcd, Map<Long, Integer> userIdWeightMap) {
        if (planId == null) {
            return;
        }
        if (groupId == null) {
            return;
        }
        if (gcd <= 0) {
            gcd = 1;
        }
        if (userIdWeightMap.isEmpty()) {
            return;
        }
        log.info("insertRedisCache,planId:{},groupId:{},gcd:{},userIdWeightMap:{}", new Object[]{planId, groupId, gcd, userIdWeightMap});
        ArrayList<Long> allGroupUserIds = new ArrayList<Long>();
        for (Map.Entry<Long, Integer> entry : userIdWeightMap.entrySet()) {
            Long groupUserId = entry.getKey();
            Integer originWeight = entry.getValue();
            int weight = originWeight / gcd;
            for (int i = 0; i < weight; ++i) {
                allGroupUserIds.add(groupUserId);
            }
        }
        if (CollectionUtils.isEmpty(allGroupUserIds)) {
            log.info("insertRedisCache,planId:{},groupId:{},allGroupUserIds is empty", (Object)planId, (Object)groupId);
            return;
        }
        Collections.shuffle(allGroupUserIds);
        ArrayList<String> data = new ArrayList<String>();
        for (Long groupUserId : allGroupUserIds) {
            MarketingCacheDto dto = new MarketingCacheDto();
            dto.setGcd(gcd);
            dto.setUserWeightMap(userIdWeightMap);
            dto.setGroupUserId(groupUserId);
            data.add(JSONObject.toJSONString((Object)dto));
        }
        String string = MessageFormat.format(MARKETING_REDIS_ALLOC_KEY_PREFIX, planId, groupId);
        this.syncCache(string, data);
    }

    private void syncCache(String key, List<String> data) {
        try {
            this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(SCRIPT, Long.class), Collections.singletonList(key), data.toArray());
        }
        catch (Exception e) {
            log.error("syncCache error", (Throwable)e);
        }
    }

    public static int findGCD(Set<Integer> set) {
        if (CollectionUtils.isEmpty(set)) {
            return 1;
        }
        int gcd = set.iterator().next();
        for (int num : set) {
            gcd = MarketingAllocServiceImpl.findGCD(gcd, num);
        }
        return gcd;
    }

    public static int findGCD(int a, int b) {
        if (b == 0) {
            return a;
        }
        return MarketingAllocServiceImpl.findGCD(b, a % b);
    }

    @Override
    public void delRedisAllocCache(Long planId, Collection<Long> groupIds) {
        log.info("delRedisAllocCache,planId:{},groupIds:{}", (Object)planId, groupIds);
        if (planId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(groupIds)) {
            return;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Long groupId : groupIds) {
            String key = MessageFormat.format(MARKETING_REDIS_ALLOC_KEY_PREFIX, planId, groupId);
            keys.add(key);
        }
        Long delete = this.stringRedisTemplate.delete(keys);
        log.info("delRedisAllocCache,planId:{},delete:{}", (Object)planId, (Object)delete);
    }

    @Override
    public MarketingCacheDto getRedisAllocCache(Long planId, Long groupId) {
        MarketingCacheDto marketingCacheDto;
        log.info("getRedisAllocCache,planId:{},groupId:{}", (Object)planId, (Object)groupId);
        if (planId == null) {
            return null;
        }
        if (groupId == null) {
            return null;
        }
        String key = MessageFormat.format(MARKETING_REDIS_ALLOC_KEY_PREFIX, planId, groupId);
        String value = (String)this.stringRedisTemplate.opsForList().rightPop((Object)key);
        if (StringUtils.isBlank((CharSequence)value)) {
            this.genRedisAllocCache(planId);
            value = (String)this.stringRedisTemplate.opsForList().leftPop((Object)key);
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            log.info("getRedisAllocCache,planId:{},groupId:{},redis cache is blank", (Object)planId, (Object)groupId);
            return null;
        }
        try {
            marketingCacheDto = (MarketingCacheDto)JSONObject.parseObject((String)value, MarketingCacheDto.class);
        }
        catch (Exception e) {
            log.error("getRedisAllocCache,planId:{},groupId:{},parseObject error", new Object[]{planId, groupId, e});
            return null;
        }
        Long remainSize = this.stringRedisTemplate.opsForList().size((Object)key);
        if (remainSize != null && remainSize > 0L) {
            return marketingCacheDto;
        }
        log.info("getRedisAllocCache,planId:{},groupId:{},alloc size is zero,reset cache,size:{}", new Object[]{planId, groupId, remainSize});
        String traceId = TraceIdUtils.getTraceId();
        this.threadPool.submit(() -> {
            TraceIdUtils.setTraceId((String)traceId);
            this.insertWeightRedisCache(planId, groupId, marketingCacheDto.getGcd(), marketingCacheDto.getUserWeightMap());
        });
        return marketingCacheDto;
    }
}

